<?php

declare(strict_types=1);

namespace phpDocumentor\Reflection\Assets;

use phpDocumentor\Reflection\DocBlock\Tag;
use phpDocumentor\Reflection\DocBlock\Tags\Formatter;
use phpDocumentor\Reflection\FqsenResolver;
use phpDocumentor\Reflection\DocBlock\Tags\Factory\StaticMethod;

final class CustomServiceInterface implements Tag
{
    /** @var Formatter|null */
    public $formatter;

    public function getName() : string
    {
        return 'spy';
    }

    public static function create(string $body, Formatter $formatter = null)
    {
        $tag = new self();
        $tag->formatter = $formatter;

        return $tag;
    }

    public function render(?Formatter $formatter = null) : string
    {
        return $this->getName();
    }

    public function __toString() : string
    {
        return $this->getName();
    }
}
