# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AuthenticationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The method to authenticate the user of the client at the server."""

    ANONYMOUS = "Anonymous"
    """The user authentication method is anonymous."""
    CERTIFICATE = "Certificate"
    """The user authentication method is an x509 certificate."""
    USERNAME_PASSWORD = "UsernamePassword"
    """The user authentication method is a username and password."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DataPointObservabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the data point observability mode."""

    NONE = "None"
    """No mapping to OpenTelemetry."""
    COUNTER = "Counter"
    """Map as counter to OpenTelemetry."""
    GAUGE = "Gauge"
    """Map as gauge to OpenTelemetry."""
    HISTOGRAM = "Histogram"
    """Map as histogram to OpenTelemetry."""
    LOG = "Log"
    """Map as log to OpenTelemetry."""


class DatasetDestinationTarget(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The set of supported dataset destinations for an asset."""

    MQTT = "Mqtt"
    """MQTT target."""
    BROKER_STATE_STORE = "BrokerStateStore"
    """Broker State Store target."""
    STORAGE = "Storage"
    """Storage target."""


class EventDestinationTarget(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The set of supported event destinations for an asset."""

    MQTT = "Mqtt"
    """MQTT target."""
    STORAGE = "Storage"
    """Storage target."""


class EventObservabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the event observability mode."""

    NONE = "None"
    """No mapping to OpenTelemetry."""
    LOG = "Log"
    """Map as log to OpenTelemetry."""


class Format(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the schema format."""

    JSON_SCHEMA_DRAFT7 = "JsonSchema/draft-07"
    """JSON Schema version draft 7 format"""
    DELTA1_0 = "Delta/1.0"
    """Delta format"""


class ManagementActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the ManagementAction's type."""

    CALL = "Call"
    """Call action type."""
    READ = "Read"
    """Read action type."""
    WRITE = "Write"
    """Write action type."""


class MqttDestinationQos(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The set of supported QoS types for a MQTT destination."""

    QOS0 = "Qos0"
    """QoS 0."""
    QOS1 = "Qos1"
    """QoS 1."""


class NamespaceDiscoveredManagementActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the ManagementAction's type."""

    CALL = "Call"
    """Call action type."""
    READ = "Read"
    """Read action type."""
    WRITE = "Write"
    """Write action type."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning status of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    ACCEPTED = "Accepted"
    """Resource has been accepted by the server."""
    DELETING = "Deleting"
    """Resource is deleting."""


class SchemaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the schema type."""

    MESSAGE_SCHEMA = "MessageSchema"
    """Message Schema schema type"""


class Scope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope of the migrate resources operation."""

    RESOURCES = "Resources"
    """Scoping the migration to resourceIds provided"""


class StreamDestinationTarget(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The set of supported stream destinations for an asset."""

    MQTT = "Mqtt"
    """MQTT target."""
    STORAGE = "Storage"
    """Storage target."""


class SystemAssignedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (either system assigned, or none)."""

    NONE = "None"
    """No managed system identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed system identity."""


class TopicRetainType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Topic retain types."""

    KEEP = "Keep"
    """Retain the messages."""
    NEVER = "Never"
    """Never retain messages."""
