# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeviceRegistryMgmtNamespacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeviceRegistryMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_get(self, resource_group):
        response = self.client.namespaces.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_create_or_replace(self, resource_group):
        response = self.client.namespaces.begin_create_or_replace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {"type": "str", "principalId": "str", "tenantId": "str"},
                "name": "str",
                "properties": {
                    "messaging": {"endpoints": {"str": {"address": "str", "endpointType": "str", "resourceId": "str"}}},
                    "provisioningState": "str",
                    "uuid": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_update(self, resource_group):
        response = self.client.namespaces.begin_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            properties={
                "identity": {"type": "str", "principalId": "str", "tenantId": "str"},
                "properties": {
                    "messaging": {"endpoints": {"str": {"address": "str", "endpointType": "str", "resourceId": "str"}}}
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_delete(self, resource_group):
        response = self.client.namespaces.begin_delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_list_by_resource_group(self, resource_group):
        response = self.client.namespaces.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_list_by_subscription(self, resource_group):
        response = self.client.namespaces.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_migrate(self, resource_group):
        response = self.client.namespaces.begin_migrate(
            resource_group_name=resource_group.name,
            namespace_name="str",
            body={"resourceIds": ["str"], "scope": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
