% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-meta-has-completed.R
\docType{data}
\name{spec_meta_has_completed}
\alias{spec_meta_has_completed}
\title{spec_meta_has_completed}
\value{
\code{dbHasCompleted()} returns a logical scalar.
For a query initiated by \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}} with non-empty result set,
\code{dbHasCompleted()} returns \code{FALSE} initially
and \code{TRUE} after calling \code{\link[DBI:dbFetch]{DBI::dbFetch()}} without limit.
For a query initiated by \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}},
\code{dbHasCompleted()} always returns \code{TRUE}.
}
\description{
spec_meta_has_completed
}
\section{Failure modes}{

Attempting to query completion status for a result set cleared with
\code{\link[DBI:dbClearResult]{DBI::dbClearResult()}} gives an error.
}

\section{Specification}{

The completion status for a query is only guaranteed to be set to
\code{FALSE} after attempting to fetch past the end of the entire result.
Therefore, for a query with an empty result set,
the initial return value is unspecified,
but the result value is \code{TRUE} after trying to fetch only one row.


Similarly, for a query with a result set of length n,
the return value is unspecified after fetching n rows,
but the result value is \code{TRUE} after trying to fetch only one more
row.
}

\seealso{
Other meta specifications: 
\code{\link{spec_get_info}},
\code{\link{spec_meta_bind}},
\code{\link{spec_meta_column_info}},
\code{\link{spec_meta_get_row_count}},
\code{\link{spec_meta_get_rows_affected}},
\code{\link{spec_meta_get_statement}},
\code{\link{spec_meta_is_valid}}
}
\concept{meta specifications}
