% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5A.R
\docType{class}
\name{H5A-class}
\alias{H5A-class}
\alias{H5A}
\title{Class for representing HDF5 attributes}
\value{
Object of class \code{\link{H5A}}.
}
\description{
This class represents an HDF5 attribute. Usually it is easier to read and write attributes for
groups, datasets and committed datatypes using the functions documented in \code{\link{h5attributes}}.
}
\details{
Otherwise, the functionality for attributes is very similar to that of datasets (\code{\link{H5D}}),
however with the notable exception that attributes always have to be read and written as a whole.
}
\section{Methods}{

\describe{
\item{\code{get_info()}}{

This function implements the HDF5-API function H5Aget_info.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{attr_name()}}{

This function implements the HDF5-API function H5Aget_name.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{get_space()}}{

This function implements the HDF5-API function H5Aget_space.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{get_type(native = TRUE)}}{

This function implements the HDF5-API function H5Aget_type.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{get_storage_size()}}{

This function implements the HDF5-API function H5Aget_storage_size.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{read_low_level(buffer, mem_type, duplicate_buffer = FALSE)}}{

Only for advanced users. See documentation for \code{read} instead.
This function implements the HDF5-API function H5Aread.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{read(flags = getOption("hdf5r.h5tor_default"), drop = TRUE)}}{

Reads the data of the attribute and returns it as an R-object

\strong{Parameters}
\describe{
\item{flags}{Conversion rules for integer values. See also \code{\link{h5const}}}
\item{drop}{Logical. Should dimensions of length 1 be dropped (R-default for arrays)}
}}

\item{\code{write_low_level(buffer, mem_type)}}{

Only for advanced users. See documentation for \code{write} instead.
This function implements the HDF5-API function H5Awrite.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_a.html} for details.}

\item{\code{write(robj, mem_type = NULL,
  flush = getOption("hdf5r.flush_on_write"))}}{

Writes the data of \code{robj} to the attribute

\strong{Parameters}
\describe{
\item{robj}{The object to write into the attribute}
\item{mem_type}{The memory data type to use when transferring from HDF5 to intermediate storage. This is an 
advanced development feature and may be removed in the future.}
}}

\item{\code{print(...)}}{

Prints information for the dataset

\strong{Parameters}
\describe{
\item{...}{ignored}
}}

\item{\code{flush(scope = h5const$H5F_SCOPE_GLOBAL)}}{

This function implements the HDF5-API function H5Fflush.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_f.html} for details.}

\item{\code{get_filename()}}{

This function implements the HDF5-API function H5Fget_name.
Please see the documentation at \url{https://support.hdfgroup.org/documentation/hdf5/latest/group___h5_f.html} for details.}
}}

\examples{
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")
h5attr(file, "attr_numeric") <- rnorm(10)
a <- file$attr_open("attr_numeric")
a$get_info()
a$attr_name()
a$get_space()
a$get_type()
a$get_storage_size()
a$read()
a$write(10:1)
a$print()
a$close()
file$close_all()
}
\author{
Holger Hoefling
}
