% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undesirable_function_linter.R
\name{undesirable_function_linter}
\alias{undesirable_function_linter}
\title{Undesirable function linter}
\usage{
undesirable_function_linter(
  fun = default_undesirable_functions,
  symbol_is_undesirable = TRUE
)
}
\arguments{
\item{fun}{Character vector of undesirable function names. Input can be any of three types:
\itemize{
\item Unnamed entries must be a character string specifying an undesirable function.
\item For named entries, the name specifies the undesirable function.
\itemize{
\item If the entry is a character string, it is used as a description of
why a given function is undesirable
\item Otherwise, entries should be missing (\code{NA})
A generic message that the named function is undesirable is used if no
specific description is provided.
Input can also be a list of character strings for convenience.
}
}

Defaults to \link{default_undesirable_functions}. To make small customizations to this list,
use \code{\link[=modify_defaults]{modify_defaults()}}.}

\item{symbol_is_undesirable}{Whether to consider the use of an undesirable function
name as a symbol undesirable or not.}
}
\description{
Report the use of undesirable functions and suggest an alternative.
}
\examples{
# defaults for which functions are considered undesirable
names(default_undesirable_functions)

# will produce lints
lint(
  text = "sapply(x, mean)",
  linters = undesirable_function_linter()
)

lint(
  text = "log10(x)",
  linters = undesirable_function_linter(fun = c("log10" = NA))
)

lint(
  text = "log10(x)",
  linters = undesirable_function_linter(fun = c("log10" = "use log()"))
)

lint(
  text = 'dir <- "path/to/a/directory"',
  linters = undesirable_function_linter(fun = c("dir" = NA))
)


lint(
  text = 'dir <- "path/to/a/directory"',
  linters = undesirable_function_linter(fun = "dir")
)

# okay
lint(
  text = "vapply(x, mean, FUN.VALUE = numeric(1))",
  linters = undesirable_function_linter()
)

lint(
  text = "log(x, base = 10)",
  linters = undesirable_function_linter(fun = c("log10" = "use log()"))
)

lint(
  text = 'dir <- "path/to/a/directory"',
  linters = undesirable_function_linter(fun = c("dir" = NA), symbol_is_undesirable = FALSE)
)

lint(
  text = 'dir <- "path/to/a/directory"',
  linters = undesirable_function_linter(fun = "dir", symbol_is_undesirable = FALSE)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=robustness_linters]{robustness}, \link[=style_linters]{style}
}
