/*
 * HPFAdj.c - Define the high pass filter adjustment table.
 *
 * Copyright (C) 2025 Martin Guy <martinwguy@gmail.com>
 * based on dolbybcsoftwaredecode by Richard Evans 2018.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation. See COPYING for details.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "HPFAdj.h"

#include <stdint.h>
#include <math.h>

#define HPFAdjTabSize   1000

static uint16_t const HPFAdjTab[HPFAdjTabSize] = {
   5784, 5794, 5805, 5815, 5826, 5837, 5847, 5858, 5869, 5880,
   5890, 5902, 5912, 5923, 5934, 5947, 5957, 5968, 5979, 5998,
   6001, 6013, 6024, 6035, 6050, 6058, 6070, 6081, 6095, 6105,
   6116, 6129, 6140, 6151, 6163, 6175, 6186, 6199, 6210, 6273,
   6234, 6246, 6258, 6271, 6283, 6295, 6307, 6320, 6332, 6354,
   6356, 6369, 6381, 6395, 6406, 6420, 6432, 6446, 6467, 6482,
   6482, 6495, 6508, 6521, 6534, 6547, 6561, 6575, 6590, 6602,
   6612, 6627, 6638, 6667, 6674, 6678, 6860, 6705, 6726, 6732,
   6746, 6759, 6772, 6787, 6801, 6815, 6842, 6844, 6855, 6873,
   6966, 6898, 6931, 6924, 6939, 6952, 6968, 6984, 6995, 7216,
   7023, 7052, 7059, 7068, 7081, 7095, 7109, 7124, 7143, 7155,
   7314, 7183, 7198, 7212, 7232, 7241, 7256, 7271, 7286, 7372,
   7316, 7354, 7350, 7362, 7424, 7393, 7411, 7425, 7476, 7452,
   7469, 7484, 7549, 7514, 7542, 7545, 7568, 7576, 7592, 7613,
   7632, 7679, 7654, 7693, 7689, 7714, 7719, 7737, 7753, 7766,
   7788, 7805, 7816, 7839, 7854, 7864, 7883, 7914, 7911, 7944,
   7944, 7963, 7980, 7994, 8033, 8027, 8112, 8196, 8077, 8098,
   8110, 8130, 8150, 8254, 8194, 8196, 8212, 8231, 8246, 8263,
   8283, 8452, 8316, 8346, 8370, 8366, 8383, 8402, 8424, 8437,
   8459, 8476, 8495, 8507, 8523, 8555, 8559, 8577, 8595, 8934,
   9110, 8739, 8666, 8701, 8702, 8759, 8749, 8780, 8774, 8823,
   8814, 8837, 8858, 9022, 8882, 8906, 8921, 8939, 8960, 8989,
   8997, 9371, 9062, 9061, 9067, 9093, 9107, 9127, 9158, 9165,
   9210, 9198, 9232, 9267, 9276, 9337, 9331, 9330, 9360, 9485,
   9373, 9392, 9410, 9435, 9452, 9466, 9496, 9507, 9540,11107,
  11482,11590, 9607, 9644, 9648, 9682, 9726, 9710, 9731, 9752,
   9778, 9793, 9885, 9824, 9844, 9869, 9975, 9907, 9922, 9969,
   9975,10051,10003,10027,10079,10105,10087,10170,10140,10172,
  10204,10238,10215,10248,11472,10813,10291,10325,10355,10362,
  10389,10445,10444,10633,10459,10532,10543,10522,10594,10567,
  10688,10614,10691,10651,10672,10696,10716,11188,10762,10780,
  10810,10950,10847,10876,10897,10955,10969,11107,10987,11002,
  11033,11044,11075,11111,11118,11182,11179,11188,11215,11227,
  11407,13182,18198,22802,24307,15765,12304,11403,11433,11481,
  11471,11493,11534,11626,11561,11666,11622,11667,11660,11737,
  11700,11731,11998,11804,11870,11855,11841,11896,11916,12006,
  11949,11983,12424,12184,12039,12072,12085,12143,12137,12162,
  12191,12240,12231,12248,12751,12980,12600,12402,12458,12393,
  12594,12449,12492,12497,12613,12842,12566,12682,12617,12713,
  12729,12733,12726,12781,12771,13313,13601,13522,13434,13213,
  12919,12942,12969,13014,13119,13182,13213,13185,13124,13298,
  13203,13276,13302,13430,13284,13309,13682,13517,13454,13463,
  13655,13493,13489,13559,13562,13597,13610,14334,15551,14741,
  13753,13730,13777,13869,13852,13840,13867,14148,14057,13961,
  13990,14337,14285,14212,14086,14145,14153,14183,14240,14313,
  14431,14301,14339,14348,14348,14348,14349,14349,14349,14349,
  14349,14349,14349,14350,14350,14350,14350,14350,14350,14350,
  14351,14351,14351,14351,14351,14351,14352,14352,14352,14352,
  14352,14352,14352,14352,14353,14353,14353,14353,14353,14353,
  14354,14354,14354,14354,14354,14354,14354,14354,14355,14355,
  14355,14355,14355,14355,14355,14356,14356,14356,14356,14356,
  14356,14356,14357,14357,14357,14357,14357,14357,14357,14358,
  14358,14358,14358,14358,14358,14358,14358,14359,14359,14359,
  14359,14359,14359,14359,14359,14360,14360,14360,14360,14360,
  14360,14360,14361,14361,14361,14361,14361,14361,14361,14361,
  14362,14362,14362,14362,14362,14362,14362,14362,14363,14363,
  14363,14363,14363,14363,14363,14363,14364,14364,14364,14364,
  14364,14364,14364,14364,14365,14365,14365,14365,14365,14365,
  14365,14365,14365,14366,14366,14366,14366,14366,14366,14366,
  14366,14367,14367,14367,14367,14367,14367,14367,14367,14367,
  14368,14368,14368,14368,14368,14368,14368,14368,14368,14369,
  14369,14369,14369,14369,14369,14369,14369,14370,14370,14370,
  14370,14370,14370,14370,14370,14370,14371,14371,14371,14371,
  14371,14371,14371,14371,14371,14371,14372,14372,14372,14372,
  14372,14372,14372,14372,14372,14373,14373,14373,14373,14373,
  14373,14373,14373,14373,14374,14374,14374,14374,14374,14374,
  14374,14374,14374,14374,14375,14375,14375,14375,14375,14375,
  14375,14375,14375,14376,14376,14376,14376,14376,14376,14376,
  14376,14376,14376,14377,14377,14377,14377,14377,14377,14377,
  14377,14377,14377,14377,14378,14378,14378,14378,14378,14378,
  14378,14378,14378,14378,14379,14379,14379,14379,14379,14379,
  14379,14379,14379,14379,14380,14380,14380,14380,14380,14380,
  14380,14380,14380,14380,14380,14381,14381,14381,14381,14381,
  14381,14381,14381,14381,14381,14382,14382,14382,14382,14382,
  14382,14382,14382,14382,14382,14382,14382,14383,14383,14383,
  14383,14383,14383,14383,14383,14383,14383,14383,14384,14384,
  14384,14384,14384,14384,14384,14384,14384,14384,14384,14385,
  14385,14385,14385,14385,14385,14385,14385,14385,14385,14385,
  14385,14386,14386,14386,14386,14386,14386,14386,14386,14386,
  14386,14386,14387,14387,14387,14387,14387,14387,14387,14387,
  14387,14387,14387,14387,14388,14388,14388,14388,14388,14388,
  14388,14388,14388,14388,14388,14388,14388,14389,14389,14389,
  14389,14389,14389,14389,14389,14389,14389,14389,14389,14390,
  14390,14390,14390,14390,14390,14390,14390,14390,14390,14390,
  14390,14390,14391,14391,14391,14391,14391,14391,14391,14391,
  14391,14391,14391,14391,14391,14392,14392,14392,14392,14392,
  14392,14392,14392,14392,14392,14392,14392,14392,14393,14393,
  14393,14393,14393,14393,14393,14393,14393,14393,14393,14393,
  14393,14394,14394,14394,14394,14394,14394,14394,14394,14394,
  14394,14394,14394,14394,14394,14395,14395,14395,14395,14395,
  14395,14395,14395,14395,14395,14395,14395,14395,14395,14396,
  14396,14396,14396,14396,14396,14396,14396,14396,14396,14396,
  14396,14396,14396,14397,14397,14397,14397,14397,14397,14397,
  14397,14397,14397,14397,14397,14397,14397,14397,14398,14398,
  14398,14398,14398,14398,14398,14398,14398,14398,14398,14398,
  14398,14398,14398,14399,14399,14399,14399,14399,14399,14399,
  14399,14399,14399,14399,14399,14399,14399,14399,14400,14400,
  14400,14400,14400,14400,14400,14400,14400,14400,14400,14400,
  14400,14400,14400,14401,14401,14401,14401,14401,14401,14401,
  14401,14401,14401,14401,14401,14401,14401,14401,14401,14402
};


double HPFAdj(double FCRatio)
{
  int32_t TabLPs, TabHPs;
  uint16_t LowVal, HigVal;
  double DifVal;

  /* Set Table positions */
  TabLPs = round((FCRatio * 1000.0) - 0.5);
  if (TabLPs < 1)             TabLPs = 1;
  if (TabLPs > HPFAdjTabSize) TabLPs = HPFAdjTabSize;
  if (TabLPs < HPFAdjTabSize) TabHPs = TabLPs + 1;
  else                        TabHPs = TabLPs;

  /* Set values from table */
  LowVal = HPFAdjTab[TabLPs-1];
  HigVal = HPFAdjTab[TabHPs-1];

  /* Work out exact position above low value */
  if (FCRatio > 0.001) DifVal = 1000 * FCRatio - TabLPs;
  else                 DifVal = 0.0;

  /* Work out how much to add to LowVal */
  DifVal *= HigVal - LowVal;

  /* Return the result */
  return (LowVal + DifVal) / 10000.0;
}
