/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public final class NegativeOperand
implements ADQLOperand {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "NEGATIVE", false, "The unary operator that makes negative a given numeric value.");
    private ADQLOperand operand;
    private TextPosition position = null;

    public NegativeOperand(ADQLOperand operand) throws NullPointerException, UnsupportedOperationException {
        if (operand == null) {
            throw new NullPointerException("Impossible to negativate an operand equals to NULL!");
        }
        if (!operand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to negativate a non-numeric operand (" + operand.toADQL() + ")!");
        }
        this.operand = operand;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        NegativeOperand copy = new NegativeOperand((ADQLOperand)this.operand.getCopy());
        return copy;
    }

    @Override
    public String getName() {
        return "NEG_" + this.operand.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = NegativeOperand.this.operand == null;
            }

            @Override
            public ADQLObject next() {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return NegativeOperand.this.operand;
            }

            @Override
            public boolean hasNext() {
                return !this.operandGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.operandGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand && ((ADQLOperand)replacer).isNumeric()) {
                    NegativeOperand.this.operand = (ADQLOperand)replacer;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the operand \"" + NegativeOperand.this.operand.toADQL() + "\" by \"" + replacer.toADQL() + "\" in the NegativeOperand \"" + NegativeOperand.this.toADQL() + "\" because the replacer is not an ADQLOperand or is not numeric!");
                }
            }

            @Override
            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + NegativeOperand.this.operand.toADQL() + ") of a NegativeOperand (" + NegativeOperand.this.toADQL() + "). However you can remove the whole NegativeOperand.");
            }
        };
    }

    @Override
    public String toADQL() {
        return "-" + this.operand.toADQL();
    }
}

