package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRiskListCheckResult invokes the sas.DescribeRiskListCheckResult API synchronously
func (client *Client) DescribeRiskListCheckResult(request *DescribeRiskListCheckResultRequest) (response *DescribeRiskListCheckResultResponse, err error) {
	response = CreateDescribeRiskListCheckResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRiskListCheckResultWithChan invokes the sas.DescribeRiskListCheckResult API asynchronously
func (client *Client) DescribeRiskListCheckResultWithChan(request *DescribeRiskListCheckResultRequest) (<-chan *DescribeRiskListCheckResultResponse, <-chan error) {
	responseChan := make(chan *DescribeRiskListCheckResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRiskListCheckResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRiskListCheckResultWithCallback invokes the sas.DescribeRiskListCheckResult API asynchronously
func (client *Client) DescribeRiskListCheckResultWithCallback(request *DescribeRiskListCheckResultRequest, callback func(response *DescribeRiskListCheckResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRiskListCheckResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeRiskListCheckResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRiskListCheckResultRequest is the request struct for api DescribeRiskListCheckResult
type DescribeRiskListCheckResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
}

// DescribeRiskListCheckResultResponse is the response struct for api DescribeRiskListCheckResult
type DescribeRiskListCheckResultResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	List      []RiskCountDO `json:"List" xml:"List"`
}

// CreateDescribeRiskListCheckResultRequest creates a request to invoke DescribeRiskListCheckResult API
func CreateDescribeRiskListCheckResultRequest() (request *DescribeRiskListCheckResultRequest) {
	request = &DescribeRiskListCheckResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeRiskListCheckResult", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRiskListCheckResultResponse creates a response to parse from DescribeRiskListCheckResult response
func CreateDescribeRiskListCheckResultResponse() (response *DescribeRiskListCheckResultResponse) {
	response = &DescribeRiskListCheckResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
