package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAlert invokes the sls.DisableAlert API synchronously
func (client *Client) DisableAlert(request *DisableAlertRequest) (response *DisableAlertResponse, err error) {
	response = CreateDisableAlertResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAlertWithChan invokes the sls.DisableAlert API asynchronously
func (client *Client) DisableAlertWithChan(request *DisableAlertRequest) (<-chan *DisableAlertResponse, <-chan error) {
	responseChan := make(chan *DisableAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAlertWithCallback invokes the sls.DisableAlert API asynchronously
func (client *Client) DisableAlertWithCallback(request *DisableAlertRequest, callback func(response *DisableAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAlertResponse
		var err error
		defer close(result)
		response, err = client.DisableAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAlertRequest is the request struct for api DisableAlert
type DisableAlertRequest struct {
	*requests.RpcRequest
	App         string `position:"Body" name:"App"`
	ProjectName string `position:"Body" name:"ProjectName"`
	Endpoint    string `position:"Body" name:"Endpoint"`
	AlertId     string `position:"Body" name:"AlertId"`
}

// DisableAlertResponse is the response struct for api DisableAlert
type DisableAlertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDisableAlertRequest creates a request to invoke DisableAlert API
func CreateDisableAlertRequest() (request *DisableAlertRequest) {
	request = &DisableAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "DisableAlert", "sls", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableAlertResponse creates a response to parse from DisableAlert response
func CreateDisableAlertResponse() (response *DisableAlertResponse) {
	response = &DisableAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
