/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.LoggerListener;
import org.dita.dost.util.Configuration;
import org.slf4j.Logger;

public final class Processor {
    private final File ditaDir;
    private final Map<String, String> args;
    private Logger logger;
    private boolean cleanOnFailure = true;
    private boolean createDebugLog = true;

    Processor(File ditaDir, String transtype, Map<String, String> args) {
        this.ditaDir = ditaDir;
        this.args = new HashMap<String, String>(args);
        this.args.put("dita.dir", ditaDir.getAbsolutePath());
        this.args.put("transtype", transtype);
    }

    public Processor setInput(File input) {
        if (!input.isAbsolute()) {
            throw new IllegalArgumentException("Input file path must be absolute: " + String.valueOf(input));
        }
        if (!input.isFile()) {
            throw new IllegalArgumentException("Input file is not a file: " + String.valueOf(input));
        }
        this.setInput(input.toURI());
        return this;
    }

    public Processor setInput(URI input) {
        if (!input.isAbsolute()) {
            throw new IllegalArgumentException("Input file URI must be absolute: " + String.valueOf(input));
        }
        this.args.put("args.input", input.toString());
        return this;
    }

    public Processor setOutputDir(File output) {
        if (!output.isAbsolute()) {
            throw new IllegalArgumentException("Output directory path must be absolute: " + String.valueOf(output));
        }
        if (output.exists() && !output.isDirectory()) {
            throw new IllegalArgumentException("Output directory exists and is not a directory: " + String.valueOf(output));
        }
        this.args.put("output.dir", output.getAbsolutePath());
        return this;
    }

    public Processor setOutputDir(URI output) {
        if (!output.isAbsolute()) {
            throw new IllegalArgumentException("Output directory URI must be absolute: " + String.valueOf(output));
        }
        if (!output.getScheme().equals("file")) {
            throw new IllegalArgumentException("Only file scheme allowed as output directory URI: " + String.valueOf(output));
        }
        this.args.put("output.dir", output.toString());
        return this;
    }

    public Processor setProperty(String name, String value) {
        this.args.put(name, value);
        return this;
    }

    public Processor setProperties(Map<String, String> value) {
        this.args.putAll(value);
        return this;
    }

    public Processor setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Processor cleanOnFailure(boolean cleanOnFailure) {
        this.cleanOnFailure = cleanOnFailure;
        return this;
    }

    public Processor createDebugLog(boolean createDebugLog) {
        this.createDebugLog = createDebugLog;
        return this;
    }

    public Processor setMode(Configuration.Mode mode) {
        this.args.put("processing-mode", mode.toString().toLowerCase());
        return this;
    }

    public void run() throws DITAOTException {
        if (!this.args.containsKey("args.input")) {
            throw new IllegalStateException("Input file not set");
        }
        if (!this.args.containsKey("output.dir")) {
            throw new IllegalStateException("Output directory not set");
        }
        File tempDir = this.getTempDir();
        this.args.put("dita.temp.dir", tempDir.getAbsolutePath());
        boolean cleanTemp = true;
        ch.qos.logback.classic.Logger debugLogger = this.createDebugLog ? this.openDebugLogger(tempDir) : null;
        try {
            File basePluginDir = new File(this.ditaDir, Configuration.pluginResourceDirs.get("org.dita.base").getPath());
            File buildFile = new File(basePluginDir, "build.xml");
            Project project = new Project();
            project.setCoreLoader(this.getClass().getClassLoader());
            if (this.logger != null) {
                project.addBuildListener((BuildListener)new LoggerListener(this.logger));
            }
            if (debugLogger != null) {
                project.addBuildListener((BuildListener)new LoggerListener((Logger)debugLogger));
            }
            project.fireBuildStarted();
            project.init();
            project.setBaseDir(this.ditaDir);
            project.setKeepGoingMode(false);
            for (Map.Entry<String, String> arg : this.args.entrySet()) {
                project.setUserProperty(arg.getKey(), arg.getValue());
            }
            ProjectHelper.configureProject((Project)project, (File)buildFile);
            Vector<CallSite> targets = new Vector<CallSite>();
            targets.addElement((CallSite)((Object)("dita2" + this.args.get("transtype"))));
            project.executeTargets(targets);
        }
        catch (BuildException e) {
            cleanTemp = this.cleanOnFailure;
            throw new DITAOTException(e);
        }
        finally {
            block17: {
                if (debugLogger != null) {
                    this.closeDebugLogger(debugLogger);
                }
                if (cleanTemp) {
                    try {
                        FileUtils.forceDelete((File)tempDir);
                    }
                    catch (IOException ex) {
                        if (this.logger == null) break block17;
                        this.logger.error("Failed to delete temporary directory " + String.valueOf(tempDir));
                    }
                }
            }
        }
    }

    private ch.qos.logback.classic.Logger openDebugLogger(File tempDir) {
        LoggerContext loggerContext = new LoggerContext();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(new File(tempDir.getAbsolutePath() + ".log").getAbsolutePath());
        fileAppender.setContext((Context)loggerContext);
        fileAppender.setAppend(false);
        fileAppender.setImmediateFlush(true);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%-4relative [%-5level] %msg%n");
        encoder.start();
        fileAppender.setEncoder((Encoder)encoder);
        fileAppender.start();
        ch.qos.logback.classic.Logger debugLogger = loggerContext.getLogger(this.getClass().getCanonicalName() + "_" + System.currentTimeMillis());
        debugLogger.addAppender((Appender)fileAppender);
        debugLogger.setLevel(Level.DEBUG);
        return debugLogger;
    }

    private void closeDebugLogger(ch.qos.logback.classic.Logger debugLogger) {
        debugLogger.detachAndStopAllAppenders();
    }

    private File getTempDir() {
        File baseTempDir = new File(this.args.get("base.temp.dir"));
        for (int i = 0; i < 10; ++i) {
            File tempDir = new File(baseTempDir, Long.toString(System.currentTimeMillis()));
            if (!tempDir.exists()) {
                try {
                    FileUtils.forceMkdir((File)tempDir);
                    return tempDir;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Unable to create temporary directory");
    }
}

