"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseManager = void 0;
const signaling_1 = require("@lumino/signaling");
const serverconnection_1 = require("./serverconnection");
class BaseManager {
    constructor(options) {
        var _a;
        this._isDisposed = false;
        this._disposed = new signaling_1.Signal(this);
        this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    }
    /**
     * A signal emitted when the delegate is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Test whether the delegate has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the delegate and invoke the callback function.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._disposed.emit(undefined);
        signaling_1.Signal.clearData(this);
    }
}
exports.BaseManager = BaseManager;
//# sourceMappingURL=basemanager.js.map