/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificateKt;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001aR\u0013\u0010!\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0011\u0010,\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)\u00a8\u0006."}, d2={"Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "Lorg/signal/libsignal/internal/NativeHandleGuard$SimpleOwner;", "serialized", "", "<init>", "([B)V", "nativeHandle", "", "(J)V", "release", "", "signer", "Lorg/signal/libsignal/metadata/certificate/ServerCertificate;", "getSigner", "()Lorg/signal/libsignal/metadata/certificate/ServerCertificate;", "key", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getKey", "()Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "senderDeviceId", "", "getSenderDeviceId", "()I", "senderUuid", "", "getSenderUuid", "()Ljava/lang/String;", "senderE164", "Ljava/util/Optional;", "getSenderE164", "()Ljava/util/Optional;", "sender", "getSender", "senderAci", "Lorg/signal/libsignal/protocol/ServiceId$Aci;", "getSenderAci", "()Lorg/signal/libsignal/protocol/ServiceId$Aci;", "expiration", "getExpiration", "()J", "getSerialized", "()[B", "certificate", "getCertificate", "signature", "getSignature", "libsignal-client"})
public final class SenderCertificate
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.SenderCertificate_Destroy(nativeHandle);
    }

    public SenderCertificate(@NotNull byte[] serialized) throws InvalidCertificateException {
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        super(SenderCertificateKt.access$createNativeFrom(serialized));
    }

    public SenderCertificate(long nativeHandle) {
        super(nativeHandle);
    }

    @NotNull
    public final ServerCertificate getSigner() {
        Long l = this.guardedMapChecked(Native::SenderCertificate_GetServerCertificate);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMapChecked(...)");
        return new ServerCertificate(((Number)l).longValue());
    }

    @NotNull
    public final ECPublicKey getKey() {
        Long l = this.guardedMapChecked(Native::SenderCertificate_GetKey);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMapChecked(...)");
        return new ECPublicKey(((Number)l).longValue());
    }

    public final int getSenderDeviceId() {
        Integer n = this.guardedMapChecked(Native::SenderCertificate_GetDeviceId);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"guardedMapChecked(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public final String getSenderUuid() {
        String string = this.guardedMapChecked(Native::SenderCertificate_GetSenderUuid);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guardedMapChecked(...)");
        return string;
    }

    @NotNull
    public final Optional<String> getSenderE164() {
        Optional<String> optional = Optional.ofNullable(this.guardedMapChecked(Native::SenderCertificate_GetSenderE164));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final String getSender() {
        return this.getSenderUuid();
    }

    @Nullable
    public final ServiceId.Aci getSenderAci() {
        try {
            return ServiceId.Aci.parseFromString(this.getSender());
        }
        catch (ServiceId.InvalidServiceIdException e) {
            return null;
        }
    }

    public final long getExpiration() {
        Long l = this.guardedMapChecked(Native::SenderCertificate_GetExpiration);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMapChecked(...)");
        return ((Number)l).longValue();
    }

    @NotNull
    public final byte[] getSerialized() {
        byte[] byArray = this.guardedMapChecked(Native::SenderCertificate_GetSerialized);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getCertificate() {
        byte[] byArray = this.guardedMapChecked(Native::SenderCertificate_GetCertificate);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getSignature() {
        byte[] byArray = this.guardedMapChecked(Native::SenderCertificate_GetSignature);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }
}

