/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.MimeUtils;
import org.asamk.signal.manager.util.Utils;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.util.StreamDetails;

public class AttachmentStore {
    private final File attachmentsPath;

    public AttachmentStore(File attachmentsPath) {
        this.attachmentsPath = attachmentsPath;
    }

    public void storeAttachmentPreview(SignalServiceAttachmentPointer pointer, AttachmentStorer storer) throws IOException {
        this.storeAttachment(this.getAttachmentPreviewFile(pointer.getRemoteId(), pointer.getFileName(), Optional.ofNullable(pointer.getContentType())), storer);
    }

    public void storeAttachment(SignalServiceAttachmentPointer pointer, AttachmentStorer storer) throws IOException {
        this.storeAttachment(this.getAttachmentFile(pointer), storer);
    }

    public File getAttachmentFile(SignalServiceAttachmentPointer pointer) {
        return this.getAttachmentFile(pointer.getRemoteId(), pointer.getFileName(), Optional.ofNullable(pointer.getContentType()));
    }

    public StreamDetails retrieveAttachment(String id) throws IOException {
        File attachmentFile = new File(this.attachmentsPath, id);
        return Utils.createStreamDetailsFromFile(attachmentFile);
    }

    private void storeAttachment(File attachmentFile, AttachmentStorer storer) throws IOException {
        this.createAttachmentsDir();
        try (FileOutputStream output = new FileOutputStream(attachmentFile);){
            storer.store(output);
        }
    }

    private File getAttachmentPreviewFile(SignalServiceAttachmentRemoteId attachmentId, Optional<String> filename, Optional<String> contentType) {
        String extension = AttachmentStore.getAttachmentExtension(filename, contentType);
        return new File(this.attachmentsPath, attachmentId.toString() + extension + ".preview");
    }

    private File getAttachmentFile(SignalServiceAttachmentRemoteId attachmentId, Optional<String> filename, Optional<String> contentType) {
        String extension = AttachmentStore.getAttachmentExtension(filename, contentType);
        return new File(this.attachmentsPath, attachmentId.toString() + extension);
    }

    private static String getAttachmentExtension(Optional<String> filename, Optional<String> contentType) {
        return filename.filter(f -> f.contains(".")).map(f -> f.substring(f.lastIndexOf(".") + 1)).or(() -> contentType.flatMap(MimeUtils::guessExtensionFromMimeType)).map(ext -> "." + ext).orElse("");
    }

    private void createAttachmentsDir() throws IOException {
        IOUtils.createPrivateDirectories(this.attachmentsPath);
    }

    @FunctionalInterface
    public static interface AttachmentStorer {
        public void store(OutputStream var1) throws IOException;
    }
}

