/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.stickerPacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.storage.stickerPacks.JsonStickerPack;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.Utils;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.util.Hex;

public class StickerPackStore {
    private final File stickersPath;

    public StickerPackStore(File stickersPath) {
        this.stickersPath = stickersPath;
    }

    public boolean existsStickerPack(StickerPackId stickerPackId) {
        return this.getStickerPackManifestFile(stickerPackId).exists();
    }

    public JsonStickerPack retrieveManifest(StickerPackId stickerPackId) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.getStickerPackManifestFile(stickerPackId));){
            JsonStickerPack jsonStickerPack = (JsonStickerPack)new ObjectMapper().readValue((InputStream)inputStream, JsonStickerPack.class);
            return jsonStickerPack;
        }
    }

    public StreamDetails retrieveSticker(StickerPackId stickerPackId, int stickerId) throws IOException {
        File stickerFile = this.getStickerPackStickerFile(stickerPackId, stickerId);
        if (!stickerFile.exists()) {
            return null;
        }
        return Utils.createStreamDetailsFromFile(stickerFile);
    }

    public void storeManifest(StickerPackId stickerPackId, JsonStickerPack manifest) throws IOException {
        try (FileOutputStream output = new FileOutputStream(this.getStickerPackManifestFile(stickerPackId));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
            new ObjectMapper().writeValue((Writer)writer, (Object)manifest);
        }
    }

    public void storeSticker(StickerPackId stickerPackId, int stickerId, StickerStorer storer) throws IOException {
        this.createStickerPackDir(stickerPackId);
        try (FileOutputStream output = new FileOutputStream(this.getStickerPackStickerFile(stickerPackId, stickerId));){
            storer.store(output);
        }
    }

    private File getStickerPackManifestFile(StickerPackId stickerPackId) {
        return new File(this.getStickerPackPath(stickerPackId), "manifest.json");
    }

    private File getStickerPackStickerFile(StickerPackId stickerPackId, int stickerId) {
        return new File(this.getStickerPackPath(stickerPackId), String.valueOf(stickerId));
    }

    private File getStickerPackPath(StickerPackId stickerPackId) {
        return new File(this.stickersPath, Hex.toStringCondensed((byte[])stickerPackId.serialize()));
    }

    private void createStickerPackDir(StickerPackId stickerPackId) throws IOException {
        IOUtils.createPrivateDirectories(this.getStickerPackPath(stickerPackId));
    }

    @FunctionalInterface
    public static interface StickerStorer {
        public void store(OutputStream var1) throws IOException;
    }
}

