/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.push.TrustStore;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalUrl;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a!\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"chooseUrl", "T", "Lorg/whispersystems/signalservice/internal/configuration/SignalUrl;", "", "([Lorg/whispersystems/signalservice/internal/configuration/SignalUrl;)Lorg/whispersystems/signalservice/internal/configuration/SignalUrl;", "buildOkHttpClient", "Lokhttp3/OkHttpClient;", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "(Lorg/whispersystems/signalservice/internal/configuration/SignalUrl;Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;)Lokhttp3/OkHttpClient;", "createTlsSocketFactory", "Lkotlin/Pair;", "Ljavax/net/ssl/SSLSocketFactory;", "Ljavax/net/ssl/X509TrustManager;", "trustStore", "Lorg/whispersystems/signalservice/api/push/TrustStore;", "signal-service-java"})
public final class SignalUrlExtensionsKt {
    @NotNull
    public static final <T extends SignalUrl> T chooseUrl(@NotNull T[] $this$chooseUrl) {
        Intrinsics.checkNotNullParameter($this$chooseUrl, (String)"<this>");
        return $this$chooseUrl[(int)(Math.random() * (double)$this$chooseUrl.length)];
    }

    @NotNull
    public static final <T extends SignalUrl> OkHttpClient buildOkHttpClient(@NotNull T $this$buildOkHttpClient, @NotNull SignalServiceConfiguration configuration) {
        Intrinsics.checkNotNullParameter($this$buildOkHttpClient, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        TrustStore trustStore = $this$buildOkHttpClient.getTrustStore();
        Intrinsics.checkNotNullExpressionValue((Object)trustStore, (String)"getTrustStore(...)");
        Pair<SSLSocketFactory, X509TrustManager> pair = SignalUrlExtensionsKt.createTlsSocketFactory(trustStore);
        SSLSocketFactory socketFactory = (SSLSocketFactory)pair.component1();
        X509TrustManager trustManager = (X509TrustManager)pair.component2();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(socketFactory, trustManager);
        ConnectionSpec[] connectionSpecArray = new ConnectionSpec[]{ConnectionSpec.RESTRICTED_TLS};
        List<ConnectionSpec> list = $this$buildOkHttpClient.getConnectionSpecs().orElse(Util.immutableList(connectionSpecArray));
        Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
        OkHttpClient.Builder builder2 = builder.connectionSpecs(list).retryOnConnectionFailure(false).readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS);
        for (Interceptor interceptor : configuration.getNetworkInterceptors()) {
            builder2.addInterceptor(interceptor);
        }
        if (configuration.getSignalProxy().isPresent()) {
            SignalProxy signalProxy = configuration.getSignalProxy().get();
            Intrinsics.checkNotNullExpressionValue((Object)signalProxy, (String)"get(...)");
            SignalProxy proxy = signalProxy;
            builder2.socketFactory((SocketFactory)new TlsProxySocketFactory(proxy.getHost(), proxy.getPort(), configuration.getDns()));
        }
        return builder2.build();
    }

    private static final Pair<SSLSocketFactory, X509TrustManager> createTlsSocketFactory(TrustStore trustStore) {
        Pair pair;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = BlacklistingTrustManager.createFor(trustStore);
            context.init(null, trustManagers, null);
            Tls12SocketFactory tls12SocketFactory = new Tls12SocketFactory(context.getSocketFactory());
            TrustManager trustManager = trustManagers[0];
            Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            pair = TuplesKt.to((Object)tls12SocketFactory, (Object)((X509TrustManager)trustManager));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        return pair;
    }
}

