/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.serialize;

import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.messages.SignalServiceMetadata;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.serialize.SignalServiceAddressProtobufSerializer;
import org.whispersystems.signalservice.internal.serialize.protos.MetadataProto;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/internal/serialize/SignalServiceMetadataProtobufSerializer;", "", "<init>", "()V", "toProtobuf", "Lorg/whispersystems/signalservice/internal/serialize/protos/MetadataProto;", "metadata", "Lorg/whispersystems/signalservice/api/messages/SignalServiceMetadata;", "fromProtobuf", "signal-service-java"})
public final class SignalServiceMetadataProtobufSerializer {
    @NotNull
    public static final SignalServiceMetadataProtobufSerializer INSTANCE = new SignalServiceMetadataProtobufSerializer();

    private SignalServiceMetadataProtobufSerializer() {
    }

    @NotNull
    public final MetadataProto toProtobuf(@NotNull SignalServiceMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        MetadataProto.Builder builder = new MetadataProto.Builder();
        SignalServiceAddress signalServiceAddress = metadata.getSender();
        Intrinsics.checkNotNullExpressionValue((Object)signalServiceAddress, (String)"getSender(...)");
        MetadataProto.Builder builder2 = builder.address(SignalServiceAddressProtobufSerializer.toProtobuf(signalServiceAddress)).senderDevice(metadata.getSenderDevice()).needsReceipt(metadata.isNeedsReceipt()).timestamp(metadata.getTimestamp()).serverReceivedTimestamp(metadata.getServerReceivedTimestamp()).serverDeliveredTimestamp(metadata.getServerDeliveredTimestamp()).serverGuid(metadata.getServerGuid()).destinationUuid(metadata.getDestinationUuid());
        if (metadata.getGroupId().isPresent()) {
            byte[] byArray = metadata.getGroupId().get();
            builder2.groupId(ByteString.Companion.of(Arrays.copyOf(byArray, byArray.length)));
        }
        return builder2.build();
    }

    @NotNull
    public final SignalServiceMetadata fromProtobuf(@NotNull MetadataProto metadata) {
        Intrinsics.checkNotNullParameter((Object)((Object)metadata), (String)"metadata");
        if (metadata.address == null) {
            throw new IllegalArgumentException("Missing address in metadata");
        }
        Integer n = metadata.senderDevice;
        Long l = metadata.timestamp;
        Long l2 = metadata.serverReceivedTimestamp;
        Long l3 = metadata.serverDeliveredTimestamp;
        Boolean bl = metadata.needsReceipt;
        ByteString byteString = metadata.groupId;
        return new SignalServiceMetadata(SignalServiceAddressProtobufSerializer.fromProtobuf(metadata.address), n != null ? n : 0, l != null ? l : 0L, l2 != null ? l2 : 0L, l3 != null ? l3 : 0L, bl != null ? bl : false, metadata.serverGuid, Optional.ofNullable((byte[])(byteString != null ? byteString.toByteArray() : null)), metadata.destinationUuid);
    }
}

