// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package secretsmanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetSecretValue = "BatchGetSecretValue"

// BatchGetSecretValueRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetSecretValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetSecretValue for more information on using the BatchGetSecretValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetSecretValueRequest method.
//	req, resp := client.BatchGetSecretValueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue
func (c *SecretsManager) BatchGetSecretValueRequest(input *BatchGetSecretValueInput) (req *request.Request, output *BatchGetSecretValueOutput) {
	op := &request.Operation{
		Name:       opBatchGetSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetSecretValueInput{}
	}

	output = &BatchGetSecretValueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetSecretValue API operation for AWS Secrets Manager.
//
// Retrieves the contents of the encrypted fields SecretString or SecretBinary
// for up to 20 secrets. To retrieve a single secret, call GetSecretValue.
//
// To choose which secrets to retrieve, you can specify a list of secrets by
// name or ARN, or you can use filters. If Secrets Manager encounters errors
// such as AccessDeniedException while attempting to retrieve any of the secrets,
// you can see the errors in Errors in the response.
//
// Secrets Manager generates CloudTrail GetSecretValue log entries for each
// secret you request when you call this action. Do not include sensitive information
// in request parameters because it might be logged. For more information, see
// Logging Secrets Manager events with CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:BatchGetSecretValue, and you must have
// secretsmanager:GetSecretValue for each secret. If you use filters, you must
// also have secretsmanager:ListSecrets. If the secrets are encrypted using
// customer-managed keys instead of the Amazon Web Services managed key aws/secretsmanager,
// then you also need kms:Decrypt permissions for the keys. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation BatchGetSecretValue for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - DecryptionFailure
//     Secrets Manager can't decrypt the protected secret text using the provided
//     KMS key.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidNextTokenException
//     The NextToken value is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/BatchGetSecretValue
func (c *SecretsManager) BatchGetSecretValue(input *BatchGetSecretValueInput) (*BatchGetSecretValueOutput, error) {
	req, out := c.BatchGetSecretValueRequest(input)
	return out, req.Send()
}

// BatchGetSecretValueWithContext is the same as BatchGetSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) BatchGetSecretValueWithContext(ctx aws.Context, input *BatchGetSecretValueInput, opts ...request.Option) (*BatchGetSecretValueOutput, error) {
	req, out := c.BatchGetSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetSecretValuePages iterates over the pages of a BatchGetSecretValue operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetSecretValue method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a BatchGetSecretValue operation.
//	pageNum := 0
//	err := client.BatchGetSecretValuePages(params,
//	    func(page *secretsmanager.BatchGetSecretValueOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecretsManager) BatchGetSecretValuePages(input *BatchGetSecretValueInput, fn func(*BatchGetSecretValueOutput, bool) bool) error {
	return c.BatchGetSecretValuePagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetSecretValuePagesWithContext same as BatchGetSecretValuePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) BatchGetSecretValuePagesWithContext(ctx aws.Context, input *BatchGetSecretValueInput, fn func(*BatchGetSecretValueOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetSecretValueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetSecretValueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*BatchGetSecretValueOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opCancelRotateSecret = "CancelRotateSecret"

// CancelRotateSecretRequest generates a "aws/request.Request" representing the
// client's request for the CancelRotateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelRotateSecret for more information on using the CancelRotateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelRotateSecretRequest method.
//	req, resp := client.CancelRotateSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret
func (c *SecretsManager) CancelRotateSecretRequest(input *CancelRotateSecretInput) (req *request.Request, output *CancelRotateSecretOutput) {
	op := &request.Operation{
		Name:       opCancelRotateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRotateSecretInput{}
	}

	output = &CancelRotateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelRotateSecret API operation for AWS Secrets Manager.
//
// Turns off automatic rotation, and if a rotation is currently in progress,
// cancels the rotation.
//
// If you cancel a rotation in progress, it can leave the VersionStage labels
// in an unexpected state. You might need to remove the staging label AWSPENDING
// from the partially created version. You also need to determine whether to
// roll back to the previous version of the secret by moving the staging label
// AWSCURRENT to the version that has AWSPENDING. To determine which version
// has a specific staging label, call ListSecretVersionIds. Then use UpdateSecretVersionStage
// to change staging labels. For more information, see How rotation works (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html).
//
// To turn on automatic rotation again, call RotateSecret.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:CancelRotateSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation CancelRotateSecret for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CancelRotateSecret
func (c *SecretsManager) CancelRotateSecret(input *CancelRotateSecretInput) (*CancelRotateSecretOutput, error) {
	req, out := c.CancelRotateSecretRequest(input)
	return out, req.Send()
}

// CancelRotateSecretWithContext is the same as CancelRotateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See CancelRotateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) CancelRotateSecretWithContext(ctx aws.Context, input *CancelRotateSecretInput, opts ...request.Option) (*CancelRotateSecretOutput, error) {
	req, out := c.CancelRotateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecret = "CreateSecret"

// CreateSecretRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecret for more information on using the CreateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSecretRequest method.
//	req, resp := client.CreateSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret
func (c *SecretsManager) CreateSecretRequest(input *CreateSecretInput) (req *request.Request, output *CreateSecretOutput) {
	op := &request.Operation{
		Name:       opCreateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecretInput{}
	}

	output = &CreateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecret API operation for AWS Secrets Manager.
//
// Creates a new secret. A secret can be a password, a set of credentials such
// as a user name and password, an OAuth token, or other secret information
// that you store in an encrypted form in Secrets Manager. The secret also includes
// the connection information to access a database or other service, which Secrets
// Manager doesn't encrypt. A secret in Secrets Manager consists of both the
// protected secret data and the important information needed to manage the
// secret.
//
// For secrets that use managed rotation, you need to create the secret through
// the managing service. For more information, see Secrets Manager secrets managed
// by other Amazon Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
// For information about creating a secret in the console, see Create a secret
// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html).
//
// To create a secret, you can provide the secret value to be encrypted in either
// the SecretString parameter or the SecretBinary parameter, but not both. If
// you include SecretString or SecretBinary then Secrets Manager creates an
// initial secret version and automatically attaches the staging label AWSCURRENT
// to it.
//
// For database credentials you want to rotate, for Secrets Manager to be able
// to rotate the secret, you must make sure the JSON you store in the SecretString
// matches the JSON structure of a database secret (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_secret_json_structure.html).
//
// If you don't specify an KMS encryption key, Secrets Manager uses the Amazon
// Web Services managed key aws/secretsmanager. If this key doesn't already
// exist in your account, then Secrets Manager creates it for you automatically.
// All users and roles in the Amazon Web Services account automatically have
// access to use aws/secretsmanager. Creating aws/secretsmanager can result
// in a one-time significant delay in returning the result.
//
// If the secret is in a different Amazon Web Services account from the credentials
// calling the API, then you can't use aws/secretsmanager to encrypt the secret,
// and you must create and use a customer managed KMS key.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters except SecretBinary
// or SecretString because it might be logged. For more information, see Logging
// Secrets Manager events with CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:CreateSecret. If you include tags in
// the secret, you also need secretsmanager:TagResource. To add replica Regions,
// you must also have secretsmanager:ReplicateSecretToRegions. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// To encrypt the secret with a KMS key other than aws/secretsmanager, you need
// kms:GenerateDataKey and kms:Decrypt permission to the key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation CreateSecret for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - LimitExceededException
//     The request failed because it would exceed one of the Secrets Manager quotas.
//
//   - EncryptionFailure
//     Secrets Manager can't encrypt the protected secret text using the provided
//     KMS key. Check that the KMS key is available, enabled, and not in an invalid
//     state. For more information, see Key state: Effect on your KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   - ResourceExistsException
//     A resource with the ID you requested already exists.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - MalformedPolicyDocumentException
//     The resource policy has syntax errors.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - PreconditionNotMetException
//     The request failed because you did not complete all the prerequisite steps.
//
//   - DecryptionFailure
//     Secrets Manager can't decrypt the protected secret text using the provided
//     KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/CreateSecret
func (c *SecretsManager) CreateSecret(input *CreateSecretInput) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	return out, req.Send()
}

// CreateSecretWithContext is the same as CreateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) CreateSecretWithContext(ctx aws.Context, input *CreateSecretInput, opts ...request.Option) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy
func (c *SecretsManager) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicy API operation for AWS Secrets Manager.
//
// Deletes the resource-based permission policy attached to the secret. To attach
// a policy to a secret, use PutResourcePolicy.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:DeleteResourcePolicy. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteResourcePolicy
func (c *SecretsManager) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecret = "DeleteSecret"

// DeleteSecretRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecret for more information on using the DeleteSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSecretRequest method.
//	req, resp := client.DeleteSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret
func (c *SecretsManager) DeleteSecretRequest(input *DeleteSecretInput) (req *request.Request, output *DeleteSecretOutput) {
	op := &request.Operation{
		Name:       opDeleteSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecretInput{}
	}

	output = &DeleteSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSecret API operation for AWS Secrets Manager.
//
// Deletes a secret and all of its versions. You can specify a recovery window
// during which you can restore the secret. The minimum recovery window is 7
// days. The default recovery window is 30 days. Secrets Manager attaches a
// DeletionDate stamp to the secret that specifies the end of the recovery window.
// At the end of the recovery window, Secrets Manager deletes the secret permanently.
//
// You can't delete a primary secret that is replicated to other Regions. You
// must first delete the replicas using RemoveRegionsFromReplication, and then
// delete the primary secret. When you delete a replica, it is deleted immediately.
//
// You can't directly delete a version of a secret. Instead, you remove all
// staging labels from the version using UpdateSecretVersionStage. This marks
// the version as deprecated, and then Secrets Manager can automatically delete
// the version in the background.
//
// To determine whether an application still uses a secret, you can create an
// Amazon CloudWatch alarm to alert you to any attempts to access a secret during
// the recovery window. For more information, see Monitor secrets scheduled
// for deletion (https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring_cloudwatch_deleted-secrets.html).
//
// Secrets Manager performs the permanent secret deletion at the end of the
// waiting period as a background task with low priority. There is no guarantee
// of a specific time after the recovery window for the permanent delete to
// occur.
//
// At any time before recovery window ends, you can use RestoreSecret to remove
// the DeletionDate and cancel the deletion of the secret.
//
// When a secret is scheduled for deletion, you cannot retrieve the secret value.
// You must first cancel the deletion with RestoreSecret and then you can retrieve
// the secret.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:DeleteSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DeleteSecret for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DeleteSecret
func (c *SecretsManager) DeleteSecret(input *DeleteSecretInput) (*DeleteSecretOutput, error) {
	req, out := c.DeleteSecretRequest(input)
	return out, req.Send()
}

// DeleteSecretWithContext is the same as DeleteSecret with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DeleteSecretWithContext(ctx aws.Context, input *DeleteSecretInput, opts ...request.Option) (*DeleteSecretOutput, error) {
	req, out := c.DeleteSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecret = "DescribeSecret"

// DescribeSecretRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecret for more information on using the DescribeSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSecretRequest method.
//	req, resp := client.DescribeSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret
func (c *SecretsManager) DescribeSecretRequest(input *DescribeSecretInput) (req *request.Request, output *DescribeSecretOutput) {
	op := &request.Operation{
		Name:       opDescribeSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecretInput{}
	}

	output = &DescribeSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecret API operation for AWS Secrets Manager.
//
// Retrieves the details of a secret. It does not include the encrypted secret
// value. Secrets Manager only returns fields that have a value in the response.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:DescribeSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation DescribeSecret for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/DescribeSecret
func (c *SecretsManager) DescribeSecret(input *DescribeSecretInput) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	return out, req.Send()
}

// DescribeSecretWithContext is the same as DescribeSecret with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) DescribeSecretWithContext(ctx aws.Context, input *DescribeSecretInput, opts ...request.Option) (*DescribeSecretOutput, error) {
	req, out := c.DescribeSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRandomPassword = "GetRandomPassword"

// GetRandomPasswordRequest generates a "aws/request.Request" representing the
// client's request for the GetRandomPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRandomPassword for more information on using the GetRandomPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRandomPasswordRequest method.
//	req, resp := client.GetRandomPasswordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword
func (c *SecretsManager) GetRandomPasswordRequest(input *GetRandomPasswordInput) (req *request.Request, output *GetRandomPasswordOutput) {
	op := &request.Operation{
		Name:       opGetRandomPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRandomPasswordInput{}
	}

	output = &GetRandomPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRandomPassword API operation for AWS Secrets Manager.
//
// Generates a random password. We recommend that you specify the maximum length
// and include every character type that the system you are generating a password
// for can support. By default, Secrets Manager uses uppercase and lowercase
// letters, numbers, and the following characters in passwords: !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
//
// Required permissions: secretsmanager:GetRandomPassword. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetRandomPassword for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetRandomPassword
func (c *SecretsManager) GetRandomPassword(input *GetRandomPasswordInput) (*GetRandomPasswordOutput, error) {
	req, out := c.GetRandomPasswordRequest(input)
	return out, req.Send()
}

// GetRandomPasswordWithContext is the same as GetRandomPassword with the addition of
// the ability to pass a context and additional request options.
//
// See GetRandomPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetRandomPasswordWithContext(ctx aws.Context, input *GetRandomPasswordInput, opts ...request.Option) (*GetRandomPasswordOutput, error) {
	req, out := c.GetRandomPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy
func (c *SecretsManager) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS Secrets Manager.
//
// Retrieves the JSON text of the resource-based policy document attached to
// the secret. For more information about permissions policies attached to a
// secret, see Permissions policies attached to a secret (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html).
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:GetResourcePolicy. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetResourcePolicy
func (c *SecretsManager) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecretValue = "GetSecretValue"

// GetSecretValueRequest generates a "aws/request.Request" representing the
// client's request for the GetSecretValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecretValue for more information on using the GetSecretValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSecretValueRequest method.
//	req, resp := client.GetSecretValueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue
func (c *SecretsManager) GetSecretValueRequest(input *GetSecretValueInput) (req *request.Request, output *GetSecretValueOutput) {
	op := &request.Operation{
		Name:       opGetSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecretValueInput{}
	}

	output = &GetSecretValueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecretValue API operation for AWS Secrets Manager.
//
// Retrieves the contents of the encrypted fields SecretString or SecretBinary
// from the specified version of a secret, whichever contains content.
//
// To retrieve the values for a group of secrets, call BatchGetSecretValue.
//
// We recommend that you cache your secret values by using client-side caching.
// Caching secrets improves speed and reduces your costs. For more information,
// see Cache secrets for your applications (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html).
//
// To retrieve the previous version of a secret, use VersionStage and specify
// AWSPREVIOUS. To revert to the previous version of a secret, call UpdateSecretVersionStage
// (https://docs.aws.amazon.com/cli/latest/reference/secretsmanager/update-secret-version-stage.html).
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:GetSecretValue. If the secret is encrypted
// using a customer-managed key instead of the Amazon Web Services managed key
// aws/secretsmanager, then you also need kms:Decrypt permissions for that key.
// For more information, see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation GetSecretValue for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - DecryptionFailure
//     Secrets Manager can't decrypt the protected secret text using the provided
//     KMS key.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/GetSecretValue
func (c *SecretsManager) GetSecretValue(input *GetSecretValueInput) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	return out, req.Send()
}

// GetSecretValueWithContext is the same as GetSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) GetSecretValueWithContext(ctx aws.Context, input *GetSecretValueInput, opts ...request.Option) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecretVersionIds = "ListSecretVersionIds"

// ListSecretVersionIdsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecretVersionIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecretVersionIds for more information on using the ListSecretVersionIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecretVersionIdsRequest method.
//	req, resp := client.ListSecretVersionIdsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds
func (c *SecretsManager) ListSecretVersionIdsRequest(input *ListSecretVersionIdsInput) (req *request.Request, output *ListSecretVersionIdsOutput) {
	op := &request.Operation{
		Name:       opListSecretVersionIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecretVersionIdsInput{}
	}

	output = &ListSecretVersionIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecretVersionIds API operation for AWS Secrets Manager.
//
// Lists the versions of a secret. Secrets Manager uses staging labels to indicate
// the different versions of a secret. For more information, see Secrets Manager
// concepts: Versions (https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
//
// To list the secrets in the account, use ListSecrets.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:ListSecretVersionIds. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ListSecretVersionIds for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The NextToken value is invalid.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecretVersionIds
func (c *SecretsManager) ListSecretVersionIds(input *ListSecretVersionIdsInput) (*ListSecretVersionIdsOutput, error) {
	req, out := c.ListSecretVersionIdsRequest(input)
	return out, req.Send()
}

// ListSecretVersionIdsWithContext is the same as ListSecretVersionIds with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecretVersionIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretVersionIdsWithContext(ctx aws.Context, input *ListSecretVersionIdsInput, opts ...request.Option) (*ListSecretVersionIdsOutput, error) {
	req, out := c.ListSecretVersionIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecretVersionIdsPages iterates over the pages of a ListSecretVersionIds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecretVersionIds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecretVersionIds operation.
//	pageNum := 0
//	err := client.ListSecretVersionIdsPages(params,
//	    func(page *secretsmanager.ListSecretVersionIdsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecretsManager) ListSecretVersionIdsPages(input *ListSecretVersionIdsInput, fn func(*ListSecretVersionIdsOutput, bool) bool) error {
	return c.ListSecretVersionIdsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecretVersionIdsPagesWithContext same as ListSecretVersionIdsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretVersionIdsPagesWithContext(ctx aws.Context, input *ListSecretVersionIdsInput, fn func(*ListSecretVersionIdsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecretVersionIdsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecretVersionIdsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecretVersionIdsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecrets = "ListSecrets"

// ListSecretsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecrets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecrets for more information on using the ListSecrets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecretsRequest method.
//	req, resp := client.ListSecretsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets
func (c *SecretsManager) ListSecretsRequest(input *ListSecretsInput) (req *request.Request, output *ListSecretsOutput) {
	op := &request.Operation{
		Name:       opListSecrets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecretsInput{}
	}

	output = &ListSecretsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecrets API operation for AWS Secrets Manager.
//
// Lists the secrets that are stored by Secrets Manager in the Amazon Web Services
// account, not including secrets that are marked for deletion. To see secrets
// marked for deletion, use the Secrets Manager console.
//
// All Secrets Manager operations are eventually consistent. ListSecrets might
// not reflect changes from the last five minutes. You can get more recent information
// for a specific secret by calling DescribeSecret.
//
// To list the versions of a secret, use ListSecretVersionIds.
//
// To retrieve the values for the secrets, call BatchGetSecretValue or GetSecretValue.
//
// For information about finding secrets in the console, see Find secrets in
// Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html).
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:ListSecrets. For more information, see
// IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ListSecrets for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidNextTokenException
//     The NextToken value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ListSecrets
func (c *SecretsManager) ListSecrets(input *ListSecretsInput) (*ListSecretsOutput, error) {
	req, out := c.ListSecretsRequest(input)
	return out, req.Send()
}

// ListSecretsWithContext is the same as ListSecrets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecrets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretsWithContext(ctx aws.Context, input *ListSecretsInput, opts ...request.Option) (*ListSecretsOutput, error) {
	req, out := c.ListSecretsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecretsPages iterates over the pages of a ListSecrets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecrets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecrets operation.
//	pageNum := 0
//	err := client.ListSecretsPages(params,
//	    func(page *secretsmanager.ListSecretsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecretsManager) ListSecretsPages(input *ListSecretsInput, fn func(*ListSecretsOutput, bool) bool) error {
	return c.ListSecretsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecretsPagesWithContext same as ListSecretsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ListSecretsPagesWithContext(ctx aws.Context, input *ListSecretsInput, fn func(*ListSecretsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecretsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecretsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecretsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy
func (c *SecretsManager) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for AWS Secrets Manager.
//
// Attaches a resource-based permission policy to a secret. A resource-based
// policy is optional. For more information, see Authentication and access control
// for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html)
//
// For information about attaching a policy in the console, see Attach a permissions
// policy to a secret (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html).
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:PutResourcePolicy. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - MalformedPolicyDocumentException
//     The resource policy has syntax errors.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - PublicPolicyException
//     The BlockPublicPolicy parameter is set to true, and the resource policy did
//     not prevent broad access to the secret.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutResourcePolicy
func (c *SecretsManager) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSecretValue = "PutSecretValue"

// PutSecretValueRequest generates a "aws/request.Request" representing the
// client's request for the PutSecretValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSecretValue for more information on using the PutSecretValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSecretValueRequest method.
//	req, resp := client.PutSecretValueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue
func (c *SecretsManager) PutSecretValueRequest(input *PutSecretValueInput) (req *request.Request, output *PutSecretValueOutput) {
	op := &request.Operation{
		Name:       opPutSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSecretValueInput{}
	}

	output = &PutSecretValueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSecretValue API operation for AWS Secrets Manager.
//
// Creates a new version with a new encrypted secret value and attaches it to
// the secret. The version can contain a new SecretString value or a new SecretBinary
// value.
//
// We recommend you avoid calling PutSecretValue at a sustained rate of more
// than once every 10 minutes. When you update the secret value, Secrets Manager
// creates a new version of the secret. Secrets Manager removes outdated versions
// when there are more than 100, but it does not remove versions created less
// than 24 hours ago. If you call PutSecretValue more than once every 10 minutes,
// you create more versions than Secrets Manager removes, and you will reach
// the quota for secret versions.
//
// You can specify the staging labels to attach to the new version in VersionStages.
// If you don't include VersionStages, then Secrets Manager automatically moves
// the staging label AWSCURRENT to this version. If this operation creates the
// first version for the secret, then Secrets Manager automatically attaches
// the staging label AWSCURRENT to it. If this operation moves the staging label
// AWSCURRENT from another version to this version, then Secrets Manager also
// automatically moves the staging label AWSPREVIOUS to the version that AWSCURRENT
// was removed from.
//
// This operation is idempotent. If you call this operation with a ClientRequestToken
// that matches an existing version's VersionId, and you specify the same secret
// data, the operation succeeds but does nothing. However, if the secret data
// is different, then the operation fails because you can't modify an existing
// version; you can only create new ones.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters except SecretBinary,
// SecretString, or RotationToken because it might be logged. For more information,
// see Logging Secrets Manager events with CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:PutSecretValue. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation PutSecretValue for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - LimitExceededException
//     The request failed because it would exceed one of the Secrets Manager quotas.
//
//   - EncryptionFailure
//     Secrets Manager can't encrypt the protected secret text using the provided
//     KMS key. Check that the KMS key is available, enabled, and not in an invalid
//     state. For more information, see Key state: Effect on your KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   - ResourceExistsException
//     A resource with the ID you requested already exists.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - DecryptionFailure
//     Secrets Manager can't decrypt the protected secret text using the provided
//     KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/PutSecretValue
func (c *SecretsManager) PutSecretValue(input *PutSecretValueInput) (*PutSecretValueOutput, error) {
	req, out := c.PutSecretValueRequest(input)
	return out, req.Send()
}

// PutSecretValueWithContext is the same as PutSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See PutSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) PutSecretValueWithContext(ctx aws.Context, input *PutSecretValueInput, opts ...request.Option) (*PutSecretValueOutput, error) {
	req, out := c.PutSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRegionsFromReplication = "RemoveRegionsFromReplication"

// RemoveRegionsFromReplicationRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRegionsFromReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRegionsFromReplication for more information on using the RemoveRegionsFromReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveRegionsFromReplicationRequest method.
//	req, resp := client.RemoveRegionsFromReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication
func (c *SecretsManager) RemoveRegionsFromReplicationRequest(input *RemoveRegionsFromReplicationInput) (req *request.Request, output *RemoveRegionsFromReplicationOutput) {
	op := &request.Operation{
		Name:       opRemoveRegionsFromReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRegionsFromReplicationInput{}
	}

	output = &RemoveRegionsFromReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveRegionsFromReplication API operation for AWS Secrets Manager.
//
// For a secret that is replicated to other Regions, deletes the secret replicas
// from the Regions you specify.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:RemoveRegionsFromReplication. For more
// information, see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RemoveRegionsFromReplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RemoveRegionsFromReplication
func (c *SecretsManager) RemoveRegionsFromReplication(input *RemoveRegionsFromReplicationInput) (*RemoveRegionsFromReplicationOutput, error) {
	req, out := c.RemoveRegionsFromReplicationRequest(input)
	return out, req.Send()
}

// RemoveRegionsFromReplicationWithContext is the same as RemoveRegionsFromReplication with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRegionsFromReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RemoveRegionsFromReplicationWithContext(ctx aws.Context, input *RemoveRegionsFromReplicationInput, opts ...request.Option) (*RemoveRegionsFromReplicationOutput, error) {
	req, out := c.RemoveRegionsFromReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplicateSecretToRegions = "ReplicateSecretToRegions"

// ReplicateSecretToRegionsRequest generates a "aws/request.Request" representing the
// client's request for the ReplicateSecretToRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplicateSecretToRegions for more information on using the ReplicateSecretToRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReplicateSecretToRegionsRequest method.
//	req, resp := client.ReplicateSecretToRegionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions
func (c *SecretsManager) ReplicateSecretToRegionsRequest(input *ReplicateSecretToRegionsInput) (req *request.Request, output *ReplicateSecretToRegionsOutput) {
	op := &request.Operation{
		Name:       opReplicateSecretToRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplicateSecretToRegionsInput{}
	}

	output = &ReplicateSecretToRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplicateSecretToRegions API operation for AWS Secrets Manager.
//
// Replicates the secret to a new Regions. See Multi-Region secrets (https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html).
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:ReplicateSecretToRegions. If the primary
// secret is encrypted with a KMS key other than aws/secretsmanager, you also
// need kms:Decrypt permission to the key. To encrypt the replicated secret
// with a KMS key other than aws/secretsmanager, you need kms:GenerateDataKey
// and kms:Encrypt to the key. For more information, see IAM policy actions
// for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ReplicateSecretToRegions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ReplicateSecretToRegions
func (c *SecretsManager) ReplicateSecretToRegions(input *ReplicateSecretToRegionsInput) (*ReplicateSecretToRegionsOutput, error) {
	req, out := c.ReplicateSecretToRegionsRequest(input)
	return out, req.Send()
}

// ReplicateSecretToRegionsWithContext is the same as ReplicateSecretToRegions with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateSecretToRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ReplicateSecretToRegionsWithContext(ctx aws.Context, input *ReplicateSecretToRegionsInput, opts ...request.Option) (*ReplicateSecretToRegionsOutput, error) {
	req, out := c.ReplicateSecretToRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreSecret = "RestoreSecret"

// RestoreSecretRequest generates a "aws/request.Request" representing the
// client's request for the RestoreSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreSecret for more information on using the RestoreSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreSecretRequest method.
//	req, resp := client.RestoreSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret
func (c *SecretsManager) RestoreSecretRequest(input *RestoreSecretInput) (req *request.Request, output *RestoreSecretOutput) {
	op := &request.Operation{
		Name:       opRestoreSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreSecretInput{}
	}

	output = &RestoreSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreSecret API operation for AWS Secrets Manager.
//
// Cancels the scheduled deletion of a secret by removing the DeletedDate time
// stamp. You can access a secret again after it has been restored.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:RestoreSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RestoreSecret for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RestoreSecret
func (c *SecretsManager) RestoreSecret(input *RestoreSecretInput) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	return out, req.Send()
}

// RestoreSecretWithContext is the same as RestoreSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RestoreSecretWithContext(ctx aws.Context, input *RestoreSecretInput, opts ...request.Option) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateSecret = "RotateSecret"

// RotateSecretRequest generates a "aws/request.Request" representing the
// client's request for the RotateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RotateSecret for more information on using the RotateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RotateSecretRequest method.
//	req, resp := client.RotateSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret
func (c *SecretsManager) RotateSecretRequest(input *RotateSecretInput) (req *request.Request, output *RotateSecretOutput) {
	op := &request.Operation{
		Name:       opRotateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateSecretInput{}
	}

	output = &RotateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateSecret API operation for AWS Secrets Manager.
//
// Configures and starts the asynchronous process of rotating the secret. For
// information about rotation, see Rotate secrets (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html)
// in the Secrets Manager User Guide. If you include the configuration parameters,
// the operation sets the values for the secret and then immediately starts
// a rotation. If you don't include the configuration parameters, the operation
// starts a rotation with the values already stored in the secret.
//
// When rotation is successful, the AWSPENDING staging label might be attached
// to the same version as the AWSCURRENT version, or it might not be attached
// to any version. If the AWSPENDING staging label is present but not attached
// to the same version as AWSCURRENT, then any later invocation of RotateSecret
// assumes that a previous rotation request is still in progress and returns
// an error. When rotation is unsuccessful, the AWSPENDING staging label might
// be attached to an empty secret version. For more information, see Troubleshoot
// rotation (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot_rotation.html)
// in the Secrets Manager User Guide.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:RotateSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
// You also need lambda:InvokeFunction permissions on the rotation function.
// For more information, see Permissions for rotation (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets-required-permissions-function.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation RotateSecret for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/RotateSecret
func (c *SecretsManager) RotateSecret(input *RotateSecretInput) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	return out, req.Send()
}

// RotateSecretWithContext is the same as RotateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RotateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) RotateSecretWithContext(ctx aws.Context, input *RotateSecretInput, opts ...request.Option) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplicationToReplica = "StopReplicationToReplica"

// StopReplicationToReplicaRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationToReplica operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplicationToReplica for more information on using the StopReplicationToReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopReplicationToReplicaRequest method.
//	req, resp := client.StopReplicationToReplicaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica
func (c *SecretsManager) StopReplicationToReplicaRequest(input *StopReplicationToReplicaInput) (req *request.Request, output *StopReplicationToReplicaOutput) {
	op := &request.Operation{
		Name:       opStopReplicationToReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationToReplicaInput{}
	}

	output = &StopReplicationToReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplicationToReplica API operation for AWS Secrets Manager.
//
// Removes the link between the replica secret and the primary secret and promotes
// the replica to a primary secret in the replica Region.
//
// You must call this operation from the Region in which you want to promote
// the replica to a primary secret.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:StopReplicationToReplica. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation StopReplicationToReplica for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/StopReplicationToReplica
func (c *SecretsManager) StopReplicationToReplica(input *StopReplicationToReplicaInput) (*StopReplicationToReplicaOutput, error) {
	req, out := c.StopReplicationToReplicaRequest(input)
	return out, req.Send()
}

// StopReplicationToReplicaWithContext is the same as StopReplicationToReplica with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplicationToReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) StopReplicationToReplicaWithContext(ctx aws.Context, input *StopReplicationToReplicaInput, opts ...request.Option) (*StopReplicationToReplicaOutput, error) {
	req, out := c.StopReplicationToReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource
func (c *SecretsManager) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Secrets Manager.
//
// Attaches tags to a secret. Tags consist of a key name and a value. Tags are
// part of the secret's metadata. They are not associated with specific versions
// of the secret. This operation appends tags to the existing list of tags.
//
// For tag quotas and naming restrictions, see Service quotas for Tagging (https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas)
// in the Amazon Web Services General Reference guide.
//
// If you use tags as part of your security strategy, then adding or removing
// a tag can change permissions. If successfully completing this operation would
// result in you losing your permissions for this secret, then the operation
// is blocked and returns an Access Denied error.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:TagResource. For more information, see
// IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/TagResource
func (c *SecretsManager) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource
func (c *SecretsManager) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Secrets Manager.
//
// Removes specific tags from a secret.
//
// This operation is idempotent. If a requested tag is not attached to the secret,
// no error is returned and the secret metadata is unchanged.
//
// If you use tags as part of your security strategy, then removing a tag can
// change permissions. If successfully completing this operation would result
// in you losing your permissions for this secret, then the operation is blocked
// and returns an Access Denied error.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:UntagResource. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UntagResource
func (c *SecretsManager) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecret = "UpdateSecret"

// UpdateSecretRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecret operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecret for more information on using the UpdateSecret
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecretRequest method.
//	req, resp := client.UpdateSecretRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret
func (c *SecretsManager) UpdateSecretRequest(input *UpdateSecretInput) (req *request.Request, output *UpdateSecretOutput) {
	op := &request.Operation{
		Name:       opUpdateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretInput{}
	}

	output = &UpdateSecretOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecret API operation for AWS Secrets Manager.
//
// Modifies the details of a secret, including metadata and the secret value.
// To change the secret value, you can also use PutSecretValue.
//
// To change the rotation configuration of a secret, use RotateSecret instead.
//
// To change a secret so that it is managed by another service, you need to
// recreate the secret in that service. See Secrets Manager secrets managed
// by other Amazon Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
// We recommend you avoid calling UpdateSecret at a sustained rate of more than
// once every 10 minutes. When you call UpdateSecret to update the secret value,
// Secrets Manager creates a new version of the secret. Secrets Manager removes
// outdated versions when there are more than 100, but it does not remove versions
// created less than 24 hours ago. If you update the secret value more than
// once every 10 minutes, you create more versions than Secrets Manager removes,
// and you will reach the quota for secret versions.
//
// If you include SecretString or SecretBinary to create a new secret version,
// Secrets Manager automatically moves the staging label AWSCURRENT to the new
// version. Then it attaches the label AWSPREVIOUS to the version that AWSCURRENT
// was removed from.
//
// If you call this operation with a ClientRequestToken that matches an existing
// version's VersionId, the operation results in an error. You can't modify
// an existing version, you can only create a new version. To remove a version,
// remove all staging labels from it. See UpdateSecretVersionStage.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters except SecretBinary
// or SecretString because it might be logged. For more information, see Logging
// Secrets Manager events with CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:UpdateSecret. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
// If you use a customer managed key, you must also have kms:GenerateDataKey,
// kms:Encrypt, and kms:Decrypt permissions on the key. If you change the KMS
// key and you don't have kms:Encrypt permission to the new key, Secrets Manager
// does not re-ecrypt existing secret versions with the new key. For more information,
// see Secret encryption and decryption (https://docs.aws.amazon.com/secretsmanager/latest/userguide/security-encryption.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UpdateSecret for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - LimitExceededException
//     The request failed because it would exceed one of the Secrets Manager quotas.
//
//   - EncryptionFailure
//     Secrets Manager can't encrypt the protected secret text using the provided
//     KMS key. Check that the KMS key is available, enabled, and not in an invalid
//     state. For more information, see Key state: Effect on your KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
//
//   - ResourceExistsException
//     A resource with the ID you requested already exists.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - MalformedPolicyDocumentException
//     The resource policy has syntax errors.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - PreconditionNotMetException
//     The request failed because you did not complete all the prerequisite steps.
//
//   - DecryptionFailure
//     Secrets Manager can't decrypt the protected secret text using the provided
//     KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecret
func (c *SecretsManager) UpdateSecret(input *UpdateSecretInput) (*UpdateSecretOutput, error) {
	req, out := c.UpdateSecretRequest(input)
	return out, req.Send()
}

// UpdateSecretWithContext is the same as UpdateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UpdateSecretWithContext(ctx aws.Context, input *UpdateSecretInput, opts ...request.Option) (*UpdateSecretOutput, error) {
	req, out := c.UpdateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecretVersionStage = "UpdateSecretVersionStage"

// UpdateSecretVersionStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecretVersionStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecretVersionStage for more information on using the UpdateSecretVersionStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecretVersionStageRequest method.
//	req, resp := client.UpdateSecretVersionStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage
func (c *SecretsManager) UpdateSecretVersionStageRequest(input *UpdateSecretVersionStageInput) (req *request.Request, output *UpdateSecretVersionStageOutput) {
	op := &request.Operation{
		Name:       opUpdateSecretVersionStage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretVersionStageInput{}
	}

	output = &UpdateSecretVersionStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecretVersionStage API operation for AWS Secrets Manager.
//
// Modifies the staging labels attached to a version of a secret. Secrets Manager
// uses staging labels to track a version as it progresses through the secret
// rotation process. Each staging label can be attached to only one version
// at a time. To add a staging label to a version when it is already attached
// to another version, Secrets Manager first removes it from the other version
// first and then attaches it to this one. For more information about versions
// and staging labels, see Concepts: Version (https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
//
// The staging labels that you specify in the VersionStage parameter are added
// to the existing list of staging labels for the version.
//
// You can move the AWSCURRENT staging label to this version by including it
// in this call.
//
// Whenever you move AWSCURRENT, Secrets Manager automatically moves the label
// AWSPREVIOUS to the version that AWSCURRENT was removed from.
//
// If this action results in the last label being removed from a version, then
// the version is considered to be 'deprecated' and can be deleted by Secrets
// Manager.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:UpdateSecretVersionStage. For more information,
// see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation UpdateSecretVersionStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
//   - LimitExceededException
//     The request failed because it would exceed one of the Secrets Manager quotas.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage
func (c *SecretsManager) UpdateSecretVersionStage(input *UpdateSecretVersionStageInput) (*UpdateSecretVersionStageOutput, error) {
	req, out := c.UpdateSecretVersionStageRequest(input)
	return out, req.Send()
}

// UpdateSecretVersionStageWithContext is the same as UpdateSecretVersionStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecretVersionStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) UpdateSecretVersionStageWithContext(ctx aws.Context, input *UpdateSecretVersionStageInput, opts ...request.Option) (*UpdateSecretVersionStageOutput, error) {
	req, out := c.UpdateSecretVersionStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateResourcePolicy = "ValidateResourcePolicy"

// ValidateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the ValidateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateResourcePolicy for more information on using the ValidateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateResourcePolicyRequest method.
//	req, resp := client.ValidateResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy
func (c *SecretsManager) ValidateResourcePolicyRequest(input *ValidateResourcePolicyInput) (req *request.Request, output *ValidateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opValidateResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateResourcePolicyInput{}
	}

	output = &ValidateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateResourcePolicy API operation for AWS Secrets Manager.
//
// Validates that a resource policy does not grant a wide range of principals
// access to your secret. A resource-based policy is optional for secrets.
//
// The API performs three checks when validating the policy:
//
//   - Sends a call to Zelkova (https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/),
//     an automated reasoning engine, to ensure your resource policy does not
//     allow broad access to your secret, for example policies that use a wildcard
//     for the principal.
//
//   - Checks for correct syntax in a policy.
//
//   - Verifies the policy does not lock out a caller.
//
// Secrets Manager generates a CloudTrail log entry when you call this action.
// Do not include sensitive information in request parameters because it might
// be logged. For more information, see Logging Secrets Manager events with
// CloudTrail (https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieve-ct-entries.html).
//
// Required permissions: secretsmanager:ValidateResourcePolicy and secretsmanager:PutResourcePolicy.
// For more information, see IAM policy actions for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions)
// and Authentication and access control in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Secrets Manager's
// API operation ValidateResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - MalformedPolicyDocumentException
//     The resource policy has syntax errors.
//
//   - ResourceNotFoundException
//     Secrets Manager can't find the resource that you asked for.
//
//   - InvalidParameterException
//     The parameter name or value is invalid.
//
//   - InternalServiceError
//     An error occurred on the server side.
//
//   - InvalidRequestException
//     A parameter value is not valid for the current state of the resource.
//
//     Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/ValidateResourcePolicy
func (c *SecretsManager) ValidateResourcePolicy(input *ValidateResourcePolicyInput) (*ValidateResourcePolicyOutput, error) {
	req, out := c.ValidateResourcePolicyRequest(input)
	return out, req.Send()
}

// ValidateResourcePolicyWithContext is the same as ValidateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecretsManager) ValidateResourcePolicyWithContext(ctx aws.Context, input *ValidateResourcePolicyInput, opts ...request.Option) (*ValidateResourcePolicyOutput, error) {
	req, out := c.ValidateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The error Secrets Manager encountered while retrieving an individual secret
// as part of BatchGetSecretValue.
type APIErrorType struct {
	_ struct{} `type:"structure"`

	// The error Secrets Manager encountered while retrieving an individual secret
	// as part of BatchGetSecretValue, for example ResourceNotFoundException,InvalidParameterException,
	// InvalidRequestException, DecryptionFailure, or AccessDeniedException.
	ErrorCode *string `type:"string"`

	// A message describing the error.
	Message *string `type:"string"`

	// The ARN or name of the secret.
	SecretId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APIErrorType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APIErrorType) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *APIErrorType) SetErrorCode(v string) *APIErrorType {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *APIErrorType) SetMessage(v string) *APIErrorType {
	s.Message = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *APIErrorType) SetSecretId(v string) *APIErrorType {
	s.SecretId = &v
	return s
}

type BatchGetSecretValueInput struct {
	_ struct{} `type:"structure"`

	// The filters to choose which secrets to retrieve. You must include Filters
	// or SecretIdList, but not both.
	Filters []*Filter `type:"list"`

	// The number of results to include in the response.
	//
	// If there are more results available, in the response, Secrets Manager includes
	// NextToken. To get the next results, call BatchGetSecretValue again with the
	// value from NextToken. To use this parameter, you must also use the Filters
	// parameter.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates where the output should continue from, if a previous
	// call did not show all results. To get the next results, call BatchGetSecretValue
	// again with this value.
	NextToken *string `min:"1" type:"string"`

	// The ARN or names of the secrets to retrieve. You must include Filters or
	// SecretIdList, but not both.
	SecretIdList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSecretValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetSecretValueInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SecretIdList != nil && len(s.SecretIdList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretIdList", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *BatchGetSecretValueInput) SetFilters(v []*Filter) *BatchGetSecretValueInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *BatchGetSecretValueInput) SetMaxResults(v int64) *BatchGetSecretValueInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetSecretValueInput) SetNextToken(v string) *BatchGetSecretValueInput {
	s.NextToken = &v
	return s
}

// SetSecretIdList sets the SecretIdList field's value.
func (s *BatchGetSecretValueInput) SetSecretIdList(v []*string) *BatchGetSecretValueInput {
	s.SecretIdList = v
	return s
}

type BatchGetSecretValueOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors Secrets Manager encountered while attempting to retrieve
	// individual secrets.
	Errors []*APIErrorType `type:"list"`

	// Secrets Manager includes this value if there's more output available than
	// what is included in the current response. This can occur even when the response
	// includes no values at all, such as when you ask for a filtered view of a
	// long list. To get the next results, call BatchGetSecretValue again with this
	// value.
	NextToken *string `min:"1" type:"string"`

	// A list of secret values.
	SecretValues []*SecretValueEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSecretValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetSecretValueOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetSecretValueOutput) SetErrors(v []*APIErrorType) *BatchGetSecretValueOutput {
	s.Errors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetSecretValueOutput) SetNextToken(v string) *BatchGetSecretValueOutput {
	s.NextToken = &v
	return s
}

// SetSecretValues sets the SecretValues field's value.
func (s *BatchGetSecretValueOutput) SetSecretValues(v []*SecretValueEntry) *BatchGetSecretValueOutput {
	s.SecretValues = v
	return s
}

type CancelRotateSecretInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRotateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRotateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRotateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRotateSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *CancelRotateSecretInput) SetSecretId(v string) *CancelRotateSecretInput {
	s.SecretId = &v
	return s
}

type CancelRotateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the version of the secret created during the rotation.
	// This version might not be complete, and should be evaluated for possible
	// deletion. We recommend that you remove the VersionStage value AWSPENDING
	// from this version so that Secrets Manager can delete it. Failing to clean
	// up a cancelled rotation can block you from starting future rotations.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRotateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelRotateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CancelRotateSecretOutput) SetARN(v string) *CancelRotateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *CancelRotateSecretOutput) SetName(v string) *CancelRotateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CancelRotateSecretOutput) SetVersionId(v string) *CancelRotateSecretOutput {
	s.VersionId = &v
	return s
}

type CreateSecretInput struct {
	_ struct{} `type:"structure"`

	// A list of Regions and KMS keys to replicate secrets.
	AddReplicaRegions []*ReplicaRegionType `min:"1" type:"list"`

	// If you include SecretString or SecretBinary, then Secrets Manager creates
	// an initial version for the secret, and this parameter specifies the unique
	// identifier for the new version.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDKs to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes it as the value for
	// this parameter in the request.
	//
	// If you generate a raw HTTP request to the Secrets Manager service endpoint,
	// then you must generate a ClientRequestToken and include it in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and the version SecretString
	//    and SecretBinary values are the same as those in the request, then the
	//    request is ignored.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    and SecretBinary values are different from those in the request, then
	//    the request fails because you cannot modify an existing version. Instead,
	//    use PutSecretValue to create a new version.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The description of the secret.
	Description *string `type:"string"`

	// Specifies whether to overwrite a secret with the same name in the destination
	// Region. By default, secrets aren't overwritten.
	ForceOverwriteReplicaSecret *bool `type:"boolean"`

	// The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt
	// the secret value in the secret. An alias is always prefixed by alias/, for
	// example alias/aws/secretsmanager. For more information, see About aliases
	// (https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
	//
	// To use a KMS key in a different account, use the key ARN or the alias ARN.
	//
	// If you don't specify this value, then Secrets Manager uses the key aws/secretsmanager.
	// If that key doesn't yet exist, then Secrets Manager creates it for you automatically
	// the first time it encrypts the secret value.
	//
	// If the secret is in a different Amazon Web Services account from the credentials
	// calling the API, then you can't use aws/secretsmanager to encrypt the secret,
	// and you must create and use a customer managed KMS key.
	KmsKeyId *string `type:"string"`

	// The name of the new secret.
	//
	// The secret name can contain ASCII letters, numbers, and the following characters:
	// /_+=.@-
	//
	// Do not end your secret name with a hyphen followed by six characters. If
	// you do so, you risk confusion and unexpected results when searching for a
	// secret by partial ARN. Secrets Manager automatically adds a hyphen and six
	// random characters after the secret name at the end of the ARN.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The binary data to encrypt and store in the new version of the secret. We
	// recommend that you store your binary data in a file and then pass the contents
	// of the file as a parameter.
	//
	// Either SecretString or SecretBinary must have a value, but not both.
	//
	// This parameter is not available in the Secrets Manager console.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretBinary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSecretInput's
	// String and GoString methods.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `min:"1" type:"blob" sensitive:"true"`

	// The text data to encrypt and store in this new version of the secret. We
	// recommend you use a JSON structure of key/value pairs for your secret value.
	//
	// Either SecretString or SecretBinary must have a value, but not both.
	//
	// If you create a secret by using the Secrets Manager console then Secrets
	// Manager puts the protected secret text in only the SecretString parameter.
	// The Secrets Manager console stores the information as a JSON structure of
	// key/value pairs that a Lambda rotation function can parse.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSecretInput's
	// String and GoString methods.
	SecretString *string `min:"1" type:"string" sensitive:"true"`

	// A list of tags to attach to the secret. Each tag is a key and value pair
	// of strings in a JSON text string, for example:
	//
	// [{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]
	//
	// Secrets Manager tag key names are case sensitive. A tag with the key "ABC"
	// is a different tag from one with key "abc".
	//
	// If you check tags in permissions policies as part of your security strategy,
	// then adding or removing a tag can change permissions. If the completion of
	// this operation would result in you losing your permissions for this secret,
	// then Secrets Manager blocks the operation and returns an Access Denied error.
	// For more information, see Control access to secrets using tags (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac)
	// and Limit access to identities with tags that match secrets' tags (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2).
	//
	// For information about how to format a JSON parameter for the various command
	// line tool environments, see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json).
	// If your command-line tool or SDK requires quotation marks around the parameter,
	// you should use single quotes to avoid confusion with the double quotes required
	// in the JSON text.
	//
	// For tag quotas and naming restrictions, see Service quotas for Tagging (https://docs.aws.amazon.com/general/latest/gr/arg.html#taged-reference-quotas)
	// in the Amazon Web Services General Reference guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecretInput"}
	if s.AddReplicaRegions != nil && len(s.AddReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddReplicaRegions", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SecretBinary != nil && len(s.SecretBinary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretBinary", 1))
	}
	if s.SecretString != nil && len(*s.SecretString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretString", 1))
	}
	if s.AddReplicaRegions != nil {
		for i, v := range s.AddReplicaRegions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddReplicaRegions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddReplicaRegions sets the AddReplicaRegions field's value.
func (s *CreateSecretInput) SetAddReplicaRegions(v []*ReplicaRegionType) *CreateSecretInput {
	s.AddReplicaRegions = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSecretInput) SetClientRequestToken(v string) *CreateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecretInput) SetDescription(v string) *CreateSecretInput {
	s.Description = &v
	return s
}

// SetForceOverwriteReplicaSecret sets the ForceOverwriteReplicaSecret field's value.
func (s *CreateSecretInput) SetForceOverwriteReplicaSecret(v bool) *CreateSecretInput {
	s.ForceOverwriteReplicaSecret = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSecretInput) SetKmsKeyId(v string) *CreateSecretInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecretInput) SetName(v string) *CreateSecretInput {
	s.Name = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *CreateSecretInput) SetSecretBinary(v []byte) *CreateSecretInput {
	s.SecretBinary = v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *CreateSecretInput) SetSecretString(v string) *CreateSecretInput {
	s.SecretString = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecretInput) SetTags(v []*Tag) *CreateSecretInput {
	s.Tags = v
	return s
}

type CreateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new secret. The ARN includes the name of the secret followed
	// by six random characters. This ensures that if you create a new secret with
	// the same name as a deleted secret, then users with access to the old secret
	// don't get access to the new secret because the ARNs are different.
	ARN *string `min:"20" type:"string"`

	// The name of the new secret.
	Name *string `min:"1" type:"string"`

	// A list of the replicas of this secret and their status:
	//
	//    * Failed, which indicates that the replica was not created.
	//
	//    * InProgress, which indicates that Secrets Manager is in the process of
	//    creating the replica.
	//
	//    * InSync, which indicates that the replica was created.
	ReplicationStatus []*ReplicationStatusType `type:"list"`

	// The unique identifier associated with the version of the new secret.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CreateSecretOutput) SetARN(v string) *CreateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecretOutput) SetName(v string) *CreateSecretOutput {
	s.Name = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *CreateSecretOutput) SetReplicationStatus(v []*ReplicationStatusType) *CreateSecretOutput {
	s.ReplicationStatus = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateSecretOutput) SetVersionId(v string) *CreateSecretOutput {
	s.VersionId = &v
	return s
}

// Secrets Manager can't decrypt the protected secret text using the provided
// KMS key.
type DecryptionFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptionFailure) GoString() string {
	return s.String()
}

func newErrorDecryptionFailure(v protocol.ResponseMetadata) error {
	return &DecryptionFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DecryptionFailure) Code() string {
	return "DecryptionFailure"
}

// Message returns the exception's message.
func (s *DecryptionFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DecryptionFailure) OrigErr() error {
	return nil
}

func (s *DecryptionFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DecryptionFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DecryptionFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret to delete the attached resource-based policy
	// for.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *DeleteResourcePolicyInput) SetSecretId(v string) *DeleteResourcePolicyInput {
	s.SecretId = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that the resource-based policy was deleted for.
	ARN *string `min:"20" type:"string"`

	// The name of the secret that the resource-based policy was deleted for.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DeleteResourcePolicyOutput) SetARN(v string) *DeleteResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteResourcePolicyOutput) SetName(v string) *DeleteResourcePolicyOutput {
	s.Name = &v
	return s
}

type DeleteSecretInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to delete the secret without any recovery window. You can't
	// use both this parameter and RecoveryWindowInDays in the same call. If you
	// don't use either, then by default Secrets Manager uses a 30 day recovery
	// window.
	//
	// Secrets Manager performs the actual deletion with an asynchronous background
	// process, so there might be a short delay before the secret is permanently
	// deleted. If you delete a secret and then immediately create a secret with
	// the same name, use appropriate back off and retry logic.
	//
	// If you forcibly delete an already deleted or nonexistent secret, the operation
	// does not return ResourceNotFoundException.
	//
	// Use this parameter with caution. This parameter causes the operation to skip
	// the normal recovery window before the permanent deletion that Secrets Manager
	// would normally impose with the RecoveryWindowInDays parameter. If you delete
	// a secret with the ForceDeleteWithoutRecovery parameter, then you have no
	// opportunity to recover the secret. You lose the secret permanently.
	ForceDeleteWithoutRecovery *bool `type:"boolean"`

	// The number of days from 7 to 30 that Secrets Manager waits before permanently
	// deleting the secret. You can't use both this parameter and ForceDeleteWithoutRecovery
	// in the same call. If you don't use either, then by default Secrets Manager
	// uses a 30 day recovery window.
	RecoveryWindowInDays *int64 `type:"long"`

	// The ARN or name of the secret to delete.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDeleteWithoutRecovery sets the ForceDeleteWithoutRecovery field's value.
func (s *DeleteSecretInput) SetForceDeleteWithoutRecovery(v bool) *DeleteSecretInput {
	s.ForceDeleteWithoutRecovery = &v
	return s
}

// SetRecoveryWindowInDays sets the RecoveryWindowInDays field's value.
func (s *DeleteSecretInput) SetRecoveryWindowInDays(v int64) *DeleteSecretInput {
	s.RecoveryWindowInDays = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *DeleteSecretInput) SetSecretId(v string) *DeleteSecretInput {
	s.SecretId = &v
	return s
}

type DeleteSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The date and time after which this secret Secrets Manager can permanently
	// delete this secret, and it can no longer be restored. This value is the date
	// and time of the delete request plus the number of days in RecoveryWindowInDays.
	DeletionDate *time.Time `type:"timestamp"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DeleteSecretOutput) SetARN(v string) *DeleteSecretOutput {
	s.ARN = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *DeleteSecretOutput) SetDeletionDate(v time.Time) *DeleteSecretOutput {
	s.DeletionDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteSecretOutput) SetName(v string) *DeleteSecretOutput {
	s.Name = &v
	return s
}

type DescribeSecretInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *DescribeSecretInput) SetSecretId(v string) *DescribeSecretInput {
	s.SecretId = &v
	return s
}

type DescribeSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The date the secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The date the secret is scheduled for deletion. If it is not scheduled for
	// deletion, this field is omitted. When you delete a secret, Secrets Manager
	// requires a recovery window of at least 7 days before deleting the secret.
	// Some time after the deleted date, Secrets Manager deletes the secret, including
	// all of its versions.
	//
	// If a secret is scheduled for deletion, then its details, including the encrypted
	// secret value, is not accessible. To cancel a scheduled deletion and restore
	// access to the secret, use RestoreSecret.
	DeletedDate *time.Time `type:"timestamp"`

	// The description of the secret.
	Description *string `type:"string"`

	// The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt
	// the secret value. If the secret is encrypted with the Amazon Web Services
	// managed key aws/secretsmanager, this field is omitted. Secrets created using
	// the console use an KMS key ID.
	KmsKeyId *string `type:"string"`

	// The date that the secret was last accessed in the Region. This field is omitted
	// if the secret has never been retrieved in the Region.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The last date and time that this secret was modified in any way.
	LastChangedDate *time.Time `type:"timestamp"`

	// The last date and time that Secrets Manager rotated the secret. If the secret
	// isn't configured for rotation or rotation has been disabled, Secrets Manager
	// returns null.
	LastRotatedDate *time.Time `type:"timestamp"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`

	// The next rotation is scheduled to occur on or before this date. If the secret
	// isn't configured for rotation or rotation has been disabled, Secrets Manager
	// returns null. If rotation fails, Secrets Manager retries the entire rotation
	// process multiple times. If rotation is unsuccessful, this date may be in
	// the past.
	//
	// This date represents the latest date that rotation will occur, but it is
	// not an approximate rotation date. In some cases, for example if you turn
	// off automatic rotation and then turn it back on, the next rotation may occur
	// much sooner than this date.
	NextRotationDate *time.Time `type:"timestamp"`

	// The ID of the service that created this secret. For more information, see
	// Secrets managed by other Amazon Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
	OwningService *string `min:"1" type:"string"`

	// The Region the secret is in. If a secret is replicated to other Regions,
	// the replicas are listed in ReplicationStatus.
	PrimaryRegion *string `min:"1" type:"string"`

	// A list of the replicas of this secret and their status:
	//
	//    * Failed, which indicates that the replica was not created.
	//
	//    * InProgress, which indicates that Secrets Manager is in the process of
	//    creating the replica.
	//
	//    * InSync, which indicates that the replica was created.
	ReplicationStatus []*ReplicationStatusType `type:"list"`

	// Specifies whether automatic rotation is turned on for this secret. If the
	// secret has never been configured for rotation, Secrets Manager returns null.
	//
	// To turn on rotation, use RotateSecret. To turn off rotation, use CancelRotateSecret.
	RotationEnabled *bool `type:"boolean"`

	// The ARN of the Lambda function that Secrets Manager invokes to rotate the
	// secret.
	RotationLambdaARN *string `type:"string"`

	// The rotation schedule and Lambda function for this secret. If the secret
	// previously had rotation turned on, but it is now turned off, this field shows
	// the previous rotation schedule and rotation function. If the secret never
	// had rotation turned on, this field is omitted.
	RotationRules *RotationRulesType `type:"structure"`

	// The list of tags attached to the secret. To add tags to a secret, use TagResource.
	// To remove tags, use UntagResource.
	Tags []*Tag `type:"list"`

	// A list of the versions of the secret that have staging labels attached. Versions
	// that don't have staging labels are considered deprecated and Secrets Manager
	// can delete them.
	//
	// Secrets Manager uses staging labels to indicate the status of a secret version
	// during rotation. The three staging labels for rotation are:
	//
	//    * AWSCURRENT, which indicates the current version of the secret.
	//
	//    * AWSPENDING, which indicates the version of the secret that contains
	//    new secret information that will become the next current version when
	//    rotation finishes. During rotation, Secrets Manager creates an AWSPENDING
	//    version ID before creating the new secret version. To check if a secret
	//    version exists, call GetSecretValue.
	//
	//    * AWSPREVIOUS, which indicates the previous current version of the secret.
	//    You can use this as the last known good version.
	//
	// For more information about rotation and staging labels, see How rotation
	// works (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html).
	VersionIdsToStages map[string][]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DescribeSecretOutput) SetARN(v string) *DescribeSecretOutput {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DescribeSecretOutput) SetCreatedDate(v time.Time) *DescribeSecretOutput {
	s.CreatedDate = &v
	return s
}

// SetDeletedDate sets the DeletedDate field's value.
func (s *DescribeSecretOutput) SetDeletedDate(v time.Time) *DescribeSecretOutput {
	s.DeletedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSecretOutput) SetDescription(v string) *DescribeSecretOutput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeSecretOutput) SetKmsKeyId(v string) *DescribeSecretOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *DescribeSecretOutput) SetLastAccessedDate(v time.Time) *DescribeSecretOutput {
	s.LastAccessedDate = &v
	return s
}

// SetLastChangedDate sets the LastChangedDate field's value.
func (s *DescribeSecretOutput) SetLastChangedDate(v time.Time) *DescribeSecretOutput {
	s.LastChangedDate = &v
	return s
}

// SetLastRotatedDate sets the LastRotatedDate field's value.
func (s *DescribeSecretOutput) SetLastRotatedDate(v time.Time) *DescribeSecretOutput {
	s.LastRotatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSecretOutput) SetName(v string) *DescribeSecretOutput {
	s.Name = &v
	return s
}

// SetNextRotationDate sets the NextRotationDate field's value.
func (s *DescribeSecretOutput) SetNextRotationDate(v time.Time) *DescribeSecretOutput {
	s.NextRotationDate = &v
	return s
}

// SetOwningService sets the OwningService field's value.
func (s *DescribeSecretOutput) SetOwningService(v string) *DescribeSecretOutput {
	s.OwningService = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *DescribeSecretOutput) SetPrimaryRegion(v string) *DescribeSecretOutput {
	s.PrimaryRegion = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *DescribeSecretOutput) SetReplicationStatus(v []*ReplicationStatusType) *DescribeSecretOutput {
	s.ReplicationStatus = v
	return s
}

// SetRotationEnabled sets the RotationEnabled field's value.
func (s *DescribeSecretOutput) SetRotationEnabled(v bool) *DescribeSecretOutput {
	s.RotationEnabled = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *DescribeSecretOutput) SetRotationLambdaARN(v string) *DescribeSecretOutput {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *DescribeSecretOutput) SetRotationRules(v *RotationRulesType) *DescribeSecretOutput {
	s.RotationRules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSecretOutput) SetTags(v []*Tag) *DescribeSecretOutput {
	s.Tags = v
	return s
}

// SetVersionIdsToStages sets the VersionIdsToStages field's value.
func (s *DescribeSecretOutput) SetVersionIdsToStages(v map[string][]*string) *DescribeSecretOutput {
	s.VersionIdsToStages = v
	return s
}

// Secrets Manager can't encrypt the protected secret text using the provided
// KMS key. Check that the KMS key is available, enabled, and not in an invalid
// state. For more information, see Key state: Effect on your KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
type EncryptionFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionFailure) GoString() string {
	return s.String()
}

func newErrorEncryptionFailure(v protocol.ResponseMetadata) error {
	return &EncryptionFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EncryptionFailure) Code() string {
	return "EncryptionFailure"
}

// Message returns the exception's message.
func (s *EncryptionFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EncryptionFailure) OrigErr() error {
	return nil
}

func (s *EncryptionFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EncryptionFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EncryptionFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

// Allows you to add filters when you use the search function in Secrets Manager.
// For more information, see Find secrets in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html).
type Filter struct {
	_ struct{} `type:"structure"`

	// The following are keys you can use:
	//
	//    * description: Prefix match, not case-sensitive.
	//
	//    * name: Prefix match, case-sensitive.
	//
	//    * tag-key: Prefix match, case-sensitive.
	//
	//    * tag-value: Prefix match, case-sensitive.
	//
	//    * primary-region: Prefix match, case-sensitive.
	//
	//    * owning-service: Prefix match, case-sensitive.
	//
	//    * all: Breaks the filter value string into words and then searches all
	//    attributes for matches. Not case-sensitive.
	Key *string `type:"string" enum:"FilterNameStringType"`

	// The keyword to filter for.
	//
	// You can prefix your search value with an exclamation mark (!) in order to
	// perform negation filters.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetRandomPasswordInput struct {
	_ struct{} `type:"structure"`

	// A string of the characters that you don't want in the password.
	ExcludeCharacters *string `type:"string"`

	// Specifies whether to exclude lowercase letters from the password. If you
	// don't include this switch, the password can contain lowercase letters.
	ExcludeLowercase *bool `type:"boolean"`

	// Specifies whether to exclude numbers from the password. If you don't include
	// this switch, the password can contain numbers.
	ExcludeNumbers *bool `type:"boolean"`

	// Specifies whether to exclude the following punctuation characters from the
	// password: ! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~.
	// If you don't include this switch, the password can contain punctuation.
	ExcludePunctuation *bool `type:"boolean"`

	// Specifies whether to exclude uppercase letters from the password. If you
	// don't include this switch, the password can contain uppercase letters.
	ExcludeUppercase *bool `type:"boolean"`

	// Specifies whether to include the space character. If you include this switch,
	// the password can contain space characters.
	IncludeSpace *bool `type:"boolean"`

	// The length of the password. If you don't include this parameter, the default
	// length is 32 characters.
	PasswordLength *int64 `min:"1" type:"long"`

	// Specifies whether to include at least one upper and lowercase letter, one
	// number, and one punctuation. If you don't include this switch, the password
	// contains at least one of every character type.
	RequireEachIncludedType *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRandomPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRandomPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRandomPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRandomPasswordInput"}
	if s.PasswordLength != nil && *s.PasswordLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PasswordLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeCharacters sets the ExcludeCharacters field's value.
func (s *GetRandomPasswordInput) SetExcludeCharacters(v string) *GetRandomPasswordInput {
	s.ExcludeCharacters = &v
	return s
}

// SetExcludeLowercase sets the ExcludeLowercase field's value.
func (s *GetRandomPasswordInput) SetExcludeLowercase(v bool) *GetRandomPasswordInput {
	s.ExcludeLowercase = &v
	return s
}

// SetExcludeNumbers sets the ExcludeNumbers field's value.
func (s *GetRandomPasswordInput) SetExcludeNumbers(v bool) *GetRandomPasswordInput {
	s.ExcludeNumbers = &v
	return s
}

// SetExcludePunctuation sets the ExcludePunctuation field's value.
func (s *GetRandomPasswordInput) SetExcludePunctuation(v bool) *GetRandomPasswordInput {
	s.ExcludePunctuation = &v
	return s
}

// SetExcludeUppercase sets the ExcludeUppercase field's value.
func (s *GetRandomPasswordInput) SetExcludeUppercase(v bool) *GetRandomPasswordInput {
	s.ExcludeUppercase = &v
	return s
}

// SetIncludeSpace sets the IncludeSpace field's value.
func (s *GetRandomPasswordInput) SetIncludeSpace(v bool) *GetRandomPasswordInput {
	s.IncludeSpace = &v
	return s
}

// SetPasswordLength sets the PasswordLength field's value.
func (s *GetRandomPasswordInput) SetPasswordLength(v int64) *GetRandomPasswordInput {
	s.PasswordLength = &v
	return s
}

// SetRequireEachIncludedType sets the RequireEachIncludedType field's value.
func (s *GetRandomPasswordInput) SetRequireEachIncludedType(v bool) *GetRandomPasswordInput {
	s.RequireEachIncludedType = &v
	return s
}

type GetRandomPasswordOutput struct {
	_ struct{} `type:"structure"`

	// A string with the password.
	//
	// RandomPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRandomPasswordOutput's
	// String and GoString methods.
	RandomPassword *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRandomPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRandomPasswordOutput) GoString() string {
	return s.String()
}

// SetRandomPassword sets the RandomPassword field's value.
func (s *GetRandomPasswordOutput) SetRandomPassword(v string) *GetRandomPasswordOutput {
	s.RandomPassword = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret to retrieve the attached resource-based policy
	// for.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *GetResourcePolicyInput) SetSecretId(v string) *GetResourcePolicyInput {
	s.SecretId = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that the resource-based policy was retrieved for.
	ARN *string `min:"20" type:"string"`

	// The name of the secret that the resource-based policy was retrieved for.
	Name *string `min:"1" type:"string"`

	// A JSON-formatted string that contains the permissions policy attached to
	// the secret. For more information about permissions policies, see Authentication
	// and access control for Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GetResourcePolicyOutput) SetARN(v string) *GetResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourcePolicyOutput) SetName(v string) *GetResourcePolicyOutput {
	s.Name = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *GetResourcePolicyOutput) SetResourcePolicy(v string) *GetResourcePolicyOutput {
	s.ResourcePolicy = &v
	return s
}

type GetSecretValueInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret to retrieve. To retrieve a secret from another
	// account, you must use an ARN.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the version of the secret to retrieve. If you include
	// both this parameter and VersionStage, the two parameters must refer to the
	// same secret version. If you don't specify either a VersionStage or VersionId,
	// then Secrets Manager returns the AWSCURRENT version.
	//
	// This value is typically a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value with 32 hexadecimal digits.
	VersionId *string `min:"32" type:"string"`

	// The staging label of the version of the secret to retrieve.
	//
	// Secrets Manager uses staging labels to keep track of different versions during
	// the rotation process. If you include both this parameter and VersionId, the
	// two parameters must refer to the same secret version. If you don't specify
	// either a VersionStage or VersionId, Secrets Manager returns the AWSCURRENT
	// version.
	VersionStage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecretValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSecretValueInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 32))
	}
	if s.VersionStage != nil && len(*s.VersionStage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *GetSecretValueInput) SetSecretId(v string) *GetSecretValueInput {
	s.SecretId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetSecretValueInput) SetVersionId(v string) *GetSecretValueInput {
	s.VersionId = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *GetSecretValueInput) SetVersionStage(v string) *GetSecretValueInput {
	s.VersionStage = &v
	return s
}

type GetSecretValueOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The date and time that this version of the secret was created. If you don't
	// specify which version in VersionId or VersionStage, then Secrets Manager
	// uses the AWSCURRENT version.
	CreatedDate *time.Time `type:"timestamp"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// The decrypted secret value, if the secret value was originally provided as
	// binary data in the form of a byte array. When you retrieve a SecretBinary
	// using the HTTP API, the Python SDK, or the Amazon Web Services CLI, the value
	// is Base64-encoded. Otherwise, it is not encoded.
	//
	// If the secret was created by using the Secrets Manager console, or if the
	// secret value was originally provided as a string, then this field is omitted.
	// The secret value appears in SecretString instead.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretBinary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSecretValueOutput's
	// String and GoString methods.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `min:"1" type:"blob" sensitive:"true"`

	// The decrypted secret value, if the secret value was originally provided as
	// a string or through the Secrets Manager console.
	//
	// If this secret was created by using the console, then Secrets Manager stores
	// the information as a JSON structure of key/value pairs.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSecretValueOutput's
	// String and GoString methods.
	SecretString *string `min:"1" type:"string" sensitive:"true"`

	// The unique identifier of this version of the secret.
	VersionId *string `min:"32" type:"string"`

	// A list of all of the staging labels currently attached to this version of
	// the secret.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecretValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecretValueOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GetSecretValueOutput) SetARN(v string) *GetSecretValueOutput {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetSecretValueOutput) SetCreatedDate(v time.Time) *GetSecretValueOutput {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSecretValueOutput) SetName(v string) *GetSecretValueOutput {
	s.Name = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *GetSecretValueOutput) SetSecretBinary(v []byte) *GetSecretValueOutput {
	s.SecretBinary = v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *GetSecretValueOutput) SetSecretString(v string) *GetSecretValueOutput {
	s.SecretString = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetSecretValueOutput) SetVersionId(v string) *GetSecretValueOutput {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *GetSecretValueOutput) SetVersionStages(v []*string) *GetSecretValueOutput {
	s.VersionStages = v
	return s
}

// An error occurred on the server side.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken value is invalid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The parameter name or value is invalid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter value is not valid for the current state of the resource.
//
// Possible causes:
//
//   - The secret is scheduled for deletion.
//
//   - You tried to enable rotation on a secret that doesn't already have a
//     Lambda function ARN configured and you didn't include such an ARN as a
//     parameter in this call.
//
//   - The secret is managed by another service, and you must use that service
//     to update it. For more information, see Secrets managed by other Amazon
//     Web Services services (https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request failed because it would exceed one of the Secrets Manager quotas.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListSecretVersionIdsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include versions of secrets that don't have any staging
	// labels attached to them. Versions without staging labels are considered deprecated
	// and are subject to deletion by Secrets Manager. By default, versions without
	// staging labels aren't included.
	IncludeDeprecated *bool `type:"boolean"`

	// The number of results to include in the response.
	//
	// If there are more results available, in the response, Secrets Manager includes
	// NextToken. To get the next results, call ListSecretVersionIds again with
	// the value from NextToken.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates where the output should continue from, if a previous
	// call did not show all results. To get the next results, call ListSecretVersionIds
	// again with this value.
	NextToken *string `min:"1" type:"string"`

	// The ARN or name of the secret whose versions you want to list.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretVersionIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretVersionIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecretVersionIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecretVersionIdsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeprecated sets the IncludeDeprecated field's value.
func (s *ListSecretVersionIdsInput) SetIncludeDeprecated(v bool) *ListSecretVersionIdsInput {
	s.IncludeDeprecated = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecretVersionIdsInput) SetMaxResults(v int64) *ListSecretVersionIdsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretVersionIdsInput) SetNextToken(v string) *ListSecretVersionIdsInput {
	s.NextToken = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ListSecretVersionIdsInput) SetSecretId(v string) *ListSecretVersionIdsInput {
	s.SecretId = &v
	return s
}

type ListSecretVersionIdsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`

	// Secrets Manager includes this value if there's more output available than
	// what is included in the current response. This can occur even when the response
	// includes no values at all, such as when you ask for a filtered view of a
	// long list. To get the next results, call ListSecretVersionIds again with
	// this value.
	NextToken *string `min:"1" type:"string"`

	// A list of the versions of the secret.
	Versions []*SecretVersionsListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretVersionIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretVersionIdsOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ListSecretVersionIdsOutput) SetARN(v string) *ListSecretVersionIdsOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListSecretVersionIdsOutput) SetName(v string) *ListSecretVersionIdsOutput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretVersionIdsOutput) SetNextToken(v string) *ListSecretVersionIdsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListSecretVersionIdsOutput) SetVersions(v []*SecretVersionsListEntry) *ListSecretVersionIdsOutput {
	s.Versions = v
	return s
}

type ListSecretsInput struct {
	_ struct{} `type:"structure"`

	// The filters to apply to the list of secrets.
	Filters []*Filter `type:"list"`

	// Specifies whether to include secrets scheduled for deletion. By default,
	// secrets scheduled for deletion aren't included.
	IncludePlannedDeletion *bool `type:"boolean"`

	// The number of results to include in the response.
	//
	// If there are more results available, in the response, Secrets Manager includes
	// NextToken. To get the next results, call ListSecrets again with the value
	// from NextToken.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates where the output should continue from, if a previous
	// call did not show all results. To get the next results, call ListSecrets
	// again with this value.
	NextToken *string `min:"1" type:"string"`

	// Secrets are listed by CreatedDate.
	SortOrder *string `type:"string" enum:"SortOrderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecretsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecretsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSecretsInput) SetFilters(v []*Filter) *ListSecretsInput {
	s.Filters = v
	return s
}

// SetIncludePlannedDeletion sets the IncludePlannedDeletion field's value.
func (s *ListSecretsInput) SetIncludePlannedDeletion(v bool) *ListSecretsInput {
	s.IncludePlannedDeletion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecretsInput) SetMaxResults(v int64) *ListSecretsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretsInput) SetNextToken(v string) *ListSecretsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListSecretsInput) SetSortOrder(v string) *ListSecretsInput {
	s.SortOrder = &v
	return s
}

type ListSecretsOutput struct {
	_ struct{} `type:"structure"`

	// Secrets Manager includes this value if there's more output available than
	// what is included in the current response. This can occur even when the response
	// includes no values at all, such as when you ask for a filtered view of a
	// long list. To get the next results, call ListSecrets again with this value.
	NextToken *string `min:"1" type:"string"`

	// A list of the secrets in the account.
	SecretList []*SecretListEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecretsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecretsOutput) SetNextToken(v string) *ListSecretsOutput {
	s.NextToken = &v
	return s
}

// SetSecretList sets the SecretList field's value.
func (s *ListSecretsOutput) SetSecretList(v []*SecretListEntry) *ListSecretsOutput {
	s.SecretList = v
	return s
}

// The resource policy has syntax errors.
type MalformedPolicyDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyDocumentException) GoString() string {
	return s.String()
}

func newErrorMalformedPolicyDocumentException(v protocol.ResponseMetadata) error {
	return &MalformedPolicyDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedPolicyDocumentException) Code() string {
	return "MalformedPolicyDocumentException"
}

// Message returns the exception's message.
func (s *MalformedPolicyDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedPolicyDocumentException) OrigErr() error {
	return nil
}

func (s *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedPolicyDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedPolicyDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request failed because you did not complete all the prerequisite steps.
type PreconditionNotMetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionNotMetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionNotMetException) GoString() string {
	return s.String()
}

func newErrorPreconditionNotMetException(v protocol.ResponseMetadata) error {
	return &PreconditionNotMetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionNotMetException) Code() string {
	return "PreconditionNotMetException"
}

// Message returns the exception's message.
func (s *PreconditionNotMetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionNotMetException) OrigErr() error {
	return nil
}

func (s *PreconditionNotMetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionNotMetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionNotMetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The BlockPublicPolicy parameter is set to true, and the resource policy did
// not prevent broad access to the secret.
type PublicPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicPolicyException) GoString() string {
	return s.String()
}

func newErrorPublicPolicyException(v protocol.ResponseMetadata) error {
	return &PublicPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PublicPolicyException) Code() string {
	return "PublicPolicyException"
}

// Message returns the exception's message.
func (s *PublicPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PublicPolicyException) OrigErr() error {
	return nil
}

func (s *PublicPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PublicPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PublicPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to block resource-based policies that allow broad access
	// to the secret, for example those that use a wildcard for the principal. By
	// default, public policies aren't blocked.
	//
	// Resource policy validation and the BlockPublicPolicy parameter help protect
	// your resources by preventing public access from being granted through the
	// resource policies that are directly attached to your secrets. In addition
	// to using these features, carefully inspect the following policies to confirm
	// that they do not grant public access:
	//
	//    * Identity-based policies attached to associated Amazon Web Services principals
	//    (for example, IAM roles)
	//
	//    * Resource-based policies attached to associated Amazon Web Services resources
	//    (for example, Key Management Service (KMS) keys)
	//
	// To review permissions to your secrets, see Determine who has permissions
	// to your secrets (https://docs.aws.amazon.com/secretsmanager/latest/userguide/determine-acccess_examine-iam-policies.html).
	BlockPublicPolicy *bool `type:"boolean"`

	// A JSON-formatted string for an Amazon Web Services resource-based policy.
	// For example policies, see Permissions policy examples (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`

	// The ARN or name of the secret to attach the resource-based policy.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.ResourcePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *PutResourcePolicyInput) SetBlockPublicPolicy(v bool) *PutResourcePolicyInput {
	s.BlockPublicPolicy = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *PutResourcePolicyInput) SetResourcePolicy(v string) *PutResourcePolicyInput {
	s.ResourcePolicy = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PutResourcePolicyInput) SetSecretId(v string) *PutResourcePolicyInput {
	s.SecretId = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *PutResourcePolicyOutput) SetARN(v string) *PutResourcePolicyOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutResourcePolicyOutput) SetName(v string) *PutResourcePolicyOutput {
	s.Name = &v
	return s
}

type PutSecretValueInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the new version of the secret.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDKs to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes it as the value for
	// this parameter in the request.
	//
	// If you generate a raw HTTP request to the Secrets Manager service endpoint,
	// then you must generate a ClientRequestToken and include it in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	//
	//    * If the ClientRequestToken value isn't already associated with a version
	//    of the secret then a new version of the secret is created.
	//
	//    * If a version with this value already exists and that version's SecretString
	//    or SecretBinary values are the same as those in the request then the request
	//    is ignored. The operation is idempotent.
	//
	//    * If a version with this value already exists and the version of the SecretString
	//    and SecretBinary values are different from those in the request, then
	//    the request fails because you can't modify a secret version. You can only
	//    create new versions to store new secret values.
	//
	// This value becomes the VersionId of the new version.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// A unique identifier that indicates the source of the request. For cross-account
	// rotation (when you rotate a secret in one account by using a Lambda rotation
	// function in another account) and the Lambda rotation function assumes an
	// IAM role to call Secrets Manager, Secrets Manager validates the identity
	// with the rotation token. For more information, see How rotation works (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html).
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// RotationToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutSecretValueInput's
	// String and GoString methods.
	RotationToken *string `min:"36" type:"string" sensitive:"true"`

	// The binary data to encrypt and store in the new version of the secret. To
	// use this parameter in the command-line tools, we recommend that you store
	// your binary data in a file and then pass the contents of the file as a parameter.
	//
	// You must include SecretBinary or SecretString, but not both.
	//
	// You can't access this value from the Secrets Manager console.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretBinary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutSecretValueInput's
	// String and GoString methods.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `min:"1" type:"blob" sensitive:"true"`

	// The ARN or name of the secret to add a new version to.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// If the secret doesn't already exist, use CreateSecret instead.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The text to encrypt and store in the new version of the secret.
	//
	// You must include SecretBinary or SecretString, but not both.
	//
	// We recommend you create the secret string as JSON key/value pairs, as shown
	// in the example.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutSecretValueInput's
	// String and GoString methods.
	SecretString *string `min:"1" type:"string" sensitive:"true"`

	// A list of staging labels to attach to this version of the secret. Secrets
	// Manager uses staging labels to track versions of a secret through the rotation
	// process.
	//
	// If you specify a staging label that's already associated with a different
	// version of the same secret, then Secrets Manager removes the label from the
	// other version and attaches it to this version. If you specify AWSCURRENT,
	// and it is already attached to another version, then Secrets Manager also
	// moves the staging label AWSPREVIOUS to the version that AWSCURRENT was removed
	// from.
	//
	// If you don't include VersionStages, then Secrets Manager automatically moves
	// the staging label AWSCURRENT to this version.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSecretValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSecretValueInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.RotationToken != nil && len(*s.RotationToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RotationToken", 36))
	}
	if s.SecretBinary != nil && len(s.SecretBinary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretBinary", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.SecretString != nil && len(*s.SecretString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretString", 1))
	}
	if s.VersionStages != nil && len(s.VersionStages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStages", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PutSecretValueInput) SetClientRequestToken(v string) *PutSecretValueInput {
	s.ClientRequestToken = &v
	return s
}

// SetRotationToken sets the RotationToken field's value.
func (s *PutSecretValueInput) SetRotationToken(v string) *PutSecretValueInput {
	s.RotationToken = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *PutSecretValueInput) SetSecretBinary(v []byte) *PutSecretValueInput {
	s.SecretBinary = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *PutSecretValueInput) SetSecretId(v string) *PutSecretValueInput {
	s.SecretId = &v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *PutSecretValueInput) SetSecretString(v string) *PutSecretValueInput {
	s.SecretString = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *PutSecretValueInput) SetVersionStages(v []*string) *PutSecretValueInput {
	s.VersionStages = v
	return s
}

type PutSecretValueOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the version of the secret.
	VersionId *string `min:"32" type:"string"`

	// The list of staging labels that are currently attached to this version of
	// the secret. Secrets Manager uses staging labels to track a version as it
	// progresses through the secret rotation process.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSecretValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSecretValueOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *PutSecretValueOutput) SetARN(v string) *PutSecretValueOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutSecretValueOutput) SetName(v string) *PutSecretValueOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutSecretValueOutput) SetVersionId(v string) *PutSecretValueOutput {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *PutSecretValueOutput) SetVersionStages(v []*string) *PutSecretValueOutput {
	s.VersionStages = v
	return s
}

type RemoveRegionsFromReplicationInput struct {
	_ struct{} `type:"structure"`

	// The Regions of the replicas to remove.
	//
	// RemoveReplicaRegions is a required field
	RemoveReplicaRegions []*string `min:"1" type:"list" required:"true"`

	// The ARN or name of the secret.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveRegionsFromReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveRegionsFromReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRegionsFromReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRegionsFromReplicationInput"}
	if s.RemoveReplicaRegions == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoveReplicaRegions"))
	}
	if s.RemoveReplicaRegions != nil && len(s.RemoveReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveReplicaRegions", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRemoveReplicaRegions sets the RemoveReplicaRegions field's value.
func (s *RemoveRegionsFromReplicationInput) SetRemoveReplicaRegions(v []*string) *RemoveRegionsFromReplicationInput {
	s.RemoveReplicaRegions = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *RemoveRegionsFromReplicationInput) SetSecretId(v string) *RemoveRegionsFromReplicationInput {
	s.SecretId = &v
	return s
}

type RemoveRegionsFromReplicationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the primary secret.
	ARN *string `min:"20" type:"string"`

	// The status of replicas for this secret after you remove Regions.
	ReplicationStatus []*ReplicationStatusType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveRegionsFromReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveRegionsFromReplicationOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RemoveRegionsFromReplicationOutput) SetARN(v string) *RemoveRegionsFromReplicationOutput {
	s.ARN = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *RemoveRegionsFromReplicationOutput) SetReplicationStatus(v []*ReplicationStatusType) *RemoveRegionsFromReplicationOutput {
	s.ReplicationStatus = v
	return s
}

// A custom type that specifies a Region and the KmsKeyId for a replica secret.
type ReplicaRegionType struct {
	_ struct{} `type:"structure"`

	// The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't
	// include this field, Secrets Manager uses aws/secretsmanager.
	KmsKeyId *string `type:"string"`

	// A Region code. For a list of Region codes, see Name and code of Regions (https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints).
	Region *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicaRegionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicaRegionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaRegionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicaRegionType"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicaRegionType) SetKmsKeyId(v string) *ReplicaRegionType {
	s.KmsKeyId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ReplicaRegionType) SetRegion(v string) *ReplicaRegionType {
	s.Region = &v
	return s
}

type ReplicateSecretToRegionsInput struct {
	_ struct{} `type:"structure"`

	// A list of Regions in which to replicate the secret.
	//
	// AddReplicaRegions is a required field
	AddReplicaRegions []*ReplicaRegionType `min:"1" type:"list" required:"true"`

	// Specifies whether to overwrite a secret with the same name in the destination
	// Region. By default, secrets aren't overwritten.
	ForceOverwriteReplicaSecret *bool `type:"boolean"`

	// The ARN or name of the secret to replicate.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateSecretToRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateSecretToRegionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicateSecretToRegionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicateSecretToRegionsInput"}
	if s.AddReplicaRegions == nil {
		invalidParams.Add(request.NewErrParamRequired("AddReplicaRegions"))
	}
	if s.AddReplicaRegions != nil && len(s.AddReplicaRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddReplicaRegions", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.AddReplicaRegions != nil {
		for i, v := range s.AddReplicaRegions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddReplicaRegions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddReplicaRegions sets the AddReplicaRegions field's value.
func (s *ReplicateSecretToRegionsInput) SetAddReplicaRegions(v []*ReplicaRegionType) *ReplicateSecretToRegionsInput {
	s.AddReplicaRegions = v
	return s
}

// SetForceOverwriteReplicaSecret sets the ForceOverwriteReplicaSecret field's value.
func (s *ReplicateSecretToRegionsInput) SetForceOverwriteReplicaSecret(v bool) *ReplicateSecretToRegionsInput {
	s.ForceOverwriteReplicaSecret = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ReplicateSecretToRegionsInput) SetSecretId(v string) *ReplicateSecretToRegionsInput {
	s.SecretId = &v
	return s
}

type ReplicateSecretToRegionsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the primary secret.
	ARN *string `min:"20" type:"string"`

	// The status of replication.
	ReplicationStatus []*ReplicationStatusType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateSecretToRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateSecretToRegionsOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ReplicateSecretToRegionsOutput) SetARN(v string) *ReplicateSecretToRegionsOutput {
	s.ARN = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *ReplicateSecretToRegionsOutput) SetReplicationStatus(v []*ReplicationStatusType) *ReplicateSecretToRegionsOutput {
	s.ReplicationStatus = v
	return s
}

// A replication object consisting of a RegionReplicationStatus object and includes
// a Region, KMSKeyId, status, and status message.
type ReplicationStatusType struct {
	_ struct{} `type:"structure"`

	// Can be an ARN, Key ID, or Alias.
	KmsKeyId *string `type:"string"`

	// The date that the secret was last accessed in the Region. This field is omitted
	// if the secret has never been retrieved in the Region.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The Region where replication occurs.
	Region *string `min:"1" type:"string"`

	// The status can be InProgress, Failed, or InSync.
	Status *string `type:"string" enum:"StatusType"`

	// Status message such as "Secret with this name already exists in this region".
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationStatusType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationStatusType) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationStatusType) SetKmsKeyId(v string) *ReplicationStatusType {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *ReplicationStatusType) SetLastAccessedDate(v time.Time) *ReplicationStatusType {
	s.LastAccessedDate = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ReplicationStatusType) SetRegion(v string) *ReplicationStatusType {
	s.Region = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationStatusType) SetStatus(v string) *ReplicationStatusType {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationStatusType) SetStatusMessage(v string) *ReplicationStatusType {
	s.StatusMessage = &v
	return s
}

// A resource with the ID you requested already exists.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Secrets Manager can't find the resource that you asked for.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreSecretInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret to restore.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreSecretInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *RestoreSecretInput) SetSecretId(v string) *RestoreSecretInput {
	s.SecretId = &v
	return s
}

type RestoreSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that was restored.
	ARN *string `min:"20" type:"string"`

	// The name of the secret that was restored.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RestoreSecretOutput) SetARN(v string) *RestoreSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *RestoreSecretOutput) SetName(v string) *RestoreSecretOutput {
	s.Name = &v
	return s
}

type RotateSecretInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the new version of the secret. You only need to specify
	// this value if you implement your own retry logic and you want to ensure that
	// Secrets Manager doesn't attempt to create a secret version twice.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDKs to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes it as the value for
	// this parameter in the request.
	//
	// If you generate a raw HTTP request to the Secrets Manager service endpoint,
	// then you must generate a ClientRequestToken and include it in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// Specifies whether to rotate the secret immediately or wait until the next
	// scheduled rotation window. The rotation schedule is defined in RotateSecretRequest$RotationRules.
	//
	// For secrets that use a Lambda rotation function to rotate, if you don't immediately
	// rotate the secret, Secrets Manager tests the rotation configuration by running
	// the testSecret step (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_lambda-functions.html#rotate-secrets_lambda-functions-code)
	// of the Lambda rotation function. The test creates an AWSPENDING version of
	// the secret and then removes it.
	//
	// By default, Secrets Manager rotates the secret immediately.
	RotateImmediately *bool `type:"boolean"`

	// For secrets that use a Lambda rotation function to rotate, the ARN of the
	// Lambda rotation function.
	//
	// For secrets that use managed rotation, omit this field. For more information,
	// see Managed rotation (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html)
	// in the Secrets Manager User Guide.
	RotationLambdaARN *string `type:"string"`

	// A structure that defines the rotation configuration for this secret.
	RotationRules *RotationRulesType `type:"structure"`

	// The ARN or name of the secret to rotate.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateSecretInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.RotationRules != nil {
		if err := s.RotationRules.Validate(); err != nil {
			invalidParams.AddNested("RotationRules", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RotateSecretInput) SetClientRequestToken(v string) *RotateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetRotateImmediately sets the RotateImmediately field's value.
func (s *RotateSecretInput) SetRotateImmediately(v bool) *RotateSecretInput {
	s.RotateImmediately = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *RotateSecretInput) SetRotationLambdaARN(v string) *RotateSecretInput {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *RotateSecretInput) SetRotationRules(v *RotationRulesType) *RotateSecretInput {
	s.RotationRules = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *RotateSecretInput) SetSecretId(v string) *RotateSecretInput {
	s.SecretId = &v
	return s
}

type RotateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret.
	ARN *string `min:"20" type:"string"`

	// The name of the secret.
	Name *string `min:"1" type:"string"`

	// The ID of the new version of the secret.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *RotateSecretOutput) SetARN(v string) *RotateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *RotateSecretOutput) SetName(v string) *RotateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *RotateSecretOutput) SetVersionId(v string) *RotateSecretOutput {
	s.VersionId = &v
	return s
}

// A structure that defines the rotation configuration for the secret.
type RotationRulesType struct {
	_ struct{} `type:"structure"`

	// The number of days between rotations of the secret. You can use this value
	// to check that your secret meets your compliance guidelines for how often
	// secrets must be rotated. If you use this field to set the rotation schedule,
	// Secrets Manager calculates the next rotation date based on the previous rotation.
	// Manually updating the secret value by calling PutSecretValue or UpdateSecret
	// is considered a valid rotation.
	//
	// In DescribeSecret and ListSecrets, this value is calculated from the rotation
	// schedule after every successful rotation. In RotateSecret, you can set the
	// rotation schedule in RotationRules with AutomaticallyAfterDays or ScheduleExpression,
	// but not both. To set a rotation schedule in hours, use ScheduleExpression.
	AutomaticallyAfterDays *int64 `min:"1" type:"long"`

	// The length of the rotation window in hours, for example 3h for a three hour
	// window. Secrets Manager rotates your secret at any time during this window.
	// The window must not extend into the next rotation window or the next UTC
	// day. The window starts according to the ScheduleExpression. If you don't
	// specify a Duration, for a ScheduleExpression in hours, the window automatically
	// closes after one hour. For a ScheduleExpression in days, the window automatically
	// closes at the end of the UTC day. For more information, including examples,
	// see Schedule expressions in Secrets Manager rotation (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html)
	// in the Secrets Manager Users Guide.
	Duration *string `min:"2" type:"string"`

	// A cron() or rate() expression that defines the schedule for rotating your
	// secret. Secrets Manager rotation schedules use UTC time zone. Secrets Manager
	// rotates your secret any time during a rotation window.
	//
	// Secrets Manager rate() expressions represent the interval in hours or days
	// that you want to rotate your secret, for example rate(12 hours) or rate(10
	// days). You can rotate a secret as often as every four hours. If you use a
	// rate() expression, the rotation window starts at midnight. For a rate in
	// hours, the default rotation window closes after one hour. For a rate in days,
	// the default rotation window closes at the end of the day. You can set the
	// Duration to change the rotation window. The rotation window must not extend
	// into the next UTC day or into the next rotation window.
	//
	// You can use a cron() expression to create a rotation schedule that is more
	// detailed than a rotation interval. For more information, including examples,
	// see Schedule expressions in Secrets Manager rotation (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_schedule.html)
	// in the Secrets Manager Users Guide. For a cron expression that represents
	// a schedule in hours, the default rotation window closes after one hour. For
	// a cron expression that represents a schedule in days, the default rotation
	// window closes at the end of the day. You can set the Duration to change the
	// rotation window. The rotation window must not extend into the next UTC day
	// or into the next rotation window.
	ScheduleExpression *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationRulesType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RotationRulesType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotationRulesType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotationRulesType"}
	if s.AutomaticallyAfterDays != nil && *s.AutomaticallyAfterDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AutomaticallyAfterDays", 1))
	}
	if s.Duration != nil && len(*s.Duration) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Duration", 2))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticallyAfterDays sets the AutomaticallyAfterDays field's value.
func (s *RotationRulesType) SetAutomaticallyAfterDays(v int64) *RotationRulesType {
	s.AutomaticallyAfterDays = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *RotationRulesType) SetDuration(v string) *RotationRulesType {
	s.Duration = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RotationRulesType) SetScheduleExpression(v string) *RotationRulesType {
	s.ScheduleExpression = &v
	return s
}

// A structure that contains the details about a secret. It does not include
// the encrypted SecretString and SecretBinary values. To get those values,
// use GetSecretValue (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_GetSecretValue.html) .
type SecretListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret.
	ARN *string `min:"20" type:"string"`

	// The date and time when a secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The date and time the deletion of the secret occurred. Not present on active
	// secrets. The secret can be recovered until the number of days in the recovery
	// window has passed, as specified in the RecoveryWindowInDays parameter of
	// the DeleteSecret (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_DeleteSecret.html)
	// operation.
	DeletedDate *time.Time `type:"timestamp"`

	// The user-provided description of the secret.
	Description *string `type:"string"`

	// The ARN of the KMS key that Secrets Manager uses to encrypt the secret value.
	// If the secret is encrypted with the Amazon Web Services managed key aws/secretsmanager,
	// this field is omitted.
	KmsKeyId *string `type:"string"`

	// The date that the secret was last accessed in the Region. This field is omitted
	// if the secret has never been retrieved in the Region.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The last date and time that this secret was modified in any way.
	LastChangedDate *time.Time `type:"timestamp"`

	// The most recent date and time that the Secrets Manager rotation process was
	// successfully completed. This value is null if the secret hasn't ever rotated.
	LastRotatedDate *time.Time `type:"timestamp"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// The next rotation is scheduled to occur on or before this date. If the secret
	// isn't configured for rotation or rotation has been disabled, Secrets Manager
	// returns null.
	NextRotationDate *time.Time `type:"timestamp"`

	// Returns the name of the service that created the secret.
	OwningService *string `min:"1" type:"string"`

	// The Region where Secrets Manager originated the secret.
	PrimaryRegion *string `min:"1" type:"string"`

	// Indicates whether automatic, scheduled rotation is enabled for this secret.
	RotationEnabled *bool `type:"boolean"`

	// The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager
	// to rotate and expire the secret either automatically per the schedule or
	// manually by a call to RotateSecret (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_RotateSecret.html).
	RotationLambdaARN *string `type:"string"`

	// A structure that defines the rotation configuration for the secret.
	RotationRules *RotationRulesType `type:"structure"`

	// A list of all of the currently assigned SecretVersionStage staging labels
	// and the SecretVersionId attached to each one. Staging labels are used to
	// keep track of the different versions during the rotation process.
	//
	// A version that does not have any SecretVersionStage is considered deprecated
	// and subject to deletion. Such versions are not included in this list.
	SecretVersionsToStages map[string][]*string `type:"map"`

	// The list of user-defined tags associated with the secret. To add tags to
	// a secret, use TagResource (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_TagResource.html).
	// To remove tags, use UntagResource (https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_UntagResource.html).
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretListEntry) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *SecretListEntry) SetARN(v string) *SecretListEntry {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecretListEntry) SetCreatedDate(v time.Time) *SecretListEntry {
	s.CreatedDate = &v
	return s
}

// SetDeletedDate sets the DeletedDate field's value.
func (s *SecretListEntry) SetDeletedDate(v time.Time) *SecretListEntry {
	s.DeletedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecretListEntry) SetDescription(v string) *SecretListEntry {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *SecretListEntry) SetKmsKeyId(v string) *SecretListEntry {
	s.KmsKeyId = &v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *SecretListEntry) SetLastAccessedDate(v time.Time) *SecretListEntry {
	s.LastAccessedDate = &v
	return s
}

// SetLastChangedDate sets the LastChangedDate field's value.
func (s *SecretListEntry) SetLastChangedDate(v time.Time) *SecretListEntry {
	s.LastChangedDate = &v
	return s
}

// SetLastRotatedDate sets the LastRotatedDate field's value.
func (s *SecretListEntry) SetLastRotatedDate(v time.Time) *SecretListEntry {
	s.LastRotatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecretListEntry) SetName(v string) *SecretListEntry {
	s.Name = &v
	return s
}

// SetNextRotationDate sets the NextRotationDate field's value.
func (s *SecretListEntry) SetNextRotationDate(v time.Time) *SecretListEntry {
	s.NextRotationDate = &v
	return s
}

// SetOwningService sets the OwningService field's value.
func (s *SecretListEntry) SetOwningService(v string) *SecretListEntry {
	s.OwningService = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *SecretListEntry) SetPrimaryRegion(v string) *SecretListEntry {
	s.PrimaryRegion = &v
	return s
}

// SetRotationEnabled sets the RotationEnabled field's value.
func (s *SecretListEntry) SetRotationEnabled(v bool) *SecretListEntry {
	s.RotationEnabled = &v
	return s
}

// SetRotationLambdaARN sets the RotationLambdaARN field's value.
func (s *SecretListEntry) SetRotationLambdaARN(v string) *SecretListEntry {
	s.RotationLambdaARN = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *SecretListEntry) SetRotationRules(v *RotationRulesType) *SecretListEntry {
	s.RotationRules = v
	return s
}

// SetSecretVersionsToStages sets the SecretVersionsToStages field's value.
func (s *SecretListEntry) SetSecretVersionsToStages(v map[string][]*string) *SecretListEntry {
	s.SecretVersionsToStages = v
	return s
}

// SetTags sets the Tags field's value.
func (s *SecretListEntry) SetTags(v []*Tag) *SecretListEntry {
	s.Tags = v
	return s
}

// A structure that contains the secret value and other details for a secret.
type SecretValueEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret.
	ARN *string `min:"20" type:"string"`

	// The date the secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The friendly name of the secret.
	Name *string `min:"1" type:"string"`

	// The decrypted secret value, if the secret value was originally provided as
	// binary data in the form of a byte array. The parameter represents the binary
	// data as a base64-encoded (https://tools.ietf.org/html/rfc4648#section-4)
	// string.
	//
	// SecretBinary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SecretValueEntry's
	// String and GoString methods.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `min:"1" type:"blob" sensitive:"true"`

	// The decrypted secret value, if the secret value was originally provided as
	// a string or through the Secrets Manager console.
	//
	// SecretString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SecretValueEntry's
	// String and GoString methods.
	SecretString *string `min:"1" type:"string" sensitive:"true"`

	// The unique version identifier of this version of the secret.
	VersionId *string `min:"32" type:"string"`

	// A list of all of the staging labels currently attached to this version of
	// the secret.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretValueEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretValueEntry) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *SecretValueEntry) SetARN(v string) *SecretValueEntry {
	s.ARN = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecretValueEntry) SetCreatedDate(v time.Time) *SecretValueEntry {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecretValueEntry) SetName(v string) *SecretValueEntry {
	s.Name = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *SecretValueEntry) SetSecretBinary(v []byte) *SecretValueEntry {
	s.SecretBinary = v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *SecretValueEntry) SetSecretString(v string) *SecretValueEntry {
	s.SecretString = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SecretValueEntry) SetVersionId(v string) *SecretValueEntry {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *SecretValueEntry) SetVersionStages(v []*string) *SecretValueEntry {
	s.VersionStages = v
	return s
}

// A structure that contains information about one version of a secret.
type SecretVersionsListEntry struct {
	_ struct{} `type:"structure"`

	// The date and time this version of the secret was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The KMS keys used to encrypt the secret version.
	KmsKeyIds []*string `type:"list"`

	// The date that this version of the secret was last accessed. Note that the
	// resolution of this field is at the date level and does not include the time.
	LastAccessedDate *time.Time `type:"timestamp"`

	// The unique version identifier of this version of the secret.
	VersionId *string `min:"32" type:"string"`

	// An array of staging labels that are currently associated with this version
	// of the secret.
	VersionStages []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretVersionsListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecretVersionsListEntry) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecretVersionsListEntry) SetCreatedDate(v time.Time) *SecretVersionsListEntry {
	s.CreatedDate = &v
	return s
}

// SetKmsKeyIds sets the KmsKeyIds field's value.
func (s *SecretVersionsListEntry) SetKmsKeyIds(v []*string) *SecretVersionsListEntry {
	s.KmsKeyIds = v
	return s
}

// SetLastAccessedDate sets the LastAccessedDate field's value.
func (s *SecretVersionsListEntry) SetLastAccessedDate(v time.Time) *SecretVersionsListEntry {
	s.LastAccessedDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SecretVersionsListEntry) SetVersionId(v string) *SecretVersionsListEntry {
	s.VersionId = &v
	return s
}

// SetVersionStages sets the VersionStages field's value.
func (s *SecretVersionsListEntry) SetVersionStages(v []*string) *SecretVersionsListEntry {
	s.VersionStages = v
	return s
}

type StopReplicationToReplicaInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the primary secret.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationToReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationToReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationToReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationToReplicaInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *StopReplicationToReplicaInput) SetSecretId(v string) *StopReplicationToReplicaInput {
	s.SecretId = &v
	return s
}

type StopReplicationToReplicaOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the promoted secret. The ARN is the same as the original primary
	// secret except the Region is changed.
	ARN *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationToReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopReplicationToReplicaOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StopReplicationToReplicaOutput) SetARN(v string) *StopReplicationToReplicaOutput {
	s.ARN = &v
	return s
}

// A structure that contains information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key identifier, or name, of the tag.
	Key *string `min:"1" type:"string"`

	// The string value associated with the key of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the secret to attach tags to. You can specify either the
	// Amazon Resource Name (ARN) or the friendly name of the secret.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The tags to attach to the secret as a JSON text string argument. Each element
	// in the list consists of a Key and a Value.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For more information, see Specifying
	// parameter values for the Amazon Web Services CLI (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html)
	// in the Amazon Web Services CLI User Guide.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *TagResourceInput) SetSecretId(v string) *TagResourceInput {
	s.SecretId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN or name of the secret.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// A list of tag key names to remove from the secret. You don't specify the
	// value. Both the key and its associated value are removed.
	//
	// This parameter requires a JSON text string argument.
	//
	// For storing multiple values, we recommend that you use a JSON text string
	// argument and specify key/value pairs. For more information, see Specifying
	// parameter values for the Amazon Web Services CLI (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html)
	// in the Amazon Web Services CLI User Guide.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretId sets the SecretId field's value.
func (s *UntagResourceInput) SetSecretId(v string) *UntagResourceInput {
	s.SecretId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateSecretInput struct {
	_ struct{} `type:"structure"`

	// If you include SecretString or SecretBinary, then Secrets Manager creates
	// a new version for the secret, and this parameter specifies the unique identifier
	// for the new version.
	//
	// If you use the Amazon Web Services CLI or one of the Amazon Web Services
	// SDKs to call this operation, then you can leave this parameter empty. The
	// CLI or SDK generates a random UUID for you and includes it as the value for
	// this parameter in the request.
	//
	// If you generate a raw HTTP request to the Secrets Manager service endpoint,
	// then you must generate a ClientRequestToken and include it in the request.
	//
	// This value helps ensure idempotency. Secrets Manager uses this value to prevent
	// the accidental creation of duplicate versions if there are failures and retries
	// during a rotation. We recommend that you generate a UUID-type (https://wikipedia.org/wiki/Universally_unique_identifier)
	// value to ensure uniqueness of your versions within the specified secret.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The description of the secret.
	Description *string `type:"string"`

	// The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt
	// new secret versions as well as any existing versions with the staging labels
	// AWSCURRENT, AWSPENDING, or AWSPREVIOUS. If you don't have kms:Encrypt permission
	// to the new key, Secrets Manager does not re-ecrypt existing secret versions
	// with the new key. For more information about versions and staging labels,
	// see Concepts: Version (https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
	//
	// A key alias is always prefixed by alias/, for example alias/aws/secretsmanager.
	// For more information, see About aliases (https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
	//
	// If you set this to an empty string, Secrets Manager uses the Amazon Web Services
	// managed key aws/secretsmanager. If this key doesn't already exist in your
	// account, then Secrets Manager creates it for you automatically. All users
	// and roles in the Amazon Web Services account automatically have access to
	// use aws/secretsmanager. Creating aws/secretsmanager can result in a one-time
	// significant delay in returning the result.
	//
	// You can only use the Amazon Web Services managed key aws/secretsmanager if
	// you call this operation using credentials from the same Amazon Web Services
	// account that owns the secret. If the secret is in a different account, then
	// you must use a customer managed key and provide the ARN of that KMS key in
	// this field. The user making the call must have permissions to both the secret
	// and the KMS key in their respective accounts.
	KmsKeyId *string `type:"string"`

	// The binary data to encrypt and store in the new version of the secret. We
	// recommend that you store your binary data in a file and then pass the contents
	// of the file as a parameter.
	//
	// Either SecretBinary or SecretString must have a value, but not both.
	//
	// You can't access this parameter in the Secrets Manager console.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretBinary is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSecretInput's
	// String and GoString methods.
	//
	// SecretBinary is automatically base64 encoded/decoded by the SDK.
	SecretBinary []byte `min:"1" type:"blob" sensitive:"true"`

	// The ARN or name of the secret.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The text data to encrypt and store in the new version of the secret. We recommend
	// you use a JSON structure of key/value pairs for your secret value.
	//
	// Either SecretBinary or SecretString must have a value, but not both.
	//
	// Sensitive: This field contains sensitive information, so the service does
	// not include it in CloudTrail log entries. If you create your own log entries,
	// you must also avoid logging the information in this field.
	//
	// SecretString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSecretInput's
	// String and GoString methods.
	SecretString *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecretInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.SecretBinary != nil && len(s.SecretBinary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretBinary", 1))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.SecretString != nil && len(*s.SecretString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateSecretInput) SetClientRequestToken(v string) *UpdateSecretInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSecretInput) SetDescription(v string) *UpdateSecretInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateSecretInput) SetKmsKeyId(v string) *UpdateSecretInput {
	s.KmsKeyId = &v
	return s
}

// SetSecretBinary sets the SecretBinary field's value.
func (s *UpdateSecretInput) SetSecretBinary(v []byte) *UpdateSecretInput {
	s.SecretBinary = v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *UpdateSecretInput) SetSecretId(v string) *UpdateSecretInput {
	s.SecretId = &v
	return s
}

// SetSecretString sets the SecretString field's value.
func (s *UpdateSecretInput) SetSecretString(v string) *UpdateSecretInput {
	s.SecretString = &v
	return s
}

type UpdateSecretOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that was updated.
	ARN *string `min:"20" type:"string"`

	// The name of the secret that was updated.
	Name *string `min:"1" type:"string"`

	// If Secrets Manager created a new version of the secret during this operation,
	// then VersionId contains the unique identifier of the new version.
	VersionId *string `min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *UpdateSecretOutput) SetARN(v string) *UpdateSecretOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSecretOutput) SetName(v string) *UpdateSecretOutput {
	s.Name = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *UpdateSecretOutput) SetVersionId(v string) *UpdateSecretOutput {
	s.VersionId = &v
	return s
}

type UpdateSecretVersionStageInput struct {
	_ struct{} `type:"structure"`

	// The ID of the version to add the staging label to. To remove a label from
	// a version, then do not specify this parameter.
	//
	// If the staging label is already attached to a different version of the secret,
	// then you must also specify the RemoveFromVersionId parameter.
	MoveToVersionId *string `min:"32" type:"string"`

	// The ID of the version that the staging label is to be removed from. If the
	// staging label you are trying to attach to one version is already attached
	// to a different version, then you must include this parameter and specify
	// the version that the label is to be removed from. If the label is attached
	// and you either do not specify this parameter, or the version ID does not
	// match, then the operation fails.
	RemoveFromVersionId *string `min:"32" type:"string"`

	// The ARN or the name of the secret with the version and staging labelsto modify.
	//
	// For an ARN, we recommend that you specify a complete ARN rather than a partial
	// ARN. See Finding a secret from a partial ARN (https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The staging label to add to this version.
	//
	// VersionStage is a required field
	VersionStage *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretVersionStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretVersionStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretVersionStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecretVersionStageInput"}
	if s.MoveToVersionId != nil && len(*s.MoveToVersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("MoveToVersionId", 32))
	}
	if s.RemoveFromVersionId != nil && len(*s.RemoveFromVersionId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveFromVersionId", 32))
	}
	if s.SecretId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}
	if s.VersionStage == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionStage"))
	}
	if s.VersionStage != nil && len(*s.VersionStage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionStage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMoveToVersionId sets the MoveToVersionId field's value.
func (s *UpdateSecretVersionStageInput) SetMoveToVersionId(v string) *UpdateSecretVersionStageInput {
	s.MoveToVersionId = &v
	return s
}

// SetRemoveFromVersionId sets the RemoveFromVersionId field's value.
func (s *UpdateSecretVersionStageInput) SetRemoveFromVersionId(v string) *UpdateSecretVersionStageInput {
	s.RemoveFromVersionId = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *UpdateSecretVersionStageInput) SetSecretId(v string) *UpdateSecretVersionStageInput {
	s.SecretId = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *UpdateSecretVersionStageInput) SetVersionStage(v string) *UpdateSecretVersionStageInput {
	s.VersionStage = &v
	return s
}

type UpdateSecretVersionStageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret that was updated.
	ARN *string `min:"20" type:"string"`

	// The name of the secret that was updated.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretVersionStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecretVersionStageOutput) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *UpdateSecretVersionStageOutput) SetARN(v string) *UpdateSecretVersionStageOutput {
	s.ARN = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSecretVersionStageOutput) SetName(v string) *UpdateSecretVersionStageOutput {
	s.Name = &v
	return s
}

type ValidateResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted string that contains an Amazon Web Services resource-based
	// policy. The policy in the string identifies who can access or manage this
	// secret and its versions. For example policies, see Permissions policy examples
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`

	// The ARN or name of the secret with the resource-based policy you want to
	// validate.
	SecretId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateResourcePolicyInput"}
	if s.ResourcePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *ValidateResourcePolicyInput) SetResourcePolicy(v string) *ValidateResourcePolicyInput {
	s.ResourcePolicy = &v
	return s
}

// SetSecretId sets the SecretId field's value.
func (s *ValidateResourcePolicyInput) SetSecretId(v string) *ValidateResourcePolicyInput {
	s.SecretId = &v
	return s
}

type ValidateResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// True if your policy passes validation, otherwise false.
	PolicyValidationPassed *bool `type:"boolean"`

	// Validation errors if your policy didn't pass validation.
	ValidationErrors []*ValidationErrorsEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidateResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyValidationPassed sets the PolicyValidationPassed field's value.
func (s *ValidateResourcePolicyOutput) SetPolicyValidationPassed(v bool) *ValidateResourcePolicyOutput {
	s.PolicyValidationPassed = &v
	return s
}

// SetValidationErrors sets the ValidationErrors field's value.
func (s *ValidateResourcePolicyOutput) SetValidationErrors(v []*ValidationErrorsEntry) *ValidateResourcePolicyOutput {
	s.ValidationErrors = v
	return s
}

// Displays errors that occurred during validation of the resource policy.
type ValidationErrorsEntry struct {
	_ struct{} `type:"structure"`

	// Checks the name of the policy.
	CheckName *string `min:"1" type:"string"`

	// Displays error messages if validation encounters problems during validation
	// of the resource policy.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationErrorsEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationErrorsEntry) GoString() string {
	return s.String()
}

// SetCheckName sets the CheckName field's value.
func (s *ValidationErrorsEntry) SetCheckName(v string) *ValidationErrorsEntry {
	s.CheckName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ValidationErrorsEntry) SetErrorMessage(v string) *ValidationErrorsEntry {
	s.ErrorMessage = &v
	return s
}

const (
	// FilterNameStringTypeDescription is a FilterNameStringType enum value
	FilterNameStringTypeDescription = "description"

	// FilterNameStringTypeName is a FilterNameStringType enum value
	FilterNameStringTypeName = "name"

	// FilterNameStringTypeTagKey is a FilterNameStringType enum value
	FilterNameStringTypeTagKey = "tag-key"

	// FilterNameStringTypeTagValue is a FilterNameStringType enum value
	FilterNameStringTypeTagValue = "tag-value"

	// FilterNameStringTypePrimaryRegion is a FilterNameStringType enum value
	FilterNameStringTypePrimaryRegion = "primary-region"

	// FilterNameStringTypeOwningService is a FilterNameStringType enum value
	FilterNameStringTypeOwningService = "owning-service"

	// FilterNameStringTypeAll is a FilterNameStringType enum value
	FilterNameStringTypeAll = "all"
)

// FilterNameStringType_Values returns all elements of the FilterNameStringType enum
func FilterNameStringType_Values() []string {
	return []string{
		FilterNameStringTypeDescription,
		FilterNameStringTypeName,
		FilterNameStringTypeTagKey,
		FilterNameStringTypeTagValue,
		FilterNameStringTypePrimaryRegion,
		FilterNameStringTypeOwningService,
		FilterNameStringTypeAll,
	}
}

const (
	// SortOrderTypeAsc is a SortOrderType enum value
	SortOrderTypeAsc = "asc"

	// SortOrderTypeDesc is a SortOrderType enum value
	SortOrderTypeDesc = "desc"
)

// SortOrderType_Values returns all elements of the SortOrderType enum
func SortOrderType_Values() []string {
	return []string{
		SortOrderTypeAsc,
		SortOrderTypeDesc,
	}
}

const (
	// StatusTypeInSync is a StatusType enum value
	StatusTypeInSync = "InSync"

	// StatusTypeFailed is a StatusType enum value
	StatusTypeFailed = "Failed"

	// StatusTypeInProgress is a StatusType enum value
	StatusTypeInProgress = "InProgress"
)

// StatusType_Values returns all elements of the StatusType enum
func StatusType_Values() []string {
	return []string{
		StatusTypeInSync,
		StatusTypeFailed,
		StatusTypeInProgress,
	}
}
