/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLServerGenericSynonym
extends GenericSynonym
implements DBPQualifiedObject {
    private static final Log log = Log.getLog(SQLServerGenericSynonym.class);
    private String targetObjectName;

    public SQLServerGenericSynonym(GenericStructContainer container, String name, String description, String targetObjectName) {
        super(container, name, description);
        this.targetObjectName = targetObjectName;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getParentObject(), this});
    }

    @Property(viewable=true, order=20)
    public DBSObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        int divPos = this.targetObjectName.indexOf("].[");
        if (divPos == -1) {
            log.debug((Object)("Bad target object name '" + this.targetObjectName + "' for synonym '" + this.getName() + "'"));
            return null;
        }
        String schemaName = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.targetObjectName.substring(0, divPos + 1));
        String objectName = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.targetObjectName.substring(divPos + 2));
        GenericCatalog database = this.getParentObject().getCatalog();
        GenericSchema schema = database.getSchema(monitor, schemaName);
        if (schema == null) {
            log.debug((Object)("Schema '" + schemaName + "' not found for synonym '" + this.getName() + "'"));
            return null;
        }
        return schema.getChild(monitor, objectName);
    }
}

