//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldispatchthreadgroupsindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLDispatchThreadgroupsIndirectArguments {
    pub threadgroupsPerGrid: [u32; 3],
}

unsafe impl Encode for MTLDispatchThreadgroupsIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct("?", &[<[u32; 3]>::ENCODING]);
}

unsafe impl RefEncode for MTLDispatchThreadgroupsIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstageinregionindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLStageInRegionIndirectArguments {
    pub stageInOrigin: [u32; 3],
    pub stageInSize: [u32; 3],
}

unsafe impl Encode for MTLStageInRegionIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct("?", &[<[u32; 3]>::ENCODING, <[u32; 3]>::ENCODING]);
}

unsafe impl RefEncode for MTLStageInRegionIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A command encoder that writes data parallel compute commands.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcomputecommandencoder?language=objc)
    #[cfg(feature = "MTLCommandEncoder")]
    pub unsafe trait MTLComputeCommandEncoder: MTLCommandEncoder {
        #[cfg(feature = "MTLCommandBuffer")]
        /// The dispatch type of the compute command encoder.
        #[unsafe(method(dispatchType))]
        #[unsafe(method_family = none)]
        unsafe fn dispatchType(&self) -> MTLDispatchType;

        #[cfg(feature = "MTLComputePipeline")]
        /// Set the compute pipeline state that will be used.
        #[unsafe(method(setComputePipelineState:))]
        #[unsafe(method_family = none)]
        fn setComputePipelineState(&self, state: &ProtocolObject<dyn MTLComputePipelineState>);

        /// Set the data (by copy) for a given buffer binding point.  This will remove any existing MTLBuffer from the binding point.
        #[unsafe(method(setBytes:length:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBytes_length_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set a global buffer for all compute kernels at the given bind point index.
        #[unsafe(method(setBuffer:offset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffer_offset_atIndex(
            &self,
            buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            offset: NSUInteger,
            index: NSUInteger,
        );

        /// Set the offset within the current global buffer for all compute kernels at the given bind point index.
        #[unsafe(method(setBufferOffset:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBufferOffset_atIndex(&self, offset: NSUInteger, index: NSUInteger);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Set an array of global buffers for all compute kernels with the given bind point range.
        #[unsafe(method(setBuffers:offsets:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffers_offsets_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// sets kernel buffer at specified index with provided offset and stride.
        /// only call this when the kernel-buffer is part of the stageInputDescriptor
        /// and has set its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setBuffer:offset:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffer_offset_attributeStride_atIndex(
            &self,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            offset: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// sets an array of kernel buffers with provided offsets and strides with the
        /// given bind point range. Only call this when at least one buffer is part of
        /// the vertexDescriptor, other buffers must set `MTLAttributeStrideStatic`
        #[unsafe(method(setBuffers:offsets:attributeStrides:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setBuffers_offsets_attributeStrides_withRange(
            &self,
            buffers: NonNull<*const ProtocolObject<dyn MTLBuffer>>,
            offsets: NonNull<NSUInteger>,
            strides: NonNull<NSUInteger>,
            range: NSRange,
        );

        /// only call this when the buffer-index is part of the stageInputDescriptor
        /// and has set its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setBufferOffset:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBufferOffset_attributeStride_atIndex(
            &self,
            offset: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        /// only call this when the buffer-index is part of the stageInputDescriptor
        /// and has set its stride to `MTLBufferLayoutStrideDynamic`
        #[unsafe(method(setBytes:length:attributeStride:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setBytes_length_attributeStride_atIndex(
            &self,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            stride: NSUInteger,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set a visible function table at the given buffer index
        #[unsafe(method(setVisibleFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setVisibleFunctionTable_atBufferIndex(
            &self,
            visible_function_table: Option<&ProtocolObject<dyn MTLVisibleFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLVisibleFunctionTable"
        ))]
        /// Set visible function tables at the given buffer index range
        #[unsafe(method(setVisibleFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setVisibleFunctionTables_withBufferRange(
            &self,
            visible_function_tables: NonNull<*const ProtocolObject<dyn MTLVisibleFunctionTable>>,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set a visible function table at the given buffer index
        #[unsafe(method(setIntersectionFunctionTable:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setIntersectionFunctionTable_atBufferIndex(
            &self,
            intersection_function_table: Option<&ProtocolObject<dyn MTLIntersectionFunctionTable>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIntersectionFunctionTable",
            feature = "MTLResource"
        ))]
        /// Set visible function tables at the given buffer index range
        #[unsafe(method(setIntersectionFunctionTables:withBufferRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setIntersectionFunctionTables_withBufferRange(
            &self,
            intersection_function_tables: NonNull<
                *const ProtocolObject<dyn MTLIntersectionFunctionTable>,
            >,
            range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Set a global raytracing acceleration structure for all compute kernels at the given buffer bind point index.
        #[unsafe(method(setAccelerationStructure:atBufferIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccelerationStructure_atBufferIndex(
            &self,
            acceleration_structure: Option<&ProtocolObject<dyn MTLAccelerationStructure>>,
            buffer_index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set a global texture for all compute kernels at the given bind point index.
        #[unsafe(method(setTexture:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setTexture_atIndex(
            &self,
            texture: Option<&ProtocolObject<dyn MTLTexture>>,
            index: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Set an array of global textures for all compute kernels with the given bind point range.
        #[unsafe(method(setTextures:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setTextures_withRange(
            &self,
            textures: NonNull<*const ProtocolObject<dyn MTLTexture>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all compute kernels at the given bind point index.
        #[unsafe(method(setSamplerState:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerState_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all compute kernels with the given bind point range.
        #[unsafe(method(setSamplerStates:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerStates_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            range: NSRange,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set a global sampler for all compute kernels at the given bind point index.
        #[unsafe(method(setSamplerState:lodMinClamp:lodMaxClamp:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerState_lodMinClamp_lodMaxClamp_atIndex(
            &self,
            sampler: Option<&ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamp: c_float,
            lod_max_clamp: c_float,
            index: NSUInteger,
        );

        #[cfg(feature = "MTLSampler")]
        /// Set an array of global samplers for all compute kernels with the given bind point range.
        #[unsafe(method(setSamplerStates:lodMinClamps:lodMaxClamps:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn setSamplerStates_lodMinClamps_lodMaxClamps_withRange(
            &self,
            samplers: NonNull<*const ProtocolObject<dyn MTLSamplerState>>,
            lod_min_clamps: NonNull<c_float>,
            lod_max_clamps: NonNull<c_float>,
            range: NSRange,
        );

        /// Set the threadgroup memory byte length at the binding point specified by the index. This applies to all compute kernels.
        #[unsafe(method(setThreadgroupMemoryLength:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setThreadgroupMemoryLength_atIndex(&self, length: NSUInteger, index: NSUInteger);

        /// Set imageblock sizes.
        #[unsafe(method(setImageblockWidth:height:))]
        #[unsafe(method_family = none)]
        unsafe fn setImageblockWidth_height(&self, width: NSUInteger, height: NSUInteger);

        #[cfg(feature = "MTLTypes")]
        #[unsafe(method(setStageInRegion:))]
        #[unsafe(method_family = none)]
        unsafe fn setStageInRegion(&self, region: MTLRegion);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        #[unsafe(method(setStageInRegionWithIndirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn setStageInRegionWithIndirectBuffer_indirectBufferOffset(
            &self,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        #[unsafe(method(dispatchThreadgroups:threadsPerThreadgroup:))]
        #[unsafe(method_family = none)]
        fn dispatchThreadgroups_threadsPerThreadgroup(
            &self,
            threadgroups_per_grid: MTLSize,
            threads_per_threadgroup: MTLSize,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTypes"
        ))]
        #[unsafe(method(dispatchThreadgroupsWithIndirectBuffer:indirectBufferOffset:threadsPerThreadgroup:))]
        #[unsafe(method_family = none)]
        unsafe fn dispatchThreadgroupsWithIndirectBuffer_indirectBufferOffset_threadsPerThreadgroup(
            &self,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
            threads_per_threadgroup: MTLSize,
        );

        #[cfg(feature = "MTLTypes")]
        #[unsafe(method(dispatchThreads:threadsPerThreadgroup:))]
        #[unsafe(method_family = none)]
        fn dispatchThreads_threadsPerThreadgroup(
            &self,
            threads_per_grid: MTLSize,
            threads_per_threadgroup: MTLSize,
        );

        #[cfg(feature = "MTLFence")]
        /// Update the fence to capture all GPU work so far enqueued by this encoder.
        ///
        /// The fence is updated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(updateFence:))]
        #[unsafe(method_family = none)]
        fn updateFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(feature = "MTLFence")]
        /// Prevent further GPU work until the fence is reached.
        ///
        /// The fence is evaluated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(waitForFence:))]
        #[unsafe(method_family = none)]
        fn waitForFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that a resource may be accessed by the command encoder through an argument buffer
        ///
        ///
        /// For tracked MTLResources, this method protects against data hazards. This method must be called before encoding any dispatch commands which may access the resource through an argument buffer.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useResource:usage:))]
        #[unsafe(method_family = none)]
        fn useResource_usage(
            &self,
            resource: &ProtocolObject<dyn MTLResource>,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that an array of resources may be accessed through an argument buffer by the command encoder
        ///
        /// For tracked MTL Resources, this method protects against data hazards. This method must be called before encoding any dispatch commands which may access the resources through an argument buffer.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useResources:count:usage:))]
        #[unsafe(method_family = none)]
        unsafe fn useResources_count_usage(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from a heap may be accessed as readonly by the render pass through an argument buffer
        ///
        /// For tracked MTLHeaps, this method protects against data hazards. This method must be called before encoding any dispatch commands which may access the resources allocated from the heap through an argument buffer. This method may cause all of the color attachments allocated from the heap to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useHeap:))]
        #[unsafe(method_family = none)]
        fn useHeap(&self, heap: &ProtocolObject<dyn MTLHeap>);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from an array of heaps may be accessed as readonly by the render pass through an argument buffer
        ///
        /// For tracked MTLHeaps, this method protects against data hazards. This method must be called before encoding any dispatch commands which may access the resources allocated from the heaps through an argument buffer. This method may cause all of the color attachments allocated from the heaps to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useHeaps:count:))]
        #[unsafe(method_family = none)]
        unsafe fn useHeaps_count(
            &self,
            heaps: NonNull<NonNull<ProtocolObject<dyn MTLHeap>>>,
            count: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Execute commands in the buffer within the range specified.
        ///
        /// The same indirect command buffer may be executed any number of times within the same encoder.
        #[unsafe(method(executeCommandsInBuffer:withRange:))]
        #[unsafe(method_family = none)]
        unsafe fn executeCommandsInBuffer_withRange(
            &self,
            indirect_command_buffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            execution_range: NSRange,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLIndirectCommandBuffer",
            feature = "MTLResource"
        ))]
        /// Execute commands in the buffer within the range specified by the indirect range buffer.
        ///
        /// Parameter `indirectRangeBuffer`: An indirect buffer from which the device reads the execution range parameter, as laid out in the MTLIndirectCommandBufferExecutionRange structure.
        ///
        /// Parameter `indirectBufferOffset`: The byte offset within indirectBuffer where the execution range parameter is located. Must be a multiple of 4 bytes.
        ///
        /// The same indirect command buffer may be executed any number of times within the same encoder.
        #[unsafe(method(executeCommandsInBuffer:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn executeCommandsInBuffer_indirectBuffer_indirectBufferOffset(
            &self,
            indirect_commandbuffer: &ProtocolObject<dyn MTLIndirectCommandBuffer>,
            indirect_range_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        /// Encodes a barrier between currently dispatched kernels in a concurrent compute command encoder and any subsequent ones on a specified resource group
        ///
        /// This API ensures that all dispatches in the encoder have completed execution and their side effects are visible to subsequent dispatches in that encoder. Calling barrier on a serial encoder is allowed, but ignored.
        #[unsafe(method(memoryBarrierWithScope:))]
        #[unsafe(method_family = none)]
        unsafe fn memoryBarrierWithScope(&self, scope: MTLBarrierScope);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Encodes a barrier between currently dispatched kernels in a concurrent compute command encoder and any subsequent ones on an array of resources.
        ///
        /// This API ensures that all dispatches in the encoder have completed execution and side effects on the specified resources are visible to subsequent dispatches in that encoder. Calling barrier on a serial encoder is allowed, but ignored.
        #[unsafe(method(memoryBarrierWithResources:count:))]
        #[unsafe(method_family = none)]
        unsafe fn memoryBarrierWithResources_count(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
        );

        #[cfg(feature = "MTLCounters")]
        /// Sample hardware counters at this point in the compute encoder and
        /// store the counter sample into the sample buffer at the specified index.
        ///
        /// Parameter `sampleBuffer`: The sample buffer to sample into
        ///
        /// Parameter `sampleIndex`: The index into the counter buffer to write the sample
        ///
        /// Parameter `barrier`: Insert a barrier before taking the sample.  Passing
        /// YES will ensure that all work encoded before this operation in the encoder is
        /// complete but does not isolate the work with respect to other encoders.  Passing
        /// NO will allow the sample to be taken concurrently with other operations in this
        /// encoder.
        /// In general, passing YES will lead to more repeatable counter results but
        /// may negatively impact performance.  Passing NO will generally be higher performance
        /// but counter results may not be repeatable.
        ///
        /// On devices where MTLCounterSamplingPointAtDispatchBoundary is unsupported,
        /// this method is not available and will generate an error if called.
        #[unsafe(method(sampleCountersInBuffer:atSampleIndex:withBarrier:))]
        #[unsafe(method_family = none)]
        unsafe fn sampleCountersInBuffer_atSampleIndex_withBarrier(
            &self,
            sample_buffer: &ProtocolObject<dyn MTLCounterSampleBuffer>,
            sample_index: NSUInteger,
            barrier: bool,
        );
    }
);
