//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	apiresource "k8s.io/apimachinery/pkg/api/resource"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	core "k8s.io/kubernetes/pkg/apis/core"
	resource "k8s.io/kubernetes/pkg/apis/resource"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.AllocatedDeviceStatus)(nil), (*resource.AllocatedDeviceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AllocatedDeviceStatus_To_resource_AllocatedDeviceStatus(a.(*resourcev1alpha3.AllocatedDeviceStatus), b.(*resource.AllocatedDeviceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocatedDeviceStatus)(nil), (*resourcev1alpha3.AllocatedDeviceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocatedDeviceStatus_To_v1alpha3_AllocatedDeviceStatus(a.(*resource.AllocatedDeviceStatus), b.(*resourcev1alpha3.AllocatedDeviceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.AllocationResult)(nil), (*resource.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_AllocationResult_To_resource_AllocationResult(a.(*resourcev1alpha3.AllocationResult), b.(*resource.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.AllocationResult)(nil), (*resourcev1alpha3.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_AllocationResult_To_v1alpha3_AllocationResult(a.(*resource.AllocationResult), b.(*resourcev1alpha3.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.BasicDevice)(nil), (*resource.BasicDevice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_BasicDevice_To_resource_BasicDevice(a.(*resourcev1alpha3.BasicDevice), b.(*resource.BasicDevice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.BasicDevice)(nil), (*resourcev1alpha3.BasicDevice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_BasicDevice_To_v1alpha3_BasicDevice(a.(*resource.BasicDevice), b.(*resourcev1alpha3.BasicDevice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.CELDeviceSelector)(nil), (*resource.CELDeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CELDeviceSelector_To_resource_CELDeviceSelector(a.(*resourcev1alpha3.CELDeviceSelector), b.(*resource.CELDeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.CELDeviceSelector)(nil), (*resourcev1alpha3.CELDeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_CELDeviceSelector_To_v1alpha3_CELDeviceSelector(a.(*resource.CELDeviceSelector), b.(*resourcev1alpha3.CELDeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.Device)(nil), (*resource.Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Device_To_resource_Device(a.(*resourcev1alpha3.Device), b.(*resource.Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.Device)(nil), (*resourcev1alpha3.Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_Device_To_v1alpha3_Device(a.(*resource.Device), b.(*resourcev1alpha3.Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceAllocationConfiguration)(nil), (*resource.DeviceAllocationConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceAllocationConfiguration_To_resource_DeviceAllocationConfiguration(a.(*resourcev1alpha3.DeviceAllocationConfiguration), b.(*resource.DeviceAllocationConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceAllocationConfiguration)(nil), (*resourcev1alpha3.DeviceAllocationConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceAllocationConfiguration_To_v1alpha3_DeviceAllocationConfiguration(a.(*resource.DeviceAllocationConfiguration), b.(*resourcev1alpha3.DeviceAllocationConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceAllocationResult)(nil), (*resource.DeviceAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult(a.(*resourcev1alpha3.DeviceAllocationResult), b.(*resource.DeviceAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceAllocationResult)(nil), (*resourcev1alpha3.DeviceAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult(a.(*resource.DeviceAllocationResult), b.(*resourcev1alpha3.DeviceAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceAttribute)(nil), (*resource.DeviceAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceAttribute_To_resource_DeviceAttribute(a.(*resourcev1alpha3.DeviceAttribute), b.(*resource.DeviceAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceAttribute)(nil), (*resourcev1alpha3.DeviceAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceAttribute_To_v1alpha3_DeviceAttribute(a.(*resource.DeviceAttribute), b.(*resourcev1alpha3.DeviceAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClaim)(nil), (*resource.DeviceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClaim_To_resource_DeviceClaim(a.(*resourcev1alpha3.DeviceClaim), b.(*resource.DeviceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClaim)(nil), (*resourcev1alpha3.DeviceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClaim_To_v1alpha3_DeviceClaim(a.(*resource.DeviceClaim), b.(*resourcev1alpha3.DeviceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClaimConfiguration)(nil), (*resource.DeviceClaimConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClaimConfiguration_To_resource_DeviceClaimConfiguration(a.(*resourcev1alpha3.DeviceClaimConfiguration), b.(*resource.DeviceClaimConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClaimConfiguration)(nil), (*resourcev1alpha3.DeviceClaimConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClaimConfiguration_To_v1alpha3_DeviceClaimConfiguration(a.(*resource.DeviceClaimConfiguration), b.(*resourcev1alpha3.DeviceClaimConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClass)(nil), (*resource.DeviceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClass_To_resource_DeviceClass(a.(*resourcev1alpha3.DeviceClass), b.(*resource.DeviceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClass)(nil), (*resourcev1alpha3.DeviceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClass_To_v1alpha3_DeviceClass(a.(*resource.DeviceClass), b.(*resourcev1alpha3.DeviceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClassConfiguration)(nil), (*resource.DeviceClassConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClassConfiguration_To_resource_DeviceClassConfiguration(a.(*resourcev1alpha3.DeviceClassConfiguration), b.(*resource.DeviceClassConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClassConfiguration)(nil), (*resourcev1alpha3.DeviceClassConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClassConfiguration_To_v1alpha3_DeviceClassConfiguration(a.(*resource.DeviceClassConfiguration), b.(*resourcev1alpha3.DeviceClassConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClassList)(nil), (*resource.DeviceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClassList_To_resource_DeviceClassList(a.(*resourcev1alpha3.DeviceClassList), b.(*resource.DeviceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClassList)(nil), (*resourcev1alpha3.DeviceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClassList_To_v1alpha3_DeviceClassList(a.(*resource.DeviceClassList), b.(*resourcev1alpha3.DeviceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceClassSpec)(nil), (*resource.DeviceClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec(a.(*resourcev1alpha3.DeviceClassSpec), b.(*resource.DeviceClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceClassSpec)(nil), (*resourcev1alpha3.DeviceClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec(a.(*resource.DeviceClassSpec), b.(*resourcev1alpha3.DeviceClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceConfiguration)(nil), (*resource.DeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(a.(*resourcev1alpha3.DeviceConfiguration), b.(*resource.DeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceConfiguration)(nil), (*resourcev1alpha3.DeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(a.(*resource.DeviceConfiguration), b.(*resourcev1alpha3.DeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceConstraint)(nil), (*resource.DeviceConstraint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceConstraint_To_resource_DeviceConstraint(a.(*resourcev1alpha3.DeviceConstraint), b.(*resource.DeviceConstraint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceConstraint)(nil), (*resourcev1alpha3.DeviceConstraint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceConstraint_To_v1alpha3_DeviceConstraint(a.(*resource.DeviceConstraint), b.(*resourcev1alpha3.DeviceConstraint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceRequest)(nil), (*resource.DeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceRequest_To_resource_DeviceRequest(a.(*resourcev1alpha3.DeviceRequest), b.(*resource.DeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceRequest)(nil), (*resourcev1alpha3.DeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceRequest_To_v1alpha3_DeviceRequest(a.(*resource.DeviceRequest), b.(*resourcev1alpha3.DeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceRequestAllocationResult)(nil), (*resource.DeviceRequestAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceRequestAllocationResult_To_resource_DeviceRequestAllocationResult(a.(*resourcev1alpha3.DeviceRequestAllocationResult), b.(*resource.DeviceRequestAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceRequestAllocationResult)(nil), (*resourcev1alpha3.DeviceRequestAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceRequestAllocationResult_To_v1alpha3_DeviceRequestAllocationResult(a.(*resource.DeviceRequestAllocationResult), b.(*resourcev1alpha3.DeviceRequestAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.DeviceSelector)(nil), (*resource.DeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_DeviceSelector_To_resource_DeviceSelector(a.(*resourcev1alpha3.DeviceSelector), b.(*resource.DeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.DeviceSelector)(nil), (*resourcev1alpha3.DeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceSelector_To_v1alpha3_DeviceSelector(a.(*resource.DeviceSelector), b.(*resourcev1alpha3.DeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.NetworkDeviceData)(nil), (*resource.NetworkDeviceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NetworkDeviceData_To_resource_NetworkDeviceData(a.(*resourcev1alpha3.NetworkDeviceData), b.(*resource.NetworkDeviceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.NetworkDeviceData)(nil), (*resourcev1alpha3.NetworkDeviceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_NetworkDeviceData_To_v1alpha3_NetworkDeviceData(a.(*resource.NetworkDeviceData), b.(*resourcev1alpha3.NetworkDeviceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.OpaqueDeviceConfiguration)(nil), (*resource.OpaqueDeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpaqueDeviceConfiguration_To_resource_OpaqueDeviceConfiguration(a.(*resourcev1alpha3.OpaqueDeviceConfiguration), b.(*resource.OpaqueDeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.OpaqueDeviceConfiguration)(nil), (*resourcev1alpha3.OpaqueDeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_OpaqueDeviceConfiguration_To_v1alpha3_OpaqueDeviceConfiguration(a.(*resource.OpaqueDeviceConfiguration), b.(*resourcev1alpha3.OpaqueDeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaim)(nil), (*resource.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaim_To_resource_ResourceClaim(a.(*resourcev1alpha3.ResourceClaim), b.(*resource.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaim)(nil), (*resourcev1alpha3.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaim_To_v1alpha3_ResourceClaim(a.(*resource.ResourceClaim), b.(*resourcev1alpha3.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimConsumerReference)(nil), (*resource.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(a.(*resourcev1alpha3.ResourceClaimConsumerReference), b.(*resource.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimConsumerReference)(nil), (*resourcev1alpha3.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimConsumerReference_To_v1alpha3_ResourceClaimConsumerReference(a.(*resource.ResourceClaimConsumerReference), b.(*resourcev1alpha3.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimList)(nil), (*resource.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimList_To_resource_ResourceClaimList(a.(*resourcev1alpha3.ResourceClaimList), b.(*resource.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimList)(nil), (*resourcev1alpha3.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimList_To_v1alpha3_ResourceClaimList(a.(*resource.ResourceClaimList), b.(*resourcev1alpha3.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimSpec)(nil), (*resource.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(a.(*resourcev1alpha3.ResourceClaimSpec), b.(*resource.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimSpec)(nil), (*resourcev1alpha3.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(a.(*resource.ResourceClaimSpec), b.(*resourcev1alpha3.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimStatus)(nil), (*resource.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus(a.(*resourcev1alpha3.ResourceClaimStatus), b.(*resource.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimStatus)(nil), (*resourcev1alpha3.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus(a.(*resource.ResourceClaimStatus), b.(*resourcev1alpha3.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimTemplate)(nil), (*resource.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(a.(*resourcev1alpha3.ResourceClaimTemplate), b.(*resource.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplate)(nil), (*resourcev1alpha3.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplate_To_v1alpha3_ResourceClaimTemplate(a.(*resource.ResourceClaimTemplate), b.(*resourcev1alpha3.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimTemplateList)(nil), (*resource.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(a.(*resourcev1alpha3.ResourceClaimTemplateList), b.(*resource.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateList)(nil), (*resourcev1alpha3.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateList_To_v1alpha3_ResourceClaimTemplateList(a.(*resource.ResourceClaimTemplateList), b.(*resourcev1alpha3.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceClaimTemplateSpec)(nil), (*resource.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(a.(*resourcev1alpha3.ResourceClaimTemplateSpec), b.(*resource.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceClaimTemplateSpec)(nil), (*resourcev1alpha3.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec(a.(*resource.ResourceClaimTemplateSpec), b.(*resourcev1alpha3.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourcePool)(nil), (*resource.ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourcePool_To_resource_ResourcePool(a.(*resourcev1alpha3.ResourcePool), b.(*resource.ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourcePool)(nil), (*resourcev1alpha3.ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourcePool_To_v1alpha3_ResourcePool(a.(*resource.ResourcePool), b.(*resourcev1alpha3.ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceSlice)(nil), (*resource.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceSlice_To_resource_ResourceSlice(a.(*resourcev1alpha3.ResourceSlice), b.(*resource.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceSlice)(nil), (*resourcev1alpha3.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceSlice_To_v1alpha3_ResourceSlice(a.(*resource.ResourceSlice), b.(*resourcev1alpha3.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceSliceList)(nil), (*resource.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceSliceList_To_resource_ResourceSliceList(a.(*resourcev1alpha3.ResourceSliceList), b.(*resource.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceSliceList)(nil), (*resourcev1alpha3.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceSliceList_To_v1alpha3_ResourceSliceList(a.(*resource.ResourceSliceList), b.(*resourcev1alpha3.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1alpha3.ResourceSliceSpec)(nil), (*resource.ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec(a.(*resourcev1alpha3.ResourceSliceSpec), b.(*resource.ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resource.ResourceSliceSpec)(nil), (*resourcev1alpha3.ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec(a.(*resource.ResourceSliceSpec), b.(*resourcev1alpha3.ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*resource.DeviceCapacity)(nil), (*apiresource.Quantity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_DeviceCapacity_To_resource_Quantity(a.(*resource.DeviceCapacity), b.(*apiresource.Quantity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apiresource.Quantity)(nil), (*resource.DeviceCapacity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_resource_Quantity_To_resource_DeviceCapacity(a.(*apiresource.Quantity), b.(*resource.DeviceCapacity), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_AllocatedDeviceStatus_To_resource_AllocatedDeviceStatus(in *resourcev1alpha3.AllocatedDeviceStatus, out *resource.AllocatedDeviceStatus, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	out.Data = in.Data
	out.NetworkData = (*resource.NetworkDeviceData)(unsafe.Pointer(in.NetworkData))
	return nil
}

// Convert_v1alpha3_AllocatedDeviceStatus_To_resource_AllocatedDeviceStatus is an autogenerated conversion function.
func Convert_v1alpha3_AllocatedDeviceStatus_To_resource_AllocatedDeviceStatus(in *resourcev1alpha3.AllocatedDeviceStatus, out *resource.AllocatedDeviceStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_AllocatedDeviceStatus_To_resource_AllocatedDeviceStatus(in, out, s)
}

func autoConvert_resource_AllocatedDeviceStatus_To_v1alpha3_AllocatedDeviceStatus(in *resource.AllocatedDeviceStatus, out *resourcev1alpha3.AllocatedDeviceStatus, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	out.Data = in.Data
	out.NetworkData = (*resourcev1alpha3.NetworkDeviceData)(unsafe.Pointer(in.NetworkData))
	return nil
}

// Convert_resource_AllocatedDeviceStatus_To_v1alpha3_AllocatedDeviceStatus is an autogenerated conversion function.
func Convert_resource_AllocatedDeviceStatus_To_v1alpha3_AllocatedDeviceStatus(in *resource.AllocatedDeviceStatus, out *resourcev1alpha3.AllocatedDeviceStatus, s conversion.Scope) error {
	return autoConvert_resource_AllocatedDeviceStatus_To_v1alpha3_AllocatedDeviceStatus(in, out, s)
}

func autoConvert_v1alpha3_AllocationResult_To_resource_AllocationResult(in *resourcev1alpha3.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	if err := Convert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	out.NodeSelector = (*core.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	return nil
}

// Convert_v1alpha3_AllocationResult_To_resource_AllocationResult is an autogenerated conversion function.
func Convert_v1alpha3_AllocationResult_To_resource_AllocationResult(in *resourcev1alpha3.AllocationResult, out *resource.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha3_AllocationResult_To_resource_AllocationResult(in, out, s)
}

func autoConvert_resource_AllocationResult_To_v1alpha3_AllocationResult(in *resource.AllocationResult, out *resourcev1alpha3.AllocationResult, s conversion.Scope) error {
	if err := Convert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	return nil
}

// Convert_resource_AllocationResult_To_v1alpha3_AllocationResult is an autogenerated conversion function.
func Convert_resource_AllocationResult_To_v1alpha3_AllocationResult(in *resource.AllocationResult, out *resourcev1alpha3.AllocationResult, s conversion.Scope) error {
	return autoConvert_resource_AllocationResult_To_v1alpha3_AllocationResult(in, out, s)
}

func autoConvert_v1alpha3_BasicDevice_To_resource_BasicDevice(in *resourcev1alpha3.BasicDevice, out *resource.BasicDevice, s conversion.Scope) error {
	out.Attributes = *(*map[resource.QualifiedName]resource.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	if in.Capacity != nil {
		in, out := &in.Capacity, &out.Capacity
		*out = make(map[resource.QualifiedName]resource.DeviceCapacity, len(*in))
		for key, val := range *in {
			newVal := new(resource.DeviceCapacity)
			if err := Convert_resource_Quantity_To_resource_DeviceCapacity(&val, newVal, s); err != nil {
				return err
			}
			(*out)[resource.QualifiedName(key)] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	return nil
}

// Convert_v1alpha3_BasicDevice_To_resource_BasicDevice is an autogenerated conversion function.
func Convert_v1alpha3_BasicDevice_To_resource_BasicDevice(in *resourcev1alpha3.BasicDevice, out *resource.BasicDevice, s conversion.Scope) error {
	return autoConvert_v1alpha3_BasicDevice_To_resource_BasicDevice(in, out, s)
}

func autoConvert_resource_BasicDevice_To_v1alpha3_BasicDevice(in *resource.BasicDevice, out *resourcev1alpha3.BasicDevice, s conversion.Scope) error {
	out.Attributes = *(*map[resourcev1alpha3.QualifiedName]resourcev1alpha3.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	if in.Capacity != nil {
		in, out := &in.Capacity, &out.Capacity
		*out = make(map[resourcev1alpha3.QualifiedName]apiresource.Quantity, len(*in))
		for key, val := range *in {
			newVal := new(apiresource.Quantity)
			if err := Convert_resource_DeviceCapacity_To_resource_Quantity(&val, newVal, s); err != nil {
				return err
			}
			(*out)[resourcev1alpha3.QualifiedName(key)] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	return nil
}

// Convert_resource_BasicDevice_To_v1alpha3_BasicDevice is an autogenerated conversion function.
func Convert_resource_BasicDevice_To_v1alpha3_BasicDevice(in *resource.BasicDevice, out *resourcev1alpha3.BasicDevice, s conversion.Scope) error {
	return autoConvert_resource_BasicDevice_To_v1alpha3_BasicDevice(in, out, s)
}

func autoConvert_v1alpha3_CELDeviceSelector_To_resource_CELDeviceSelector(in *resourcev1alpha3.CELDeviceSelector, out *resource.CELDeviceSelector, s conversion.Scope) error {
	out.Expression = in.Expression
	return nil
}

// Convert_v1alpha3_CELDeviceSelector_To_resource_CELDeviceSelector is an autogenerated conversion function.
func Convert_v1alpha3_CELDeviceSelector_To_resource_CELDeviceSelector(in *resourcev1alpha3.CELDeviceSelector, out *resource.CELDeviceSelector, s conversion.Scope) error {
	return autoConvert_v1alpha3_CELDeviceSelector_To_resource_CELDeviceSelector(in, out, s)
}

func autoConvert_resource_CELDeviceSelector_To_v1alpha3_CELDeviceSelector(in *resource.CELDeviceSelector, out *resourcev1alpha3.CELDeviceSelector, s conversion.Scope) error {
	out.Expression = in.Expression
	return nil
}

// Convert_resource_CELDeviceSelector_To_v1alpha3_CELDeviceSelector is an autogenerated conversion function.
func Convert_resource_CELDeviceSelector_To_v1alpha3_CELDeviceSelector(in *resource.CELDeviceSelector, out *resourcev1alpha3.CELDeviceSelector, s conversion.Scope) error {
	return autoConvert_resource_CELDeviceSelector_To_v1alpha3_CELDeviceSelector(in, out, s)
}

func autoConvert_v1alpha3_Device_To_resource_Device(in *resourcev1alpha3.Device, out *resource.Device, s conversion.Scope) error {
	out.Name = in.Name
	if in.Basic != nil {
		in, out := &in.Basic, &out.Basic
		*out = new(resource.BasicDevice)
		if err := Convert_v1alpha3_BasicDevice_To_resource_BasicDevice(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Basic = nil
	}
	return nil
}

// Convert_v1alpha3_Device_To_resource_Device is an autogenerated conversion function.
func Convert_v1alpha3_Device_To_resource_Device(in *resourcev1alpha3.Device, out *resource.Device, s conversion.Scope) error {
	return autoConvert_v1alpha3_Device_To_resource_Device(in, out, s)
}

func autoConvert_resource_Device_To_v1alpha3_Device(in *resource.Device, out *resourcev1alpha3.Device, s conversion.Scope) error {
	out.Name = in.Name
	if in.Basic != nil {
		in, out := &in.Basic, &out.Basic
		*out = new(resourcev1alpha3.BasicDevice)
		if err := Convert_resource_BasicDevice_To_v1alpha3_BasicDevice(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Basic = nil
	}
	return nil
}

// Convert_resource_Device_To_v1alpha3_Device is an autogenerated conversion function.
func Convert_resource_Device_To_v1alpha3_Device(in *resource.Device, out *resourcev1alpha3.Device, s conversion.Scope) error {
	return autoConvert_resource_Device_To_v1alpha3_Device(in, out, s)
}

func autoConvert_v1alpha3_DeviceAllocationConfiguration_To_resource_DeviceAllocationConfiguration(in *resourcev1alpha3.DeviceAllocationConfiguration, out *resource.DeviceAllocationConfiguration, s conversion.Scope) error {
	out.Source = resource.AllocationConfigSource(in.Source)
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_DeviceAllocationConfiguration_To_resource_DeviceAllocationConfiguration is an autogenerated conversion function.
func Convert_v1alpha3_DeviceAllocationConfiguration_To_resource_DeviceAllocationConfiguration(in *resourcev1alpha3.DeviceAllocationConfiguration, out *resource.DeviceAllocationConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceAllocationConfiguration_To_resource_DeviceAllocationConfiguration(in, out, s)
}

func autoConvert_resource_DeviceAllocationConfiguration_To_v1alpha3_DeviceAllocationConfiguration(in *resource.DeviceAllocationConfiguration, out *resourcev1alpha3.DeviceAllocationConfiguration, s conversion.Scope) error {
	out.Source = resourcev1alpha3.AllocationConfigSource(in.Source)
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_DeviceAllocationConfiguration_To_v1alpha3_DeviceAllocationConfiguration is an autogenerated conversion function.
func Convert_resource_DeviceAllocationConfiguration_To_v1alpha3_DeviceAllocationConfiguration(in *resource.DeviceAllocationConfiguration, out *resourcev1alpha3.DeviceAllocationConfiguration, s conversion.Scope) error {
	return autoConvert_resource_DeviceAllocationConfiguration_To_v1alpha3_DeviceAllocationConfiguration(in, out, s)
}

func autoConvert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult(in *resourcev1alpha3.DeviceAllocationResult, out *resource.DeviceAllocationResult, s conversion.Scope) error {
	out.Results = *(*[]resource.DeviceRequestAllocationResult)(unsafe.Pointer(&in.Results))
	out.Config = *(*[]resource.DeviceAllocationConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult is an autogenerated conversion function.
func Convert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult(in *resourcev1alpha3.DeviceAllocationResult, out *resource.DeviceAllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceAllocationResult_To_resource_DeviceAllocationResult(in, out, s)
}

func autoConvert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult(in *resource.DeviceAllocationResult, out *resourcev1alpha3.DeviceAllocationResult, s conversion.Scope) error {
	out.Results = *(*[]resourcev1alpha3.DeviceRequestAllocationResult)(unsafe.Pointer(&in.Results))
	out.Config = *(*[]resourcev1alpha3.DeviceAllocationConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult is an autogenerated conversion function.
func Convert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult(in *resource.DeviceAllocationResult, out *resourcev1alpha3.DeviceAllocationResult, s conversion.Scope) error {
	return autoConvert_resource_DeviceAllocationResult_To_v1alpha3_DeviceAllocationResult(in, out, s)
}

func autoConvert_v1alpha3_DeviceAttribute_To_resource_DeviceAttribute(in *resourcev1alpha3.DeviceAttribute, out *resource.DeviceAttribute, s conversion.Scope) error {
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_v1alpha3_DeviceAttribute_To_resource_DeviceAttribute is an autogenerated conversion function.
func Convert_v1alpha3_DeviceAttribute_To_resource_DeviceAttribute(in *resourcev1alpha3.DeviceAttribute, out *resource.DeviceAttribute, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceAttribute_To_resource_DeviceAttribute(in, out, s)
}

func autoConvert_resource_DeviceAttribute_To_v1alpha3_DeviceAttribute(in *resource.DeviceAttribute, out *resourcev1alpha3.DeviceAttribute, s conversion.Scope) error {
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_resource_DeviceAttribute_To_v1alpha3_DeviceAttribute is an autogenerated conversion function.
func Convert_resource_DeviceAttribute_To_v1alpha3_DeviceAttribute(in *resource.DeviceAttribute, out *resourcev1alpha3.DeviceAttribute, s conversion.Scope) error {
	return autoConvert_resource_DeviceAttribute_To_v1alpha3_DeviceAttribute(in, out, s)
}

func autoConvert_v1alpha3_DeviceClaim_To_resource_DeviceClaim(in *resourcev1alpha3.DeviceClaim, out *resource.DeviceClaim, s conversion.Scope) error {
	out.Requests = *(*[]resource.DeviceRequest)(unsafe.Pointer(&in.Requests))
	out.Constraints = *(*[]resource.DeviceConstraint)(unsafe.Pointer(&in.Constraints))
	out.Config = *(*[]resource.DeviceClaimConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1alpha3_DeviceClaim_To_resource_DeviceClaim is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClaim_To_resource_DeviceClaim(in *resourcev1alpha3.DeviceClaim, out *resource.DeviceClaim, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClaim_To_resource_DeviceClaim(in, out, s)
}

func autoConvert_resource_DeviceClaim_To_v1alpha3_DeviceClaim(in *resource.DeviceClaim, out *resourcev1alpha3.DeviceClaim, s conversion.Scope) error {
	out.Requests = *(*[]resourcev1alpha3.DeviceRequest)(unsafe.Pointer(&in.Requests))
	out.Constraints = *(*[]resourcev1alpha3.DeviceConstraint)(unsafe.Pointer(&in.Constraints))
	out.Config = *(*[]resourcev1alpha3.DeviceClaimConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_resource_DeviceClaim_To_v1alpha3_DeviceClaim is an autogenerated conversion function.
func Convert_resource_DeviceClaim_To_v1alpha3_DeviceClaim(in *resource.DeviceClaim, out *resourcev1alpha3.DeviceClaim, s conversion.Scope) error {
	return autoConvert_resource_DeviceClaim_To_v1alpha3_DeviceClaim(in, out, s)
}

func autoConvert_v1alpha3_DeviceClaimConfiguration_To_resource_DeviceClaimConfiguration(in *resourcev1alpha3.DeviceClaimConfiguration, out *resource.DeviceClaimConfiguration, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_DeviceClaimConfiguration_To_resource_DeviceClaimConfiguration is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClaimConfiguration_To_resource_DeviceClaimConfiguration(in *resourcev1alpha3.DeviceClaimConfiguration, out *resource.DeviceClaimConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClaimConfiguration_To_resource_DeviceClaimConfiguration(in, out, s)
}

func autoConvert_resource_DeviceClaimConfiguration_To_v1alpha3_DeviceClaimConfiguration(in *resource.DeviceClaimConfiguration, out *resourcev1alpha3.DeviceClaimConfiguration, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_DeviceClaimConfiguration_To_v1alpha3_DeviceClaimConfiguration is an autogenerated conversion function.
func Convert_resource_DeviceClaimConfiguration_To_v1alpha3_DeviceClaimConfiguration(in *resource.DeviceClaimConfiguration, out *resourcev1alpha3.DeviceClaimConfiguration, s conversion.Scope) error {
	return autoConvert_resource_DeviceClaimConfiguration_To_v1alpha3_DeviceClaimConfiguration(in, out, s)
}

func autoConvert_v1alpha3_DeviceClass_To_resource_DeviceClass(in *resourcev1alpha3.DeviceClass, out *resource.DeviceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_DeviceClass_To_resource_DeviceClass is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClass_To_resource_DeviceClass(in *resourcev1alpha3.DeviceClass, out *resource.DeviceClass, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClass_To_resource_DeviceClass(in, out, s)
}

func autoConvert_resource_DeviceClass_To_v1alpha3_DeviceClass(in *resource.DeviceClass, out *resourcev1alpha3.DeviceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_DeviceClass_To_v1alpha3_DeviceClass is an autogenerated conversion function.
func Convert_resource_DeviceClass_To_v1alpha3_DeviceClass(in *resource.DeviceClass, out *resourcev1alpha3.DeviceClass, s conversion.Scope) error {
	return autoConvert_resource_DeviceClass_To_v1alpha3_DeviceClass(in, out, s)
}

func autoConvert_v1alpha3_DeviceClassConfiguration_To_resource_DeviceClassConfiguration(in *resourcev1alpha3.DeviceClassConfiguration, out *resource.DeviceClassConfiguration, s conversion.Scope) error {
	if err := Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_DeviceClassConfiguration_To_resource_DeviceClassConfiguration is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClassConfiguration_To_resource_DeviceClassConfiguration(in *resourcev1alpha3.DeviceClassConfiguration, out *resource.DeviceClassConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClassConfiguration_To_resource_DeviceClassConfiguration(in, out, s)
}

func autoConvert_resource_DeviceClassConfiguration_To_v1alpha3_DeviceClassConfiguration(in *resource.DeviceClassConfiguration, out *resourcev1alpha3.DeviceClassConfiguration, s conversion.Scope) error {
	if err := Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_DeviceClassConfiguration_To_v1alpha3_DeviceClassConfiguration is an autogenerated conversion function.
func Convert_resource_DeviceClassConfiguration_To_v1alpha3_DeviceClassConfiguration(in *resource.DeviceClassConfiguration, out *resourcev1alpha3.DeviceClassConfiguration, s conversion.Scope) error {
	return autoConvert_resource_DeviceClassConfiguration_To_v1alpha3_DeviceClassConfiguration(in, out, s)
}

func autoConvert_v1alpha3_DeviceClassList_To_resource_DeviceClassList(in *resourcev1alpha3.DeviceClassList, out *resource.DeviceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.DeviceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha3_DeviceClassList_To_resource_DeviceClassList is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClassList_To_resource_DeviceClassList(in *resourcev1alpha3.DeviceClassList, out *resource.DeviceClassList, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClassList_To_resource_DeviceClassList(in, out, s)
}

func autoConvert_resource_DeviceClassList_To_v1alpha3_DeviceClassList(in *resource.DeviceClassList, out *resourcev1alpha3.DeviceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1alpha3.DeviceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_DeviceClassList_To_v1alpha3_DeviceClassList is an autogenerated conversion function.
func Convert_resource_DeviceClassList_To_v1alpha3_DeviceClassList(in *resource.DeviceClassList, out *resourcev1alpha3.DeviceClassList, s conversion.Scope) error {
	return autoConvert_resource_DeviceClassList_To_v1alpha3_DeviceClassList(in, out, s)
}

func autoConvert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec(in *resourcev1alpha3.DeviceClassSpec, out *resource.DeviceClassSpec, s conversion.Scope) error {
	out.Selectors = *(*[]resource.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.Config = *(*[]resource.DeviceClassConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec is an autogenerated conversion function.
func Convert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec(in *resourcev1alpha3.DeviceClassSpec, out *resource.DeviceClassSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceClassSpec_To_resource_DeviceClassSpec(in, out, s)
}

func autoConvert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec(in *resource.DeviceClassSpec, out *resourcev1alpha3.DeviceClassSpec, s conversion.Scope) error {
	out.Selectors = *(*[]resourcev1alpha3.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.Config = *(*[]resourcev1alpha3.DeviceClassConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec is an autogenerated conversion function.
func Convert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec(in *resource.DeviceClassSpec, out *resourcev1alpha3.DeviceClassSpec, s conversion.Scope) error {
	return autoConvert_resource_DeviceClassSpec_To_v1alpha3_DeviceClassSpec(in, out, s)
}

func autoConvert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(in *resourcev1alpha3.DeviceConfiguration, out *resource.DeviceConfiguration, s conversion.Scope) error {
	out.Opaque = (*resource.OpaqueDeviceConfiguration)(unsafe.Pointer(in.Opaque))
	return nil
}

// Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration is an autogenerated conversion function.
func Convert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(in *resourcev1alpha3.DeviceConfiguration, out *resource.DeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceConfiguration_To_resource_DeviceConfiguration(in, out, s)
}

func autoConvert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(in *resource.DeviceConfiguration, out *resourcev1alpha3.DeviceConfiguration, s conversion.Scope) error {
	out.Opaque = (*resourcev1alpha3.OpaqueDeviceConfiguration)(unsafe.Pointer(in.Opaque))
	return nil
}

// Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration is an autogenerated conversion function.
func Convert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(in *resource.DeviceConfiguration, out *resourcev1alpha3.DeviceConfiguration, s conversion.Scope) error {
	return autoConvert_resource_DeviceConfiguration_To_v1alpha3_DeviceConfiguration(in, out, s)
}

func autoConvert_v1alpha3_DeviceConstraint_To_resource_DeviceConstraint(in *resourcev1alpha3.DeviceConstraint, out *resource.DeviceConstraint, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	out.MatchAttribute = (*resource.FullyQualifiedName)(unsafe.Pointer(in.MatchAttribute))
	return nil
}

// Convert_v1alpha3_DeviceConstraint_To_resource_DeviceConstraint is an autogenerated conversion function.
func Convert_v1alpha3_DeviceConstraint_To_resource_DeviceConstraint(in *resourcev1alpha3.DeviceConstraint, out *resource.DeviceConstraint, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceConstraint_To_resource_DeviceConstraint(in, out, s)
}

func autoConvert_resource_DeviceConstraint_To_v1alpha3_DeviceConstraint(in *resource.DeviceConstraint, out *resourcev1alpha3.DeviceConstraint, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	out.MatchAttribute = (*resourcev1alpha3.FullyQualifiedName)(unsafe.Pointer(in.MatchAttribute))
	return nil
}

// Convert_resource_DeviceConstraint_To_v1alpha3_DeviceConstraint is an autogenerated conversion function.
func Convert_resource_DeviceConstraint_To_v1alpha3_DeviceConstraint(in *resource.DeviceConstraint, out *resourcev1alpha3.DeviceConstraint, s conversion.Scope) error {
	return autoConvert_resource_DeviceConstraint_To_v1alpha3_DeviceConstraint(in, out, s)
}

func autoConvert_v1alpha3_DeviceRequest_To_resource_DeviceRequest(in *resourcev1alpha3.DeviceRequest, out *resource.DeviceRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]resource.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = resource.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	return nil
}

// Convert_v1alpha3_DeviceRequest_To_resource_DeviceRequest is an autogenerated conversion function.
func Convert_v1alpha3_DeviceRequest_To_resource_DeviceRequest(in *resourcev1alpha3.DeviceRequest, out *resource.DeviceRequest, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceRequest_To_resource_DeviceRequest(in, out, s)
}

func autoConvert_resource_DeviceRequest_To_v1alpha3_DeviceRequest(in *resource.DeviceRequest, out *resourcev1alpha3.DeviceRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]resourcev1alpha3.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = resourcev1alpha3.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	return nil
}

// Convert_resource_DeviceRequest_To_v1alpha3_DeviceRequest is an autogenerated conversion function.
func Convert_resource_DeviceRequest_To_v1alpha3_DeviceRequest(in *resource.DeviceRequest, out *resourcev1alpha3.DeviceRequest, s conversion.Scope) error {
	return autoConvert_resource_DeviceRequest_To_v1alpha3_DeviceRequest(in, out, s)
}

func autoConvert_v1alpha3_DeviceRequestAllocationResult_To_resource_DeviceRequestAllocationResult(in *resourcev1alpha3.DeviceRequestAllocationResult, out *resource.DeviceRequestAllocationResult, s conversion.Scope) error {
	out.Request = in.Request
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	return nil
}

// Convert_v1alpha3_DeviceRequestAllocationResult_To_resource_DeviceRequestAllocationResult is an autogenerated conversion function.
func Convert_v1alpha3_DeviceRequestAllocationResult_To_resource_DeviceRequestAllocationResult(in *resourcev1alpha3.DeviceRequestAllocationResult, out *resource.DeviceRequestAllocationResult, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceRequestAllocationResult_To_resource_DeviceRequestAllocationResult(in, out, s)
}

func autoConvert_resource_DeviceRequestAllocationResult_To_v1alpha3_DeviceRequestAllocationResult(in *resource.DeviceRequestAllocationResult, out *resourcev1alpha3.DeviceRequestAllocationResult, s conversion.Scope) error {
	out.Request = in.Request
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	return nil
}

// Convert_resource_DeviceRequestAllocationResult_To_v1alpha3_DeviceRequestAllocationResult is an autogenerated conversion function.
func Convert_resource_DeviceRequestAllocationResult_To_v1alpha3_DeviceRequestAllocationResult(in *resource.DeviceRequestAllocationResult, out *resourcev1alpha3.DeviceRequestAllocationResult, s conversion.Scope) error {
	return autoConvert_resource_DeviceRequestAllocationResult_To_v1alpha3_DeviceRequestAllocationResult(in, out, s)
}

func autoConvert_v1alpha3_DeviceSelector_To_resource_DeviceSelector(in *resourcev1alpha3.DeviceSelector, out *resource.DeviceSelector, s conversion.Scope) error {
	out.CEL = (*resource.CELDeviceSelector)(unsafe.Pointer(in.CEL))
	return nil
}

// Convert_v1alpha3_DeviceSelector_To_resource_DeviceSelector is an autogenerated conversion function.
func Convert_v1alpha3_DeviceSelector_To_resource_DeviceSelector(in *resourcev1alpha3.DeviceSelector, out *resource.DeviceSelector, s conversion.Scope) error {
	return autoConvert_v1alpha3_DeviceSelector_To_resource_DeviceSelector(in, out, s)
}

func autoConvert_resource_DeviceSelector_To_v1alpha3_DeviceSelector(in *resource.DeviceSelector, out *resourcev1alpha3.DeviceSelector, s conversion.Scope) error {
	out.CEL = (*resourcev1alpha3.CELDeviceSelector)(unsafe.Pointer(in.CEL))
	return nil
}

// Convert_resource_DeviceSelector_To_v1alpha3_DeviceSelector is an autogenerated conversion function.
func Convert_resource_DeviceSelector_To_v1alpha3_DeviceSelector(in *resource.DeviceSelector, out *resourcev1alpha3.DeviceSelector, s conversion.Scope) error {
	return autoConvert_resource_DeviceSelector_To_v1alpha3_DeviceSelector(in, out, s)
}

func autoConvert_v1alpha3_NetworkDeviceData_To_resource_NetworkDeviceData(in *resourcev1alpha3.NetworkDeviceData, out *resource.NetworkDeviceData, s conversion.Scope) error {
	out.InterfaceName = in.InterfaceName
	out.IPs = *(*[]string)(unsafe.Pointer(&in.IPs))
	out.HardwareAddress = in.HardwareAddress
	return nil
}

// Convert_v1alpha3_NetworkDeviceData_To_resource_NetworkDeviceData is an autogenerated conversion function.
func Convert_v1alpha3_NetworkDeviceData_To_resource_NetworkDeviceData(in *resourcev1alpha3.NetworkDeviceData, out *resource.NetworkDeviceData, s conversion.Scope) error {
	return autoConvert_v1alpha3_NetworkDeviceData_To_resource_NetworkDeviceData(in, out, s)
}

func autoConvert_resource_NetworkDeviceData_To_v1alpha3_NetworkDeviceData(in *resource.NetworkDeviceData, out *resourcev1alpha3.NetworkDeviceData, s conversion.Scope) error {
	out.InterfaceName = in.InterfaceName
	out.IPs = *(*[]string)(unsafe.Pointer(&in.IPs))
	out.HardwareAddress = in.HardwareAddress
	return nil
}

// Convert_resource_NetworkDeviceData_To_v1alpha3_NetworkDeviceData is an autogenerated conversion function.
func Convert_resource_NetworkDeviceData_To_v1alpha3_NetworkDeviceData(in *resource.NetworkDeviceData, out *resourcev1alpha3.NetworkDeviceData, s conversion.Scope) error {
	return autoConvert_resource_NetworkDeviceData_To_v1alpha3_NetworkDeviceData(in, out, s)
}

func autoConvert_v1alpha3_OpaqueDeviceConfiguration_To_resource_OpaqueDeviceConfiguration(in *resourcev1alpha3.OpaqueDeviceConfiguration, out *resource.OpaqueDeviceConfiguration, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Parameters = in.Parameters
	return nil
}

// Convert_v1alpha3_OpaqueDeviceConfiguration_To_resource_OpaqueDeviceConfiguration is an autogenerated conversion function.
func Convert_v1alpha3_OpaqueDeviceConfiguration_To_resource_OpaqueDeviceConfiguration(in *resourcev1alpha3.OpaqueDeviceConfiguration, out *resource.OpaqueDeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpaqueDeviceConfiguration_To_resource_OpaqueDeviceConfiguration(in, out, s)
}

func autoConvert_resource_OpaqueDeviceConfiguration_To_v1alpha3_OpaqueDeviceConfiguration(in *resource.OpaqueDeviceConfiguration, out *resourcev1alpha3.OpaqueDeviceConfiguration, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Parameters = in.Parameters
	return nil
}

// Convert_resource_OpaqueDeviceConfiguration_To_v1alpha3_OpaqueDeviceConfiguration is an autogenerated conversion function.
func Convert_resource_OpaqueDeviceConfiguration_To_v1alpha3_OpaqueDeviceConfiguration(in *resource.OpaqueDeviceConfiguration, out *resourcev1alpha3.OpaqueDeviceConfiguration, s conversion.Scope) error {
	return autoConvert_resource_OpaqueDeviceConfiguration_To_v1alpha3_OpaqueDeviceConfiguration(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaim_To_resource_ResourceClaim(in *resourcev1alpha3.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ResourceClaim_To_resource_ResourceClaim is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaim_To_resource_ResourceClaim(in *resourcev1alpha3.ResourceClaim, out *resource.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaim_To_resource_ResourceClaim(in, out, s)
}

func autoConvert_resource_ResourceClaim_To_v1alpha3_ResourceClaim(in *resource.ResourceClaim, out *resourcev1alpha3.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaim_To_v1alpha3_ResourceClaim is an autogenerated conversion function.
func Convert_resource_ResourceClaim_To_v1alpha3_ResourceClaim(in *resource.ResourceClaim, out *resourcev1alpha3.ResourceClaim, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaim_To_v1alpha3_ResourceClaim(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *resourcev1alpha3.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1alpha3_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in *resourcev1alpha3.ResourceClaimConsumerReference, out *resource.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimConsumerReference_To_resource_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha3_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *resourcev1alpha3.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_resource_ResourceClaimConsumerReference_To_v1alpha3_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_resource_ResourceClaimConsumerReference_To_v1alpha3_ResourceClaimConsumerReference(in *resource.ResourceClaimConsumerReference, out *resourcev1alpha3.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimConsumerReference_To_v1alpha3_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimList_To_resource_ResourceClaimList(in *resourcev1alpha3.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha3_ResourceClaimList_To_resource_ResourceClaimList is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimList_To_resource_ResourceClaimList(in *resourcev1alpha3.ResourceClaimList, out *resource.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimList_To_resource_ResourceClaimList(in, out, s)
}

func autoConvert_resource_ResourceClaimList_To_v1alpha3_ResourceClaimList(in *resource.ResourceClaimList, out *resourcev1alpha3.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1alpha3.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimList_To_v1alpha3_ResourceClaimList is an autogenerated conversion function.
func Convert_resource_ResourceClaimList_To_v1alpha3_ResourceClaimList(in *resource.ResourceClaimList, out *resourcev1alpha3.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimList_To_v1alpha3_ResourceClaimList(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *resourcev1alpha3.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_DeviceClaim_To_resource_DeviceClaim(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(in *resourcev1alpha3.ResourceClaimSpec, out *resource.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *resourcev1alpha3.ResourceClaimSpec, s conversion.Scope) error {
	if err := Convert_resource_DeviceClaim_To_v1alpha3_DeviceClaim(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(in *resource.ResourceClaimSpec, out *resourcev1alpha3.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *resourcev1alpha3.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	out.Allocation = (*resource.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]resource.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.Devices = *(*[]resource.AllocatedDeviceStatus)(unsafe.Pointer(&in.Devices))
	return nil
}

// Convert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus(in *resourcev1alpha3.ResourceClaimStatus, out *resource.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimStatus_To_resource_ResourceClaimStatus(in, out, s)
}

func autoConvert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *resourcev1alpha3.ResourceClaimStatus, s conversion.Scope) error {
	out.Allocation = (*resourcev1alpha3.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]resourcev1alpha3.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.Devices = *(*[]resourcev1alpha3.AllocatedDeviceStatus)(unsafe.Pointer(&in.Devices))
	return nil
}

// Convert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus is an autogenerated conversion function.
func Convert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus(in *resource.ResourceClaimStatus, out *resourcev1alpha3.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimStatus_To_v1alpha3_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *resourcev1alpha3.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ResourceClaimTemplate_To_resource_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in *resourcev1alpha3.ResourceClaimTemplate, out *resource.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimTemplate_To_resource_ResourceClaimTemplate(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplate_To_v1alpha3_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *resourcev1alpha3.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplate_To_v1alpha3_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplate_To_v1alpha3_ResourceClaimTemplate(in *resource.ResourceClaimTemplate, out *resourcev1alpha3.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplate_To_v1alpha3_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *resourcev1alpha3.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resource.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha3_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in *resourcev1alpha3.ResourceClaimTemplateList, out *resource.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimTemplateList_To_resource_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateList_To_v1alpha3_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *resourcev1alpha3.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1alpha3.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_resource_ResourceClaimTemplateList_To_v1alpha3_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateList_To_v1alpha3_ResourceClaimTemplateList(in *resource.ResourceClaimTemplateList, out *resourcev1alpha3.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateList_To_v1alpha3_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *resourcev1alpha3.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_ResourceClaimSpec_To_resource_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in *resourcev1alpha3.ResourceClaimTemplateSpec, out *resource.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceClaimTemplateSpec_To_resource_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *resourcev1alpha3.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceClaimSpec_To_v1alpha3_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec(in *resource.ResourceClaimTemplateSpec, out *resourcev1alpha3.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceClaimTemplateSpec_To_v1alpha3_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1alpha3_ResourcePool_To_resource_ResourcePool(in *resourcev1alpha3.ResourcePool, out *resource.ResourcePool, s conversion.Scope) error {
	out.Name = in.Name
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_v1alpha3_ResourcePool_To_resource_ResourcePool is an autogenerated conversion function.
func Convert_v1alpha3_ResourcePool_To_resource_ResourcePool(in *resourcev1alpha3.ResourcePool, out *resource.ResourcePool, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourcePool_To_resource_ResourcePool(in, out, s)
}

func autoConvert_resource_ResourcePool_To_v1alpha3_ResourcePool(in *resource.ResourcePool, out *resourcev1alpha3.ResourcePool, s conversion.Scope) error {
	out.Name = in.Name
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_resource_ResourcePool_To_v1alpha3_ResourcePool is an autogenerated conversion function.
func Convert_resource_ResourcePool_To_v1alpha3_ResourcePool(in *resource.ResourcePool, out *resourcev1alpha3.ResourcePool, s conversion.Scope) error {
	return autoConvert_resource_ResourcePool_To_v1alpha3_ResourcePool(in, out, s)
}

func autoConvert_v1alpha3_ResourceSlice_To_resource_ResourceSlice(in *resourcev1alpha3.ResourceSlice, out *resource.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ResourceSlice_To_resource_ResourceSlice is an autogenerated conversion function.
func Convert_v1alpha3_ResourceSlice_To_resource_ResourceSlice(in *resourcev1alpha3.ResourceSlice, out *resource.ResourceSlice, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceSlice_To_resource_ResourceSlice(in, out, s)
}

func autoConvert_resource_ResourceSlice_To_v1alpha3_ResourceSlice(in *resource.ResourceSlice, out *resourcev1alpha3.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_resource_ResourceSlice_To_v1alpha3_ResourceSlice is an autogenerated conversion function.
func Convert_resource_ResourceSlice_To_v1alpha3_ResourceSlice(in *resource.ResourceSlice, out *resourcev1alpha3.ResourceSlice, s conversion.Scope) error {
	return autoConvert_resource_ResourceSlice_To_v1alpha3_ResourceSlice(in, out, s)
}

func autoConvert_v1alpha3_ResourceSliceList_To_resource_ResourceSliceList(in *resourcev1alpha3.ResourceSliceList, out *resource.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]resource.ResourceSlice, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_ResourceSlice_To_resource_ResourceSlice(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_ResourceSliceList_To_resource_ResourceSliceList is an autogenerated conversion function.
func Convert_v1alpha3_ResourceSliceList_To_resource_ResourceSliceList(in *resourcev1alpha3.ResourceSliceList, out *resource.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceSliceList_To_resource_ResourceSliceList(in, out, s)
}

func autoConvert_resource_ResourceSliceList_To_v1alpha3_ResourceSliceList(in *resource.ResourceSliceList, out *resourcev1alpha3.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]resourcev1alpha3.ResourceSlice, len(*in))
		for i := range *in {
			if err := Convert_resource_ResourceSlice_To_v1alpha3_ResourceSlice(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_resource_ResourceSliceList_To_v1alpha3_ResourceSliceList is an autogenerated conversion function.
func Convert_resource_ResourceSliceList_To_v1alpha3_ResourceSliceList(in *resource.ResourceSliceList, out *resourcev1alpha3.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_resource_ResourceSliceList_To_v1alpha3_ResourceSliceList(in, out, s)
}

func autoConvert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec(in *resourcev1alpha3.ResourceSliceSpec, out *resource.ResourceSliceSpec, s conversion.Scope) error {
	out.Driver = in.Driver
	if err := Convert_v1alpha3_ResourcePool_To_resource_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = in.NodeName
	out.NodeSelector = (*core.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = in.AllNodes
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]resource.Device, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Device_To_resource_Device(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Devices = nil
	}
	return nil
}

// Convert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec is an autogenerated conversion function.
func Convert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec(in *resourcev1alpha3.ResourceSliceSpec, out *resource.ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_ResourceSliceSpec_To_resource_ResourceSliceSpec(in, out, s)
}

func autoConvert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec(in *resource.ResourceSliceSpec, out *resourcev1alpha3.ResourceSliceSpec, s conversion.Scope) error {
	out.Driver = in.Driver
	if err := Convert_resource_ResourcePool_To_v1alpha3_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = in.NodeName
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = in.AllNodes
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]resourcev1alpha3.Device, len(*in))
		for i := range *in {
			if err := Convert_resource_Device_To_v1alpha3_Device(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Devices = nil
	}
	return nil
}

// Convert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec is an autogenerated conversion function.
func Convert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec(in *resource.ResourceSliceSpec, out *resourcev1alpha3.ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_resource_ResourceSliceSpec_To_v1alpha3_ResourceSliceSpec(in, out, s)
}
