package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMailAddress invokes the dm.ModifyMailAddress API synchronously
// api document: https://help.aliyun.com/api/dm/modifymailaddress.html
func (client *Client) ModifyMailAddress(request *ModifyMailAddressRequest) (response *ModifyMailAddressResponse, err error) {
	response = CreateModifyMailAddressResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMailAddressWithChan invokes the dm.ModifyMailAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/modifymailaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMailAddressWithChan(request *ModifyMailAddressRequest) (<-chan *ModifyMailAddressResponse, <-chan error) {
	responseChan := make(chan *ModifyMailAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMailAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMailAddressWithCallback invokes the dm.ModifyMailAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/modifymailaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMailAddressWithCallback(request *ModifyMailAddressRequest, callback func(response *ModifyMailAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMailAddressResponse
		var err error
		defer close(result)
		response, err = client.ModifyMailAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMailAddressRequest is the request struct for api ModifyMailAddress
type ModifyMailAddressRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MailAddressId        requests.Integer `position:"Query" name:"MailAddressId"`
	ReplyAddress         string           `position:"Query" name:"ReplyAddress"`
	Password             string           `position:"Query" name:"Password"`
}

// ModifyMailAddressResponse is the response struct for api ModifyMailAddress
type ModifyMailAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMailAddressRequest creates a request to invoke ModifyMailAddress API
func CreateModifyMailAddressRequest() (request *ModifyMailAddressRequest) {
	request = &ModifyMailAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "ModifyMailAddress", "", "")
	return
}

// CreateModifyMailAddressResponse creates a response to parse from ModifyMailAddress response
func CreateModifyMailAddressResponse() (response *ModifyMailAddressResponse) {
	response = &ModifyMailAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
