package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceAutoRenewAttribute invokes the ens.ModifyInstanceAutoRenewAttribute API synchronously
func (client *Client) ModifyInstanceAutoRenewAttribute(request *ModifyInstanceAutoRenewAttributeRequest) (response *ModifyInstanceAutoRenewAttributeResponse, err error) {
	response = CreateModifyInstanceAutoRenewAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceAutoRenewAttributeWithChan invokes the ens.ModifyInstanceAutoRenewAttribute API asynchronously
func (client *Client) ModifyInstanceAutoRenewAttributeWithChan(request *ModifyInstanceAutoRenewAttributeRequest) (<-chan *ModifyInstanceAutoRenewAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceAutoRenewAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceAutoRenewAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceAutoRenewAttributeWithCallback invokes the ens.ModifyInstanceAutoRenewAttribute API asynchronously
func (client *Client) ModifyInstanceAutoRenewAttributeWithCallback(request *ModifyInstanceAutoRenewAttributeRequest, callback func(response *ModifyInstanceAutoRenewAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceAutoRenewAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceAutoRenewAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceAutoRenewAttributeRequest is the request struct for api ModifyInstanceAutoRenewAttribute
type ModifyInstanceAutoRenewAttributeRequest struct {
	*requests.RpcRequest
	Duration      string `position:"Query" name:"Duration"`
	RenewalStatus string `position:"Query" name:"RenewalStatus"`
	OwnerId       string `position:"Query" name:"OwnerId"`
	AutoRenew     string `position:"Query" name:"AutoRenew"`
	InstanceIds   string `position:"Query" name:"InstanceIds"`
}

// ModifyInstanceAutoRenewAttributeResponse is the response struct for api ModifyInstanceAutoRenewAttribute
type ModifyInstanceAutoRenewAttributeResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceAutoRenewAttributeRequest creates a request to invoke ModifyInstanceAutoRenewAttribute API
func CreateModifyInstanceAutoRenewAttributeRequest() (request *ModifyInstanceAutoRenewAttributeRequest) {
	request = &ModifyInstanceAutoRenewAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyInstanceAutoRenewAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceAutoRenewAttributeResponse creates a response to parse from ModifyInstanceAutoRenewAttribute response
func CreateModifyInstanceAutoRenewAttributeResponse() (response *ModifyInstanceAutoRenewAttributeResponse) {
	response = &ModifyInstanceAutoRenewAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
