package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSagStaticRoute invokes the smartag.CreateSagStaticRoute API synchronously
func (client *Client) CreateSagStaticRoute(request *CreateSagStaticRouteRequest) (response *CreateSagStaticRouteResponse, err error) {
	response = CreateCreateSagStaticRouteResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSagStaticRouteWithChan invokes the smartag.CreateSagStaticRoute API asynchronously
func (client *Client) CreateSagStaticRouteWithChan(request *CreateSagStaticRouteRequest) (<-chan *CreateSagStaticRouteResponse, <-chan error) {
	responseChan := make(chan *CreateSagStaticRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSagStaticRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSagStaticRouteWithCallback invokes the smartag.CreateSagStaticRoute API asynchronously
func (client *Client) CreateSagStaticRouteWithCallback(request *CreateSagStaticRouteRequest, callback func(response *CreateSagStaticRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSagStaticRouteResponse
		var err error
		defer close(result)
		response, err = client.CreateSagStaticRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSagStaticRouteRequest is the request struct for api CreateSagStaticRoute
type CreateSagStaticRouteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vlan                 string           `position:"Query" name:"Vlan"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NextHop              string           `position:"Query" name:"NextHop"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	PortName             string           `position:"Query" name:"PortName"`
	DestinationCidr      string           `position:"Query" name:"DestinationCidr"`
}

// CreateSagStaticRouteResponse is the response struct for api CreateSagStaticRoute
type CreateSagStaticRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSagStaticRouteRequest creates a request to invoke CreateSagStaticRoute API
func CreateCreateSagStaticRouteRequest() (request *CreateSagStaticRouteRequest) {
	request = &CreateSagStaticRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateSagStaticRoute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSagStaticRouteResponse creates a response to parse from CreateSagStaticRoute response
func CreateCreateSagStaticRouteResponse() (response *CreateSagStaticRouteResponse) {
	response = &CreateSagStaticRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
