package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVodRealtimeLogDeliveryInfos invokes the vod.ListVodRealtimeLogDeliveryInfos API synchronously
func (client *Client) ListVodRealtimeLogDeliveryInfos(request *ListVodRealtimeLogDeliveryInfosRequest) (response *ListVodRealtimeLogDeliveryInfosResponse, err error) {
	response = CreateListVodRealtimeLogDeliveryInfosResponse()
	err = client.DoAction(request, response)
	return
}

// ListVodRealtimeLogDeliveryInfosWithChan invokes the vod.ListVodRealtimeLogDeliveryInfos API asynchronously
func (client *Client) ListVodRealtimeLogDeliveryInfosWithChan(request *ListVodRealtimeLogDeliveryInfosRequest) (<-chan *ListVodRealtimeLogDeliveryInfosResponse, <-chan error) {
	responseChan := make(chan *ListVodRealtimeLogDeliveryInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVodRealtimeLogDeliveryInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVodRealtimeLogDeliveryInfosWithCallback invokes the vod.ListVodRealtimeLogDeliveryInfos API asynchronously
func (client *Client) ListVodRealtimeLogDeliveryInfosWithCallback(request *ListVodRealtimeLogDeliveryInfosRequest, callback func(response *ListVodRealtimeLogDeliveryInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVodRealtimeLogDeliveryInfosResponse
		var err error
		defer close(result)
		response, err = client.ListVodRealtimeLogDeliveryInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVodRealtimeLogDeliveryInfosRequest is the request struct for api ListVodRealtimeLogDeliveryInfos
type ListVodRealtimeLogDeliveryInfosRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// ListVodRealtimeLogDeliveryInfosResponse is the response struct for api ListVodRealtimeLogDeliveryInfos
type ListVodRealtimeLogDeliveryInfosResponse struct {
	*responses.BaseResponse
	RequestId string                                   `json:"RequestId" xml:"RequestId"`
	Content   ContentInListVodRealtimeLogDeliveryInfos `json:"Content" xml:"Content"`
}

// CreateListVodRealtimeLogDeliveryInfosRequest creates a request to invoke ListVodRealtimeLogDeliveryInfos API
func CreateListVodRealtimeLogDeliveryInfosRequest() (request *ListVodRealtimeLogDeliveryInfosRequest) {
	request = &ListVodRealtimeLogDeliveryInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListVodRealtimeLogDeliveryInfos", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListVodRealtimeLogDeliveryInfosResponse creates a response to parse from ListVodRealtimeLogDeliveryInfos response
func CreateListVodRealtimeLogDeliveryInfosResponse() (response *ListVodRealtimeLogDeliveryInfosResponse) {
	response = &ListVodRealtimeLogDeliveryInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
