/*
Copyright (c) 2022-2024 Rupert Carmichael
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdint.h>
#include <string.h>

#include "geo.h"
#include "geo_memcard.h"

// Pre-formatted 2K Neo Geo Memory Card
static uint8_t mc_formatted[SIZE_2K] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x0a, 0x0a, 0xff,
    0x52, 0x6f, 0x73, 0x79, 0x20, 0x4c, 0x65, 0x65,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x4e, 0x40, 0x45, 0x44, 0x4f, 0x48, 0x2d, 0x4c,
    0x47, 0x50, 0x45, 0x54, 0x4f, 0x58, 0x80, 0x5c,
    0x02, 0x60, 0x00, 0x64, 0x00, 0x68, 0x00, 0x6c,
    0x00, 0x70, 0x00, 0x74, 0x00, 0x78, 0x00, 0x7c,
    0xff, 0x80, 0x00, 0x84, 0xff, 0x88, 0x00, 0x8c,
    0xff, 0x90, 0x00, 0x94, 0xff, 0x98, 0x00, 0x9c,
    0xff, 0xa0, 0x00, 0xa4, 0xff, 0xa8, 0x00, 0xac,
    0xff, 0xb0, 0x00, 0xb4, 0xff, 0xb8, 0x00, 0xbc,
    0xff, 0xc0, 0x00, 0xc4, 0xff, 0xc8, 0x00, 0xcc,
    0xff, 0xd0, 0x00, 0xd4, 0xff, 0xd8, 0x00, 0xdc,
    0xff, 0xe0, 0x00, 0xe4, 0xff, 0xe8, 0x00, 0xec,
    0xff, 0xf0, 0x00, 0xf4, 0xff, 0xf8, 0x00, 0xfc,
    0xff, 0x00, 0x01, 0x04, 0xff, 0x08, 0x01, 0x0c,
    0xff, 0x10, 0x01, 0x14, 0xff, 0x18, 0x01, 0x1c,
    0xff, 0x20, 0x01, 0x24, 0xff, 0x28, 0x01, 0x2c,
    0xff, 0x30, 0x01, 0x34, 0xff, 0x38, 0x01, 0x3c,
    0xff, 0x40, 0x01, 0x44, 0xff, 0x48, 0x01, 0x4c,
    0xff, 0x50, 0x01, 0x54, 0xff, 0x58, 0x01, 0x5c,
    0xff, 0x60, 0x01, 0x64, 0xff, 0x68, 0x01, 0x6c,
    0xff, 0x70, 0x01, 0x74, 0xff, 0x78, 0x01, 0x7c,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x80, 0x02, 0x84, 0x02, 0x88, 0x02, 0x8c,
    0x02, 0x90, 0x02, 0x94, 0x02, 0x98, 0x02, 0x9c,
    0x02, 0xa0, 0x02, 0xa4, 0x02, 0xa8, 0x02, 0xac,
    0x02, 0xb0, 0x02, 0xb4, 0x02, 0xb8, 0x02, 0xbc,
    0x02, 0xc0, 0x02, 0xc4, 0x02, 0xc8, 0x02, 0xcc,
    0x02, 0xd0, 0x02, 0xd4, 0x02, 0xd8, 0x02, 0xdc,
    0x02, 0xe0, 0x02, 0xe4, 0x02, 0xe8, 0x02, 0xec,
    0x02, 0xf0, 0x02, 0xf4, 0x02, 0xf8, 0x02, 0xfc,
    0x03, 0x00, 0x03, 0x04, 0x03, 0x08, 0x03, 0x0c,
    0x03, 0x10, 0x03, 0x14, 0x03, 0x18, 0x03, 0x1c,
    0x03, 0x20, 0x03, 0x24, 0x03, 0x28, 0x03, 0x2c,
    0x03, 0x30, 0x03, 0x34, 0x03, 0x38, 0x03, 0x3c,
    0x03, 0x40, 0x03, 0x44, 0x03, 0x48, 0x03, 0x4c,
    0x03, 0x50, 0x03, 0x54, 0x03, 0x58, 0x03, 0x5c,
    0x03, 0x60, 0x03, 0x64, 0x03, 0x68, 0x03, 0x6c,
    0x03, 0x70, 0x03, 0x74, 0x03, 0x78, 0x03, 0x7c,
    0x03, 0x80, 0x03, 0x84, 0x03, 0x88, 0x03, 0x8c,
    0x03, 0x90, 0x03, 0x94, 0x03, 0x98, 0x03, 0x9c,
    0x03, 0xa0, 0x03, 0xa4, 0x03, 0xa8, 0x03, 0xac,
    0x03, 0xb0, 0x03, 0xb4, 0x03, 0xb8, 0x03, 0xbc,
    0x03, 0xc0, 0x03, 0xc4, 0x03, 0xc8, 0x03, 0xcc,
    0x03, 0xd0, 0x03, 0xd4, 0x03, 0xd8, 0x03, 0xdc,
    0x03, 0xe0, 0x03, 0xe4, 0x03, 0xe8, 0x03, 0xec,
    0x03, 0xf0, 0x03, 0xf4, 0x03, 0xf8, 0x03, 0xfc,
    0x04, 0x00, 0x04, 0x04, 0x04, 0x08, 0x04, 0x0c,
    0x04, 0x10, 0x04, 0x14, 0x04, 0x18, 0x04, 0x1c,
    0x04, 0x20, 0x04, 0x24, 0x04, 0x28, 0x04, 0x2c,
    0x04, 0x30, 0x04, 0x34, 0x04, 0x38, 0x04, 0x3c,
    0x04, 0x40, 0x04, 0x44, 0x04, 0x48, 0x04, 0x4c,
    0x04, 0x50, 0x04, 0x54, 0x04, 0x58, 0x04, 0x5c,
    0x04, 0x60, 0x04, 0x64, 0x04, 0x68, 0x04, 0x6c,
    0x04, 0x70, 0x04, 0x74, 0x04, 0x78, 0x04, 0x7c,
    0x04, 0x80, 0x04, 0x84, 0x04, 0x88, 0x04, 0x8c,
    0x04, 0x90, 0x04, 0x94, 0x04, 0x98, 0x04, 0x9c,
    0x04, 0xa0, 0x04, 0xa4, 0x04, 0xa8, 0x04, 0xac,
    0x04, 0xb0, 0x04, 0xb4, 0x04, 0xb8, 0x04, 0xbc,
    0x04, 0xc0, 0x04, 0xc4, 0x04, 0xc8, 0x04, 0xcc,
    0x04, 0xd0, 0x04, 0xd4, 0x04, 0xd8, 0x04, 0xdc,
    0x04, 0xe0, 0x04, 0xe4, 0x04, 0xe8, 0x04, 0xec,
    0x04, 0xf0, 0x04, 0xf4, 0x04, 0xf8, 0x04, 0xfc,
    0x05, 0x00, 0x05, 0x04, 0x05, 0x08, 0x05, 0x0c,
    0x05, 0x10, 0x05, 0x14, 0x05, 0x18, 0x05, 0x1c,
    0x05, 0x20, 0x05, 0x24, 0x05, 0x28, 0x05, 0x2c,
    0x05, 0x30, 0x05, 0x34, 0x05, 0x38, 0x05, 0x3c,
    0x05, 0x40, 0x05, 0x44, 0x05, 0x48, 0x05, 0x4c,
    0x05, 0x50, 0x05, 0x54, 0x05, 0x58, 0x05, 0x5c,
    0x05, 0x60, 0x05, 0x64, 0x05, 0x68, 0x05, 0x6c,
    0x05, 0x70, 0x05, 0x74, 0x05, 0x78, 0x05, 0x7c,
    0x05, 0x80, 0x05, 0x84, 0x05, 0x88, 0x05, 0x8c,
    0x05, 0x90, 0x05, 0x94, 0x05, 0x98, 0x05, 0x9c,
    0x05, 0xa0, 0x05, 0xa4, 0x05, 0xa8, 0x05, 0xac,
    0x05, 0xb0, 0x05, 0xb4, 0x05, 0xb8, 0x05, 0xbc,
    0x05, 0xc0, 0x05, 0xc4, 0x05, 0xc8, 0x05, 0xcc,
    0x05, 0xd0, 0x05, 0xd4, 0x05, 0xd8, 0x05, 0xdc,
    0x05, 0xe0, 0x05, 0xe4, 0x05, 0xe8, 0x05, 0xec,
    0x05, 0xf0, 0x05, 0xf4, 0x05, 0xf8, 0x05, 0xfc,
    0x06, 0x00, 0x06, 0x04, 0x06, 0x08, 0x06, 0x0c,
    0x06, 0x10, 0x06, 0x14, 0x06, 0x18, 0x06, 0x1c,
    0x06, 0x20, 0x06, 0x24, 0x06, 0x28, 0x06, 0x2c,
    0x06, 0x30, 0x06, 0x34, 0x06, 0x38, 0x06, 0x3c,
    0x06, 0x40, 0x06, 0x44, 0x06, 0x48, 0x06, 0x4c,
    0x06, 0x50, 0x06, 0x54, 0x06, 0x58, 0x06, 0x5c,
    0x06, 0x60, 0x06, 0x64, 0x06, 0x68, 0x06, 0x6c,
    0x06, 0x70, 0x06, 0x74, 0x06, 0x78, 0x06, 0x7c,
    0x06, 0x80, 0x06, 0x84, 0x06, 0x88, 0x06, 0x8c,
    0x06, 0x90, 0x06, 0x94, 0x06, 0x98, 0x06, 0x9c,
    0x06, 0xa0, 0x06, 0xa4, 0x06, 0xa8, 0x06, 0xac,
    0x06, 0xb0, 0x06, 0xb4, 0x06, 0xb8, 0x06, 0xbc,
    0x06, 0xc0, 0x06, 0xc4, 0x06, 0xc8, 0x06, 0xcc,
    0x06, 0xd0, 0x06, 0xd4, 0x06, 0xd8, 0x06, 0xdc,
    0x06, 0xe0, 0x06, 0xe4, 0x06, 0xe8, 0x06, 0xec,
    0x06, 0xf0, 0x06, 0xf4, 0x06, 0xf8, 0x06, 0xfc,
    0x07, 0x00, 0x07, 0x04, 0x07, 0x08, 0x07, 0x0c,
    0x07, 0x10, 0x07, 0x14, 0x07, 0x18, 0x07, 0x1c,
    0x07, 0x20, 0x07, 0x24, 0x07, 0x28, 0x07, 0x2c,
    0x07, 0x30, 0x07, 0x34, 0x07, 0x38, 0x07, 0x3c,
    0x07, 0x40, 0x07, 0x44, 0x07, 0x48, 0x07, 0x4c,
    0x07, 0x50, 0x07, 0x54, 0x07, 0x58, 0x07, 0x5c,
    0x07, 0x60, 0x07, 0x64, 0x07, 0x68, 0x07, 0x6c,
    0x07, 0x70, 0x07, 0x74, 0x07, 0x78, 0x07, 0x7c,
    0x07, 0x80, 0x07, 0x84, 0x07, 0x88, 0x07, 0x8c,
    0x07, 0x90, 0x07, 0x94, 0x07, 0x98, 0x07, 0x9c,
    0x07, 0xa0, 0x07, 0xa4, 0x07, 0xa8, 0x07, 0xac,
    0x07, 0xb0, 0x07, 0xb4, 0x07, 0xb8, 0x07, 0xbc,
    0x07, 0xc0, 0x07, 0xc4, 0x07, 0xc8, 0x07, 0xcc,
    0x07, 0xd0, 0x07, 0xd4, 0x07, 0xd8, 0x07, 0xdc,
    0x07, 0xe0, 0x07, 0xe4, 0x07, 0xe8, 0x07, 0xec,
    0x07, 0xf0, 0x07, 0xf4, 0x07, 0xf8, 0x07, 0xfc,
    0x08, 0x00, 0x08, 0x04, 0x08, 0x08, 0x08, 0x0c,
    0x08, 0x10, 0x08, 0x14, 0x08, 0x18, 0x08, 0x1c,
    0x08, 0x20, 0x08, 0x24, 0x08, 0x28, 0x08, 0x2c,
    0x08, 0x30, 0x08, 0x34, 0x08, 0x38, 0x08, 0x3c,
    0x08, 0x40, 0x08, 0x44, 0x08, 0x48, 0x08, 0x4c,
    0x08, 0x50, 0x08, 0x54, 0x08, 0x58, 0x08, 0x5c,
    0x08, 0x60, 0x08, 0x64, 0x08, 0x68, 0x08, 0x6c,
    0x08, 0x70, 0x08, 0x74, 0x08, 0x78, 0x08, 0x7c,
    0x08, 0x80, 0x08, 0x84, 0x08, 0x88, 0x08, 0x8c,
    0x08, 0x90, 0x08, 0x94, 0x08, 0x98, 0x08, 0x9c,
    0x08, 0xa0, 0x08, 0xa4, 0x08, 0xa8, 0x08, 0xac,
    0x08, 0xb0, 0x08, 0xb4, 0x08, 0xb8, 0x08, 0xbc,
    0x08, 0xc0, 0x08, 0xc4, 0x08, 0xc8, 0x08, 0xcc,
    0x08, 0xd0, 0x08, 0xd4, 0x08, 0xd8, 0x08, 0xdc,
    0x08, 0xe0, 0x08, 0xe4, 0x08, 0xe8, 0x08, 0xec,
    0x08, 0xf0, 0x08, 0xf4, 0x08, 0xf8, 0x08, 0xfc,
    0x09, 0x00, 0x09, 0x04, 0x09, 0x08, 0x09, 0x0c,
    0x09, 0x10, 0x09, 0x14, 0x09, 0x18, 0x09, 0x1c,
    0x09, 0x20, 0x09, 0x24, 0x09, 0x28, 0x09, 0x2c,
    0x09, 0x30, 0x09, 0x34, 0x09, 0x38, 0x09, 0x3c,
    0x09, 0x40, 0x09, 0x44, 0x09, 0x48, 0x09, 0x4c,
    0x09, 0x50, 0x09, 0x54, 0x09, 0x58, 0x09, 0x5c,
    0x09, 0x60, 0x09, 0x64, 0x09, 0x68, 0x09, 0x6c,
    0x09, 0x70, 0x09, 0x74, 0x09, 0x78, 0x09, 0x7c,
    0x09, 0x80, 0x09, 0x84, 0x09, 0x88, 0x09, 0x8c,
    0x09, 0x90, 0x09, 0x94, 0x09, 0x98, 0x09, 0x9c,
    0x09, 0xa0, 0x09, 0xa4, 0x09, 0xa8, 0x09, 0xac,
    0x09, 0xb0, 0x09, 0xb4, 0x09, 0xb8, 0x09, 0xbc,
    0x09, 0xc0, 0x09, 0xc4, 0x09, 0xc8, 0x09, 0xcc,
    0x09, 0xd0, 0x09, 0xd4, 0x09, 0xd8, 0x09, 0xdc,
    0x09, 0xe0, 0x09, 0xe4, 0x09, 0xe8, 0x09, 0xec,
    0x09, 0xf0, 0x09, 0xf4, 0x09, 0xf8, 0x09, 0xfc,
    0x0a, 0x00, 0x0a, 0x04, 0x0a, 0x08, 0x0a, 0x0c,
    0x0a, 0x10, 0x0a, 0x14, 0x0a, 0x18, 0x0a, 0x1c,
    0x0a, 0x20, 0x0a, 0x24, 0x0a, 0x28, 0x0a, 0x2c,
    0x0a, 0x30, 0x0a, 0x34, 0x0a, 0x38, 0x0a, 0x3c,
    0x0a, 0x40, 0x0a, 0x44, 0x0a, 0x48, 0x0a, 0x4c,
    0x0a, 0x50, 0x0a, 0x54, 0x0a, 0x58, 0x0a, 0x5c,
    0x0a, 0x60, 0x0a, 0x64, 0x0a, 0x68, 0x0a, 0x6c,
    0x0a, 0x70, 0x0a, 0x74, 0x0a, 0x78, 0x0a, 0x7c,
    0x0a, 0x80, 0x0a, 0x84, 0x0a, 0x88, 0x0a, 0x8c,
    0x0a, 0x90, 0x0a, 0x94, 0x0a, 0x98, 0x0a, 0x9c,
    0x0a, 0xa0, 0x0a, 0xa4, 0x0a, 0xa8, 0x0a, 0xac,
    0x0a, 0xb0, 0x0a, 0xb4, 0x0a, 0xb8, 0x0a, 0xbc,
    0x0a, 0xc0, 0x0a, 0xc4, 0x0a, 0xc8, 0x0a, 0xcc,
    0x0a, 0xd0, 0x0a, 0xd4, 0x0a, 0xd8, 0x0a, 0xdc,
    0x0a, 0xe0, 0x0a, 0xe4, 0x0a, 0xe8, 0x0a, 0xec,
    0x0a, 0xf0, 0x0a, 0xf4, 0x0a, 0xf8, 0x0a, 0xfc,
    0x0b, 0x00, 0x0b, 0x04, 0x0b, 0x08, 0x0b, 0x0c,
    0x0b, 0x10, 0x0b, 0x14, 0x0b, 0x18, 0x0b, 0x1c,
    0x0b, 0x20, 0x0b, 0x24, 0x0b, 0x28, 0x0b, 0x2c,
    0x0b, 0x30, 0x0b, 0x34, 0x0b, 0x38, 0x0b, 0x3c,
    0x0b, 0x40, 0x0b, 0x44, 0x0b, 0x48, 0x0b, 0x4c,
    0x0b, 0x50, 0x0b, 0x54, 0x0b, 0x58, 0x0b, 0x5c,
    0x0b, 0x60, 0x0b, 0x64, 0x0b, 0x68, 0x0b, 0x6c,
    0x0b, 0x70, 0x0b, 0x74, 0x0b, 0x78, 0x0b, 0x7c,
    0x0b, 0x80, 0x0b, 0x84, 0x0b, 0x88, 0x0b, 0x8c,
    0x0b, 0x90, 0x0b, 0x94, 0x0b, 0x98, 0x0b, 0x9c,
    0x0b, 0xa0, 0x0b, 0xa4, 0x0b, 0xa8, 0x0b, 0xac,
    0x0b, 0xb0, 0x0b, 0xb4, 0x0b, 0xb8, 0x0b, 0xbc,
    0x0b, 0xc0, 0x0b, 0xc4, 0x0b, 0xc8, 0x0b, 0xcc,
    0x0b, 0xd0, 0x0b, 0xd4, 0x0b, 0xd8, 0x0b, 0xdc,
    0x0b, 0xe0, 0x0b, 0xe4, 0x0b, 0xe8, 0x0b, 0xec,
    0x0b, 0xf0, 0x0b, 0xf4, 0x0b, 0xf8, 0x0b, 0xfc,
    0x0c, 0x00, 0x0c, 0x04, 0x0c, 0x08, 0x0c, 0x0c,
    0x0c, 0x10, 0x0c, 0x14, 0x0c, 0x18, 0x0c, 0x1c,
    0x0c, 0x20, 0x0c, 0x24, 0x0c, 0x28, 0x0c, 0x2c,
    0x0c, 0x30, 0x0c, 0x34, 0x0c, 0x38, 0x0c, 0x3c,
    0x0c, 0x40, 0x0c, 0x44, 0x0c, 0x48, 0x0c, 0x4c,
    0x0c, 0x50, 0x0c, 0x54, 0x0c, 0x58, 0x0c, 0x5c,
    0x0c, 0x60, 0x0c, 0x64, 0x0c, 0x68, 0x0c, 0x6c,
    0x0c, 0x70, 0x0c, 0x74, 0x0c, 0x78, 0x0c, 0x7c,
    0x0c, 0x80, 0x0c, 0x84, 0x0c, 0x88, 0x0c, 0x8c,
    0x0c, 0x90, 0x0c, 0x94, 0x0c, 0x98, 0x0c, 0x9c,
    0x0c, 0xa0, 0x0c, 0xa4, 0x0c, 0xa8, 0x0c, 0xac,
    0x0c, 0xb0, 0x0c, 0xb4, 0x0c, 0xb8, 0x0c, 0xbc,
    0x0c, 0xc0, 0x0c, 0xc4, 0x0c, 0xc8, 0x0c, 0xcc,
    0x0c, 0xd0, 0x0c, 0xd4, 0x0c, 0xd8, 0x0c, 0xdc,
    0x0c, 0xe0, 0x0c, 0xe4, 0x0c, 0xe8, 0x0c, 0xec,
    0x0c, 0xf0, 0x0c, 0xf4, 0x0c, 0xf8, 0x0c, 0xfc,
    0x0d, 0x00, 0x0d, 0x04, 0x0d, 0x08, 0x0d, 0x0c,
    0x0d, 0x10, 0x0d, 0x14, 0x0d, 0x18, 0x0d, 0x1c,
    0x0d, 0x20, 0x0d, 0x24, 0x0d, 0x28, 0x0d, 0x2c,
    0x0d, 0x30, 0x0d, 0x34, 0x0d, 0x38, 0x0d, 0x3c,
    0x0d, 0x40, 0x0d, 0x44, 0x0d, 0x48, 0x0d, 0x4c,
    0x0d, 0x50, 0x0d, 0x54, 0x0d, 0x58, 0x0d, 0x5c,
    0x0d, 0x60, 0x0d, 0x64, 0x0d, 0x68, 0x0d, 0x6c,
    0x0d, 0x70, 0x0d, 0x74, 0x0d, 0x78, 0x0d, 0x7c,
    0x0d, 0x80, 0x0d, 0x84, 0x0d, 0x88, 0x0d, 0x8c,
    0x0d, 0x90, 0x0d, 0x94, 0x0d, 0x98, 0x0d, 0x9c,
    0x0d, 0xa0, 0x0d, 0xa4, 0x0d, 0xa8, 0x0d, 0xac,
    0x0d, 0xb0, 0x0d, 0xb4, 0x0d, 0xb8, 0x0d, 0xbc,
    0x0d, 0xc0, 0x0d, 0xc4, 0x0d, 0xc8, 0x0d, 0xcc,
    0x0d, 0xd0, 0x0d, 0xd4, 0x0d, 0xd8, 0x0d, 0xdc,
    0x0d, 0xe0, 0x0d, 0xe4, 0x0d, 0xe8, 0x0d, 0xec,
    0x0d, 0xf0, 0x0d, 0xf4, 0x0d, 0xf8, 0x0d, 0xfc,
    0x0e, 0x00, 0x0e, 0x04, 0x0e, 0x08, 0x0e, 0x0c,
    0x0e, 0x10, 0x0e, 0x14, 0x0e, 0x18, 0x0e, 0x1c,
    0x0e, 0x20, 0x0e, 0x24, 0x0e, 0x28, 0x0e, 0x2c,
    0x0e, 0x30, 0x0e, 0x34, 0x0e, 0x38, 0x0e, 0x3c,
    0x0e, 0x40, 0x0e, 0x44, 0x0e, 0x48, 0x0e, 0x4c,
    0x0e, 0x50, 0x0e, 0x54, 0x0e, 0x58, 0x0e, 0x5c,
    0x0e, 0x60, 0x0e, 0x64, 0x0e, 0x68, 0x0e, 0x6c,
    0x0e, 0x70, 0x0e, 0x74, 0x0e, 0x78, 0x0e, 0x7c,
    0x0e, 0x80, 0x0e, 0x84, 0x0e, 0x88, 0x0e, 0x8c,
    0x0e, 0x90, 0x0e, 0x94, 0x0e, 0x98, 0x0e, 0x9c,
    0x0e, 0xa0, 0x0e, 0xa4, 0x0e, 0xa8, 0x0e, 0xac,
    0x0e, 0xb0, 0x0e, 0xb4, 0x0e, 0xb8, 0x0e, 0xbc,
    0x0e, 0xc0, 0x0e, 0xc4, 0x0e, 0xc8, 0x0e, 0xcc,
    0x0e, 0xd0, 0x0e, 0xd4, 0x0e, 0xd8, 0x0e, 0xdc,
    0x0e, 0xe0, 0x0e, 0xe4, 0x0e, 0xe8, 0x0e, 0xec,
    0x0e, 0xf0, 0x0e, 0xf4, 0x0e, 0xf8, 0x0e, 0xfc,
    0x0f, 0x00, 0x0f, 0x04, 0x0f, 0x08, 0x0f, 0x0c,
    0x0f, 0x10, 0x0f, 0x14, 0x0f, 0x18, 0x0f, 0x1c,
    0x0f, 0x20, 0x0f, 0x24, 0x0f, 0x28, 0x0f, 0x2c,
    0x0f, 0x30, 0x0f, 0x34, 0x0f, 0x38, 0x0f, 0x3c,
    0x0f, 0x40, 0x0f, 0x44, 0x0f, 0x48, 0x0f, 0x4c,
    0x0f, 0x50, 0x0f, 0x54, 0x0f, 0x58, 0x0f, 0x5c,
    0x0f, 0x60, 0x0f, 0x64, 0x0f, 0x68, 0x0f, 0x6c,
    0x0f, 0x70, 0x0f, 0x74, 0x0f, 0x78, 0x0f, 0x7c,
    0x0f, 0x80, 0x0f, 0x84, 0x0f, 0x88, 0x0f, 0x8c,
    0x0f, 0x90, 0x0f, 0x94, 0x0f, 0x98, 0x0f, 0x9c,
    0x0f, 0xa0, 0x0f, 0xa4, 0x0f, 0xa8, 0x0f, 0xac,
    0x0f, 0xb0, 0x0f, 0xb4, 0x0f, 0xb8, 0x0f, 0xbc,
    0x0f, 0xc0, 0x0f, 0xc4, 0x0f, 0xc8, 0x0f, 0xcc,
    0x0f, 0xd0, 0x0f, 0xd4, 0x0f, 0xd8, 0x0f, 0xdc,
    0x0f, 0xe0, 0x0f, 0xe4, 0x0f, 0xe8, 0x0f, 0xec,
    0x0f, 0xf0, 0x0f, 0xf4, 0x0f, 0xf8, 0x0f, 0xfc
};

// Format a 2K Neo Geo Memory Card
void geo_memcard_format(uint8_t *ptr) {
    memcpy(ptr, mc_formatted, SIZE_2K);
}
