/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public abstract class AbstractChangeTracker<T extends Observable> {
    private final ObservableList<T> source;
    private final ListChangeListener<T> outerListChangeListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(this::safeRemoveListener);
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::safeAddListener);
            }
            this.notifyChange();
        }
    };
    private final WeakListChangeListener<T> weakOuterListChangeListener = new WeakListChangeListener(this.outerListChangeListener);
    protected Consumer<ObservableList<T>> onChanged;

    public AbstractChangeTracker(ObservableList<T> source) {
        this(source, null);
    }

    public AbstractChangeTracker(ObservableList<T> source, Consumer<ObservableList<T>> onChanged) {
        this.source = Objects.requireNonNull(source, "Source list cannot be null");
        this.onChanged = onChanged;
    }

    protected void initOuterListener() {
        this.source.forEach(this::safeAddListener);
        this.source.addListener(this.weakOuterListChangeListener);
    }

    public void setOnChanged(Consumer<ObservableList<T>> onChanged) {
        this.onChanged = onChanged;
    }

    protected void notifyChange() {
        if (this.onChanged != null) {
            this.onChanged.accept(this.source);
        }
    }

    protected abstract void safeAddListener(T var1);

    protected abstract void safeRemoveListener(T var1);

    public void dispose() {
        this.source.forEach(this::safeRemoveListener);
        this.source.removeListener(this.weakOuterListChangeListener);
    }
}

