/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.TypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.logic.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;

public class AnonymousClassDeclarationContext
extends AbstractJavaParserContext<ObjectCreationExpr> {
    private final JavaParserAnonymousClassDeclaration myDeclaration;

    public AnonymousClassDeclarationContext(ObjectCreationExpr node, TypeSolver typeSolver) {
        super(node, typeSolver);
        this.myDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)this.wrappedNode, this.typeSolver);
        Preconditions.checkArgument((boolean)node.getAnonymousClassBody().isPresent(), (Object)"An anonymous class must have a body");
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference<ResolvedMethodDeclaration> res;
        SymbolReference<ResolvedMethodDeclaration> parentSolution;
        List<ResolvedMethodDeclaration> candidateMethods = this.myDeclaration.getDeclaredMethods().stream().filter((Predicate<ResolvedMethodDeclaration> & Serializable)m -> m.getName().equals(name) && (!staticOnly || m.isStatic())).collect(Collectors.toList());
        if (!this.myDeclaration.isJavaLangObject()) {
            for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
                ancestor.getTypeDeclaration().ifPresent((Consumer<ResolvedReferenceTypeDeclaration> & Serializable)ancestorTypeDeclaration -> {
                    SymbolReference<ResolvedMethodDeclaration> res = MethodResolutionLogic.solveMethodInType(ancestorTypeDeclaration, name, argumentsTypes, staticOnly);
                    if (res.isSolved()) {
                        candidateMethods.add(res.getCorrespondingDeclaration());
                    }
                });
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = this.getParent().orElseThrow((Supplier<RuntimeException> & Serializable)() -> new RuntimeException("Parent context unexpectedly empty.")).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add(parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.myDeclaration.getSuperTypeDeclaration().isInterface() && (res = MethodResolutionLogic.solveMethodInType(new ReflectionClassDeclaration(Object.class, this.typeSolver), name, argumentsTypes, false)).isSolved()) {
            candidateMethods.add(res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name, List<ResolvedType> typeArguments) {
        List<TypeDeclaration> typeDeclarations = this.myDeclaration.findMembersOfKind(TypeDeclaration.class);
        Optional exactMatch = typeDeclarations.stream().filter((Predicate<TypeDeclaration> & Serializable)internalType -> internalType.getName().getId().equals(name)).findFirst().map((Function<TypeDeclaration, SymbolReference> & Serializable)internalType -> SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration<?>)internalType)));
        if (exactMatch.isPresent()) {
            return (SymbolReference)exactMatch.get();
        }
        Optional recursiveMatch = typeDeclarations.stream().filter((Predicate<TypeDeclaration> & Serializable)internalType -> name.startsWith(String.format("%s.", internalType.getName()))).findFirst().map((Function<TypeDeclaration, SymbolReference> & Serializable)internalType -> JavaParserFactory.getContext(internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1)));
        if (recursiveMatch.isPresent()) {
            return (SymbolReference)recursiveMatch.get();
        }
        Optional typeArgumentsMatch = ((ObjectCreationExpr)this.wrappedNode).getTypeArguments().map((Function<NodeList, NodeList> & Serializable)nodes -> ((NodeWithTypeArguments)((Object)nodes)).getTypeArguments().orElse(new NodeList())).orElse(new NodeList()).stream().filter((Predicate<Type> & Serializable)type -> type.toString().equals(name)).findFirst().map((Function<Type, SymbolReference> & Serializable)matchingType -> SymbolReference.solved(new JavaParserTypeParameter(new TypeParameter(matchingType.toString()), this.typeSolver)));
        if (typeArgumentsMatch.isPresent()) {
            return (SymbolReference)typeArgumentsMatch.get();
        }
        for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
            Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration = ancestor.getTypeDeclaration();
            if (!optionalTypeDeclaration.isPresent()) continue;
            ResolvedReferenceTypeDeclaration typeDeclaration = optionalTypeDeclaration.get();
            if (typeDeclaration.getName().equals(name)) {
                return SymbolReference.solved(typeDeclaration);
            }
            try {
                for (ResolvedTypeDeclaration resolvedTypeDeclaration : typeDeclaration.internalTypes()) {
                    if (!resolvedTypeDeclaration.getName().equals(name)) continue;
                    return SymbolReference.solved(resolvedTypeDeclaration);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return this.solveTypeInParentContext(name, typeArguments);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        Preconditions.checkArgument((this.typeSolver != null ? 1 : 0) != 0);
        if (this.myDeclaration.hasField(name)) {
            return SymbolReference.solved(this.myDeclaration.getField(name));
        }
        return this.solveSymbolInParentContext(name);
    }
}

