/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.token;

import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.token.Token;

public class DisplayGroupToken
extends Token {
    private final boolean open;
    private final Type type;

    public DisplayGroupToken(boolean open, Type type) {
        this(open, type, 0);
    }

    public DisplayGroupToken(boolean open, Type type, int formattingAttributes) {
        this(open, type, formattingAttributes, false);
    }

    public DisplayGroupToken(boolean open, Type type, int formattingAttributes, boolean firstField) {
        super(formattingAttributes, firstField);
        this.open = open;
        this.type = type;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public DisplayGroupToken copyWithFirstField(boolean firstField) {
        return new DisplayGroupToken(this.isOpen(), this.getType(), this.getFormattingAttributes(), firstField);
    }

    @Override
    public Token wrapFormattingAttributes(int otherFormattingAttributes) {
        int fa = FormattingAttributes.merge(otherFormattingAttributes, this.getFormattingAttributes());
        return new DisplayGroupToken(this.isOpen(), this.getType(), fa, this.isFirstField());
    }

    public static enum Type {
        BLOCK,
        LEFT_MARGIN,
        RIGHT_INLINE,
        INDENT;

    }
}

