/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.spec.ECParameterSpec;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public abstract class ECKey
implements java.security.interfaces.ECKey,
ASN1Object,
Key {
    java.security.interfaces.ECKey a = null;
    AlgorithmIdentifier b = null;
    ASN1Object c = null;

    protected ECKey() {
    }

    protected ECKey(java.security.interfaces.ECKey eCKey) {
        this.a = eCKey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public int getBitLength() {
        if (this.a == null) {
            return 0;
        }
        return this.a.getParams().getCurve().getField().getFieldSize();
    }

    public java.security.interfaces.ECKey getKey() {
        if (this.a == null) {
            return null;
        }
        return this.a;
    }

    @Override
    public ECParameterSpec getParams() {
        if (this.a == null) {
            return null;
        }
        return this.a.getParams();
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.b != null) {
            return this.b;
        }
        return null;
    }

    public ASN1Object getContents() {
        if (this.c != null) {
            return this.c;
        }
        return null;
    }

    @Override
    public abstract Object clone();

    @Override
    public void erase() {
        if (this.a != null) {
            this.a = null;
        }
        if (this.b != null) {
            this.b = null;
        }
        if (this.c != null) {
            this.c = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

