/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.beans.property.DoubleProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class HorizontalHelper
implements OrientationHelper {
    HorizontalHelper() {
    }

    @Override
    public Orientation getContentBias() {
        return Orientation.VERTICAL;
    }

    @Override
    public double getX(double x, double y) {
        return y;
    }

    @Override
    public double getY(double x, double y) {
        return x;
    }

    @Override
    public double minBreadth(Node node) {
        return node.minHeight(-1.0);
    }

    @Override
    public double prefBreadth(Node node) {
        return node.prefHeight(-1.0);
    }

    @Override
    public double prefLength(Node node, double breadth) {
        return node.prefWidth(breadth);
    }

    @Override
    public double breadth(Bounds bounds) {
        return bounds.getHeight();
    }

    @Override
    public double length(Bounds bounds) {
        return bounds.getWidth();
    }

    @Override
    public double minX(Bounds bounds) {
        return bounds.getMinY();
    }

    @Override
    public double minY(Bounds bounds) {
        return bounds.getMinX();
    }

    @Override
    public double layoutX(Node node) {
        return node.getLayoutY();
    }

    @Override
    public double layoutY(Node node) {
        return node.getLayoutX();
    }

    @Override
    public DoubleProperty layoutYProperty(Node node) {
        return node.layoutXProperty();
    }

    @Override
    public void resizeRelocate(Node node, double b0, double l0, double breadth, double length) {
        node.resizeRelocate(l0, b0, length, breadth);
    }

    @Override
    public void resize(Node node, double breadth, double length) {
        node.resize(length, breadth);
    }

    @Override
    public void relocate(Node node, double b0, double l0) {
        node.relocate(l0, b0);
    }

    @Override
    public Val<Double> widthEstimateProperty(VirtualFlow<?, ?> content) {
        return content.totalLengthEstimateProperty();
    }

    @Override
    public Val<Double> heightEstimateProperty(VirtualFlow<?, ?> content) {
        return content.totalBreadthEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollXProperty(VirtualFlow<?, ?> content) {
        return content.lengthOffsetEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty(VirtualFlow<?, ?> content) {
        return content.breadthOffsetProperty();
    }

    @Override
    public void scrollHorizontallyBy(VirtualFlow<?, ?> content, double dx) {
        content.scrollLength(dx);
    }

    @Override
    public void scrollVerticallyBy(VirtualFlow<?, ?> content, double dy) {
        content.scrollBreadth(dy);
    }

    @Override
    public void scrollHorizontallyToPixel(VirtualFlow<?, ?> content, double pixel) {
        content.setLengthOffset(pixel);
    }

    @Override
    public void scrollVerticallyToPixel(VirtualFlow<?, ?> content, double pixel) {
        content.setBreadthOffset(pixel);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitBeforeCells(double bOff, double lOff) {
        return VirtualFlowHit.hitBeforeCells(lOff, bOff);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> hitAfterCells(double bOff, double lOff) {
        return VirtualFlowHit.hitAfterCells(lOff, bOff);
    }

    @Override
    public <C extends Cell<?, ?>> VirtualFlowHit<C> cellHit(int itemIndex, C cell, double bOff, double lOff) {
        return VirtualFlowHit.cellHit(itemIndex, cell, lOff, bOff);
    }
}

