# Copyright 2021-2022 David Robillard <d@drobilla.net>
# SPDX-License-Identifier: 0BSD OR ISC

# Project information

project = "Testlib"
copyright = "2022, David Robillard"
author = "David Robillard"
release = "1.2.3"
version = "1.2.3"

# General configuration

exclude_patterns = ["xml"]
language = "en"
nitpicky = True
pygments_style = "friendly"

try:
    import sphinx_lv2_theme

    have_lv2_theme = True
except ModuleNotFoundError:
    have_lv2_theme = False

# Ignore everything opaque or external for nitpicky mode
_opaque = [
    "TestlibThingieImpl",
    "uint32_t",
]

nitpick_ignore = list(map(lambda x: ("c:identifier", x), _opaque))

# HTML output

html_copy_source = False
html_secnumber_suffix = " "
html_short_title = "Testlib"

if have_lv2_theme:
    html_theme = "sphinx_lv2_theme"

    if tags.has("singlehtml"):
        html_sidebars = {
            "**": [
                "globaltoc.html",
            ]
        }

        html_theme_options = {
            "body_max_width": "48em",
            "body_min_width": "48em",
            "description": "A made-up library for documentation testing",
            "show_footer_version": True,
            "show_logo_version": False,
            "logo_name": True,
            "logo_width": "8em",
            "nosidebar": False,
            "page_width": "80em",
            "sidebar_width": "18em",
            "globaltoc_maxdepth": 3,
            "globaltoc_collapse": False,
        }

    else:
        html_theme_options = {
            "body_max_width": "60em",
            "body_min_width": "40em",
            "description": "A made-up library for documentation testing",
            "show_footer_version": True,
            "show_logo_version": False,
            "logo_name": True,
            "logo_width": "8em",
            "nosidebar": True,
            "page_width": "60em",
            "sidebar_width": "14em",
            "globaltoc_maxdepth": 1,
            "globaltoc_collapse": True,
        }

else:
    html_theme = "alabaster"

    html_theme_options = {
        "body_max_width": "60em",
        "body_min_width": "40em",
        "description": "A made-up library for documentation testing",
        "logo_name": True,
        "page_width": "60em",
        "sidebar_width": "14em",
        "globaltoc_maxdepth": 1,
        "globaltoc_collapse": True,
    }
