import type { DraggableLocation } from 'react-beautiful-dnd';
/**
 * Calculates the actual destination of an item based on its start location
 * and target location.
 *
 * The actual destination may not be the same as the target location.
 * An item moving to a higher index in the same list introduces an
 * off-by-one error that this function accounts for.
 */
export declare function getActualDestination({ start, target, }: {
    /**
     * The start location of the draggable.
     */
    start: DraggableLocation;
    /**
     * Where the drop indicator is being drawn.
     */
    target: DraggableLocation | null;
}): DraggableLocation | null;
