/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.reverse;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class ReverseStringFilter
extends TokenFilter {
    private TermAttribute termAtt;
    private final char marker;
    private static final char NOMARKER = '\uffff';
    public static final char START_OF_HEADING_MARKER = '\u0001';
    public static final char INFORMATION_SEPARATOR_MARKER = '\u001f';
    public static final char PUA_EC00_MARKER = '\uec00';
    public static final char RTL_DIRECTION_MARKER = '\u200f';

    public ReverseStringFilter(TokenStream in) {
        this(in, '\uffff');
    }

    public ReverseStringFilter(TokenStream in, char marker) {
        super(in);
        this.marker = marker;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int len = this.termAtt.termLength();
            if (this.marker != '\uffff') {
                this.termAtt.resizeTermBuffer(++len);
                this.termAtt.termBuffer()[len - 1] = this.marker;
            }
            ReverseStringFilter.reverse(this.termAtt.termBuffer(), len);
            this.termAtt.setTermLength(len);
            return true;
        }
        return false;
    }

    public static String reverse(String input) {
        char[] charInput = input.toCharArray();
        ReverseStringFilter.reverse(charInput);
        return new String(charInput);
    }

    public static void reverse(char[] buffer) {
        ReverseStringFilter.reverse(buffer, buffer.length);
    }

    public static void reverse(char[] buffer, int len) {
        ReverseStringFilter.reverse(buffer, 0, len);
    }

    public static void reverse(char[] buffer, int start, int len) {
        if (len <= 1) {
            return;
        }
        int num = len >> 1;
        for (int i = start; i < start + num; ++i) {
            char c = buffer[i];
            buffer[i] = buffer[start * 2 + len - i - 1];
            buffer[start * 2 + len - i - 1] = c;
        }
    }
}

