/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GreekAnalyzer
extends Analyzer {
    private static final String[] GREEK_STOP_WORDS = new String[]{"\u03bf", "\u03b7", "\u03c4\u03bf", "\u03bf\u03b9", "\u03c4\u03b1", "\u03c4\u03bf\u03c5", "\u03c4\u03b7\u03c3", "\u03c4\u03c9\u03bd", "\u03c4\u03bf\u03bd", "\u03c4\u03b7\u03bd", "\u03ba\u03b1\u03b9", "\u03ba\u03b9", "\u03ba", "\u03b5\u03b9\u03bc\u03b1\u03b9", "\u03b5\u03b9\u03c3\u03b1\u03b9", "\u03b5\u03b9\u03bd\u03b1\u03b9", "\u03b5\u03b9\u03bc\u03b1\u03c3\u03c4\u03b5", "\u03b5\u03b9\u03c3\u03c4\u03b5", "\u03c3\u03c4\u03bf", "\u03c3\u03c4\u03bf\u03bd", "\u03c3\u03c4\u03b7", "\u03c3\u03c4\u03b7\u03bd", "\u03bc\u03b1", "\u03b1\u03bb\u03bb\u03b1", "\u03b1\u03c0\u03bf", "\u03b3\u03b9\u03b1", "\u03c0\u03c1\u03bf\u03c3", "\u03bc\u03b5", "\u03c3\u03b5", "\u03c9\u03c3", "\u03c0\u03b1\u03c1\u03b1", "\u03b1\u03bd\u03c4\u03b9", "\u03ba\u03b1\u03c4\u03b1", "\u03bc\u03b5\u03c4\u03b1", "\u03b8\u03b1", "\u03bd\u03b1", "\u03b4\u03b5", "\u03b4\u03b5\u03bd", "\u03bc\u03b7", "\u03bc\u03b7\u03bd", "\u03b5\u03c0\u03b9", "\u03b5\u03bd\u03c9", "\u03b5\u03b1\u03bd", "\u03b1\u03bd", "\u03c4\u03bf\u03c4\u03b5", "\u03c0\u03bf\u03c5", "\u03c0\u03c9\u03c3", "\u03c0\u03bf\u03b9\u03bf\u03c3", "\u03c0\u03bf\u03b9\u03b1", "\u03c0\u03bf\u03b9\u03bf", "\u03c0\u03bf\u03b9\u03bf\u03b9", "\u03c0\u03bf\u03b9\u03b5\u03c3", "\u03c0\u03bf\u03b9\u03c9\u03bd", "\u03c0\u03bf\u03b9\u03bf\u03c5\u03c3", "\u03b1\u03c5\u03c4\u03bf\u03c3", "\u03b1\u03c5\u03c4\u03b7", "\u03b1\u03c5\u03c4\u03bf", "\u03b1\u03c5\u03c4\u03bf\u03b9", "\u03b1\u03c5\u03c4\u03c9\u03bd", "\u03b1\u03c5\u03c4\u03bf\u03c5\u03c3", "\u03b1\u03c5\u03c4\u03b5\u03c3", "\u03b1\u03c5\u03c4\u03b1", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03bf\u03c3", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03b7", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03bf", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03bf\u03b9", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03b5\u03c3", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03b1", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03c9\u03bd", "\u03b5\u03ba\u03b5\u03b9\u03bd\u03bf\u03c5\u03c3", "\u03bf\u03c0\u03c9\u03c3", "\u03bf\u03bc\u03c9\u03c3", "\u03b9\u03c3\u03c9\u03c3", "\u03bf\u03c3\u03bf", "\u03bf\u03c4\u03b9"};
    private final Set<?> stopSet;
    private final Version matchVersion;

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GreekAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_SET);
    }

    public GreekAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.stopSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.matchVersion = matchVersion;
    }

    public GreekAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public GreekAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(this.matchVersion, reader);
        result = new GreekLowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new GreekLowerCaseFilter((TokenStream)streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stopSet);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    static /* synthetic */ String[] access$100() {
        return GREEK_STOP_WORDS;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        private static final Set<?> DEFAULT_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(GreekAnalyzer.access$100()), false));

        private DefaultSetHolder() {
        }
    }
}

