/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef mlkem_keygen_vectors_h__
#define mlkem_keygen_vectors_h__

#include "testvectors_base/test-structs.h"

const std::vector<MlKemKeyGenTestVector> MlKemKeyGenTests = {
    // tcID: 26
    {26,
     params_ml_kem768,
     // seed
     {0xa2, 0xb4, 0xbc, 0xa3, 0x15, 0xa6, 0xea, 0x46, 0x00, 0xb4, 0xa3,
      0x16, 0xe0, 0x9a, 0x25, 0x78, 0xaa, 0x1e, 0x8b, 0xce, 0x91, 0x9c,
      0x8d, 0xf3, 0xa9, 0x6c, 0x71, 0xc8, 0x43, 0xf5, 0xb3, 0x8b, 0xd6,
      0xbf, 0x05, 0x5c, 0xb7, 0xb3, 0x75, 0xe3, 0x27, 0x1e, 0xd1, 0x31,
      0xf1, 0xba, 0x31, 0xf8, 0x3f, 0xef, 0x53, 0x3a, 0x23, 0x98, 0x78,
      0xa7, 0x10, 0x74, 0x57, 0x8b, 0x89, 0x12, 0x65, 0xd1},
     // publicKeyDigest
     {0x7c, 0xa0, 0xc2, 0xcb, 0xbf, 0x4f, 0xbf, 0x28, 0xde, 0x8c, 0x47,
      0x9d, 0x44, 0x73, 0xc3, 0x39, 0xd9, 0x6b, 0x89, 0xc3, 0x4a, 0x4e,
      0x5f, 0xcb, 0xcf, 0x77, 0x28, 0xbd, 0xfb, 0x43, 0xb9, 0x45},
     // privateKeyDigest
     {0xae, 0xcc, 0xd5, 0x41, 0x12, 0xdb, 0xda, 0x9b, 0x5d, 0xab, 0xec,
      0xa6, 0x05, 0x1a, 0x06, 0x06, 0x8f, 0x09, 0xec, 0x71, 0x9f, 0x36,
      0xcd, 0xc5, 0x9a, 0x46, 0xe1, 0x96, 0x0f, 0x7d, 0x37, 0x58}},
    // tcID: 27
    {27,
     params_ml_kem768,
     // seed
     {0x6d, 0xbb, 0x99, 0xae, 0x68, 0x89, 0xaf, 0x01, 0xda, 0x38, 0x7d,
      0x7d, 0x99, 0xbd, 0x4e, 0x91, 0xba, 0xcb, 0x11, 0xa6, 0x05, 0x1b,
      0x14, 0xae, 0xcd, 0x4c, 0x96, 0xf3, 0x0c, 0xd9, 0xf9, 0xd9, 0x36,
      0x05, 0x57, 0xca, 0xdd, 0xfc, 0xf5, 0xfe, 0xe7, 0xc0, 0xde, 0x6a,
      0x36, 0x3f, 0x09, 0x57, 0x57, 0x58, 0x8c, 0x35, 0xa3, 0xfd, 0x11,
      0xc5, 0x86, 0x77, 0xab, 0x5e, 0x87, 0x97, 0xc2, 0xb8},
     // publicKeyDigest
     {0x9c, 0x90, 0x32, 0x98, 0x4a, 0xe7, 0x2b, 0x7d, 0x5e, 0x07, 0x32,
      0xa2, 0x9e, 0xc2, 0x9d, 0x8b, 0xbc, 0x42, 0x52, 0xa3, 0x14, 0x54,
      0x18, 0x57, 0x10, 0xd2, 0x80, 0xc2, 0x23, 0xa4, 0x78, 0x99},
     // privateKeyDigest
     {0x09, 0x29, 0x35, 0x2c, 0x65, 0x6c, 0xe7, 0x69, 0x7a, 0x75, 0xd6,
      0x2d, 0x68, 0xf0, 0xa9, 0x0b, 0x89, 0x0e, 0x5d, 0x52, 0x1e, 0x7f,
      0xf9, 0x0d, 0xd2, 0x77, 0x70, 0xae, 0x53, 0x44, 0xe0, 0xdb}},
    // tcID: 28
    {28,
     params_ml_kem768,
     // seed
     {0x77, 0x25, 0x32, 0x1c, 0x56, 0xf9, 0x25, 0x86, 0x8f, 0xf8, 0x34,
      0xf5, 0xd1, 0xee, 0x90, 0xa7, 0x03, 0x32, 0xaa, 0x92, 0x83, 0x43,
      0x4e, 0x12, 0x2c, 0x60, 0xa8, 0xd4, 0x74, 0xac, 0x6c, 0x0f, 0x00,
      0xf6, 0xee, 0xc7, 0x27, 0x78, 0xe0, 0x2a, 0xcd, 0x04, 0xbb, 0x05,
      0x61, 0x13, 0xc5, 0x71, 0x98, 0x2e, 0x45, 0x01, 0x8b, 0xea, 0xc5,
      0x66, 0xec, 0x59, 0x95, 0x37, 0x24, 0xf3, 0x8a, 0x4b},
     // publicKeyDigest
     {0x85, 0xe4, 0x21, 0x77, 0x47, 0x9a, 0xc3, 0x64, 0xc3, 0x43, 0xe2,
      0x6b, 0x4b, 0xdd, 0x48, 0x0d, 0x14, 0xf1, 0xa7, 0x48, 0x7f, 0xf4,
      0xc6, 0x4e, 0x37, 0x85, 0x0c, 0x5d, 0x1b, 0x4e, 0xfc, 0x96},
     // privateKeyDigest
     {0xa2, 0x39, 0x72, 0x54, 0x0f, 0xb3, 0xa2, 0x0b, 0xf3, 0xf6, 0xfc,
      0xde, 0x34, 0xdf, 0xb6, 0x10, 0xc5, 0x58, 0x5c, 0x48, 0x16, 0x49,
      0xe2, 0x2f, 0xd3, 0xb8, 0xe9, 0xd7, 0x9d, 0x83, 0x13, 0x22}},
    // tcID: 29
    {29,
     params_ml_kem768,
     // seed
     {0x9d, 0xb7, 0x80, 0xf1, 0x56, 0x57, 0x96, 0x5e, 0xdc, 0xd9, 0x9a,
      0x74, 0x19, 0x06, 0xd3, 0x41, 0x60, 0xaa, 0x52, 0x71, 0x0e, 0x2c,
      0xf0, 0x17, 0x85, 0x12, 0x83, 0xe5, 0xa6, 0xcd, 0xfd, 0x8f, 0xaf,
      0xd2, 0x84, 0x7b, 0x06, 0x7e, 0x70, 0x42, 0x71, 0x4c, 0xd2, 0xd1,
      0xad, 0xa8, 0xbe, 0xf1, 0x41, 0x38, 0x17, 0x19, 0x17, 0x41, 0xc6,
      0x22, 0x32, 0x86, 0x70, 0xc7, 0x9a, 0x07, 0xab, 0xae},
     // publicKeyDigest
     {0x0a, 0xc7, 0xd5, 0x94, 0x5e, 0x9f, 0x2c, 0x91, 0x2b, 0x74, 0xf1,
      0xf5, 0x61, 0x4d, 0x27, 0x5f, 0x79, 0x5d, 0x3d, 0x01, 0x13, 0xc1,
      0xfa, 0xb3, 0xea, 0x76, 0x00, 0x28, 0xdc, 0x76, 0xb5, 0x85},
     // privateKeyDigest
     {0x59, 0x1c, 0x9a, 0x8a, 0xff, 0xef, 0x4c, 0xc9, 0xed, 0xad, 0x85,
      0x67, 0x95, 0x21, 0x6e, 0x7d, 0xb2, 0x78, 0x1f, 0xd1, 0x99, 0xef,
      0xdb, 0x01, 0x5e, 0x37, 0x5c, 0x9d, 0xdd, 0xbe, 0xe6, 0x01}},
    // tcID: 30
    {30,
     params_ml_kem768,
     // seed
     {0xd7, 0x56, 0x1d, 0x7a, 0x9d, 0x67, 0x4a, 0x1b, 0xc0, 0x79, 0x9c,
      0x08, 0xd6, 0xa0, 0x4f, 0x72, 0x58, 0x8e, 0x91, 0xa1, 0x8f, 0xb3,
      0xc3, 0xe5, 0xe1, 0x6f, 0xd4, 0x89, 0xd8, 0xbc, 0x02, 0x4b, 0xa7,
      0x5f, 0x5d, 0x7b, 0xba, 0x35, 0x0c, 0x58, 0x7b, 0xff, 0xc6, 0xc8,
      0x5b, 0xe2, 0x6b, 0x18, 0xa3, 0x7b, 0x98, 0x2d, 0x50, 0xae, 0x8f,
      0x35, 0xd1, 0xd8, 0xb0, 0xa9, 0xbf, 0xc6, 0x1b, 0x86},
     // publicKeyDigest
     {0x82, 0x88, 0xc6, 0x30, 0x9f, 0x22, 0xb8, 0x6e, 0xfa, 0xc8, 0x73,
      0xc6, 0x79, 0xa3, 0x9d, 0x2b, 0x47, 0xf8, 0x6f, 0x0e, 0xa0, 0xad,
      0x95, 0xae, 0x9f, 0xea, 0x0d, 0xa1, 0x9b, 0xd8, 0x38, 0xea},
     // privateKeyDigest
     {0x57, 0xc0, 0xcf, 0xe0, 0xe1, 0x48, 0x30, 0x39, 0x54, 0xed, 0x11,
      0xb7, 0xd3, 0x30, 0x4e, 0x1f, 0x6f, 0x39, 0x1b, 0x51, 0x30, 0x3a,
      0xc7, 0x33, 0x1c, 0xe4, 0x61, 0xc0, 0x8b, 0xa9, 0x57, 0x98}},
    // tcID: 31
    {31,
     params_ml_kem768,
     // seed
     {0x25, 0x08, 0x26, 0x46, 0x91, 0xcd, 0x59, 0xa0, 0xf2, 0x46, 0x7f,
      0x95, 0x9a, 0x72, 0xa9, 0xc2, 0x17, 0xa4, 0xa9, 0x50, 0xff, 0xb5,
      0xa8, 0xbb, 0xd7, 0x50, 0x69, 0x6d, 0x9f, 0x41, 0x02, 0xbd, 0xc0,
      0x9f, 0x22, 0xfe, 0xc1, 0x79, 0x69, 0x72, 0x61, 0xd1, 0xdd, 0x53,
      0xe9, 0xa6, 0x88, 0x39, 0x30, 0x4e, 0xa0, 0x59, 0xa1, 0x37, 0x80,
      0x47, 0x06, 0xe7, 0xc0, 0xfb, 0x3f, 0xba, 0x72, 0xd0},
     // publicKeyDigest
     {0x44, 0x1e, 0x29, 0x1c, 0x20, 0x0f, 0xcf, 0xbf, 0x27, 0x04, 0x6e,
      0x37, 0x26, 0xdb, 0x05, 0x97, 0x22, 0x17, 0x5a, 0xa3, 0x6e, 0xf1,
      0x3a, 0x26, 0xcd, 0xc4, 0x1e, 0x98, 0xd1, 0x02, 0xab, 0xb1},
     // privateKeyDigest
     {0x81, 0xf8, 0x65, 0x21, 0x1d, 0x29, 0xc0, 0x01, 0x7a, 0x8c, 0xb0,
      0xe2, 0x9a, 0x72, 0xf2, 0xd9, 0x83, 0x7e, 0xcc, 0xb9, 0x9d, 0xb5,
      0x3d, 0xf2, 0xb2, 0x67, 0x5d, 0xd0, 0xa8, 0x3d, 0xea, 0xd5}},
    // tcID: 32
    {32,
     params_ml_kem768,
     // seed
     {0xda, 0xf0, 0xb4, 0xbc, 0x60, 0x93, 0x56, 0xbe, 0x13, 0xde, 0x9f,
      0xd9, 0xea, 0xbb, 0x48, 0x63, 0xeb, 0x7f, 0x6c, 0xba, 0x48, 0x97,
      0x49, 0xbf, 0xc2, 0xad, 0xff, 0x5c, 0x8c, 0xbe, 0x52, 0x84, 0x76,
      0xe7, 0x64, 0x48, 0xc7, 0xed, 0xa5, 0xc6, 0xed, 0xb3, 0x87, 0x68,
      0x5c, 0x78, 0x26, 0xbe, 0x93, 0x1f, 0x5c, 0x01, 0x67, 0x10, 0x3f,
      0x3f, 0x38, 0x7c, 0xaa, 0x05, 0x59, 0x43, 0x71, 0x9a},
     // publicKeyDigest
     {0xa9, 0xb8, 0xc7, 0x51, 0x14, 0x49, 0xdc, 0xd5, 0x24, 0x2f, 0x49,
      0xc5, 0xaa, 0x69, 0xbe, 0x64, 0x0f, 0xb1, 0x28, 0x08, 0x11, 0xc0,
      0x87, 0xfa, 0x89, 0x02, 0x28, 0x4d, 0xcf, 0x40, 0x99, 0x5f},
     // privateKeyDigest
     {0xe5, 0xe0, 0xea, 0x0a, 0xe2, 0x57, 0x58, 0x0c, 0x8b, 0x99, 0x93,
      0x56, 0x7d, 0xcf, 0xf1, 0x23, 0x27, 0xb7, 0x02, 0x7d, 0x4e, 0x22,
      0xf5, 0xbe, 0x7a, 0x99, 0x1c, 0x75, 0xca, 0x90, 0x0c, 0x23}},
    // tcID: 33
    {33,
     params_ml_kem768,
     // seed
     {0x9c, 0x87, 0xc3, 0x99, 0xaa, 0xe8, 0x09, 0x3e, 0x6a, 0xca, 0x95,
      0x52, 0xee, 0x47, 0x97, 0xd3, 0x02, 0xf7, 0x22, 0x3a, 0x5c, 0xfe,
      0xea, 0xee, 0xc4, 0x6f, 0x1a, 0xeb, 0xf7, 0x3d, 0xd1, 0xce, 0x1c,
      0x8b, 0xb0, 0x99, 0x69, 0xca, 0x5c, 0x67, 0x9f, 0xa2, 0x5c, 0xbd,
      0xb8, 0x1f, 0xe6, 0x97, 0x26, 0xd9, 0x21, 0x70, 0xb6, 0x62, 0x7f,
      0x4d, 0x21, 0x2c, 0x63, 0x07, 0x4f, 0xa9, 0xe1, 0xc7},
     // publicKeyDigest
     {0xab, 0x27, 0x0d, 0x28, 0x64, 0xe5, 0x39, 0x7e, 0x0b, 0x0d, 0x40,
      0x9d, 0xaf, 0x24, 0x04, 0x9c, 0x35, 0x17, 0x6e, 0x35, 0xa3, 0x21,
      0xd1, 0xc5, 0x06, 0xa4, 0xa9, 0x57, 0x45, 0x79, 0x2d, 0x46},
     // privateKeyDigest
     {0x33, 0x6e, 0xe8, 0x59, 0x30, 0x15, 0xdb, 0x35, 0xa1, 0x76, 0x46,
      0x91, 0x4d, 0x9f, 0x1b, 0xd2, 0x8f, 0xb9, 0x3e, 0x73, 0x57, 0xc6,
      0x85, 0x3c, 0x97, 0xae, 0xdd, 0xa9, 0xa5, 0x18, 0xa5, 0x41}},
    // tcID: 34
    {34,
     params_ml_kem768,
     // seed
     {0xfc, 0x6e, 0xd5, 0x50, 0x7d, 0x3d, 0x60, 0x8d, 0xa3, 0x2f, 0x14,
      0x86, 0xce, 0x03, 0xf9, 0xd4, 0x89, 0x71, 0x0a, 0x29, 0x5a, 0x34,
      0x17, 0x7f, 0x20, 0x30, 0x01, 0x54, 0x99, 0xd1, 0x39, 0x07, 0xd6,
      0x08, 0xa8, 0x6e, 0xfd, 0x98, 0x9f, 0x32, 0x54, 0xd8, 0x9a, 0x31,
      0x6a, 0x7e, 0xda, 0xce, 0xfe, 0x5e, 0x45, 0x56, 0x89, 0xcf, 0xa3,
      0xa4, 0xdc, 0xd2, 0xe8, 0x1d, 0x70, 0xb5, 0x66, 0x3d},
     // publicKeyDigest
     {0xc6, 0xa8, 0x8d, 0x35, 0xb3, 0x7a, 0xe8, 0xf0, 0x18, 0x67, 0x5d,
      0xda, 0x3d, 0xaf, 0x71, 0x80, 0xe6, 0x10, 0xe0, 0x5d, 0x83, 0x03,
      0xa6, 0xd8, 0x8d, 0xbc, 0x5c, 0x44, 0x01, 0xe9, 0x3b, 0xb8},
     // privateKeyDigest
     {0x97, 0xcf, 0x86, 0x1c, 0xc1, 0x4e, 0x57, 0xaf, 0x71, 0x0b, 0xb8,
      0xed, 0x8b, 0x3b, 0xe2, 0xc4, 0x77, 0x6f, 0xf0, 0xc0, 0x2d, 0x18,
      0x04, 0x6c, 0x14, 0x4f, 0x4b, 0x88, 0x21, 0x12, 0x59, 0x23}},
    // tcID: 35
    {35,
     params_ml_kem768,
     // seed
     {0x6e, 0x9c, 0x1e, 0xa4, 0xe9, 0x55, 0xca, 0xe2, 0xa1, 0xe1, 0x93,
      0x7f, 0x05, 0x6b, 0xc9, 0x7b, 0xf9, 0x21, 0xe9, 0x03, 0x26, 0x68,
      0x38, 0xed, 0x87, 0x08, 0x82, 0xc9, 0x0f, 0xb5, 0x3a, 0x8c, 0x1b,
      0x64, 0xa7, 0xb5, 0x70, 0x8e, 0xf4, 0x62, 0xd3, 0x54, 0xe4, 0x1e,
      0x33, 0x64, 0xa6, 0x06, 0xb3, 0xa4, 0x31, 0x71, 0x9d, 0x98, 0xbc,
      0x16, 0x52, 0x8f, 0x32, 0xde, 0xb7, 0x9e, 0x36, 0x86},
     // publicKeyDigest
     {0x7e, 0x80, 0x7b, 0xbf, 0x0a, 0xa3, 0xe1, 0xb1, 0xd3, 0x9a, 0xc2,
      0xf1, 0xeb, 0xbc, 0x03, 0x98, 0x77, 0xec, 0xb5, 0xfd, 0x12, 0xa2,
      0xe2, 0x87, 0x66, 0x2d, 0x3f, 0xe7, 0x77, 0xbc, 0x27, 0x58},
     // privateKeyDigest
     {0xfd, 0xb1, 0x6c, 0x40, 0x12, 0x96, 0x54, 0x85, 0xda, 0xb4, 0x24,
      0x4f, 0xef, 0xb5, 0x54, 0x4d, 0x74, 0xae, 0x3b, 0x0b, 0x74, 0x2f,
      0x2c, 0xa4, 0xf8, 0xca, 0x4b, 0xed, 0x5c, 0xd2, 0x33, 0x01}},
    // tcID: 36
    {36,
     params_ml_kem768,
     // seed
     {0xda, 0xb3, 0x1f, 0x41, 0xb3, 0x79, 0x6d, 0x0c, 0x9f, 0xd3, 0x3f,
      0x4e, 0x6c, 0x3e, 0x9c, 0x6e, 0x46, 0x17, 0xe1, 0xf5, 0x0b, 0xdb,
      0xfd, 0xeb, 0x45, 0x07, 0x90, 0x47, 0xdf, 0xf9, 0xad, 0x58, 0x14,
      0x1e, 0xe3, 0x0d, 0x44, 0x0a, 0xff, 0xc1, 0x5b, 0xb9, 0x6c, 0x99,
      0x7b, 0x4b, 0x42, 0x2a, 0xec, 0x41, 0xba, 0xc3, 0x56, 0x87, 0x72,
      0xbd, 0xc0, 0x63, 0x4b, 0xb3, 0x3b, 0xc9, 0xc6, 0x0b},
     // publicKeyDigest
     {0x62, 0x88, 0xe1, 0xa8, 0xf4, 0x30, 0xd1, 0x1d, 0x6a, 0xe5, 0x89,
      0xa0, 0x5d, 0xe4, 0x91, 0xf4, 0x0b, 0xf3, 0xc3, 0x03, 0xc4, 0x8d,
      0x3c, 0xf9, 0xc1, 0x9b, 0x67, 0x09, 0xa0, 0xd5, 0xc5, 0xf2},
     // privateKeyDigest
     {0x13, 0xf8, 0xbe, 0x55, 0x84, 0x26, 0x69, 0xbd, 0xbe, 0x50, 0x0f,
      0x8d, 0x42, 0x3c, 0x3e, 0xe0, 0xf6, 0x17, 0xc8, 0x33, 0xb6, 0xb3,
      0x10, 0x7d, 0x76, 0xad, 0x0a, 0xa3, 0xb4, 0x42, 0x8c, 0xdc}},
    // tcID: 37
    {37,
     params_ml_kem768,
     // seed
     {0xb3, 0x20, 0x68, 0x37, 0xef, 0x4d, 0x70, 0xed, 0x2c, 0xae, 0x79,
      0x76, 0x71, 0x4c, 0x54, 0xe4, 0xd4, 0xb9, 0xa2, 0x21, 0x76, 0x17,
      0x72, 0xd1, 0xe6, 0xf8, 0x64, 0xa6, 0x46, 0xce, 0x1f, 0xd9, 0xcd,
      0xc6, 0xf4, 0xc1, 0xe5, 0xa8, 0x9b, 0x9a, 0xd1, 0x9f, 0x97, 0x7b,
      0x21, 0x31, 0x02, 0x12, 0xf8, 0xdc, 0x6c, 0x45, 0xf0, 0x39, 0x82,
      0xa7, 0xe2, 0x4d, 0xdf, 0x8b, 0xe8, 0x42, 0x8c, 0xc3},
     // publicKeyDigest
     {0xfe, 0x73, 0xf5, 0xf0, 0x51, 0x66, 0xf9, 0xf6, 0xe6, 0x75, 0xdb,
      0x43, 0x60, 0x9c, 0x20, 0x3f, 0x85, 0xa7, 0x53, 0x65, 0x7e, 0xbe,
      0xd7, 0xe5, 0x14, 0x30, 0x83, 0xd8, 0xc0, 0x13, 0x30, 0x74},
     // privateKeyDigest
     {0xd2, 0xb9, 0xee, 0xd5, 0x13, 0x50, 0x14, 0x1b, 0x35, 0x10, 0xb9,
      0xc4, 0x4e, 0x99, 0x3e, 0xfe, 0xc3, 0xf5, 0x48, 0x41, 0x61, 0x31,
      0xa4, 0x86, 0x76, 0x6e, 0x4e, 0xca, 0xf1, 0xc1, 0x88, 0x7f}},
    // tcID: 38
    {38,
     params_ml_kem768,
     // seed
     {0xa4, 0xa4, 0x53, 0xf7, 0x37, 0x56, 0x59, 0xd2, 0xa8, 0x0c, 0x3c,
      0xbf, 0x22, 0xc3, 0x6a, 0x83, 0x8c, 0x64, 0xc2, 0x8c, 0x20, 0x6b,
      0xf2, 0x2a, 0x6a, 0x5d, 0x14, 0xe2, 0xfb, 0xe8, 0x14, 0x9a, 0x15,
      0x14, 0xd3, 0x16, 0xd9, 0xaa, 0xa6, 0xc6, 0xdc, 0xa5, 0xa3, 0xf5,
      0x67, 0x1b, 0xe5, 0x51, 0x70, 0xcd, 0xfa, 0x13, 0x2b, 0x39, 0xcd,
      0x78, 0xba, 0x2d, 0xa2, 0xde, 0x1c, 0x36, 0x78, 0x4b},
     // publicKeyDigest
     {0xba, 0x11, 0xcb, 0x78, 0xe4, 0x7d, 0x3e, 0xa5, 0x08, 0x1a, 0x36,
      0x69, 0x24, 0x2f, 0x1d, 0xfa, 0xbe, 0x78, 0xb0, 0xc8, 0xe9, 0x26,
      0x53, 0x80, 0xcd, 0x82, 0x7b, 0x0b, 0x43, 0xf9, 0x9d, 0xd3},
     // privateKeyDigest
     {0x34, 0x05, 0xff, 0x29, 0x30, 0xd7, 0xa7, 0x2c, 0xd5, 0xa3, 0x14,
      0xaa, 0xd1, 0xdb, 0xf3, 0x68, 0xf1, 0x53, 0xbd, 0x48, 0x10, 0xd1,
      0x34, 0xea, 0xf1, 0x0c, 0x27, 0x22, 0xb7, 0x1c, 0xa1, 0x70}},
    // tcID: 39
    {39,
     params_ml_kem768,
     // seed
     {0xc4, 0x92, 0x09, 0xb3, 0x68, 0xf4, 0x65, 0xae, 0x48, 0x07, 0x75,
      0xe1, 0x6a, 0x7e, 0x29, 0x6c, 0x32, 0x6d, 0xc3, 0x03, 0xb6, 0x61,
      0x18, 0xaf, 0x1e, 0x95, 0x27, 0x61, 0x6a, 0x88, 0xf9, 0x53, 0x30,
      0x67, 0x58, 0x0b, 0x27, 0x1b, 0x81, 0x8e, 0xed, 0xa0, 0xa9, 0x7c,
      0x00, 0x41, 0x17, 0x98, 0x8e, 0x6d, 0x19, 0x6f, 0xf8, 0x2a, 0xb7,
      0x1d, 0x9d, 0x31, 0xce, 0xe9, 0x82, 0x53, 0x4f, 0xf1},
     // publicKeyDigest
     {0xc5, 0x6d, 0x6d, 0x9f, 0xd3, 0x4c, 0x4a, 0xf5, 0xa9, 0xf9, 0xb9,
      0x6f, 0xbc, 0x6e, 0x2d, 0x53, 0x6c, 0xa5, 0xb5, 0xd0, 0x13, 0xed,
      0x48, 0x63, 0x43, 0x06, 0xff, 0xef, 0x6c, 0xad, 0x97, 0xa4},
     // privateKeyDigest
     {0x8e, 0x41, 0xb8, 0xf0, 0xe0, 0xdc, 0xd2, 0x6d, 0x96, 0x75, 0x23,
      0x97, 0x24, 0xb0, 0x87, 0x45, 0x35, 0x53, 0x6c, 0x39, 0x6a, 0xe6,
      0x78, 0x51, 0xc9, 0xb7, 0xb6, 0xb0, 0xe6, 0x34, 0x15, 0x84}},
    // tcID: 40
    {40,
     params_ml_kem768,
     // seed
     {0x59, 0xc0, 0x45, 0xef, 0xe5, 0xa6, 0x5c, 0xd7, 0x64, 0x19, 0x1f,
      0x4d, 0x49, 0x6c, 0x86, 0x1b, 0x83, 0xd2, 0x84, 0x02, 0xbc, 0x05,
      0xe5, 0x66, 0x11, 0xda, 0xf2, 0xf9, 0x71, 0x73, 0x47, 0xa9, 0xe1,
      0x0c, 0x5b, 0x94, 0x8c, 0x23, 0x94, 0x8b, 0x69, 0xba, 0x4b, 0x11,
      0x33, 0xe2, 0x7a, 0x86, 0xb4, 0xe1, 0x79, 0x89, 0xad, 0xed, 0x93,
      0xb4, 0x55, 0xd1, 0x12, 0x79, 0x32, 0xc5, 0x92, 0xb0},
     // publicKeyDigest
     {0xb3, 0x3f, 0xb8, 0x3b, 0xe3, 0x3d, 0x15, 0x21, 0x7c, 0xf2, 0x65,
      0xe0, 0xfa, 0x71, 0x64, 0x85, 0x51, 0x01, 0xe2, 0xf2, 0xfc, 0x8d,
      0xb1, 0xd0, 0xd1, 0xb4, 0x82, 0x2f, 0x9d, 0xed, 0x92, 0xeb},
     // privateKeyDigest
     {0x56, 0xcb, 0x6c, 0xa2, 0x3f, 0xc4, 0x7f, 0xcf, 0x1b, 0x8d, 0x57,
      0x59, 0x95, 0x3b, 0xab, 0x9a, 0x79, 0x2b, 0xbd, 0x02, 0xd9, 0x16,
      0x79, 0x78, 0xe7, 0x65, 0xac, 0xdd, 0x73, 0x8d, 0x81, 0xf4}},
    // tcID: 41
    {41,
     params_ml_kem768,
     // seed
     {0x78, 0xad, 0xca, 0xb3, 0x36, 0xed, 0xc6, 0xf7, 0x02, 0x10, 0x65,
      0xca, 0x99, 0x34, 0xb1, 0x8e, 0x88, 0x7a, 0x81, 0x0c, 0x83, 0xd8,
      0xc1, 0x66, 0x2f, 0x90, 0x40, 0x98, 0xb5, 0x20, 0x72, 0x1d, 0x4c,
      0x56, 0x0a, 0xd6, 0xe7, 0x0e, 0x02, 0x4e, 0x7e, 0x94, 0x2e, 0xbd,
      0xbc, 0xcc, 0x75, 0xdc, 0x08, 0x59, 0x31, 0xe0, 0xa8, 0xe8, 0x27,
      0x82, 0x84, 0xb2, 0xc2, 0x39, 0x3c, 0x45, 0x8c, 0x30},
     // publicKeyDigest
     {0x82, 0x8a, 0x71, 0xfc, 0x7e, 0xa1, 0xbe, 0x91, 0xaa, 0x8a, 0xe1,
      0x6f, 0x67, 0x93, 0x3d, 0xd8, 0x89, 0x73, 0x63, 0xb7, 0x31, 0x73,
      0xb3, 0x45, 0x58, 0x94, 0x4b, 0x47, 0xe1, 0xf2, 0x84, 0x6d},
     // privateKeyDigest
     {0x61, 0x0a, 0xd6, 0xb9, 0x0a, 0xd9, 0xf8, 0x17, 0x2a, 0xe4, 0x0a,
      0xf7, 0x7f, 0xfd, 0xb3, 0x4a, 0x1f, 0x9d, 0x9c, 0xbb, 0xe0, 0xdf,
      0x4a, 0x72, 0x55, 0xa4, 0x05, 0xbc, 0x26, 0xbf, 0xb3, 0x8a}},
    // tcID: 42
    {42,
     params_ml_kem768,
     // seed
     {0x1e, 0x1f, 0xfd, 0x0c, 0xe2, 0xc3, 0x4a, 0x42, 0x79, 0x5f, 0x06,
      0xf8, 0x1a, 0x19, 0x98, 0x7c, 0x2d, 0x22, 0x34, 0xc8, 0x81, 0x3f,
      0xe5, 0x9d, 0x24, 0x67, 0x7e, 0xe4, 0xea, 0x47, 0x4b, 0x20, 0x2c,
      0x7d, 0x1f, 0xc6, 0xfd, 0xd6, 0x15, 0xcc, 0x07, 0x81, 0x87, 0x87,
      0x7c, 0xd2, 0x74, 0x4c, 0xa2, 0x68, 0x7e, 0x7f, 0x00, 0x79, 0xc8,
      0x3d, 0xe6, 0xfb, 0xe3, 0xf7, 0x8f, 0x52, 0xc4, 0x00},
     // publicKeyDigest
     {0x31, 0xbf, 0x3a, 0xd5, 0x6a, 0x7e, 0xb9, 0x86, 0x69, 0x4a, 0x32,
      0x56, 0xa2, 0xd4, 0xf5, 0xf6, 0x38, 0xd3, 0xc7, 0xac, 0x6f, 0x91,
      0xc0, 0xc0, 0x4e, 0x4f, 0x68, 0xd1, 0x46, 0xf4, 0x8d, 0x2d},
     // privateKeyDigest
     {0xa4, 0x39, 0x6b, 0x0e, 0x64, 0x6c, 0xec, 0x9a, 0xce, 0xd7, 0xed,
      0x81, 0x63, 0x09, 0x94, 0x6b, 0x6e, 0xe8, 0x4d, 0x55, 0xf4, 0x1d,
      0x2c, 0x3a, 0xe6, 0x91, 0xab, 0x7c, 0xee, 0x81, 0xe7, 0x00}},
    // tcID: 43
    {43,
     params_ml_kem768,
     // seed
     {0x9c, 0x4a, 0x7c, 0xf7, 0xce, 0xcf, 0x92, 0xa0, 0xd4, 0x32, 0xba,
      0x1d, 0x68, 0x4a, 0x87, 0x3f, 0xa9, 0x32, 0x97, 0xdf, 0x89, 0x27,
      0x38, 0x99, 0x34, 0x1a, 0x0f, 0x87, 0x2c, 0xc8, 0xc4, 0x82, 0x02,
      0xc9, 0x0d, 0xc1, 0x8d, 0x78, 0x0f, 0x2d, 0xdd, 0xfd, 0x5a, 0x7f,
      0x8e, 0x3c, 0xc0, 0xc6, 0x10, 0x6d, 0xd2, 0x25, 0x9c, 0xa6, 0xa4,
      0xa9, 0x0c, 0x09, 0x70, 0xde, 0xfd, 0x6f, 0x9e, 0x2f},
     // publicKeyDigest
     {0xa1, 0x97, 0x0e, 0x5d, 0x3d, 0xce, 0x7b, 0x32, 0xc0, 0xb6, 0x24,
      0x01, 0x37, 0x75, 0x4c, 0x85, 0xd5, 0xb3, 0x25, 0xed, 0x53, 0x82,
      0x4b, 0xd4, 0xbd, 0x1b, 0xed, 0xb4, 0x01, 0x4d, 0x7a, 0x7e},
     // privateKeyDigest
     {0xd5, 0x9c, 0x84, 0xff, 0x8e, 0xf6, 0x90, 0xc7, 0x6b, 0x4e, 0x61,
      0x62, 0xe7, 0xe2, 0x47, 0xcd, 0x57, 0x75, 0x3e, 0xb1, 0xf0, 0xd6,
      0xd7, 0x1c, 0x84, 0x6e, 0x21, 0xa8, 0x18, 0xc0, 0xf8, 0xf3}},
    // tcID: 44
    {44,
     params_ml_kem768,
     // seed
     {0x87, 0x12, 0x23, 0xd6, 0x69, 0x47, 0xc5, 0x18, 0xe8, 0x18, 0xf1,
      0x7d, 0x64, 0xef, 0x2b, 0x0b, 0x42, 0x31, 0xbd, 0x27, 0x4a, 0x0d,
      0x4c, 0xdb, 0xfe, 0xf7, 0xee, 0x54, 0x7b, 0x36, 0x20, 0xc6, 0x9f,
      0x17, 0x85, 0xbb, 0x9a, 0xa7, 0xcd, 0xec, 0x1a, 0x33, 0x62, 0x05,
      0x2d, 0x80, 0xa8, 0xf2, 0x97, 0x3f, 0x00, 0x48, 0xa1, 0xdf, 0xad,
      0x0c, 0xcd, 0xbd, 0x7e, 0x36, 0x33, 0xe0, 0x4c, 0x4b},
     // publicKeyDigest
     {0x3a, 0x60, 0xc5, 0xbb, 0xe0, 0x76, 0xca, 0x56, 0x83, 0xb2, 0x99,
      0x78, 0xf6, 0x8e, 0xc6, 0x55, 0x9e, 0x4a, 0x5f, 0x2e, 0xf5, 0x4f,
      0xae, 0x3c, 0xa8, 0x7c, 0x2c, 0xc2, 0x4b, 0x7f, 0xe4, 0x4b},
     // privateKeyDigest
     {0xc1, 0x01, 0x47, 0x3e, 0x89, 0x64, 0xf3, 0xd2, 0x8e, 0xe6, 0x54,
      0x8e, 0x6c, 0x13, 0x66, 0xa7, 0x4b, 0xe8, 0x47, 0x2e, 0x7a, 0xec,
      0x27, 0x90, 0xde, 0x2a, 0x5e, 0x9f, 0xd6, 0x09, 0x63, 0x64}},
    // tcID: 45
    {45,
     params_ml_kem768,
     // seed
     {0x61, 0x7f, 0x05, 0xa9, 0xd1, 0xf7, 0x33, 0xcf, 0xc7, 0x94, 0xf9,
      0xfe, 0xd8, 0xf4, 0x52, 0x09, 0x4d, 0x71, 0x09, 0xff, 0x0f, 0x9a,
      0x86, 0xdc, 0xb1, 0x7a, 0x65, 0x30, 0x67, 0x67, 0xc7, 0x4d, 0xd6,
      0x73, 0x26, 0xbd, 0x88, 0x28, 0x3f, 0x07, 0x5e, 0x55, 0xf1, 0x10,
      0xab, 0x55, 0x1e, 0x42, 0x03, 0x50, 0x85, 0x37, 0x03, 0x3c, 0xb0,
      0x87, 0x3d, 0x8e, 0xd2, 0x11, 0xff, 0x91, 0x24, 0xb9},
     // publicKeyDigest
     {0xc1, 0x05, 0x7e, 0x62, 0xc1, 0xd6, 0x8c, 0xd0, 0x0b, 0x68, 0x17,
      0xc0, 0xde, 0xd2, 0x1b, 0xdd, 0x71, 0x0e, 0xc0, 0x86, 0xdb, 0x10,
      0xda, 0x26, 0x81, 0x5b, 0x3c, 0x17, 0x2e, 0xb5, 0xd0, 0xaf},
     // privateKeyDigest
     {0x95, 0xc3, 0xa6, 0x05, 0x4a, 0x44, 0x7e, 0xe3, 0xa5, 0xeb, 0xf8,
      0xc8, 0x56, 0x9f, 0x54, 0x80, 0xd6, 0x61, 0xe3, 0x76, 0x24, 0x73,
      0xe0, 0x79, 0xa2, 0x66, 0xaf, 0x0f, 0xe9, 0x00, 0x72, 0xed}},
    // tcID: 46
    {46,
     params_ml_kem768,
     // seed
     {0xf5, 0x54, 0xa1, 0xc6, 0x46, 0x64, 0x87, 0x65, 0x13, 0x54, 0x3f,
      0xc1, 0x0d, 0xd4, 0xd7, 0xd7, 0x3c, 0x54, 0x93, 0x06, 0xfb, 0xc5,
      0x1c, 0xac, 0x2b, 0x43, 0x39, 0xa2, 0xf3, 0xa5, 0x08, 0x55, 0x2e,
      0x56, 0x2d, 0x81, 0x25, 0x38, 0x86, 0xfa, 0xab, 0xf1, 0xa4, 0x85,
      0xb5, 0xab, 0xfc, 0xb2, 0x7d, 0x77, 0x16, 0xbf, 0xb8, 0x7a, 0xed,
      0x22, 0xd6, 0xc7, 0xfe, 0xcd, 0x5e, 0x33, 0x57, 0xb8},
     // publicKeyDigest
     {0x3b, 0xe4, 0x82, 0x7c, 0xc1, 0x43, 0x60, 0x55, 0xe3, 0xcc, 0xa4,
      0x95, 0xad, 0xb3, 0x12, 0xbe, 0x5a, 0x35, 0xbc, 0x6d, 0x6d, 0xf1,
      0x3f, 0x43, 0xd6, 0x43, 0xd9, 0x61, 0xdf, 0x40, 0xa6, 0x09},
     // privateKeyDigest
     {0xaf, 0xd6, 0xd9, 0xe2, 0x1a, 0xe0, 0x0e, 0xc4, 0x64, 0x6b, 0x4e,
      0x30, 0x53, 0x2c, 0x57, 0xfe, 0x4e, 0xc3, 0x4c, 0x45, 0x87, 0xa4,
      0x9f, 0xa3, 0x50, 0xf7, 0xcd, 0x1e, 0xfb, 0xc5, 0xee, 0x44}},
    // tcID: 47
    {47,
     params_ml_kem768,
     // seed
     {0x29, 0x9a, 0xa7, 0x74, 0x5e, 0x4d, 0xc0, 0x41, 0xff, 0x92, 0x5a,
      0xf9, 0xbe, 0x54, 0x1f, 0xc6, 0x83, 0x4c, 0xe8, 0xd3, 0x92, 0x48,
      0x73, 0x74, 0x3b, 0x53, 0x0f, 0xa5, 0xe9, 0x9b, 0x2d, 0x2c, 0x98,
      0x55, 0xcf, 0x40, 0xf8, 0x86, 0x5e, 0xe0, 0xaf, 0xff, 0x8e, 0x64,
      0xae, 0xbd, 0xfa, 0xf1, 0xf3, 0xc9, 0x26, 0x15, 0x6e, 0x25, 0x19,
      0xf9, 0xdb, 0xa0, 0xfa, 0xbd, 0x2e, 0x70, 0x40, 0x8d},
     // publicKeyDigest
     {0x74, 0x69, 0x86, 0xc0, 0x0b, 0x96, 0x93, 0x00, 0xda, 0xcf, 0x52,
      0xf1, 0x42, 0x07, 0x80, 0x04, 0xc1, 0x6c, 0xf0, 0x73, 0x91, 0x2b,
      0x48, 0x07, 0xa1, 0x80, 0x99, 0xb4, 0xc7, 0x3e, 0xc9, 0x79},
     // privateKeyDigest
     {0x62, 0x13, 0x95, 0x21, 0x82, 0xd4, 0xc4, 0x46, 0x18, 0x39, 0x39,
      0xea, 0xd2, 0xc4, 0xdc, 0xa4, 0x77, 0x2f, 0xdc, 0x28, 0x7b, 0xf4,
      0x93, 0xc4, 0xe6, 0xb2, 0x8a, 0x68, 0x13, 0xaa, 0x91, 0x7e}},
    // tcID: 48
    {48,
     params_ml_kem768,
     // seed
     {0x57, 0xf0, 0xd8, 0x45, 0x58, 0xaf, 0xe0, 0x39, 0x01, 0xf2, 0x81,
      0x07, 0xbb, 0xa1, 0xf3, 0x46, 0x81, 0x55, 0xbe, 0xe6, 0xc1, 0x0b,
      0x93, 0x6c, 0xcc, 0xfb, 0x6e, 0x09, 0x5a, 0x84, 0x7c, 0xc3, 0x36,
      0xe6, 0x0b, 0x1d, 0x30, 0xe2, 0x01, 0x16, 0xba, 0xbf, 0xdc, 0x6d,
      0x79, 0x9e, 0xa0, 0xd2, 0x0c, 0x84, 0x1d, 0xe1, 0x56, 0xeb, 0x89,
      0x63, 0x0e, 0x09, 0x27, 0x5a, 0xc5, 0x9b, 0xf8, 0xdd},
     // publicKeyDigest
     {0xc4, 0x6e, 0xa1, 0xd2, 0xea, 0x90, 0x4e, 0xad, 0x95, 0x30, 0x5c,
      0xf8, 0xab, 0x0a, 0x4e, 0xae, 0x71, 0x25, 0x48, 0x10, 0x14, 0xce,
      0x43, 0x88, 0xa8, 0x5e, 0x50, 0xee, 0x0f, 0xb5, 0x6f, 0x3b},
     // privateKeyDigest
     {0x95, 0x46, 0x0b, 0x86, 0x6b, 0xa6, 0x7e, 0x48, 0x72, 0xeb, 0x69,
      0x26, 0x4b, 0x4a, 0x48, 0x7f, 0x9e, 0x93, 0x42, 0x39, 0xad, 0xdc,
      0x30, 0xe8, 0x33, 0x0a, 0xed, 0xed, 0xdb, 0x78, 0xb8, 0xe1}},
    // tcID: 49
    {49,
     params_ml_kem768,
     // seed
     {0xc6, 0x58, 0x04, 0x0c, 0x56, 0x73, 0x55, 0xb8, 0xd2, 0x74, 0x0b,
      0x0d, 0xd6, 0x93, 0x8b, 0xce, 0xd0, 0xf7, 0xb8, 0x34, 0x5a, 0x3c,
      0x04, 0x65, 0x32, 0x9c, 0x77, 0xdb, 0x7a, 0x6c, 0xb1, 0x83, 0x5b,
      0xe8, 0x9a, 0xc2, 0x35, 0x32, 0xb9, 0xc2, 0x43, 0xf3, 0xc8, 0xb4,
      0xcc, 0xcd, 0x10, 0x4d, 0x16, 0x87, 0x98, 0xaf, 0x61, 0xf5, 0x79,
      0x61, 0x1a, 0x3a, 0x3e, 0x0f, 0x36, 0x98, 0xac, 0x9a},
     // publicKeyDigest
     {0xbf, 0x33, 0x79, 0xd3, 0x8e, 0x80, 0xd3, 0xdb, 0xa1, 0x6d, 0x87,
      0xf1, 0xc3, 0x4b, 0x32, 0x05, 0xbf, 0xb0, 0xb0, 0xc2, 0x56, 0x29,
      0xbc, 0x2d, 0x3c, 0x42, 0xef, 0x41, 0x8b, 0x50, 0xe3, 0x64},
     // privateKeyDigest
     {0xc7, 0x29, 0x44, 0xea, 0x22, 0x9f, 0xcf, 0xd2, 0x7b, 0xf8, 0xd4,
      0x29, 0x07, 0xab, 0xfb, 0xd0, 0xd7, 0xa9, 0xf5, 0x3d, 0x19, 0xdf,
      0x17, 0xf2, 0xb4, 0xed, 0x3f, 0xda, 0x81, 0x35, 0x32, 0x5b}},
    // tcID: 50
    {50,
     params_ml_kem768,
     // seed
     {0xf3, 0xa8, 0x54, 0x83, 0x71, 0xfa, 0x09, 0x52, 0x16, 0x7b, 0x35,
      0xaf, 0x4f, 0x0e, 0x33, 0x0e, 0x1d, 0x40, 0x1e, 0xcb, 0xfd, 0x85,
      0x37, 0x7c, 0x99, 0x41, 0x53, 0xc4, 0x7b, 0x08, 0x94, 0xcd, 0xcb,
      0x23, 0x52, 0x74, 0x58, 0x5d, 0x12, 0xb1, 0xd5, 0x57, 0xa0, 0xd8,
      0x09, 0x81, 0xf7, 0x41, 0x4f, 0xb8, 0x8e, 0x13, 0xcc, 0xe5, 0x51,
      0x45, 0x1c, 0xac, 0xe1, 0x83, 0xac, 0xde, 0xa9, 0xb6},
     // publicKeyDigest
     {0x3f, 0x9e, 0xd7, 0x0f, 0xda, 0x26, 0x9c, 0x81, 0x64, 0x56, 0x70,
      0x47, 0x9e, 0xd9, 0x98, 0xbe, 0xb9, 0xc7, 0x2b, 0xe4, 0xa7, 0xd5,
      0x85, 0x4a, 0x70, 0x23, 0x2b, 0x29, 0x1b, 0x59, 0x2b, 0x65},
     // privateKeyDigest
     {0x0f, 0x53, 0xc8, 0x80, 0x0f, 0x3a, 0xbe, 0x05, 0x2e, 0xbc, 0x75,
      0x45, 0x71, 0xbe, 0xe6, 0xe4, 0xe7, 0x7e, 0xef, 0x43, 0x80, 0x37,
      0xa1, 0x6d, 0xd5, 0x2a, 0x0a, 0x26, 0x6c, 0x30, 0xe0, 0xeb}},
    // tcID: 51
    {51,
     params_ml_kem1024,
     // seed
     {0x2b, 0x53, 0x30, 0xc4, 0xf2, 0x3b, 0xfd, 0xfd, 0x5c, 0x31, 0xf0,
      0x50, 0xba, 0x3b, 0x38, 0x23, 0x53, 0x24, 0xbf, 0x03, 0x23, 0x72,
      0xfc, 0x12, 0xd0, 0x4d, 0xd0, 0x89, 0x20, 0xf0, 0xbd, 0x59, 0x0a,
      0x06, 0x4d, 0x6c, 0x06, 0xce, 0xab, 0x73, 0xe5, 0x9c, 0xfc, 0xa9,
      0xff, 0x64, 0x02, 0x25, 0x5a, 0x32, 0x6a, 0xef, 0x1e, 0x9c, 0xb6,
      0x78, 0xbf, 0x36, 0x92, 0x9d, 0xaf, 0xe2, 0x9a, 0x58},
     // publicKeyDigest
     {0x88, 0xa8, 0xfd, 0x05, 0xcd, 0x6d, 0xa0, 0x66, 0xd2, 0xba, 0xb1,
      0x05, 0x29, 0x9b, 0x3e, 0xe6, 0x66, 0x05, 0xbd, 0x5a, 0x80, 0x37,
      0x60, 0xaf, 0x56, 0xa6, 0x03, 0x3c, 0xb9, 0xd3, 0xb9, 0x24},
     // privateKeyDigest
     {0x26, 0xd8, 0x23, 0x88, 0x5f, 0x46, 0x5e, 0xbd, 0x28, 0xa9, 0x23,
      0xe4, 0x19, 0x57, 0xe8, 0x6b, 0xdd, 0x58, 0xb9, 0xc0, 0x6a, 0x73,
      0xff, 0x3f, 0xe8, 0xd4, 0x3a, 0x80, 0xf5, 0x81, 0x3a, 0x64}},
    // tcID: 52
    {52,
     params_ml_kem1024,
     // seed
     {0xd1, 0x9a, 0x3d, 0xba, 0xeb, 0x91, 0xea, 0x7b, 0x11, 0xc5, 0xc7,
      0xab, 0x16, 0xf7, 0xa5, 0xea, 0x6b, 0x4c, 0xe4, 0x4c, 0xb1, 0x84,
      0x62, 0xb9, 0x69, 0x55, 0x71, 0xb7, 0x24, 0xee, 0x13, 0xac, 0x7a,
      0x98, 0xea, 0x31, 0x8a, 0xd1, 0xe2, 0x70, 0x5f, 0x20, 0xb0, 0x74,
      0x07, 0x94, 0xc3, 0xe7, 0x11, 0x12, 0x1a, 0x00, 0x60, 0x0d, 0x00,
      0xbc, 0xcc, 0xc7, 0x8c, 0xce, 0x02, 0x4a, 0x9b, 0xc1},
     // publicKeyDigest
     {0x09, 0xd0, 0x76, 0x91, 0x02, 0x7d, 0xa1, 0x8e, 0x94, 0x97, 0x80,
      0x05, 0x33, 0xb1, 0xc0, 0xe2, 0x6b, 0x57, 0xdb, 0x34, 0xab, 0x40,
      0xee, 0xb9, 0xdb, 0xb2, 0x82, 0x82, 0x75, 0x64, 0xea, 0xbe},
     // privateKeyDigest
     {0xfd, 0xb2, 0xee, 0x70, 0x51, 0x50, 0x89, 0xfd, 0xff, 0xb8, 0x7a,
      0x0f, 0x83, 0x29, 0xf2, 0x1f, 0x94, 0xff, 0xfb, 0x44, 0xb1, 0x16,
      0x81, 0x23, 0xa6, 0x5a, 0x6b, 0xc1, 0x01, 0xd9, 0x1e, 0x92}},
    // tcID: 53
    {53,
     params_ml_kem1024,
     // seed
     {0x20, 0x23, 0x26, 0xc5, 0xe2, 0xd0, 0xd9, 0x21, 0x2b, 0x06, 0x2e,
      0x62, 0x2b, 0xd3, 0x86, 0x35, 0x03, 0xb3, 0x57, 0xa7, 0xcb, 0xd5,
      0xdd, 0xf9, 0xb5, 0x86, 0x59, 0x64, 0x09, 0x87, 0x1a, 0x00, 0x2d,
      0x7a, 0xaf, 0x4e, 0xa9, 0x88, 0x67, 0xa6, 0x8b, 0xc9, 0x8d, 0xe1,
      0x67, 0x68, 0x63, 0xb1, 0x2f, 0xcc, 0xc1, 0xe5, 0xd0, 0x7d, 0x16,
      0xcf, 0x72, 0xcf, 0x4d, 0x4a, 0x77, 0x64, 0xeb, 0xb8},
     // publicKeyDigest
     {0xaa, 0x41, 0x60, 0x31, 0x5e, 0xa4, 0xdf, 0xa5, 0xfd, 0x51, 0x51,
      0x0a, 0x38, 0xb5, 0x8e, 0x65, 0x1c, 0x14, 0x65, 0x80, 0xb7, 0x5c,
      0xbd, 0x45, 0xdb, 0xf7, 0xda, 0x19, 0xda, 0x6e, 0x48, 0xfa},
     // privateKeyDigest
     {0xa1, 0x38, 0xe2, 0x07, 0x8e, 0xbd, 0x6c, 0xd0, 0xb9, 0x34, 0xad,
      0x73, 0xb1, 0x99, 0x56, 0x4a, 0x6d, 0x76, 0x2c, 0xa5, 0xaf, 0xdc,
      0x17, 0xfe, 0x31, 0xc5, 0x9e, 0xcf, 0x0c, 0x47, 0x7e, 0x97}},
    // tcID: 54
    {54,
     params_ml_kem1024,
     // seed
     {0xf7, 0x09, 0xb6, 0xb9, 0x45, 0x13, 0x8f, 0xaa, 0x61, 0x57, 0xf9,
      0xab, 0x41, 0x4e, 0x15, 0x35, 0x10, 0x3d, 0x16, 0x29, 0x28, 0x24,
      0x36, 0x4f, 0x0f, 0x15, 0x53, 0x88, 0x30, 0xbf, 0x38, 0xa9, 0xaa,
      0xd0, 0xb2, 0xc3, 0xf3, 0x0b, 0x2e, 0x09, 0xf2, 0x4f, 0x39, 0xa4,
      0x75, 0x29, 0x0e, 0x2e, 0x28, 0x2a, 0x7d, 0x66, 0x19, 0xeb, 0x5e,
      0xaa, 0xcd, 0xa9, 0xc5, 0x74, 0x1d, 0x82, 0xf9, 0x9b},
     // publicKeyDigest
     {0x35, 0x68, 0x4f, 0xbd, 0x44, 0x1a, 0x53, 0xdf, 0x57, 0xac, 0x9a,
      0x23, 0xac, 0xab, 0x39, 0x75, 0xe5, 0xa9, 0x3b, 0x98, 0xc5, 0x7a,
      0x8e, 0xa4, 0x48, 0x23, 0x4c, 0x45, 0xc4, 0xcb, 0x09, 0xe4},
     // privateKeyDigest
     {0x05, 0x38, 0x58, 0xf7, 0xa8, 0xaf, 0x69, 0xc2, 0x51, 0x54, 0xe6,
      0x7a, 0xa6, 0xb9, 0xca, 0x00, 0x32, 0xdc, 0x80, 0x54, 0x0a, 0x08,
      0xea, 0xfe, 0x61, 0xd8, 0x19, 0xae, 0x8b, 0xfb, 0x80, 0x10}},
    // tcID: 55
    {55,
     params_ml_kem1024,
     // seed
     {0xb2, 0x49, 0x59, 0x28, 0x11, 0x97, 0xad, 0x7c, 0x58, 0x34, 0x85,
      0x2d, 0xd1, 0x45, 0xa3, 0xa5, 0xf8, 0x0c, 0xf7, 0xcb, 0xf8, 0x77,
      0xcb, 0x5c, 0xf1, 0x1e, 0x58, 0x3b, 0xf4, 0x67, 0x61, 0x62, 0x2b,
      0x2b, 0xc5, 0x32, 0xe1, 0xb9, 0xd3, 0x07, 0x39, 0xca, 0x9c, 0x68,
      0x02, 0x96, 0xc7, 0x65, 0x44, 0x64, 0x45, 0x5e, 0xd2, 0xc9, 0x5a,
      0x77, 0x7c, 0x3b, 0xe1, 0xe4, 0x9e, 0xe7, 0x46, 0xf4},
     // publicKeyDigest
     {0x28, 0x4f, 0x59, 0x22, 0xe1, 0xfa, 0xdb, 0x42, 0x1c, 0xc7, 0x25,
      0xf6, 0x49, 0xa4, 0x66, 0xa7, 0xaa, 0x9d, 0x04, 0xc0, 0x9f, 0x8c,
      0x42, 0xea, 0xf6, 0xcb, 0x63, 0xa3, 0x63, 0x21, 0x50, 0x03},
     // privateKeyDigest
     {0x11, 0xf0, 0xa0, 0x95, 0xb3, 0x12, 0xb7, 0xca, 0x6e, 0x95, 0xc4,
      0x5b, 0xe4, 0x67, 0xab, 0x9e, 0x79, 0xa9, 0xea, 0xed, 0x5d, 0x15,
      0x03, 0x6e, 0x30, 0x85, 0x6a, 0x67, 0x51, 0x50, 0xaa, 0x14}},
    // tcID: 56
    {56,
     params_ml_kem1024,
     // seed
     {0x40, 0xd4, 0xf3, 0x2f, 0x98, 0x71, 0xe5, 0xdc, 0x36, 0x7e, 0x06,
      0x0e, 0xb1, 0x8c, 0xa4, 0xc8, 0xe5, 0x9f, 0x5a, 0x3e, 0x51, 0x17,
      0x22, 0x20, 0x37, 0x5e, 0x16, 0xd6, 0x1e, 0x5e, 0x66, 0xb6, 0xde,
      0x53, 0xef, 0xec, 0x91, 0xf6, 0xd9, 0x9d, 0x54, 0xf1, 0x9b, 0x33,
      0x13, 0xc1, 0xb2, 0x56, 0xca, 0x0a, 0x4c, 0x92, 0x05, 0xca, 0x0c,
      0x2f, 0xc1, 0x85, 0x26, 0x72, 0x0f, 0x39, 0xce, 0xd1},
     // publicKeyDigest
     {0x09, 0x9a, 0xb7, 0x2f, 0x8f, 0xc5, 0x20, 0xfd, 0xca, 0x2a, 0x08,
      0x00, 0x97, 0xec, 0x6f, 0xa0, 0x27, 0x04, 0x9e, 0x7a, 0x9a, 0xda,
      0x0a, 0x06, 0x20, 0x31, 0x7d, 0xaa, 0xc4, 0x07, 0x80, 0xae},
     // privateKeyDigest
     {0x16, 0x8f, 0x2d, 0x9e, 0x42, 0x1e, 0xb9, 0xde, 0xc3, 0xb9, 0x26,
      0x28, 0x4d, 0x6c, 0xa6, 0x8f, 0x1b, 0xef, 0xef, 0x77, 0x25, 0x7c,
      0xdb, 0x43, 0xd9, 0x3d, 0x8d, 0x9f, 0x76, 0x78, 0x1c, 0xd6}},
    // tcID: 57
    {57,
     params_ml_kem1024,
     // seed
     {0x2c, 0xd2, 0xb4, 0x4c, 0x92, 0xc0, 0x66, 0x4c, 0x7f, 0xbf, 0x20,
      0x9d, 0xaa, 0x94, 0x6a, 0x46, 0x1f, 0x46, 0xc4, 0xa5, 0x71, 0x63,
      0xbd, 0x50, 0xc0, 0xa4, 0xf9, 0xda, 0x99, 0xc9, 0x76, 0xab, 0x60,
      0x25, 0x46, 0x03, 0x86, 0xc1, 0x99, 0x3d, 0x77, 0x4e, 0x12, 0x07,
      0x37, 0x67, 0x62, 0xc2, 0x09, 0x0f, 0x99, 0x8b, 0xb0, 0x66, 0x9b,
      0x73, 0xd6, 0x3a, 0x0d, 0x2b, 0xfd, 0xde, 0x9a, 0x91},
     // publicKeyDigest
     {0x36, 0x54, 0x8a, 0x71, 0x8a, 0x2f, 0x37, 0x9c, 0x86, 0x70, 0x22,
      0xcf, 0xef, 0xb7, 0xb2, 0x28, 0xb4, 0x8b, 0x57, 0xe6, 0x1e, 0x6c,
      0xa3, 0x48, 0x92, 0x26, 0xca, 0xb9, 0x68, 0xfb, 0x30, 0x21},
     // privateKeyDigest
     {0xf8, 0x31, 0x16, 0x4c, 0x23, 0xe3, 0x8f, 0xc3, 0x4e, 0xc3, 0x39,
      0x82, 0x14, 0xe5, 0x36, 0xed, 0x6a, 0xfa, 0xa1, 0x9e, 0x0a, 0x92,
      0x41, 0xc7, 0xc7, 0xb4, 0x22, 0xe0, 0x6b, 0x6e, 0x2a, 0xfa}},
    // tcID: 58
    {58,
     params_ml_kem1024,
     // seed
     {0x8e, 0x9b, 0x03, 0xaa, 0xc5, 0x43, 0x9f, 0x1c, 0x16, 0xde, 0x8c,
      0x2b, 0x1d, 0x5e, 0x2e, 0xcf, 0x3c, 0xb1, 0x6d, 0x13, 0x84, 0x5c,
      0x4c, 0xb0, 0xdd, 0xf7, 0x73, 0x0b, 0x51, 0x98, 0xd6, 0x4e, 0x2c,
      0x07, 0xc5, 0xa4, 0xf0, 0x41, 0x28, 0xe8, 0xaf, 0xcf, 0xa2, 0x62,
      0x48, 0xc8, 0x11, 0x3a, 0x42, 0x16, 0xa0, 0x84, 0x10, 0xf2, 0x8a,
      0x54, 0x40, 0xf4, 0xeb, 0xee, 0x2b, 0x4e, 0xec, 0xb8},
     // publicKeyDigest
     {0xfd, 0x71, 0x01, 0x7d, 0x48, 0x1a, 0xe6, 0x73, 0x13, 0x08, 0xa1,
      0x98, 0x7a, 0x3c, 0xbc, 0x2c, 0x9d, 0x1b, 0x9c, 0x3a, 0xc5, 0xd2,
      0xca, 0xa2, 0xe3, 0x3e, 0x03, 0x1e, 0x94, 0xb5, 0xaa, 0xae},
     // privateKeyDigest
     {0x1c, 0x1f, 0x61, 0x5a, 0x9a, 0xdd, 0x4b, 0x05, 0x7d, 0x27, 0x87,
      0x9d, 0xdb, 0x85, 0x20, 0x70, 0x4c, 0xc7, 0x8e, 0x0f, 0xd2, 0xd3,
      0xa0, 0x17, 0x87, 0x04, 0x9a, 0x4e, 0x51, 0x73, 0x25, 0xcd}},
    // tcID: 59
    {59,
     params_ml_kem1024,
     // seed
     {0x87, 0x4e, 0x71, 0xd5, 0xde, 0xbd, 0xac, 0x24, 0x68, 0xd8, 0x9d,
      0xdb, 0x4b, 0x0c, 0x1b, 0x27, 0x76, 0x6a, 0x94, 0xd9, 0x05, 0x59,
      0x1d, 0x8e, 0x60, 0x8f, 0x57, 0x15, 0xee, 0xc5, 0x3f, 0x3c, 0x7e,
      0xa8, 0xca, 0xd3, 0x46, 0x5d, 0x01, 0xbb, 0xb2, 0x27, 0xc9, 0xd3,
      0xf1, 0xe0, 0xdc, 0x79, 0x42, 0x51, 0xcc, 0x8f, 0xe6, 0x5f, 0x6f,
      0x51, 0x21, 0xb8, 0x32, 0xe0, 0x78, 0x5f, 0x4b, 0x32},
     // publicKeyDigest
     {0xac, 0xc8, 0x44, 0xb3, 0xf8, 0x87, 0xf1, 0xe5, 0xb7, 0xbf, 0xba,
      0x07, 0x32, 0xa4, 0xbc, 0x47, 0x51, 0xfa, 0x39, 0x43, 0xd4, 0x31,
      0x7c, 0xdb, 0x2e, 0x7e, 0x55, 0xe2, 0x9a, 0xa5, 0x1f, 0x20},
     // privateKeyDigest
     {0x1c, 0x8e, 0x7d, 0xc7, 0x4b, 0x97, 0x1e, 0x86, 0x71, 0x9c, 0x31,
      0x4f, 0xd0, 0xbd, 0x2f, 0x10, 0x9d, 0x76, 0xb6, 0x88, 0x30, 0x4e,
      0xb6, 0x52, 0xc3, 0x6f, 0x10, 0x50, 0xa7, 0x1a, 0xe3, 0x02}},
    // tcID: 60
    {60,
     params_ml_kem1024,
     // seed
     {0xe8, 0x96, 0xca, 0x8f, 0x85, 0xb5, 0x01, 0xc4, 0x99, 0x27, 0x25,
      0xe2, 0xa5, 0x4f, 0xc8, 0x03, 0xd0, 0xd0, 0xc8, 0xf5, 0x3f, 0x03,
      0x97, 0xf7, 0x0a, 0x34, 0x04, 0xaa, 0x4d, 0x01, 0xce, 0xb0, 0xac,
      0x32, 0x31, 0x30, 0x6c, 0x34, 0x82, 0xf8, 0xc1, 0x01, 0xe9, 0x67,
      0x75, 0x21, 0x04, 0x76, 0x7a, 0x9b, 0x4b, 0x45, 0x15, 0x97, 0xeb,
      0x1a, 0xc6, 0x36, 0xc4, 0x07, 0xad, 0xc2, 0xc6, 0x82},
     // publicKeyDigest
     {0xb4, 0x80, 0x6b, 0x96, 0x13, 0x36, 0x51, 0x0a, 0x82, 0x25, 0x9b,
      0x1b, 0x5b, 0xc7, 0x17, 0x73, 0xad, 0x66, 0xdf, 0x97, 0x9b, 0x92,
      0x4b, 0x4a, 0x12, 0x31, 0x46, 0x8e, 0x89, 0x33, 0x39, 0x1f},
     // privateKeyDigest
     {0xac, 0xef, 0xd4, 0xc7, 0xa1, 0x85, 0x06, 0x59, 0xb7, 0x09, 0x06,
      0x36, 0x76, 0x4a, 0x3b, 0xf2, 0x99, 0x2f, 0xd1, 0x4c, 0x1d, 0xca,
      0x62, 0x08, 0x67, 0xbe, 0xaa, 0x0f, 0x67, 0x8f, 0x51, 0x6d}},
    // tcID: 61
    {61,
     params_ml_kem1024,
     // seed
     {0xf1, 0xa9, 0x72, 0x3f, 0x63, 0x3a, 0xc8, 0x77, 0xa2, 0x61, 0xcd,
      0xf8, 0x2d, 0xc1, 0x76, 0xd0, 0xf4, 0xe2, 0x48, 0xdb, 0x4d, 0x83,
      0x38, 0xca, 0xc7, 0xfa, 0xc4, 0xdf, 0x04, 0xa0, 0x8f, 0x8f, 0x33,
      0xe7, 0xfb, 0xea, 0xdb, 0xcb, 0xd1, 0x94, 0xb7, 0x23, 0xb7, 0xc1,
      0x8f, 0xbc, 0x33, 0xba, 0xa9, 0x35, 0x27, 0x00, 0xa9, 0xa7, 0x46,
      0xed, 0x93, 0x4d, 0x0b, 0x34, 0xce, 0x7f, 0x9a, 0x59},
     // publicKeyDigest
     {0xd3, 0xd9, 0x7c, 0x33, 0x38, 0xfd, 0x13, 0x87, 0x20, 0x93, 0x2c,
      0x67, 0xaf, 0x45, 0x85, 0x4b, 0x91, 0x96, 0xdf, 0x6f, 0x92, 0x8d,
      0xac, 0x1b, 0x4a, 0xbd, 0x36, 0x1f, 0xd5, 0x7e, 0xfa, 0x92},
     // privateKeyDigest
     {0x08, 0x65, 0xd4, 0x43, 0x64, 0xd5, 0x5c, 0x5e, 0x6b, 0x5b, 0x96,
      0x4a, 0x67, 0x3c, 0x34, 0x63, 0xfb, 0x1c, 0x34, 0x44, 0x1d, 0x3a,
      0x16, 0x33, 0xc2, 0xc3, 0xf4, 0x14, 0x8e, 0xe7, 0xf1, 0x5a}},
    // tcID: 62
    {62,
     params_ml_kem1024,
     // seed
     {0x3a, 0xcf, 0x40, 0xda, 0xde, 0xb7, 0xfd, 0x85, 0x4d, 0x44, 0x5a,
      0xb2, 0x40, 0x2e, 0x81, 0xf6, 0x23, 0x74, 0x02, 0xbf, 0xb0, 0x4e,
      0x7b, 0xbb, 0x72, 0xc9, 0xe8, 0x87, 0x57, 0x2f, 0xb5, 0xba, 0xd2,
      0xf0, 0xa3, 0x88, 0x8a, 0xe7, 0x5b, 0x13, 0xd2, 0xca, 0x4e, 0xdb,
      0xc8, 0x73, 0x85, 0xb4, 0x4f, 0xe3, 0xfd, 0xb7, 0x04, 0x6e, 0xb2,
      0xdd, 0x58, 0xcb, 0xc2, 0x3a, 0xcb, 0xcf, 0x50, 0x9c},
     // publicKeyDigest
     {0x18, 0x0a, 0x9d, 0xac, 0x20, 0x73, 0x09, 0x7c, 0x7b, 0xd0, 0xb1,
      0xcd, 0x7e, 0x21, 0x60, 0xac, 0x7c, 0xcc, 0xf9, 0x32, 0x97, 0x14,
      0x69, 0x80, 0x56, 0x1a, 0x53, 0x9b, 0xc8, 0x0c, 0x0a, 0xc1},
     // privateKeyDigest
     {0xa5, 0x78, 0x4b, 0xcb, 0x54, 0x4c, 0x94, 0xb0, 0xda, 0x54, 0x89,
      0x11, 0x04, 0x89, 0xff, 0x69, 0x65, 0x67, 0x38, 0xd1, 0x7e, 0xa0,
      0xe5, 0xac, 0xa0, 0x8d, 0x41, 0x1b, 0x07, 0x98, 0x6a, 0x78}},
    // tcID: 63
    {63,
     params_ml_kem1024,
     // seed
     {0x35, 0x82, 0x20, 0x49, 0x02, 0x8f, 0xab, 0x4e, 0x31, 0xa6, 0x09,
      0xe4, 0xe3, 0xa3, 0x9c, 0x9c, 0x32, 0xa6, 0x2e, 0xd6, 0xe7, 0x32,
      0xdf, 0x6f, 0x2c, 0x1b, 0x48, 0xca, 0xd0, 0xae, 0x80, 0x00, 0x60,
      0x8e, 0x79, 0x16, 0x5f, 0x35, 0xc4, 0x18, 0x25, 0x64, 0x3f, 0x76,
      0x8c, 0xe1, 0xe5, 0x1b, 0xb9, 0xb6, 0x0e, 0xca, 0xca, 0x0e, 0x6b,
      0xaf, 0x98, 0x7f, 0x7f, 0xc7, 0xa7, 0xd1, 0xb3, 0x71},
     // publicKeyDigest
     {0x73, 0x88, 0xc5, 0x53, 0x95, 0x96, 0x66, 0xbd, 0xf2, 0x3c, 0xb1,
      0x0c, 0xda, 0x4c, 0x37, 0xf9, 0xd9, 0xca, 0xb1, 0x71, 0x0a, 0x7a,
      0x82, 0x02, 0xa7, 0xfe, 0x1b, 0xb4, 0x37, 0x6c, 0xc0, 0x59},
     // privateKeyDigest
     {0xa3, 0xed, 0x1c, 0xce, 0x65, 0xe6, 0xec, 0x13, 0x2a, 0x2a, 0x96,
      0x39, 0x53, 0xac, 0x88, 0x17, 0x3c, 0x42, 0x89, 0x4a, 0x66, 0x8f,
      0x31, 0x45, 0xdf, 0x1f, 0x29, 0x70, 0x2d, 0x86, 0xd4, 0x34}},
    // tcID: 64
    {64,
     params_ml_kem1024,
     // seed
     {0xce, 0x21, 0x96, 0x0e, 0x11, 0xba, 0xe7, 0xba, 0x5a, 0x2a, 0xf5,
      0xaa, 0x5a, 0x45, 0x18, 0xf2, 0xc9, 0x7c, 0xdd, 0x41, 0x50, 0x41,
      0x3e, 0xe3, 0x65, 0x1b, 0x91, 0xcf, 0xc8, 0x5d, 0x78, 0x73, 0x3f,
      0x88, 0x03, 0xd5, 0xbe, 0x3f, 0x59, 0xe6, 0x9b, 0x82, 0x21, 0xe7,
      0xcb, 0x8c, 0x9d, 0x15, 0x82, 0x8b, 0x96, 0xb5, 0xb8, 0xcb, 0xb9,
      0xd2, 0xf7, 0x54, 0x4d, 0x6a, 0xa0, 0x83, 0x3c, 0x7b},
     // publicKeyDigest
     {0xe2, 0xa3, 0x66, 0xf8, 0xf2, 0x1c, 0xb4, 0xf5, 0xce, 0x24, 0x4c,
      0x18, 0x71, 0x96, 0x31, 0x94, 0x35, 0xf2, 0x89, 0xf7, 0xfe, 0xa6,
      0x10, 0xb1, 0x85, 0x91, 0xf0, 0x02, 0xb9, 0x80, 0xeb, 0x72},
     // privateKeyDigest
     {0xe5, 0x80, 0x9b, 0xf8, 0x34, 0x25, 0xdd, 0x43, 0xf1, 0x57, 0x35,
      0xbf, 0x4b, 0x32, 0xba, 0xb3, 0x1c, 0x0a, 0xf1, 0xdd, 0xda, 0x7f,
      0xe6, 0x07, 0xbb, 0x04, 0xd9, 0x9f, 0xfa, 0xbe, 0x4b, 0x18}},
    // tcID: 65
    {65,
     params_ml_kem1024,
     // seed
     {0x83, 0x75, 0x22, 0x82, 0x17, 0xb8, 0xd9, 0x4c, 0xdc, 0xbb, 0x2e,
      0x6e, 0x7e, 0xb6, 0xe1, 0xed, 0x7f, 0xa9, 0xb4, 0xba, 0x7a, 0x7d,
      0xc9, 0x52, 0xe9, 0x70, 0xc4, 0x01, 0x67, 0x5d, 0x49, 0x1b, 0x0e,
      0x28, 0x32, 0xe1, 0x2e, 0x96, 0x42, 0x43, 0x27, 0x93, 0xec, 0xc1,
      0x7d, 0xa1, 0x8d, 0x61, 0x32, 0x36, 0x47, 0xcc, 0x6f, 0x5e, 0x1a,
      0xb6, 0x57, 0x51, 0x18, 0x5a, 0xfc, 0x00, 0xdf, 0xc9},
     // publicKeyDigest
     {0x0d, 0xfe, 0xaf, 0x9e, 0xb1, 0xea, 0x5e, 0x88, 0x82, 0x71, 0x99,
      0x18, 0xca, 0xbe, 0x6a, 0xc0, 0xc1, 0x5f, 0xe3, 0x58, 0x7e, 0x3e,
      0x7b, 0xe5, 0x33, 0x92, 0xed, 0xec, 0x5f, 0x7d, 0x95, 0xf0},
     // privateKeyDigest
     {0xf8, 0xa9, 0xcf, 0xc6, 0x37, 0x45, 0x68, 0x78, 0x87, 0xbb, 0x8f,
      0x58, 0xd4, 0x67, 0x59, 0xc3, 0x15, 0x2a, 0xb9, 0xae, 0xe0, 0x21,
      0x42, 0xdd, 0x95, 0x7b, 0xf2, 0xdd, 0x23, 0x8f, 0xad, 0x7a}},
    // tcID: 66
    {66,
     params_ml_kem1024,
     // seed
     {0x6f, 0x20, 0x0e, 0x05, 0x37, 0x1a, 0xb5, 0xaa, 0x6c, 0x2d, 0xda,
      0x50, 0x7d, 0x4c, 0x70, 0x39, 0xe7, 0xd6, 0xf4, 0x00, 0x0c, 0xf6,
      0x04, 0xf1, 0xb5, 0x42, 0x1c, 0xac, 0x1c, 0xf4, 0x7d, 0xb6, 0x5b,
      0xda, 0xbb, 0x79, 0xcd, 0xe5, 0xf2, 0xb6, 0xd8, 0x19, 0x44, 0x1e,
      0xc7, 0x99, 0x1b, 0xf4, 0x35, 0x47, 0x39, 0xf8, 0xd1, 0x7d, 0x45,
      0x2a, 0x9a, 0xdc, 0xeb, 0x2a, 0xd0, 0x8d, 0xc3, 0xb0},
     // publicKeyDigest
     {0xe8, 0xe0, 0x3c, 0xc3, 0xdc, 0x39, 0x4e, 0x2d, 0x3b, 0x2b, 0xd6,
      0xfe, 0x15, 0xa0, 0x37, 0xb5, 0x08, 0xb2, 0xa3, 0xfb, 0x9d, 0x0f,
      0x18, 0x2f, 0x30, 0x8d, 0xcb, 0x19, 0x2b, 0x50, 0x3f, 0xaf},
     // privateKeyDigest
     {0xa4, 0x3f, 0x3a, 0x60, 0xac, 0xb3, 0x18, 0xb2, 0xff, 0x5b, 0xb4,
      0x45, 0x39, 0x42, 0x3b, 0x20, 0x75, 0xfb, 0x14, 0x15, 0x40, 0xae,
      0x9f, 0x85, 0xae, 0xb5, 0x26, 0x1b, 0x46, 0x28, 0x34, 0x7d}},
    // tcID: 67
    {67,
     params_ml_kem1024,
     // seed
     {0x74, 0x90, 0x50, 0x34, 0xd5, 0x3f, 0x69, 0x8b, 0x8c, 0xe1, 0x2d,
      0x78, 0xe4, 0x53, 0xef, 0x68, 0x7a, 0x53, 0x05, 0xf4, 0xf6, 0xae,
      0x5c, 0x6f, 0xe3, 0x33, 0x58, 0xdd, 0x10, 0x38, 0xd4, 0x9d, 0x54,
      0x56, 0xe6, 0x2f, 0x99, 0xc5, 0x94, 0x86, 0xcc, 0x68, 0xa7, 0xee,
      0xa9, 0x19, 0xd3, 0x69, 0x3b, 0xd7, 0x9d, 0xb9, 0xfa, 0x22, 0x84,
      0x5a, 0xc0, 0xe9, 0xf9, 0x6a, 0xc6, 0x36, 0xf3, 0x34},
     // publicKeyDigest
     {0x4c, 0x9f, 0xb2, 0x76, 0x63, 0x6d, 0x32, 0xe6, 0xd2, 0xac, 0x2d,
      0x03, 0x46, 0x71, 0xb7, 0x03, 0x84, 0x8a, 0x87, 0xe2, 0xc7, 0x52,
      0xea, 0x69, 0x07, 0x9a, 0x45, 0xc0, 0xeb, 0xf3, 0x70, 0x59},
     // privateKeyDigest
     {0xd2, 0x85, 0x33, 0x04, 0xf7, 0x94, 0xdf, 0x7f, 0xe1, 0x7b, 0xe8,
      0xc3, 0x53, 0x80, 0xbd, 0xdd, 0x91, 0x87, 0x86, 0xef, 0x35, 0x58,
      0x93, 0xf5, 0x15, 0x20, 0x81, 0x4d, 0xff, 0x1f, 0x3e, 0x08}},
    // tcID: 68
    {68,
     params_ml_kem1024,
     // seed
     {0xa1, 0x6b, 0xb3, 0xa4, 0x88, 0x42, 0x56, 0x37, 0xa5, 0xb7, 0x35,
      0x67, 0x69, 0x74, 0xee, 0xec, 0xa2, 0x6e, 0xd8, 0x09, 0x03, 0xf5,
      0xcb, 0xac, 0x9e, 0x6d, 0x71, 0x2e, 0x67, 0xee, 0x91, 0x8f, 0x58,
      0x87, 0x97, 0x8a, 0x16, 0x8c, 0xfe, 0x2e, 0xc2, 0x3b, 0xb9, 0x3a,
      0x73, 0x0a, 0xd6, 0xee, 0x4b, 0xdb, 0xd5, 0x33, 0x89, 0xc4, 0xf4,
      0x38, 0xf5, 0xca, 0x31, 0x86, 0x70, 0x19, 0x73, 0x5f},
     // publicKeyDigest
     {0x0d, 0xf2, 0x2a, 0x4c, 0xa6, 0x62, 0x65, 0x28, 0x34, 0x40, 0x2f,
      0x87, 0x00, 0x1d, 0xb0, 0x7a, 0x90, 0x0e, 0x88, 0x41, 0xd5, 0xa7,
      0xaf, 0x29, 0x3c, 0x7b, 0x39, 0x01, 0xfc, 0x2b, 0x88, 0xa2},
     // privateKeyDigest
     {0x8c, 0x04, 0xbf, 0xb8, 0xec, 0x01, 0x8e, 0xbb, 0xdf, 0xe5, 0x94,
      0x95, 0xd2, 0xdb, 0x49, 0xc3, 0x3b, 0x7b, 0x61, 0x76, 0x03, 0xb9,
      0x08, 0xdc, 0x5f, 0x98, 0x09, 0x01, 0x29, 0xc2, 0x99, 0x1e}},
    // tcID: 69
    {69,
     params_ml_kem1024,
     // seed
     {0xe6, 0x95, 0xd1, 0x12, 0x92, 0x65, 0x67, 0xfe, 0x59, 0xae, 0x67,
      0x0a, 0x44, 0x9e, 0x67, 0x00, 0xf7, 0xfa, 0xda, 0xa8, 0xc7, 0x99,
      0x20, 0xa7, 0xd2, 0x97, 0xc1, 0x1f, 0xb2, 0xcf, 0x91, 0x8f, 0x28,
      0x15, 0xcf, 0x58, 0xba, 0x29, 0xf2, 0x19, 0x97, 0x1b, 0xd4, 0x44,
      0x40, 0x4a, 0x3f, 0xd2, 0x93, 0x09, 0x5a, 0x1b, 0xa1, 0x8d, 0xe7,
      0xb6, 0xed, 0x8b, 0x3c, 0x85, 0x7e, 0xff, 0x19, 0x2d},
     // publicKeyDigest
     {0x21, 0x35, 0xf1, 0x5c, 0x68, 0x70, 0x28, 0x3c, 0xef, 0x75, 0xaf,
      0x56, 0xa9, 0x32, 0xd1, 0x3f, 0xe5, 0x92, 0x27, 0xe7, 0x7b, 0x17,
      0x8a, 0x6e, 0x3d, 0xb9, 0x45, 0xfd, 0x0f, 0xb5, 0x74, 0x9e},
     // privateKeyDigest
     {0xa3, 0x73, 0x0a, 0x12, 0x8f, 0x26, 0xcc, 0xcf, 0xdd, 0xcc, 0xd0,
      0x3a, 0x72, 0x50, 0x44, 0x2f, 0xab, 0x00, 0x1a, 0x1e, 0x8c, 0x7d,
      0xbd, 0xf6, 0x2e, 0x20, 0x89, 0x1e, 0x63, 0xce, 0x52, 0xcb}},
    // tcID: 70
    {70,
     params_ml_kem1024,
     // seed
     {0xf0, 0x41, 0x0c, 0x49, 0x58, 0xf8, 0x91, 0x56, 0x39, 0x1f, 0x10,
      0xba, 0xd2, 0x90, 0x68, 0x95, 0x20, 0x36, 0xf8, 0x04, 0x50, 0x6c,
      0x99, 0x77, 0xaf, 0x15, 0x8e, 0xcb, 0xde, 0x1b, 0x8f, 0x38, 0x97,
      0x93, 0xbb, 0x2b, 0x4f, 0x48, 0xf1, 0x23, 0xf5, 0x3b, 0xb9, 0x7e,
      0xa7, 0xc5, 0x1e, 0xc6, 0xef, 0x00, 0x3e, 0xa5, 0xe1, 0x95, 0x23,
      0xac, 0x6d, 0x5b, 0x91, 0x4a, 0x1c, 0x87, 0x92, 0xf3},
     // publicKeyDigest
     {0x77, 0x11, 0xd5, 0x50, 0xb5, 0x2d, 0xec, 0x8e, 0xdb, 0x2b, 0x8c,
      0xf2, 0x66, 0xc4, 0x7c, 0xb0, 0xda, 0x8b, 0xf2, 0xc5, 0xea, 0xae,
      0x0e, 0xbe, 0x74, 0x6a, 0xce, 0xc9, 0x94, 0x6e, 0x0b, 0x1b},
     // privateKeyDigest
     {0x1c, 0xe6, 0xe2, 0x16, 0x41, 0x40, 0xb9, 0x4a, 0xbb, 0x84, 0x6b,
      0xab, 0xf0, 0x5d, 0xfd, 0xd5, 0xa4, 0x99, 0x72, 0xca, 0x9c, 0x6d,
      0x8f, 0x37, 0x54, 0x6d, 0xe8, 0x7c, 0x7e, 0x76, 0xfa, 0x98}},
    // tcID: 71
    {71,
     params_ml_kem1024,
     // seed
     {0x46, 0xfb, 0x51, 0x10, 0x79, 0xdb, 0x83, 0x48, 0x80, 0xd3, 0xcb,
      0x88, 0xd7, 0x82, 0x3c, 0x6c, 0xb3, 0x59, 0xa0, 0xfd, 0x59, 0x98,
      0x80, 0xc7, 0xf8, 0xde, 0x24, 0x4b, 0x36, 0x25, 0x9a, 0xb8, 0x3b,
      0x5e, 0xea, 0x98, 0xe4, 0xda, 0x17, 0x33, 0x1d, 0xb6, 0x9a, 0xe7,
      0xd8, 0x37, 0x1e, 0x5d, 0xc7, 0xe0, 0x2b, 0xf4, 0xfc, 0xad, 0xf9,
      0x31, 0x94, 0x35, 0xea, 0x91, 0x0f, 0xa0, 0xff, 0x1b},
     // publicKeyDigest
     {0x4c, 0x7d, 0x85, 0x52, 0xa4, 0x3d, 0x0d, 0x56, 0x9e, 0x74, 0x73,
      0x34, 0xce, 0xed, 0x18, 0x77, 0xda, 0xdd, 0xde, 0xcb, 0x6a, 0xed,
      0x06, 0x07, 0x23, 0xfb, 0xa4, 0xc6, 0x14, 0x2e, 0xd9, 0xb5},
     // privateKeyDigest
     {0xa5, 0x19, 0xe8, 0x65, 0xcc, 0xae, 0xd7, 0xc7, 0xe1, 0xfd, 0xa7,
      0xe0, 0x58, 0x36, 0x35, 0x32, 0xe2, 0xcf, 0xe3, 0x42, 0x11, 0x10,
      0x54, 0x00, 0x2d, 0xbe, 0x22, 0xcd, 0x8c, 0xad, 0x32, 0xbc}},
    // tcID: 72
    {72,
     params_ml_kem1024,
     // seed
     {0x28, 0xd7, 0xda, 0xe6, 0xe1, 0xa1, 0x56, 0x68, 0xa6, 0x1a, 0x2a,
      0xd4, 0x9d, 0x1e, 0xa0, 0x71, 0xac, 0xad, 0x73, 0x26, 0x06, 0xda,
      0x5b, 0x36, 0xce, 0x7b, 0x63, 0x8c, 0x9a, 0x5f, 0xdc, 0x6d, 0xc8,
      0x66, 0xd2, 0x6c, 0x3e, 0xbc, 0xfb, 0x89, 0xae, 0x9f, 0x89, 0xbd,
      0x2c, 0x48, 0xdc, 0x7e, 0xc6, 0xd9, 0x6f, 0x12, 0x05, 0x75, 0x01,
      0xfb, 0x44, 0x19, 0xa3, 0xdc, 0x2a, 0x05, 0x07, 0x30},
     // publicKeyDigest
     {0x18, 0xdd, 0x4c, 0x48, 0x49, 0x8d, 0xc0, 0x9b, 0x2c, 0xe9, 0x5d,
      0x95, 0x6d, 0xda, 0x72, 0x4a, 0xd4, 0x4c, 0xf0, 0x93, 0x96, 0xd0,
      0xf2, 0x6d, 0x99, 0xee, 0x2d, 0xc3, 0xe2, 0xe1, 0xbc, 0x7e},
     // privateKeyDigest
     {0x91, 0x76, 0xd9, 0xf2, 0xd7, 0x2d, 0xe2, 0x99, 0x14, 0xcd, 0x11,
      0xe2, 0x10, 0x9a, 0x4c, 0x7e, 0x7b, 0x88, 0x1b, 0x56, 0xd8, 0x4d,
      0x3e, 0x05, 0x2c, 0x8c, 0x3f, 0x66, 0xb8, 0x12, 0x1e, 0x10}},
    // tcID: 73
    {73,
     params_ml_kem1024,
     // seed
     {0x02, 0xa3, 0xdb, 0x08, 0x15, 0xdb, 0x51, 0x86, 0x78, 0xed, 0xc6,
      0xee, 0xe3, 0xad, 0x57, 0x0d, 0x3b, 0x31, 0x19, 0x74, 0x34, 0x16,
      0x3e, 0xf0, 0x1c, 0xe9, 0xf1, 0x2a, 0x31, 0x1f, 0xb3, 0xa3, 0x94,
      0x86, 0xa2, 0xbf, 0x28, 0x21, 0x82, 0x89, 0x41, 0x2e, 0x2a, 0x6a,
      0x2a, 0xea, 0x61, 0xab, 0x58, 0xd3, 0xfd, 0xd0, 0xd9, 0x0d, 0xd2,
      0xa4, 0x63, 0x03, 0x29, 0x98, 0x64, 0x93, 0xb5, 0xa2},
     // publicKeyDigest
     {0x08, 0x2c, 0x49, 0x58, 0xf0, 0x6d, 0xeb, 0x19, 0xcf, 0xae, 0x2a,
      0x64, 0x67, 0xad, 0x06, 0x7d, 0x07, 0x0f, 0x6e, 0xb3, 0xa5, 0xda,
      0x7a, 0x7f, 0xb9, 0xf9, 0x9b, 0x72, 0x95, 0x75, 0x8b, 0xf8},
     // privateKeyDigest
     {0xaf, 0x32, 0x41, 0xa2, 0xab, 0x8e, 0x4c, 0xf5, 0x58, 0x4f, 0x4f,
      0xbf, 0x43, 0xcd, 0x11, 0xed, 0x3b, 0x94, 0xde, 0x65, 0x28, 0xd1,
      0x60, 0x8d, 0xad, 0x9a, 0x0f, 0x9c, 0x2a, 0x8c, 0xf4, 0x6b}},
    // tcID: 74
    {74,
     params_ml_kem1024,
     // seed
     {0xfd, 0x95, 0x09, 0x96, 0x5f, 0x28, 0xd5, 0x49, 0x34, 0x35, 0x7d,
      0x48, 0xaa, 0x3a, 0x6c, 0xc1, 0x98, 0xcc, 0xc7, 0xff, 0xf7, 0x69,
      0xa4, 0x0a, 0x8c, 0x4d, 0xf0, 0xfd, 0xc1, 0x15, 0x60, 0x4b, 0x4d,
      0x65, 0x3f, 0xcd, 0xd5, 0x5d, 0x3d, 0x5f, 0x2e, 0x3c, 0x6b, 0x30,
      0xf4, 0x51, 0xb3, 0xdc, 0x57, 0x57, 0x4c, 0x84, 0x3e, 0xd8, 0xb0,
      0x3d, 0x63, 0xde, 0xf4, 0x9c, 0x88, 0x04, 0x86, 0x9f},
     // publicKeyDigest
     {0x58, 0xef, 0x79, 0x96, 0x42, 0xd8, 0x1d, 0x14, 0x84, 0xe4, 0x48,
      0x72, 0x8d, 0xd3, 0x47, 0xb7, 0xbf, 0x16, 0xc8, 0xb8, 0xd8, 0xa5,
      0x21, 0xf9, 0x14, 0x21, 0x51, 0x8b, 0x17, 0xe0, 0x33, 0xa4},
     // privateKeyDigest
     {0xf9, 0x8a, 0x31, 0x26, 0x5b, 0x3d, 0x55, 0x61, 0x7d, 0x32, 0x66,
      0x27, 0xe0, 0xc0, 0x17, 0x36, 0x7c, 0xb7, 0x18, 0xf9, 0xfb, 0x18,
      0x6a, 0x83, 0x81, 0x2a, 0x27, 0xa2, 0x55, 0x6e, 0x14, 0x46}},
    // tcID: 75
    {75,
     params_ml_kem1024,
     // seed
     {0x4c, 0xa2, 0xe9, 0x99, 0x41, 0xa6, 0x81, 0x20, 0xce, 0xc5, 0x7e,
      0x52, 0x21, 0x9e, 0xcd, 0xa0, 0x6c, 0xec, 0x3a, 0xe0, 0xa4, 0xc9,
      0x58, 0x45, 0x74, 0xfd, 0x20, 0x4e, 0x06, 0xc0, 0x7c, 0x57, 0x6b,
      0x65, 0xbc, 0x95, 0x39, 0x88, 0xe1, 0x6f, 0x28, 0xdd, 0xc1, 0x2a,
      0xc3, 0xb9, 0x27, 0xba, 0x2b, 0xf1, 0xea, 0x4c, 0xe5, 0x2f, 0x16,
      0x09, 0x37, 0x23, 0x21, 0x23, 0x16, 0xa9, 0xfe, 0x8f},
     // publicKeyDigest
     {0x18, 0x4a, 0x9f, 0x14, 0xdf, 0x0e, 0xe3, 0xe4, 0x7f, 0x1f, 0xd4,
      0xde, 0xb9, 0x5e, 0x1e, 0xde, 0xf1, 0xdd, 0x69, 0x81, 0x9e, 0xbc,
      0x81, 0x9c, 0x8a, 0xce, 0x92, 0xc3, 0x51, 0x85, 0xaa, 0xd6},
     // privateKeyDigest
     {0x84, 0xa0, 0xa8, 0x7d, 0xd9, 0xdb, 0xff, 0xfd, 0x62, 0x81, 0x19,
      0x3c, 0xb9, 0x55, 0x6c, 0x64, 0x5d, 0xee, 0xe3, 0xcb, 0x63, 0x50,
      0x85, 0xd0, 0xf7, 0x14, 0x56, 0x08, 0x30, 0xb8, 0x9d, 0xf7}}};

#endif  // mlkem_keygen_vectors_h__
