Name:           dnsjit
Version:        1.5.1
Release:        1%{?dist}
Summary:        Engine for capturing, parsing and replaying DNS
Group:          Productivity/Networking/DNS/Utilities

License:        GPL-3.0-or-later
URL:            https://codeberg.org/DNS-OARC/dnsjit
# Source needs to be generated by dist-tools/create-source-packages, see
# https://github.com/jelu/dist-tools
Source0:        %{name}_%{version}.orig.tar.gz

BuildRequires:  libpcap-devel
%if 0%{?suse_version} || 0%{?sle_version}
BuildRequires:  liblz4-devel
%else
BuildRequires:  lz4-devel
%endif
BuildRequires:  luajit-devel >= 2.0.0
BuildRequires:  lmdb-devel
BuildRequires:  ck-devel
BuildRequires:  gnutls-devel
BuildRequires:  libzstd-devel
BuildRequires:  zlib-devel
BuildRequires:  xz-devel
BuildRequires:  autoconf >= 2.64
BuildRequires:  automake
BuildRequires:  libtool

%description
dnsjit is a combination of parts taken from dsc, dnscap, drool,
and put together around Lua to create a script-based engine for easy
capturing, parsing and statistics gathering of DNS message while also
providing facilities for replaying DNS traffic.


%package devel
BuildArch:  noarch
Summary:    Engine for capturing, parsing and replaying DNS - development files
Group:      Development/Libraries/C and C++
Requires:   %{name}%{?_isa} = %{version}-%{release}
Requires:   libpcap-devel
Requires:   luajit-devel >= 2.0.0
Requires:   lmdb-devel
Requires:   ck-devel
Requires:   gnutls-devel
%if 0%{?suse_version} || 0%{?sle_version}
Requires:   liblz4-devel
%else
Requires:   lz4-devel
%endif
Requires:   libzstd-devel
Requires:   zlib-devel
Requires:   xz-devel

%description devel
dnsjit is a combination of parts taken from dsc, dnscap, drool,
and put together around Lua to create a script-based engine for easy
capturing, parsing and statistics gathering of DNS message while also
providing facilities for replaying DNS traffic.

This package includes development files needed to create dnsjit modules.


%prep
%setup -q -n %{name}_%{version}


%build
sh autogen.sh
%configure
%make_build


%install
%make_install


%check
%make_build test


%files
%{_bindir}/*
%{_datadir}/doc/*
%{_mandir}/man1/*
%{_mandir}/man3/*

%files devel
%{_includedir}/*


%changelog
* Wed Feb 04 2026 Jerry Lundström <lundstrom.jerry@gmail.com> 1.5.1-1
- Release v1.5.1
  * This patch release fixes a couple of things related to DNS labels and
    testing on big endian systems.
  * Changes:
    - Use RFC 3597 format for output of unknown types and classes
    - Fixed #267: Return root label instead of empty string
    - Fixed `Label.torfc1035()` to output non-printable bytes correctly as per RFC 1035 sec. 5.1.
  * Commits:
    28fb9be class/type rfc 3597
    932a196 copyright
    5bda1d7 Fix Label.torfc1035 to output non-printable bytes correctly
    9fcb5fd Make conditional tests for ipsplit line 122
    2e37903 root label to string
    15f0442 Use RFC 3597 format for output of unknown types and classes
    6e6dbf7 scan-build
    53f0c54 CI updates
    8484f54 builds
    80379e1 Migrate to Codeberg
    829627d fix gcov
* Wed Apr 16 2025 Jerry Lundström <lundstrom.jerry@gmail.com> 1.5.0-1
- Release v1.5.0
  * This releases adds a new function to return a label quoted as described
    in RFC 1035, adds support for link-type Linux cooked v2 and fixes
    padding calculations for UDP, IPv4 and IPv6 packets.
  * New:
    - `core.object.dns.label`: Add `torfc1035()`
    - `core.object`: Add `linuxsll2` object
    - `filter.layer`: Add support for DLT_LINUX_SLL2
    - `filter.copy`: Add support for DLT_LINUX_SLL2
  * Fixes:
    - Fix #250: handle endian in tests
    - Fix #252
      - `core.object.ip6`: Add `hlen` for total length of header with all extensions
      - `filter.layer`:
        - correct UDP padding calculation
        - Fix padding calculation for IPv4 packet when options exists
        - Fix padding calculation for IPv6 packets
        - Store `hlen` for IPv6 packets
      - Add test for padding
  * Other changes:
    - Simplify and speedup pcap2tcpdns example
  * Commits:
    d03a184 DLT_LINUX_SLL2
    1cd3836 torfc1035
    8d8746f Fix IPv6 hlen
    75b634b Padding
    b8bfcf8 Simplify and speedup pcap2tcpdns example
    e37bb92 Fix log name in examples/pcap2tcpdns.lua
    80b7c34 UDP padding
    9a28aee ipsplit endian
    375e9e8 SPEC
    c82c0ca RPM
    74fbda2 COPR tweaks
    3691bd8 RPM spec
* Wed Aug 28 2024 Jerry Lundström <lundstrom.jerry@gmail.com> 1.4.0-1
- Release 1.4.0
  * This release adds a new module `input.zmmpcap` to read compressed PCAPs
    using `mmap()`, changes how `core.thread` push/pop, removes signal
    blocking and squashes a few bugs.
  * For `core.thread`, the `push()`/`pop()` now uses `double` instead of
    `int64_t` to match the conversion table of LuaJIT and to support
    floating point numbers.
  * Updates:
    - `examples/dumpdns`:
      - Add support for reading PCAPs using `mmpcap` or `zmmpcap`
      - Add support for reading PCAPs from stdin
    - `zpcap`: Add support for reading zlib/lzma compressed PCAPs
  * Fixes:
    - Fix #234: Remove signal blocking
    - Fix #233: floating point numbers not supported by `dnsjit.core.thread` push/pop
    - Fix a potential memory leak in trie
    - `zpcap`: Fix incorrect check if having enough to read
  * Commits:
    b376ac9 Fix a potential memory leak in trie
    dfeb20e Badges
    e4fa047 Fix zzmpcap
    88b5ccf Compressed PCAPs, Copyright
    36b8266 thread push number
    0056736 thread push number
    0247ec6 Signals, code format
* Thu Dec 07 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 1.3.0-1
- Release 1.3.0
  * This release adds `core.object.dns:reset()` to reset DNS objects so they
    can be reused correctly.
  * Example scripts have been updated to reflect this along with correctly
    setting `includes_dnslen` for TCP packets.
  * New example converter `pcap2tcpdns` added that can be used to create bin
    files for replaying with `dnsperf -B`.
  * Commits:
    f0d0b39 pkg-config
    464a198 pcap2tcpdns
    b40ad6d example convertor from PCAP to TCP DNS format used by dnsperf -B option
    ac51bfd pkg-config
    198bae9 Copyright
    5a87e37 DNS reset, dnslen TCP
    f2d6b05 Doc
    265a577 COPR fix
* Mon Mar 21 2022 Jerry Lundström <lundstrom.jerry@gmail.com> 1.2.3-1
- Release 1.2.3
  * This patch release fixes compilation issues on FreeBSD for LLVM v12+.
  * Commits:
    4346a48 static inline
* Fri Nov 05 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 1.2.2-1
- Release 1.2.2
  * This patch release fixes a small issues with the generated
    compatibility code and updates the package control files for Debian.
  * Commits:
    3cdd801 Fix compat
    cb352c6 debhelper
* Wed Jul 07 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 1.2.1-1
- Release 1.2.1
  * This patch release fixes packages for SLE/openSUSE and the generation
    of an environment script for the stand-alone tool example.
  * Commits:
    9c6f630 SLE/openSUSE
    f07ac4a Stand-alone tool example
* Mon Jul 05 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 1.2.0-1
- Release 1.2.0
  * This release adds development files and autotool examples for C/Lua
    modules or stand-alone tools for dnsjit.
    In `examples/` you'll now also find:
    - `modules/input-example`
      This input example is based on `dnsjit.input.zero` which was a testing
      modules during the early days of dnsjit.
      It's a C module that generates empty objects for the receiver.
    - `modules/filter-example`:
      This filter example is C module that counts the number of objects
      passed to it before sending it to the receiver.
    - `modules/output-example`:
      This output example is based on `dnsjit.output.null` which was a testing
      modules during the early days of dnsjit.
      It's a C module that will just discard objects it receives.
    - `modules/lib-example`:
      This example Lua module takes two `core_timespec_t` C objects and gives
      the duration between them as a string.
    - `stand-alone-tool`:
      This example is based on `test_pcap_read.lua` and `test_throughput.lua`
      which was previous located in `examples/`.
      There are two installable Lua programs and shows how to depend on
      a dnsjit version, depend on specific dnsjit modules and how to run
      tests using `make test`.
  * All these examples can easily be copied and renamed to build and
    distribute your own dnsjit modules and tools, using autotool for
    `configure`, `make` and `make install`.
  * Development files will also be installed, or can be installed via
    `dnsjit-dev`/`dnsjit-devel` packages. All C headers have been prefixed
    with `dnsjit/` (for example `#include <dnsjit/version.h>`).
  * Thanks to this new setup, the module `output.dnssim` has been moved out
    from dnsjit's repository and placed in DNS shotgun's:
      https://gitlab.nic.cz/knot/shotgun/-/tree/master/replay/dnssim
    This will help CZ.NIC to maintain and release both the module and tool
    at the same time.
  * New modules:
    - Added `input.zpcap`, module for reading LZ4/ZSTD compressed PCAPs
    - Added `core.loader`, module for loading C modules using LuaJIT's `ffi` interface and `package.cpath`
    - Added `core.file` with `core_file_exists()`, a C function to check if a file exists
  * Other changes:
    - Add `<dnsjit/version.h>` for `DNSJIT_MAJOR_VERSION`, `DNSJIT_MINOR_VERSION`, `DNSJIT_PATCH_VERSION`
    - `dnsjit`: Remove version print on start
    - `dnsjit.input.zero`: Will `require("example.input.zero")` for backwards compatibility
    - `dnsjit.output.null`: Will `require("example.output.null")` for backwards compatibility
    - `core/timespec`: Add `:max_init()`, return a new object with maximum values set for seconds and nanoseconds.
    - `output/pcap`:
      - Update `open()` man-page, indicate usage of `pcap_dump_open()`
      - Add `have_errors()` to check for write errors during/after dumping
    - `input.fpcap`: Add `fadvise_sequential()` to advise sequential read of the file
    - `examples/dumpdns.lua`: Add support for dumping compressed PCAPs
  * Bugfixes:
    - `lib/getopt`: Fix short options, error if length is not 1
    - `core/timespec`: Fix typo in struct documentation
  * Commits:
    892ac65 example lib
    ae7e647 stand alone tool, dnsjit
    2d937a5 Package
    5c5ba74 Package
    6059bb5 Package
    48df46f zpcap
    ff13586 Remove dnssim
    389f274 filter example
    45e0102 output example
    9d76760 Example input
    f823db8 Example modules - input
    df12078 f/m-advise
    31ee04d WIP: Advise kernel that inputs are read sequentially
    eff6313 Output PCAP man-page, errors
    ac60fec Timespec
    cea7936 Bye Travis
    a5c967f getopt
    506ee99 getopt: detect incorrect short strings
* Wed Feb 03 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 1.1.0-1
- Release 1.1.0
  * This releases adds a new module for handling Base64 URLs and new calls
    for error handling and opening PCAPs using file descriptors, along with
    a bug fix in `lib.getopt` and other changes.
  * The `dnssim` module has also gotten its own version and changelog, this
    is to prepare it for being moved outside of dnsjit's repository in the
    future.
  * New modules, calls, features:
    - New `lib.base64url`: Utility library to convert data to base64url format
    - `core.log`: New call `Log.errstr()`: Convert error number to its text representation
    - `input.fpcap`: New call `Fpcap.openfp()`: Open a PCAP file for processing using a file descriptor, for example `io.stdin`
    - `output.dnssim`: Support for DNS-over-HTTPS
  * Bug fixes:
    - `lib.getopt`: Fix bug where `-` and `--` could not be used as arguments to options
  * Other changes:
    - Fix typo in configure help text
    - Add coverage
    - `filter.ipsplit`: Extend PRNG modulus to 2^31, new implementation is the same as glibc's `rand()`
    - `lib.ip`: Fix typo in documentation
    - `output.dnssim`:
      - This module now has it's own changelog
      - Updated to v20210129
      - Depend on libhttp2 for dnssim DNS-over-HTTPS capabilities
    - `output.pcap`: Log libpcap error when failing to open
    - SUSE packages now depend on moonjit because of lack of LuaJIT support
  * Commits:
    d001ccb m4
    4b63bce output/dnssim: add changelog
    7355810 output/dnssim: add version checks
    95fa6a9 input pcap/fpcap, getopt
    99c3d9f test/test_ipsplit: update to use new PRNG
    3235b09 filter/ipsplit: extend PRNG modulus to 2^31
    8ff81a0 fixup! input.fpcap: filename "-" reads from stdin
    63cf0a4 output/dnssim: fix regression in DoH GET
    367d0b8 input.pcap: document stdin feature of open_offline()
    8d94504 input.fpcap: filename "-" reads from stdin
    617058e getopt: accept singleton - also as option value
    7d7f17c output/dnssim: unify failed to bind error messages
    bdf1517 output/dnssim: add IPv4 support
    15a21da Sonarcloud
    ceeea1d SUSE
    1fc3c82 PR179
    2f5d38f output/dnssim: allow user-set instance log name
    b036c68 Info
    0af1ffb Travis, configure
    49bdc08 output/dnssim: implement udp(tcp_fallback) method
    b4f9cf9 man: update gitlab.labs.nic.cz to gitlab.nic.cz
    45b977d output/dnssim: update man page
    4184090 output/dnssim: https2 - fix connection closure issues
    342f33e output/dnssim: https2 - omit closing connection inside callback
    67a76d5 output/dnssim: handle all states when closing connection
    41f04d8 output/dnssim: document importance of conn state enum ordering
    795ab6f output/dnssim: tls - fix handling of CONGESTED connections
    8792b32 output/dnssim: match QUESTION section of received responses
    3a88f5b Coverage
    4f611c8 dnssim
    6e35d5b Compile
    63faa44 README, format code, man-page
    925f85e lib: add missing man reference
    9239087 output/dnssim: fix man formatting
    bd7bee5 fix lua log levels
    4083efd output/dnssim: fix doc typo
    24c22b8 lib/base64url: add lua bindings
    69be2a1 core/log: add errstr() utility function
    0c14d74 output/dnssim: improve https2() documentation and behaviour
    f74e19c output/pcap: log errors when opening output PCAP
    6fe699a output/dnssim: cleanup and nitpicks
    96db8a9 output/https2: handle max_concurrent_streams similar to nghttp2
    15ea609 output/dnssim: https2 - ensure uri authority is always set
    fad3ed6 output/dnssim: https2 - fix some TODOs
    0bee6d8 output/dnssim: https2 - lua documentation
    e83e010 output/dnssim: https2 - implement GET method
    b553e0f output/dnssim: https2 - configure method
    a431a0d contrib: add base64url functions
    c753097 output/dnssim: https2 - set default concurrent stream limit
    d49f275 output/dnssim: https2 - track number of open streams
    2f7217f output/dnssim: https2 - improve data send edge cases
    c0abebc output/dnssim: https2 - return correct error code on send failure
    5b1f6c3 output/dnssim: conn - avoid assert when tearing down failed connections
    5c42266 output/dnssim: exit when file descriptors run out
    1ab2ab6 output/dnssim: https2 - additional asserts to detect invalid data
    4424eb3 output/dnssim: https2 - check response code
    303f2cd output/dnssim: https2 - improve QID mismatch debug msg
    86e3761 output/dnssim: https2 - bugfixes
    4a52f47 output/dnssim: https2 - use more consistent code style for pointers
    c8d853e output/dnssim: conn - fix potential memory leak
    3e6038b output/dnssim: https2 - enable zero-ing out msgid
    712634c output/dnssim: https2 - properly match dnsmsg to query from http request
    5abe943 output/dnssim: https2 - free memory on teardown
    39a9e9e output/dnssim: https2 - initial implementation
    058aee2 output/dnssim: https2 - initialize and setup session
    85eb4a3 output/dnssim: https2 - add libnghttp2 dependency
    6712bd6 output/dnssim: https2 - add skeleton
* Thu Jul 23 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 1.0.0-1
- Release 1.0.0
* Tue Jun 04 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 0.9.8-1
- Alpha release 0.9.8
* Fri Jan 25 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 0.9.7-1
- Alpha release 0.9.7
* Wed Aug 01 2018 Jerry Lundström <lundstrom.jerry@gmail.com> 0.9.6-1
- Alpha release 0.9.6
