// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace Microsoft.Diagnostics.DataContractReader.Data;

internal sealed class RangeSectionMap : IData<RangeSectionMap>
{
    static RangeSectionMap IData<RangeSectionMap>.Create(Target target, TargetPointer address)
        => new RangeSectionMap(target, address);

    public RangeSectionMap(Target target, TargetPointer address)
    {
        Target.TypeInfo type = target.GetTypeInfo(DataType.RangeSectionMap);
        TopLevelData = new TargetPointer(address + (ulong)type.Fields[nameof(TopLevelData)].Offset);
    }

    // pointer to first element
    public TargetPointer TopLevelData { get; init; }
}
