# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
FEDORA_RELEASES += 42
FEDORA_42_BETA_SUBVER = 1.1

.PHONY: all
all:: fedora-cloud-42.$(GARDEN_ARCH).qcow2 fedora-cloud-42.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).x86_64.qcow2 $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).aarch64.qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).%.qcow2: | $(GARDEN_DL_DIR)/fedora
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.fedoraproject.org/pub/fedora/linux/releases/42/Cloud/$*/images/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).$*.qcow2)

$(GARDEN_DL_DIR)/fedora/fedora-cloud-base-42.%.qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-42-$(FEDORA_42_BETA_SUBVER).%.qcow2 | $(GARDEN_DL_DIR)/fedora
	ln -sf $(notdir $<) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/fedora/fedora-cloud-base-42.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.*-42-$(FEDORA_42_BETA_SUBVER).qcow2
