/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/Oligomer.hpp"
#include "MsXpS/libXpertMassCore/CleavageAgent.hpp"
#include "MsXpS/libXpertMassCore/CalcOptions.hpp"
#include "MsXpS/libXpertMassCore/Polymer.hpp"
#include "MsXpS/libXpertMassCore/Ionizer.hpp"
#include "MsXpS/libXpertMassCore/CleavageConfig.hpp"
#include "MsXpS/libXpertMassCore/OligomerCollection.hpp"

namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC Cleaver
{
  public:
  Cleaver();
  Cleaver(PolymerCstQSPtr polymer_cqsp,
          PolChemDefCstSPtr pol_chem_def_csp,
          const CleavageConfig &cleavage_config,
          const CalcOptions &calc_options,
          const Ionizer &ionizer);

  Cleaver(const Cleaver &other);
  ~Cleaver();

  QString getCleaveAgentName() const;

  std::size_t transferOligomers(OligomerCollection &source,
                                OligomerCollection &dest);

  const OligomerCollection &getOligomerCollectionCstRef() const;
  OligomerCollection &getOligomerCollectionRef();

  bool cleave(bool reset = false);
  int cleavePartial(int partial_cleavage);

  int analyzeCrossLinks(OligomerCollection &oligomers);
  int analyzeCrossLinkedOligomer(OligomerSPtr oligomer_sp,
                                 OligomerCollection &oligomers);

  int fillCleavageIndices();
  int resolveCleavageNoCleavage();
  int removeDuplicateCleavageIndices();

  int findCleavageMotif(CleavageMotif &cleavage_motif,
                        size_t index_start,
                        std::size_t index_stop);
  bool accountCleavageRule(CleavageRuleSPtr cleavage_rule_sp,
                           OligomerSPtr oligomer_sp);

  //////////////// OPERATORS /////////////////////
  Cleaver &operator=(const Cleaver &other);
  bool operator==(const Cleaver &other) const;
  bool operator!=(const Cleaver &other) const;

  protected:
  PolymerCstQSPtr mcsp_polymer;
  PolChemDefCstSPtr mcsp_polChemDef;

  CleavageConfig m_cleavageConfig;
  CalcOptions m_calcOptions;
  Ionizer m_ionizer;

  std::vector<int> m_doCleaveIndices;
  std::vector<int> m_doNotCleaveIndices;

  OligomerCollection m_oligomers;
};


} // namespace libXpertMassCore
} // namespace MsXpS
