/*
 *  Phusion Passenger - https://www.phusionpassenger.com/
 *  Copyright (c) 2017-2025 Asynchronous B.V.
 *
 *  "Passenger", "Phusion Passenger" and "Union Station" are registered
 *  trademarks of Asynchronous B.V.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
#ifndef _PASSENGER_APACHE2_MODULE_SERVER_CONFIG_AUTOGENERATED_STRUCT_H_
#define _PASSENGER_APACHE2_MODULE_SERVER_CONFIG_AUTOGENERATED_STRUCT_H_

#ifdef INTELLISENSE
	// These includes do nothing, but keep IntelliSense happy.
	#include <set>
	#include <StaticString.h>
	#include <Constants.h>
	#include <ap_config.h>
#endif

/*
 * ServerConfig/AutoGeneratedStruct.h is automatically generated from ServerConfig/AutoGeneratedStruct.h.cxxcodebuilder,
 * using definitions from src/ruby_supportlib/phusion_passenger/apache2/config_options.rb.
 * Edits to ServerConfig/AutoGeneratedStruct.h will be lost.
 *
 * To update ServerConfig/AutoGeneratedStruct.h:
 *   rake apache2
 *
 * To force regeneration of ServerConfig/AutoGeneratedStruct.h:
 *   rm -f src/apache2_module/ServerConfig/AutoGeneratedStruct.h
 *   rake src/apache2_module/ServerConfig/AutoGeneratedStruct.h
 */

namespace Passenger {
namespace Apache2Module {

/*
 * Server-wide (global, not per-virtual host) configuration information (autogenerated part).
 *
 * Use the getter methods to query information, because those will return
 * the default value if the value is not specified.
 */
struct AutoGeneratedServerConfig {

	/*
	 * Whether to disable Phusion Passenger(R) anonymous telemetry.
	 */
	bool disableAnonymousTelemetry;

	/*
	 * Disable prefixing log statements with PID and channel.
	 */
	bool disableLogPrefix;

	/*
	 * Whether to disable the Phusion Passenger(R) security update check & notification.
	 */
	bool disableSecurityUpdateCheck;

	/*
	 * Whether to revert to old routing behaviour in Phusion Passenger(R).
	 */
	bool oldRouting;

	/*
	 * Whether to show the Phusion Passenger(R) version number in the X-Powered-By header.
	 */
	bool showVersionInHeader;

	/*
	 * Whether to enable turbocaching in Phusion Passenger(R).
	 */
	bool turbocaching;

	/*
	 * Whether to enable user switching support in Phusion Passenger(R).
	 */
	bool userSwitching;

	/*
	 * The Phusion Passenger(R) log verbosity.
	 */
	int logLevel;

	/*
	 * The maximum number of simultaneously alive application instances a single application may occupy.
	 */
	int maxInstancesPerApp;

	/*
	 * The maximum number of simultaneously alive application processes.
	 */
	int maxPoolSize;

	/*
	 * The maximum number of seconds that an application may be idle before it gets terminated.
	 */
	int poolIdleTime;

	/*
	 * The maximum size of the Phusion Passenger(R) response buffer.
	 */
	int responseBufferHighWatermark;

	/*
	 * The Phusion Passenger(R) socket backlog.
	 */
	int socketBacklog;

	/*
	 * Limit the number of stat calls to once per given seconds.
	 */
	int statThrottleRate;

	/*
	 * The authentication type to use when connecting to the admin panel
	 */
	StaticString adminPanelAuthType;

	/*
	 * The password to use when connecting to the admin panel using basic authentication
	 */
	StaticString adminPanelPassword;

	/*
	 * Connect to an admin panel at the given connector URL
	 */
	StaticString adminPanelUrl;

	/*
	 * The username to use when connecting to the admin panel using basic authentication
	 */
	StaticString adminPanelUsername;

	/*
	 * Use specified HTTP/SOCKS proxy for Phusion Passenger(R) anonymous telemetry collection.
	 */
	StaticString anonymousTelemetryProxy;

	/*
	 * The directory that Phusion Passenger(R) data buffers should be stored into.
	 */
	StaticString dataBufferDir;

	/*
	 * The group that Phusion Passenger(R) applications must run as when user switching fails or is disabled.
	 */
	StaticString defaultGroup;

	/*
	 * Phusion Passenger(R)'s default Ruby interpreter to use.
	 */
	StaticString defaultRuby;

	/*
	 * The user that Phusion Passenger(R) applications must run as when user switching fails or is disabled.
	 */
	StaticString defaultUser;

	/*
	 * Dump the Passenger config manifest to the given file, for debugging purposes.
	 */
	StaticString dumpConfigManifest;

	/*
	 * The Phusion Passenger(R) file descriptor log file.
	 */
	StaticString fileDescriptorLogFile;

	/*
	 * The directory to register the Phusion Passenger(R) instance to.
	 */
	StaticString instanceRegistryDir;

	/*
	 * The Phusion Passenger(R) log file.
	 */
	StaticString logFile;

	/*
	 * The Phusion Passenger(R) root folder.
	 */
	StaticString root;

	/*
	 * Use specified HTTP/SOCKS proxy for the Phusion Passenger(R) security update check.
	 */
	StaticString securityUpdateCheckProxy;

	/*
	 * The directory for Phusion Passenger(R) used during child spawning.
	 */
	StaticString spawnDir;

	/*
	 * Prestart the given web applications during startup.
	 */
	std::set<std::string> prestartURLs;


	StaticString disableAnonymousTelemetrySourceFile;
	StaticString disableLogPrefixSourceFile;
	StaticString disableSecurityUpdateCheckSourceFile;
	StaticString oldRoutingSourceFile;
	StaticString showVersionInHeaderSourceFile;
	StaticString turbocachingSourceFile;
	StaticString userSwitchingSourceFile;
	StaticString logLevelSourceFile;
	StaticString maxInstancesPerAppSourceFile;
	StaticString maxPoolSizeSourceFile;
	StaticString poolIdleTimeSourceFile;
	StaticString responseBufferHighWatermarkSourceFile;
	StaticString socketBacklogSourceFile;
	StaticString statThrottleRateSourceFile;
	StaticString adminPanelAuthTypeSourceFile;
	StaticString adminPanelPasswordSourceFile;
	StaticString adminPanelUrlSourceFile;
	StaticString adminPanelUsernameSourceFile;
	StaticString anonymousTelemetryProxySourceFile;
	StaticString dataBufferDirSourceFile;
	StaticString defaultGroupSourceFile;
	StaticString defaultRubySourceFile;
	StaticString defaultUserSourceFile;
	StaticString dumpConfigManifestSourceFile;
	StaticString fileDescriptorLogFileSourceFile;
	StaticString instanceRegistryDirSourceFile;
	StaticString logFileSourceFile;
	StaticString rootSourceFile;
	StaticString securityUpdateCheckProxySourceFile;
	StaticString spawnDirSourceFile;
	StaticString prestartURLsSourceFile;

	unsigned int disableAnonymousTelemetrySourceLine;
	unsigned int disableLogPrefixSourceLine;
	unsigned int disableSecurityUpdateCheckSourceLine;
	unsigned int oldRoutingSourceLine;
	unsigned int showVersionInHeaderSourceLine;
	unsigned int turbocachingSourceLine;
	unsigned int userSwitchingSourceLine;
	unsigned int logLevelSourceLine;
	unsigned int maxInstancesPerAppSourceLine;
	unsigned int maxPoolSizeSourceLine;
	unsigned int poolIdleTimeSourceLine;
	unsigned int responseBufferHighWatermarkSourceLine;
	unsigned int socketBacklogSourceLine;
	unsigned int statThrottleRateSourceLine;
	unsigned int adminPanelAuthTypeSourceLine;
	unsigned int adminPanelPasswordSourceLine;
	unsigned int adminPanelUrlSourceLine;
	unsigned int adminPanelUsernameSourceLine;
	unsigned int anonymousTelemetryProxySourceLine;
	unsigned int dataBufferDirSourceLine;
	unsigned int defaultGroupSourceLine;
	unsigned int defaultRubySourceLine;
	unsigned int defaultUserSourceLine;
	unsigned int dumpConfigManifestSourceLine;
	unsigned int fileDescriptorLogFileSourceLine;
	unsigned int instanceRegistryDirSourceLine;
	unsigned int logFileSourceLine;
	unsigned int rootSourceLine;
	unsigned int securityUpdateCheckProxySourceLine;
	unsigned int spawnDirSourceLine;
	unsigned int prestartURLsSourceLine;

	bool disableAnonymousTelemetryExplicitlySet: 1;
	bool disableLogPrefixExplicitlySet: 1;
	bool disableSecurityUpdateCheckExplicitlySet: 1;
	bool oldRoutingExplicitlySet: 1;
	bool showVersionInHeaderExplicitlySet: 1;
	bool turbocachingExplicitlySet: 1;
	bool userSwitchingExplicitlySet: 1;
	bool logLevelExplicitlySet: 1;
	bool maxInstancesPerAppExplicitlySet: 1;
	bool maxPoolSizeExplicitlySet: 1;
	bool poolIdleTimeExplicitlySet: 1;
	bool responseBufferHighWatermarkExplicitlySet: 1;
	bool socketBacklogExplicitlySet: 1;
	bool statThrottleRateExplicitlySet: 1;
	bool adminPanelAuthTypeExplicitlySet: 1;
	bool adminPanelPasswordExplicitlySet: 1;
	bool adminPanelUrlExplicitlySet: 1;
	bool adminPanelUsernameExplicitlySet: 1;
	bool anonymousTelemetryProxyExplicitlySet: 1;
	bool dataBufferDirExplicitlySet: 1;
	bool defaultGroupExplicitlySet: 1;
	bool defaultRubyExplicitlySet: 1;
	bool defaultUserExplicitlySet: 1;
	bool dumpConfigManifestExplicitlySet: 1;
	bool fileDescriptorLogFileExplicitlySet: 1;
	bool instanceRegistryDirExplicitlySet: 1;
	bool logFileExplicitlySet: 1;
	bool rootExplicitlySet: 1;
	bool securityUpdateCheckProxyExplicitlySet: 1;
	bool spawnDirExplicitlySet: 1;
	bool prestartURLsExplicitlySet: 1;


	AutoGeneratedServerConfig() {
		disableAnonymousTelemetry = false;
		disableLogPrefix = false;
		disableSecurityUpdateCheck = false;
		oldRouting = false;
		showVersionInHeader = true;
		turbocaching = true;
		userSwitching = true;
		logLevel = DEFAULT_LOG_LEVEL;
		maxInstancesPerApp = 0;
		maxPoolSize = DEFAULT_MAX_POOL_SIZE;
		poolIdleTime = DEFAULT_POOL_IDLE_TIME;
		responseBufferHighWatermark = DEFAULT_RESPONSE_BUFFER_HIGH_WATERMARK;
		socketBacklog = DEFAULT_SOCKET_BACKLOG;
		statThrottleRate = DEFAULT_STAT_THROTTLE_RATE;
		/*
		 * adminPanelAuthType: default initialized
		 */
		/*
		 * adminPanelPassword: default initialized
		 */
		/*
		 * adminPanelUrl: default initialized
		 */
		/*
		 * adminPanelUsername: default initialized
		 */
		/*
		 * anonymousTelemetryProxy: default initialized
		 */
		/*
		 * dataBufferDir: default initialized
		 */
		/*
		 * defaultGroup: default initialized
		 */
		defaultRuby = DEFAULT_RUBY;
		defaultUser = PASSENGER_DEFAULT_USER;
		/*
		 * dumpConfigManifest: default initialized
		 */
		/*
		 * fileDescriptorLogFile: default initialized
		 */
		/*
		 * instanceRegistryDir: default initialized
		 */
		/*
		 * logFile: default initialized
		 */
		/*
		 * root: default initialized
		 */
		/*
		 * securityUpdateCheckProxy: default initialized
		 */
		/*
		 * spawnDir: default initialized
		 */
		/*
		 * prestartURLs: default initialized
		 */

		disableAnonymousTelemetrySourceLine = 0;
		disableLogPrefixSourceLine = 0;
		disableSecurityUpdateCheckSourceLine = 0;
		oldRoutingSourceLine = 0;
		showVersionInHeaderSourceLine = 0;
		turbocachingSourceLine = 0;
		userSwitchingSourceLine = 0;
		logLevelSourceLine = 0;
		maxInstancesPerAppSourceLine = 0;
		maxPoolSizeSourceLine = 0;
		poolIdleTimeSourceLine = 0;
		responseBufferHighWatermarkSourceLine = 0;
		socketBacklogSourceLine = 0;
		statThrottleRateSourceLine = 0;
		adminPanelAuthTypeSourceLine = 0;
		adminPanelPasswordSourceLine = 0;
		adminPanelUrlSourceLine = 0;
		adminPanelUsernameSourceLine = 0;
		anonymousTelemetryProxySourceLine = 0;
		dataBufferDirSourceLine = 0;
		defaultGroupSourceLine = 0;
		defaultRubySourceLine = 0;
		defaultUserSourceLine = 0;
		dumpConfigManifestSourceLine = 0;
		fileDescriptorLogFileSourceLine = 0;
		instanceRegistryDirSourceLine = 0;
		logFileSourceLine = 0;
		rootSourceLine = 0;
		securityUpdateCheckProxySourceLine = 0;
		spawnDirSourceLine = 0;
		prestartURLsSourceLine = 0;

		disableAnonymousTelemetryExplicitlySet = false;
		disableLogPrefixExplicitlySet = false;
		disableSecurityUpdateCheckExplicitlySet = false;
		oldRoutingExplicitlySet = false;
		showVersionInHeaderExplicitlySet = false;
		turbocachingExplicitlySet = false;
		userSwitchingExplicitlySet = false;
		logLevelExplicitlySet = false;
		maxInstancesPerAppExplicitlySet = false;
		maxPoolSizeExplicitlySet = false;
		poolIdleTimeExplicitlySet = false;
		responseBufferHighWatermarkExplicitlySet = false;
		socketBacklogExplicitlySet = false;
		statThrottleRateExplicitlySet = false;
		adminPanelAuthTypeExplicitlySet = false;
		adminPanelPasswordExplicitlySet = false;
		adminPanelUrlExplicitlySet = false;
		adminPanelUsernameExplicitlySet = false;
		anonymousTelemetryProxyExplicitlySet = false;
		dataBufferDirExplicitlySet = false;
		defaultGroupExplicitlySet = false;
		defaultRubyExplicitlySet = false;
		defaultUserExplicitlySet = false;
		dumpConfigManifestExplicitlySet = false;
		fileDescriptorLogFileExplicitlySet = false;
		instanceRegistryDirExplicitlySet = false;
		logFileExplicitlySet = false;
		rootExplicitlySet = false;
		securityUpdateCheckProxyExplicitlySet = false;
		spawnDirExplicitlySet = false;
		prestartURLsExplicitlySet = false;
	}

};

} // namespace Apache2Module
} // namespace Passenger

#endif /* _PASSENGER_APACHE2_MODULE_SERVER_CONFIG_AUTOGENERATED_STRUCT_H_ */
