/*
 *  Phusion Passenger - https://www.phusionpassenger.com/
 *  Copyright (c) 2010-2025 Asynchronous B.V.
 *
 *  "Passenger", "Phusion Passenger" and "Union Station" are registered
 *  trademarks of Asynchronous B.V.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

/*
 * LocationConfig/AutoGeneratedHeaderSerialization.c is automatically generated from
 * LocationConfig/AutoGeneratedHeaderSerialization.c.cxxcodebuilder,
 * using definitions from src/ruby_supportlib/phusion_passenger/nginx/config_options.rb.
 * Edits to LocationConfig/AutoGeneratedHeaderSerialization.c will be lost.
 *
 * To update LocationConfig/AutoGeneratedHeaderSerialization.c:
 *   rake nginx
 *
 * To force regeneration of LocationConfig/AutoGeneratedHeaderSerialization.c:
 *   rm -f src/nginx_module/LocationConfig/AutoGeneratedHeaderSerialization.c
 *   rake src/nginx_module/LocationConfig/AutoGeneratedHeaderSerialization.c
 */
/*
 * 0: NGX_ERROR, 1: OK
 */
static int
passenger_serialize_autogenerated_loc_conf_to_headers(ngx_conf_t *cf, passenger_loc_conf_t *conf) {
    size_t len = 0;
    u_char int_buf[32], *end, *buf, *pos;

    /*
     * Calculate lengths
     */

    if (conf->autogenerated.ruby.data != NULL) {
        len += sizeof("!~PASSENGER_RUBY: ") - 1;
        len += conf->autogenerated.ruby.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.python.data != NULL) {
        len += sizeof("!~PASSENGER_PYTHON: ") - 1;
        len += conf->autogenerated.python.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.nodejs.data != NULL) {
        len += sizeof("!~PASSENGER_NODEJS: ") - 1;
        len += conf->autogenerated.nodejs.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.meteor_app_settings.data != NULL) {
        len += sizeof("!~PASSENGER_METEOR_APP_SETTINGS: ") - 1;
        len += conf->autogenerated.meteor_app_settings.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.environment.data != NULL) {
        len += sizeof("!~PASSENGER_APP_ENV: ") - 1;
        len += conf->autogenerated.environment.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.friendly_error_pages != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_FRIENDLY_ERROR_PAGES: ") - 1;
        len += conf->autogenerated.friendly_error_pages
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.custom_error_page.data != NULL) {
        len += sizeof("!~PASSENGER_CUSTOM_ERROR_PAGE: ") - 1;
        len += conf->autogenerated.custom_error_page.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.min_instances != NGX_CONF_UNSET_UINT) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.min_instances);
        len += sizeof("!~PASSENGER_MIN_PROCESSES: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.start_timeout != NGX_CONF_UNSET_UINT) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.start_timeout);
        len += sizeof("!~PASSENGER_START_TIMEOUT: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.user.data != NULL) {
        len += sizeof("!~PASSENGER_USER: ") - 1;
        len += conf->autogenerated.user.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.group.data != NULL) {
        len += sizeof("!~PASSENGER_GROUP: ") - 1;
        len += conf->autogenerated.group.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.app_group_name.data != NULL) {
        len += sizeof("!~PASSENGER_APP_GROUP_NAME: ") - 1;
        len += conf->autogenerated.app_group_name.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.app_root.data != NULL) {
        len += sizeof("!~PASSENGER_APP_ROOT: ") - 1;
        len += conf->autogenerated.app_root.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.app_rights.data != NULL) {
        len += sizeof("!~PASSENGER_APP_RIGHTS: ") - 1;
        len += conf->autogenerated.app_rights.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.debugger != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_DEBUGGER: ") - 1;
        len += conf->autogenerated.debugger
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.max_preloader_idle_time != NGX_CONF_UNSET) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.max_preloader_idle_time);
        len += sizeof("!~PASSENGER_MAX_PRELOADER_IDLE_TIME: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.spawn_method.data != NULL) {
        len += sizeof("!~PASSENGER_SPAWN_METHOD: ") - 1;
        len += conf->autogenerated.spawn_method.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.direct_instance_request_address.data != NULL) {
        len += sizeof("!~PASSENGER_DIRECT_INSTANCE_REQUEST_ADDRESS: ") - 1;
        len += conf->autogenerated.direct_instance_request_address.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.load_shell_envvars != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_LOAD_SHELL_ENVVARS: ") - 1;
        len += conf->autogenerated.load_shell_envvars
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.preload_bundler != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_PRELOAD_BUNDLER: ") - 1;
        len += conf->autogenerated.preload_bundler
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.max_request_queue_size != NGX_CONF_UNSET_UINT) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.max_request_queue_size);
        len += sizeof("!~PASSENGER_MAX_REQUEST_QUEUE_SIZE: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.startup_file.data != NULL) {
        len += sizeof("!~PASSENGER_STARTUP_FILE: ") - 1;
        len += conf->autogenerated.startup_file.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.restart_dir.data != NULL) {
        len += sizeof("!~PASSENGER_RESTART_DIR: ") - 1;
        len += conf->autogenerated.restart_dir.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.abort_websockets_on_process_shutdown != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_ABORT_WEBSOCKETS_ON_PROCESS_SHUTDOWN: ") - 1;
        len += conf->autogenerated.abort_websockets_on_process_shutdown
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.force_max_concurrent_requests_per_process != NGX_CONF_UNSET) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.force_max_concurrent_requests_per_process);
        len += sizeof("!~PASSENGER_FORCE_MAX_CONCURRENT_REQUESTS_PER_PROCESS: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.max_requests != NGX_CONF_UNSET_UINT) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.max_requests);
        len += sizeof("!~PASSENGER_MAX_REQUESTS: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.request_queue_overflow_status_code != NGX_CONF_UNSET) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.request_queue_overflow_status_code);
        len += sizeof("!~PASSENGER_REQUEST_QUEUE_OVERFLOW_STATUS_CODE: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.spawn_exception_status_code != NGX_CONF_UNSET) {
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.spawn_exception_status_code);
        len += sizeof("!~PASSENGER_SPAWN_EXCEPTION_STATUS_CODE: ") - 1;
        len += end - int_buf;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.sticky_sessions != NGX_CONF_UNSET) {
        len += sizeof("!~PASSENGER_STICKY_SESSIONS: ") - 1;
        len += conf->autogenerated.sticky_sessions
            ? sizeof("t\r\n") - 1
            : sizeof("f\r\n") - 1;
    }

    if (conf->autogenerated.sticky_sessions_cookie_name.data != NULL) {
        len += sizeof("!~PASSENGER_STICKY_SESSIONS_COOKIE_NAME: ") - 1;
        len += conf->autogenerated.sticky_sessions_cookie_name.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.sticky_sessions_cookie_attributes.data != NULL) {
        len += sizeof("!~PASSENGER_STICKY_SESSIONS_COOKIE_ATTRIBUTES: ") - 1;
        len += conf->autogenerated.sticky_sessions_cookie_attributes.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.vary_turbocache_by_cookie.data != NULL) {
        len += sizeof("!~PASSENGER_VARY_TURBOCACHE_BY_COOKIE: ") - 1;
        len += conf->autogenerated.vary_turbocache_by_cookie.len;
        len += sizeof("\r\n") - 1;
    }

    if (conf->autogenerated.app_log_file.data != NULL) {
        len += sizeof("!~PASSENGER_APP_LOG_FILE: ") - 1;
        len += conf->autogenerated.app_log_file.len;
        len += sizeof("\r\n") - 1;
    }


    /* Create string */
    buf = pos = ngx_pnalloc(cf->pool, len);
    if (buf == NULL) {
        return 0;
    }

    if (conf->autogenerated.ruby.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_RUBY: ",
            sizeof("!~PASSENGER_RUBY: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.ruby.data,
            conf->autogenerated.ruby.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.python.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_PYTHON: ",
            sizeof("!~PASSENGER_PYTHON: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.python.data,
            conf->autogenerated.python.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.nodejs.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_NODEJS: ",
            sizeof("!~PASSENGER_NODEJS: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.nodejs.data,
            conf->autogenerated.nodejs.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.meteor_app_settings.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_METEOR_APP_SETTINGS: ",
            sizeof("!~PASSENGER_METEOR_APP_SETTINGS: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.meteor_app_settings.data,
            conf->autogenerated.meteor_app_settings.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.environment.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_APP_ENV: ",
            sizeof("!~PASSENGER_APP_ENV: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.environment.data,
            conf->autogenerated.environment.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.friendly_error_pages != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_FRIENDLY_ERROR_PAGES: ",
            sizeof("!~PASSENGER_FRIENDLY_ERROR_PAGES: ") - 1);
        if (conf->autogenerated.friendly_error_pages) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.custom_error_page.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_CUSTOM_ERROR_PAGE: ",
            sizeof("!~PASSENGER_CUSTOM_ERROR_PAGE: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.custom_error_page.data,
            conf->autogenerated.custom_error_page.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.min_instances != NGX_CONF_UNSET_UINT) {
        pos = ngx_copy(pos,
            "!~PASSENGER_MIN_PROCESSES: ",
            sizeof("!~PASSENGER_MIN_PROCESSES: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.min_instances);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.start_timeout != NGX_CONF_UNSET_UINT) {
        pos = ngx_copy(pos,
            "!~PASSENGER_START_TIMEOUT: ",
            sizeof("!~PASSENGER_START_TIMEOUT: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.start_timeout);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.user.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_USER: ",
            sizeof("!~PASSENGER_USER: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.user.data,
            conf->autogenerated.user.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.group.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_GROUP: ",
            sizeof("!~PASSENGER_GROUP: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.group.data,
            conf->autogenerated.group.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.app_group_name.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_APP_GROUP_NAME: ",
            sizeof("!~PASSENGER_APP_GROUP_NAME: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.app_group_name.data,
            conf->autogenerated.app_group_name.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.app_root.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_APP_ROOT: ",
            sizeof("!~PASSENGER_APP_ROOT: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.app_root.data,
            conf->autogenerated.app_root.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.app_rights.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_APP_RIGHTS: ",
            sizeof("!~PASSENGER_APP_RIGHTS: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.app_rights.data,
            conf->autogenerated.app_rights.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.debugger != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_DEBUGGER: ",
            sizeof("!~PASSENGER_DEBUGGER: ") - 1);
        if (conf->autogenerated.debugger) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.max_preloader_idle_time != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_MAX_PRELOADER_IDLE_TIME: ",
            sizeof("!~PASSENGER_MAX_PRELOADER_IDLE_TIME: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.max_preloader_idle_time);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.spawn_method.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_SPAWN_METHOD: ",
            sizeof("!~PASSENGER_SPAWN_METHOD: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.spawn_method.data,
            conf->autogenerated.spawn_method.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.direct_instance_request_address.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_DIRECT_INSTANCE_REQUEST_ADDRESS: ",
            sizeof("!~PASSENGER_DIRECT_INSTANCE_REQUEST_ADDRESS: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.direct_instance_request_address.data,
            conf->autogenerated.direct_instance_request_address.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.load_shell_envvars != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_LOAD_SHELL_ENVVARS: ",
            sizeof("!~PASSENGER_LOAD_SHELL_ENVVARS: ") - 1);
        if (conf->autogenerated.load_shell_envvars) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.preload_bundler != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_PRELOAD_BUNDLER: ",
            sizeof("!~PASSENGER_PRELOAD_BUNDLER: ") - 1);
        if (conf->autogenerated.preload_bundler) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.max_request_queue_size != NGX_CONF_UNSET_UINT) {
        pos = ngx_copy(pos,
            "!~PASSENGER_MAX_REQUEST_QUEUE_SIZE: ",
            sizeof("!~PASSENGER_MAX_REQUEST_QUEUE_SIZE: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.max_request_queue_size);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.startup_file.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_STARTUP_FILE: ",
            sizeof("!~PASSENGER_STARTUP_FILE: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.startup_file.data,
            conf->autogenerated.startup_file.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.restart_dir.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_RESTART_DIR: ",
            sizeof("!~PASSENGER_RESTART_DIR: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.restart_dir.data,
            conf->autogenerated.restart_dir.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.abort_websockets_on_process_shutdown != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_ABORT_WEBSOCKETS_ON_PROCESS_SHUTDOWN: ",
            sizeof("!~PASSENGER_ABORT_WEBSOCKETS_ON_PROCESS_SHUTDOWN: ") - 1);
        if (conf->autogenerated.abort_websockets_on_process_shutdown) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.force_max_concurrent_requests_per_process != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_FORCE_MAX_CONCURRENT_REQUESTS_PER_PROCESS: ",
            sizeof("!~PASSENGER_FORCE_MAX_CONCURRENT_REQUESTS_PER_PROCESS: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.force_max_concurrent_requests_per_process);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.max_requests != NGX_CONF_UNSET_UINT) {
        pos = ngx_copy(pos,
            "!~PASSENGER_MAX_REQUESTS: ",
            sizeof("!~PASSENGER_MAX_REQUESTS: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%ui",
            conf->autogenerated.max_requests);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.request_queue_overflow_status_code != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_REQUEST_QUEUE_OVERFLOW_STATUS_CODE: ",
            sizeof("!~PASSENGER_REQUEST_QUEUE_OVERFLOW_STATUS_CODE: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.request_queue_overflow_status_code);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.spawn_exception_status_code != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_SPAWN_EXCEPTION_STATUS_CODE: ",
            sizeof("!~PASSENGER_SPAWN_EXCEPTION_STATUS_CODE: ") - 1);
        end = ngx_snprintf(int_buf,
            sizeof(int_buf) - 1,
            "%d",
            conf->autogenerated.spawn_exception_status_code);
        pos = ngx_copy(pos, int_buf, end - int_buf);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.sticky_sessions != NGX_CONF_UNSET) {
        pos = ngx_copy(pos,
            "!~PASSENGER_STICKY_SESSIONS: ",
            sizeof("!~PASSENGER_STICKY_SESSIONS: ") - 1);
        if (conf->autogenerated.sticky_sessions) {
            pos = ngx_copy(pos, "t\r\n", sizeof("t\r\n") - 1);
        } else {
            pos = ngx_copy(pos, "f\r\n", sizeof("f\r\n") - 1);
        }
    }

    if (conf->autogenerated.sticky_sessions_cookie_name.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_STICKY_SESSIONS_COOKIE_NAME: ",
            sizeof("!~PASSENGER_STICKY_SESSIONS_COOKIE_NAME: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.sticky_sessions_cookie_name.data,
            conf->autogenerated.sticky_sessions_cookie_name.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.sticky_sessions_cookie_attributes.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_STICKY_SESSIONS_COOKIE_ATTRIBUTES: ",
            sizeof("!~PASSENGER_STICKY_SESSIONS_COOKIE_ATTRIBUTES: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.sticky_sessions_cookie_attributes.data,
            conf->autogenerated.sticky_sessions_cookie_attributes.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.vary_turbocache_by_cookie.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_VARY_TURBOCACHE_BY_COOKIE: ",
            sizeof("!~PASSENGER_VARY_TURBOCACHE_BY_COOKIE: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.vary_turbocache_by_cookie.data,
            conf->autogenerated.vary_turbocache_by_cookie.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }
    if (conf->autogenerated.app_log_file.data != NULL) {
        pos = ngx_copy(pos,
            "!~PASSENGER_APP_LOG_FILE: ",
            sizeof("!~PASSENGER_APP_LOG_FILE: ") - 1);
        pos = ngx_copy(pos,
            conf->autogenerated.app_log_file.data,
            conf->autogenerated.app_log_file.len);
        pos = ngx_copy(pos, (const u_char *) "\r\n", sizeof("\r\n") - 1);
    }

    conf->options_cache.data = buf;
    conf->options_cache.len = pos - buf;

    return 1;
}

