% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{tidy_with_broom_or_parameters}
\alias{tidy_with_broom_or_parameters}
\title{Tidy a model with broom or parameters}
\usage{
tidy_with_broom_or_parameters(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(a model object, e.g. \code{glm})\cr
A model to be tidied.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{broom::tidy()} or
\code{parameters::model_parameters()}.}
}
\description{
Try to tidy a model with \code{broom::tidy()}. If it fails, will try to tidy the
model using \code{parameters::model_parameters()} through \code{tidy_parameters()}.
}
\seealso{
Other custom_tieders: 
\code{\link{tidy_broom}()},
\code{\link{tidy_multgee}()},
\code{\link{tidy_parameters}()},
\code{\link{tidy_vgam}()},
\code{\link{tidy_zeroinfl}()}
}
\concept{custom_tieders}
