% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-cols.R
\name{row_to_colnames}
\alias{row_to_colnames}
\alias{colnames_to_row}
\title{Tools for working with column names}
\usage{
row_to_colnames(x, row = 1, na_prefix = "x", verbose = TRUE)

colnames_to_row(x, prefix = "x")
}
\arguments{
\item{x}{A data frame.}

\item{row}{Row to use as column names.}

\item{na_prefix}{Prefix to give to the column name if the row has an \code{NA}.
Default is 'x', and it will be incremented at each \code{NA} (\code{x1}, \code{x2}, etc.).}

\item{verbose}{Toggle warnings.}

\item{prefix}{Prefix to give to the column name. Default is 'x', and it will
be incremented at each column (\code{x1}, \code{x2}, etc.).}
}
\value{
\code{row_to_colnames()} and \code{colnames_to_row()} both return a data frame.
}
\description{
Tools for working with column names
}
\examples{
# Convert a row to column names --------------------------------
test <- data.frame(
  a = c("iso", 2, 5),
  b = c("year", 3, 6),
  c = c("value", 5, 7)
)
test
row_to_colnames(test)

# Convert column names to row --------------------------------
test <- data.frame(
  ARG = c("BRA", "FRA"),
  `1960` = c(1960, 1960),
  `2000` = c(2000, 2000)
)
test
colnames_to_row(test)

}
