% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{formatter_pander}
\alias{formatter_pander}
\title{Formats R objects with pander}
\usage{
formatter_pander(
  x,
  ...,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{x}{object to be logged}

\item{...}{optional parameters passed to \code{pander}}

\item{.logcall}{the logging call being evaluated (useful in
formatters and layouts when you want to have access to the raw,
unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was
called (useful in formatters and layouts to extract the calling
function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function
where the formatter function will be evaluated and that is used
to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
character vector
}
\description{
Formats R objects with pander
}
\note{
This functionality depends on the \pkg{pander} package.
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
log_formatter(formatter_pander)
log_info("42")
log_info(42)
log_info(4 + 2)
log_info(head(iris))
log_info(head(iris), style = "simple")
log_info(lm(hp ~ wt, mtcars))
\dontshow{logger:::namespaces_set(old)}
}
\seealso{
Other log_formatters: 
\code{\link{formatter_cli}()},
\code{\link{formatter_glue}()},
\code{\link{formatter_glue_or_sprintf}()},
\code{\link{formatter_glue_safe}()},
\code{\link{formatter_json}()},
\code{\link{formatter_logging}()},
\code{\link{formatter_paste}()},
\code{\link{formatter_sprintf}()}
}
\concept{log_formatters}
