use yaxpeax_arch::Decoder;
use yaxpeax_x86::long_mode::InstDecoder;

const INSTRUCTIONS: [&'static [u8]; 1975] = [
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x60, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x61, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x62, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x64, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x65, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x66, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x67, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x68, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x69, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x6a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x6b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xd5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xda, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xde, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xea, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xeb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xec, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xed, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xee, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xef, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0xd7, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x74, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x75, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x76, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd1, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd2, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd3, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xdb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xdc, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xdd, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xdf, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xe9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xf9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xfa, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xfb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xfc, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xfd, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xfe, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x6c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x6d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x71, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x71, 0b11_100_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x71, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x72, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x72, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x73, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x73, 0b11_011_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x73, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x73, 0b11_111_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0xf5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0xf6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x2b, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x2b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x36, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x37, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x38, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x39, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3a, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x3f, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x40, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x45, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x45, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x46, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x47, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x47, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x8c, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x8e, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x90, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x91, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x92, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x93, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x00, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x01, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x02, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x03, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x04, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x05, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x06, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x07, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x08, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x09, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x0a, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x0b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x18, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x19, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x1c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x1d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x1e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x20, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x21, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x22, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x23, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x24, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x25, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x45, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x45, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x46, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x47, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x47, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x8c, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x8e, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x90, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x91, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x92, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x93, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x45, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x45, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x47, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x47, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x8c, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x8e, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x90, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x91, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x92, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_001, 0x93, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x45, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x45, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x47, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x47, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x8c, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x8e, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x90, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x91, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x92, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00010, 0b1_1111_101, 0x93, 0b00_000_100, 0xa1],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x38, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x42, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x4c, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x02, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x02, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x02, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x02, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x39, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x46, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x46, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_1111_101, 0x00, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_1111_101, 0x01, 0b11_001_010, 0x77],
    &[0x0f, 0x01, 0x38],
    &[0x0f, 0x01, 0x3f],
    &[0x0f, 0x01, 0x40, 0xff],
    &[0x0f, 0x01, 0x41, 0xff],
    &[0x0f, 0x01, 0x49, 0xff],
    &[0x0f, 0x01, 0x51, 0xff],
    &[0x0f, 0x01, 0x59, 0xff],
    &[0x0f, 0x01, 0x61, 0xff],
    &[0x0f, 0x01, 0x71, 0xff],
    &[0x0f, 0x01, 0x79, 0xff],
    &[0x0f, 0x01, 0xc0],
    &[0x0f, 0x01, 0xc1],
    &[0x0f, 0x01, 0xc2],
    &[0x0f, 0x01, 0xc3],
    &[0x0f, 0x01, 0xc4],
    &[0x0f, 0x01, 0xc8],
    &[0x0f, 0x01, 0xc9],
    &[0x0f, 0x01, 0xca],
    &[0x0f, 0x01, 0xcb],
    &[0x0f, 0x01, 0xcf],
    &[0x0f, 0x01, 0xd0],
    &[0x0f, 0x01, 0xd1],
    &[0x0f, 0x01, 0xd4],
    &[0x0f, 0x01, 0xd5],
    &[0x0f, 0x01, 0xd5],
    &[0x0f, 0x01, 0xd6],
    &[0x0f, 0x01, 0xd6],
    &[0x0f, 0x01, 0xd7],
    &[0x0f, 0x01, 0xd8],
    &[0x0f, 0x01, 0xd8],
    &[0x0f, 0x01, 0xd9],
    &[0x0f, 0x01, 0xd9],
    &[0x0f, 0x01, 0xda],
    &[0x0f, 0x01, 0xda],
    &[0x0f, 0x01, 0xdb],
    &[0x0f, 0x01, 0xdb],
    &[0x0f, 0x01, 0xdc],
    &[0x0f, 0x01, 0xdc],
    &[0x0f, 0x01, 0xdd],
    &[0x0f, 0x01, 0xdd],
    &[0x0f, 0x01, 0xde],
    &[0x0f, 0x01, 0xde],
    &[0x0f, 0x01, 0xdf],
    &[0x0f, 0x01, 0xdf],
    &[0x0f, 0x01, 0xe0],
    &[0x0f, 0x01, 0xe1],
    &[0x0f, 0x01, 0xe2],
    &[0x0f, 0x01, 0xe3],
    &[0x0f, 0x01, 0xe4],
    &[0x0f, 0x01, 0xe5],
    &[0x0f, 0x01, 0xe6],
    &[0x0f, 0x01, 0xe7],
    &[0x0f, 0x01, 0xee],
    &[0x0f, 0x01, 0xef],
    &[0x0f, 0x01, 0xf0],
    &[0x0f, 0x01, 0xf1],
    &[0x0f, 0x01, 0xf2],
    &[0x0f, 0x01, 0xf3],
    &[0x0f, 0x01, 0xf4],
    &[0x0f, 0x01, 0xf5],
    &[0x0f, 0x01, 0xf6],
    &[0x0f, 0x01, 0xf7],
    &[0x0f, 0x01, 0xf8],
    &[0x0f, 0x01, 0xf9],
    &[0x0f, 0x01, 0xfa],
    &[0x0f, 0x01, 0xfb],
    &[0x0f, 0x01, 0xfc],
    &[0x0f, 0x01, 0xfd],
    &[0x0f, 0x01, 0xfe],
    &[0x0f, 0x01, 0xff],
    &[0x0f, 0x02, 0xc0],
    &[0x0f, 0x03, 0xc0],
    &[0x0f, 0x05],
    &[0x0f, 0x06],
    &[0x0f, 0x06],
    &[0x0f, 0x07],
    &[0x0f, 0x0d, 0x08],
    &[0x0f, 0x0f, 0x38, 0x8e],
    &[0x0f, 0x0f, 0xc6, 0xb7],
    &[0x0f, 0x0f, 0xe0, 0x8a],
    &[0x0f, 0x12, 0x0f],
    &[0x0f, 0x12, 0xc0],
    &[0x0f, 0x12, 0xcf],
    &[0x0f, 0x13, 0x00],
    &[0x0f, 0x14, 0x08],
    &[0x0f, 0x15, 0x08],
    &[0x0f, 0x16, 0x0f],
    &[0x0f, 0x16, 0x0f],
    &[0x0f, 0x16, 0xc0],
    &[0x0f, 0x16, 0xcf],
    &[0x0f, 0x17, 0x00],
    &[0x0f, 0x18, 0x00],
    &[0x0f, 0x18, 0x08],
    &[0x0f, 0x18, 0x10],
    &[0x0f, 0x18, 0x18],
    &[0x0f, 0x18, 0x20],
    &[0x0f, 0x18, 0xc0],
    &[0x0f, 0x18, 0xcc],
    &[0x0f, 0x19, 0x20],
    &[0x0f, 0x1a, 0x20],
    &[0x0f, 0x1b, 0x20],
    &[0x0f, 0x1c, 0x20],
    &[0x0f, 0x1d, 0x20],
    &[0x0f, 0x1e, 0x20],
    &[0x0f, 0x1f, 0x20],
    &[0x0f, 0x20, 0xd0],
    &[0x0f, 0x21, 0xc8],
    &[0x0f, 0x21, 0xc8],
    &[0x0f, 0x22, 0xc0],
    &[0x0f, 0x22, 0xc7],
    &[0x0f, 0x22, 0xd0],
    &[0x0f, 0x22, 0xd7],
    &[0x0f, 0x23, 0xc8],
    &[0x0f, 0x23, 0xc8],
    &[0x0f, 0x23, 0xcf],
    &[0x0f, 0x28, 0xd0],
    &[0x0f, 0x2c, 0xcf],
    &[0x0f, 0x30],
    &[0x0f, 0x31],
    &[0x0f, 0x32],
    &[0x0f, 0x33],
    &[0x0f, 0x34],
    &[0x0f, 0x35],
    &[0x0f, 0x37],
    &[0x0f, 0x38, 0x00, 0xda],
    &[0x0f, 0x38, 0xc8, 0x12],
    &[0x0f, 0x38, 0xc9, 0x12],
    &[0x0f, 0x38, 0xca, 0x12],
    &[0x0f, 0x38, 0xcb, 0x12],
    &[0x0f, 0x38, 0xcc, 0x12],
    &[0x0f, 0x38, 0xcd, 0x12],
    &[0x0f, 0x38, 0xf0, 0x06],
    &[0x0f, 0x38, 0xf1, 0x06],
    &[0x0f, 0x3a, 0x0f, 0xc1, 0x23],
    &[0x0f, 0x3a, 0xcc, 0x12, 0x40],
    &[0x0f, 0x3a, 0xcc, 0x12, 0xff],
    &[0x0f, 0x60, 0x00],
    &[0x0f, 0x60, 0xc2],
    &[0x0f, 0x61, 0x00],
    &[0x0f, 0x61, 0xc2],
    &[0x0f, 0x62, 0x00],
    &[0x0f, 0x62, 0xc2],
    &[0x0f, 0x63, 0x00],
    &[0x0f, 0x63, 0xc2],
    &[0x0f, 0x64, 0x00],
    &[0x0f, 0x64, 0xc2],
    &[0x0f, 0x65, 0x00],
    &[0x0f, 0x65, 0xc2],
    &[0x0f, 0x66, 0x00],
    &[0x0f, 0x66, 0xc2],
    &[0x0f, 0x67, 0x00],
    &[0x0f, 0x67, 0xc2],
    &[0x0f, 0x68, 0x00],
    &[0x0f, 0x68, 0xc2],
    &[0x0f, 0x69, 0x00],
    &[0x0f, 0x69, 0xc2],
    &[0x0f, 0x6a, 0x00],
    &[0x0f, 0x6a, 0xc2],
    &[0x0f, 0x6b, 0x00],
    &[0x0f, 0x6b, 0xc2],
    &[0x0f, 0x6e, 0x00],
    &[0x0f, 0x6e, 0xc2],
    &[0x0f, 0x6f, 0x00],
    &[0x0f, 0x6f, 0xc2],
    &[0x0f, 0x6f, 0xe9],
    &[0x0f, 0x6f, 0xfb],
    &[0x0f, 0x70, 0x00, 0x7f],
    &[0x0f, 0x70, 0x00, 0x7f],
    &[0x0f, 0x71, 0xd0, 0x7f],
    &[0x0f, 0x71, 0xe0, 0x7f],
    &[0x0f, 0x71, 0xf0, 0x7f],
    &[0x0f, 0x72, 0xd0, 0x7f],
    &[0x0f, 0x72, 0xe0, 0x7f],
    &[0x0f, 0x72, 0xf0, 0x7f],
    &[0x0f, 0x73, 0xd0, 0x7f],
    &[0x0f, 0x73, 0xf0, 0x7f],
    &[0x0f, 0x74, 0xc2],
    &[0x0f, 0x75, 0xc2],
    &[0x0f, 0x76, 0xc2],
    &[0x0f, 0x78, 0x0b],
    &[0x0f, 0x78, 0xc4],
    &[0x0f, 0x79, 0x0b],
    &[0x0f, 0x79, 0xc5],
    &[0x0f, 0x86, 0x8b, 0x01, 0x00, 0x00],
    &[0x0f, 0x97, 0x00],
    &[0x0f, 0x97, 0x08],
    &[0x0f, 0x97, 0xc0],
    &[0x0f, 0x97, 0xc8],
    &[0x0f, 0xa0],
    &[0x0f, 0xa1],
    &[0x0f, 0xa2],
    &[0x0f, 0xa4, 0xc0, 0x11],
    &[0x0f, 0xa5, 0xc0],
    &[0x0f, 0xa5, 0xc9],
    &[0x0f, 0xac, 0xc0, 0x11],
    &[0x0f, 0xad, 0xc9],
    &[0x0f, 0xae, 0x04, 0x4f],
    &[0x0f, 0xae, 0x04, 0x4f],
    &[0x0f, 0xae, 0x0c, 0x4f],
    &[0x0f, 0xae, 0x14, 0x4f],
    &[0x0f, 0xae, 0x1c, 0x4f],
    &[0x0f, 0xae, 0x24, 0x4f],
    &[0x0f, 0xae, 0x2c, 0x4f],
    &[0x0f, 0xae, 0x34, 0x4f],
    &[0x0f, 0xae, 0x3c, 0x4f],
    &[0x0f, 0xae, 0x3f],
    &[0x0f, 0xaf, 0xc2],
    &[0x0f, 0xb2, 0x00],
    &[0x0f, 0xb3, 0xd0],
    &[0x0f, 0xb6, 0x06],
    &[0x0f, 0xb7, 0x06],
    &[0x0f, 0xbe, 0x83, 0xb4, 0x00, 0x00, 0x00],
    &[0x0f, 0xc0, 0xcc],
    &[0x0f, 0xc1, 0xcc],
    &[0x0f, 0xc3, 0x03],
    &[0x0f, 0xc4, 0xc0, 0x14],
    &[0x0f, 0xc5, 0xd1, 0x00],
    &[0x0f, 0xc7, 0x0f],
    &[0x0f, 0xc7, 0x0f],
    &[0x0f, 0xc7, 0x37],
    &[0x0f, 0xc7, 0x3f],
    &[0x0f, 0xc7, 0x5c, 0x24, 0x40],
    &[0x0f, 0xc7, 0x64, 0x24, 0x40],
    &[0x0f, 0xc7, 0x6c, 0x24, 0x40],
    &[0x0f, 0xc7, 0x74, 0x24, 0x40],
    &[0x0f, 0xc7, 0x7c, 0x24, 0x40],
    &[0x0f, 0xc7, 0xf5],
    &[0x0f, 0xc7, 0xfd],
    &[0x0f, 0xd8, 0xc2],
    &[0x0f, 0xd9, 0xc2],
    &[0x0f, 0xda, 0xc2],
    &[0x0f, 0xdb, 0xc2],
    &[0x0f, 0xdc, 0xc2],
    &[0x0f, 0xdd, 0xc2],
    &[0x0f, 0xde, 0xc2],
    &[0x0f, 0xdf, 0xc2],
    &[0x0f, 0xe5, 0x3d, 0xaa, 0xbb, 0xcc, 0x77],
    &[0x0f, 0xe7, 0x03],
    &[0x0f, 0xe8, 0xc2],
    &[0x0f, 0xe9, 0xc2],
    &[0x0f, 0xea, 0xc2],
    &[0x0f, 0xeb, 0xc2],
    &[0x0f, 0xec, 0xc2],
    &[0x0f, 0xed, 0xc2],
    &[0x0f, 0xee, 0xc2],
    &[0x0f, 0xef, 0xc2],
    &[0x0f, 0xf1, 0xc2],
    &[0x0f, 0xf2, 0xc2],
    &[0x0f, 0xf3, 0xc2],
    &[0x0f, 0xf4, 0xc2],
    &[0x0f, 0xf5, 0xc2],
    &[0x0f, 0xf6, 0xc2],
    &[0x0f, 0xf7, 0xc1],
    &[0x0f, 0xf8, 0xc2],
    &[0x0f, 0xf9, 0xc2],
    &[0x0f, 0xf9, 0xc2],
    &[0x0f, 0xfa, 0xc2],
    &[0x0f, 0xfb, 0xc2],
    &[0x0f, 0xfc, 0xc2],
    &[0x0f, 0xfd, 0xc2],
    &[0x0f, 0xfd, 0xd2],
    &[0x0f, 0xfe, 0xc2],
    &[0x26, 0x36, 0x0f, 0x0f, 0x70, 0xfb, 0x0c],
    &[0x26, 0x36, 0x0f, 0x0f, 0x70, 0xfb, 0x0c],
    &[0x26, 0x66, 0x67, 0x41, 0x0f, 0x38, 0xdf, 0xe4],
    &[0x2e, 0x36, 0x47, 0x0f, 0x18, 0xe7],
    &[0x2e, 0x3e, 0x66, 0x3e, 0x49, 0x0f, 0x3a, 0x41, 0x30, 0x48],
    &[0x2e, 0x66, 0x26, 0x64, 0x49, 0x0f, 0x3a, 0x21, 0x0b, 0xb1, ],
    &[0x2e, 0x66, 0x40, 0x0f, 0x3a, 0x0d, 0x40, 0x2d, 0x57],
    &[0x2e, 0x67, 0x65, 0x2e, 0x46, 0x0f, 0x01, 0xff],
    &[0x31, 0xc9],
    &[0x33, 0x04, 0x0a],
    &[0x33, 0x04, 0x20],
    &[0x33, 0x04, 0x25, 0x11, 0x22, 0x33, 0x44],
    &[0x33, 0x04, 0x4a],
    &[0x33, 0x04, 0x60],
    &[0x33, 0x04, 0x8a],
    &[0x33, 0x04, 0xa0],
    &[0x33, 0x04, 0xca],
    &[0x33, 0x04, 0xe0],
    &[0x33, 0x04, 0xe5, 0x11, 0x22, 0x33, 0x44],
    &[0x33, 0x05, 0x78, 0x56, 0x34, 0x12],
    &[0x33, 0x08],
    &[0x33, 0x20],
    &[0x33, 0x41, 0x23],
    &[0x33, 0x44, 0x65, 0x11],
    &[0x33, 0x81, 0x23, 0x01, 0x65, 0x43],
    &[0x33, 0x84, 0xa5, 0x11, 0x22, 0x33, 0x44],
    &[0x33, 0xc0],
    &[0x33, 0xc1],
    &[0x36, 0x26, 0x66, 0x0f, 0x38, 0xf8, 0xad, 0x0b, 0x08, 0x29, 0x07],
    &[0x36, 0x26, 0x66, 0x0f, 0x38, 0xf8, 0xad, 0x0b, 0x08, 0x29, 0x07],
    &[0x36, 0x26, 0x66, 0x67, 0x0f, 0x38, 0xf8, 0xad, 0x0b, 0x08, 0x29, 0x07],
    &[0x36, 0x26, 0x66, 0x67, 0x0f, 0x38, 0xf8, 0xad, 0x0b, 0x08, 0x29, 0x07],
    &[0x36, 0x36, 0x2e, 0x0f, 0x38, 0xf9, 0x55, 0x3e, ],
    &[0x36, 0x36, 0x2e, 0x0f, 0x38, 0xf9, 0x55, 0x3e, ],
    &[0x3d, 0x01, 0xf0, 0xff, 0xff],
    &[0x3e, 0x4f, 0x0f, 0x38, 0xf6, 0x23],
    &[0x3e, 0x64, 0x64, 0x66, 0x4e, 0x0f, 0x3a, 0xcf, 0xba, 0x13, 0x23, 0x04, 0xba, 0x6b],
    &[0x3e, 0x64, 0xf3, 0x64, 0x0f, 0x38, 0xf8, 0x72, 0x54],
    &[0x3e, 0x64, 0xf3, 0x64, 0x0f, 0x38, 0xf8, 0x72, 0x54],
    &[0x3e, 0xf3, 0x2e, 0xf2, 0x0f, 0x0f, 0x64, 0x93, 0x93, 0xa4],
    &[0x40, 0x0f, 0x22, 0xd0],
    &[0x40, 0x0f, 0x23, 0xc8],
    &[0x40, 0x0f, 0x23, 0xc8],
    &[0x40, 0x32, 0xc5],
    &[0x41, 0x0f, 0x7e, 0xcf],
    &[0x41, 0x33, 0x04, 0x25, 0x11, 0x22, 0x33, 0x44],
    &[0x41, 0x33, 0x04, 0xe5, 0x11, 0x22, 0x33, 0x44],
    &[0x41, 0x33, 0x44, 0x65, 0x11],
    &[0x41, 0x33, 0x84, 0xa5, 0x11, 0x22, 0x33, 0x44],
    &[0x41, 0x5e],
    &[0x42, 0x33, 0x04, 0x20],
    &[0x42, 0x33, 0x04, 0x60],
    &[0x42, 0x33, 0x04, 0xa0],
    &[0x42, 0x33, 0x04, 0xe0],
    &[0x42, 0x33, 0x34, 0x25, 0x20, 0x30, 0x40, 0x50],
    &[0x42, 0x33, 0x74, 0x25, 0x20],
    &[0x42, 0x33, 0xb4, 0x25, 0x20, 0x30, 0x40, 0x50],
    &[0x43, 0x33, 0x04, 0x20],
    &[0x43, 0x33, 0x04, 0x60],
    &[0x43, 0x33, 0x04, 0xa0],
    &[0x43, 0x33, 0x04, 0xe0],
    &[0x43, 0x33, 0x34, 0x25, 0x20, 0x30, 0x40, 0x50],
    &[0x43, 0x33, 0x74, 0x25, 0x20],
    &[0x43, 0x33, 0xb4, 0x25, 0x20, 0x30, 0x40, 0x50],
    &[0x44, 0x33, 0x05, 0x78, 0x56, 0x34, 0x12],
    &[0x44, 0x33, 0x08],
    &[0x44, 0x33, 0x20],
    &[0x44, 0x33, 0x41, 0x23],
    &[0x44, 0x33, 0x81, 0x23, 0x01, 0x65, 0x43],
    &[0x44, 0x33, 0xc1],
    &[0x45, 0x0f, 0x20, 0xc0],
    &[0x45, 0x0f, 0x22, 0xc0],
    &[0x45, 0x33, 0x05, 0x78, 0x56, 0x34, 0x12],
    &[0x45, 0x33, 0x08],
    &[0x45, 0x33, 0x20],
    &[0x45, 0x33, 0x41, 0x23],
    &[0x45, 0x33, 0x81, 0x23, 0x01, 0x65, 0x43],
    &[0x45, 0x33, 0xc1],
    &[0x45, 0x66, 0x0f, 0x21, 0xc8],
    &[0x45, 0xf2, 0x0f, 0x21, 0xc8],
    &[0x45, 0xf3, 0x0f, 0x21, 0xc8],
    &[0x46, 0x63, 0xc1],
    &[0x48, 0x03, 0x0b],
    &[0x48, 0x0f, 0x02, 0xc0],
    &[0x48, 0x0f, 0x03, 0xc0],
    &[0x48, 0x0f, 0x05],
    &[0x48, 0x0f, 0x2c, 0xcf],
    &[0x48, 0x0f, 0xa3, 0xd0],
    &[0x48, 0x0f, 0xab, 0xd0],
    &[0x48, 0x0f, 0xb3, 0xd0],
    &[0x48, 0x0f, 0xc7, 0xf5],
    &[0x48, 0x0f, 0xc7, 0xfd],
    &[0x48, 0x29, 0xc8],
    &[0x48, 0x33, 0x05, 0x78, 0x56, 0x34, 0x12],
    &[0x48, 0x33, 0x08],
    &[0x48, 0x33, 0x20],
    &[0x48, 0x33, 0x41, 0x23],
    &[0x48, 0x33, 0x81, 0x23, 0x01, 0x65, 0x43],
    &[0x48, 0x33, 0xc1],
    &[0x48, 0x39, 0xc6],
    &[0x48, 0x3d, 0x01, 0xf0, 0xff, 0xff],
    &[0x48, 0x63, 0x04, 0xba],
    &[0x48, 0x83, 0xf8, 0xff],
    &[0x48, 0x89, 0x43, 0x18],
    &[0x48, 0x89, 0x44, 0x24, 0x08],
    &[0x48, 0x8b, 0x32],
    &[0x48, 0x8d, 0x0c, 0x12],
    &[0x48, 0x8d, 0x53, 0x08],
    &[0x48, 0x8d, 0xa4, 0xc7, 0x20, 0x00, 0x00, 0x12],
    &[0x48, 0x8f, 0x00],
    &[0x48, 0x98],
    &[0x48, 0xc7, 0x04, 0x24, 0x00, 0x00, 0x00, 0x00],
    &[0x48, 0xc7, 0x43, 0x10, 0x00, 0x00, 0x00, 0x00],
    &[0x48, 0xcf],
    &[0x48, 0xff, 0x00],
    &[0x49, 0x89, 0x46, 0x10],
    &[0x49, 0x89, 0x4e, 0x08],
    &[0x4b, 0x69, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65],
    &[0x4b, 0x6b, 0x43, 0x6f, 0x6d],
    &[0x4c, 0x0f, 0xff, 0x6b, 0xac],
    &[0x4d, 0x0f, 0x43, 0xec],
    &[0x4d, 0x8b, 0x4c, 0x10, 0xf8],
    &[0x4f, 0x0f, 0x01, 0xe0],
    &[0x4f, 0x0f, 0x01, 0xf0],
    &[0x4f, 0x0f, 0x18, 0x20],
    &[0x4f, 0x0f, 0x28, 0x00],
    &[0x4f, 0x0f, 0x29, 0x00],
    &[0x4f, 0x0f, 0x2a, 0x00],
    &[0x4f, 0x0f, 0x2a, 0xcf],
    &[0x4f, 0x0f, 0x2b, 0x00],
    &[0x4f, 0x0f, 0x2c, 0xcf],
    &[0x4f, 0x0f, 0x2e, 0x00],
    &[0x4f, 0x0f, 0x2f, 0x00],
    &[0x4f, 0x0f, 0x38, 0xf0, 0x06],
    &[0x4f, 0x0f, 0x38, 0xf1, 0x06],
    &[0x4f, 0x0f, 0x50, 0xc1],
    &[0x4f, 0x0f, 0x51, 0x01],
    &[0x4f, 0x0f, 0x52, 0x01],
    &[0x4f, 0x0f, 0x53, 0x01],
    &[0x4f, 0x0f, 0x54, 0x01],
    &[0x4f, 0x0f, 0x55, 0x01],
    &[0x4f, 0x0f, 0x56, 0x01],
    &[0x4f, 0x0f, 0x57, 0x01],
    &[0x4f, 0x0f, 0x58, 0x01],
    &[0x4f, 0x0f, 0x59, 0x01],
    &[0x4f, 0x0f, 0x5a, 0x01],
    &[0x4f, 0x0f, 0x5b, 0x01],
    &[0x4f, 0x0f, 0x5c, 0x01],
    &[0x4f, 0x0f, 0x5d, 0x01],
    &[0x4f, 0x0f, 0x5e, 0x01],
    &[0x4f, 0x0f, 0x5f, 0x01],
    &[0x4f, 0x0f, 0x70, 0x00, 0x7f],
    &[0x4f, 0x0f, 0x70, 0x00, 0x7f],
    &[0x4f, 0x0f, 0x7e, 0xcf],
    &[0x4f, 0x0f, 0x7f, 0x0f],
    &[0x4f, 0x0f, 0x7f, 0xcf],
    &[0x4f, 0x0f, 0xb2, 0x00],
    &[0x4f, 0x0f, 0xc3, 0x03],
    &[0x4f, 0x0f, 0xc4, 0x00, 0x14],
    &[0x4f, 0x0f, 0xc4, 0xc0, 0x14],
    &[0x4f, 0x0f, 0xc7, 0x0f],
    &[0x4f, 0x0f, 0xc7, 0x0f],
    &[0x4f, 0x0f, 0xc7, 0x5c, 0x24, 0x40],
    &[0x4f, 0x0f, 0xc7, 0x64, 0x24, 0x40],
    &[0x4f, 0x0f, 0xc7, 0x6c, 0x24, 0x40],
    &[0x4f, 0x0f, 0xd1, 0x00],
    &[0x4f, 0x0f, 0xd1, 0xcf],
    &[0x4f, 0x0f, 0xd7, 0xcf],
    &[0x4f, 0x0f, 0xe7, 0x03],
    &[0x4f, 0x0f, 0xf7, 0xc1],
    &[0x4f, 0x4e, 0x00, 0xcc],
    &[0x4f, 0x66, 0x0f, 0x28, 0x00],
    &[0x4f, 0x66, 0x0f, 0x2a, 0x00],
    &[0x4f, 0x66, 0x0f, 0x2a, 0xcf],
    &[0x4f, 0x91],
    &[0x4f, 0xe5, 0x99],
    &[0x4f, 0xe7, 0x99],
    &[0x4f, 0xf2, 0x0f, 0x2a, 0x00],
    &[0x4f, 0xf2, 0x0f, 0x2a, 0xcf],
    &[0x4f, 0xf3, 0x0f, 0x2a, 0x00],
    &[0x4f, 0xf3, 0x0f, 0x2a, 0xcf],
    &[0x5b],
    &[0x62, 0xf2, 0x7d, 0x08, 0x2a, 0x44, 0x40, 0x01],
    &[0x62, 0xf2, 0x7d, 0x48, 0x2a, 0x44, 0x40, 0x01],
    &[0x65, 0x4c, 0x89, 0x04, 0x25, 0xa8, 0x01, 0x00, 0x00],
    &[0x65, 0x66, 0x66, 0x64, 0x48, 0x0f, 0x38, 0xdb, 0x0f],
    &[0x65, 0x67, 0x65, 0x65, 0x0f, 0x0e],
    &[0x65, 0x67, 0x65, 0x65, 0x0f, 0x0e],
    &[0x65, 0xf0, 0x87, 0x0f],
    &[0x66, 0x0f, 0x01, 0xcc],
    &[0x66, 0x0f, 0x01, 0xcd],
    &[0x66, 0x0f, 0x01, 0xce],
    &[0x66, 0x0f, 0x01, 0xcf],
    &[0x66, 0x0f, 0x05],
    &[0x66, 0x0f, 0x0f, 0xc6, 0xb7],
    &[0x66, 0x0f, 0x10, 0xc0],
    &[0x66, 0x0f, 0x1f, 0x44, 0x00, 0x00],
    &[0x66, 0x0f, 0x28, 0x00],
    &[0x66, 0x0f, 0x28, 0xd0],
    &[0x66, 0x0f, 0x29, 0x00],
    &[0x66, 0x0f, 0x38, 0x80, 0x2f],
    &[0x66, 0x0f, 0x38, 0x81, 0x2f],
    &[0x66, 0x0f, 0x38, 0x82, 0x2f],
    &[0x66, 0x0f, 0x38, 0xf1, 0x06],
    &[0x66, 0x0f, 0x38, 0xf5, 0x47, 0xe9],
    &[0x66, 0x0f, 0x38, 0xf6, 0x01],
    &[0x66, 0x0f, 0x38, 0xf6, 0xc1],
    &[0x66, 0x0f, 0xa4, 0xcf, 0x11],
    &[0x66, 0x0f, 0xac, 0xcf, 0x11],
    &[0x66, 0x0f, 0xae, 0x37],
    &[0x66, 0x0f, 0xae, 0x3f],
    &[0x66, 0x0f, 0xae, 0xf1],
    &[0x66, 0x0f, 0xae, 0xf7],
    &[0x66, 0x0f, 0xaf, 0xd1],
    &[0x66, 0x0f, 0xc0, 0xcc],
    &[0x66, 0x0f, 0xc1, 0xcc],
    &[0x66, 0x0f, 0xc5, 0xd8, 0xff],
    &[0x66, 0x0f, 0xc7, 0x0f],
    &[0x66, 0x0f, 0xc7, 0x33],
    &[0x66, 0x0f, 0xc7, 0x37],
    &[0x66, 0x0f, 0xc7, 0xf5],
    &[0x66, 0x0f, 0xc7, 0xf7],
    &[0x66, 0x0f, 0xc7, 0xfd],
    &[0x66, 0x0f, 0xef, 0xc0],
    &[0x66, 0x26, 0x45, 0x0f, 0x3a, 0x42, 0x96, 0x74, 0x29, 0x96, 0xf9, 0x6a],
    &[0x66, 0x2e, 0x0f, 0x1f, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00],
    &[0x66, 0x2e, 0x67, 0x0f, 0x3a, 0x0d, 0xb8, 0xf0, 0x2f, 0x7c, 0xf0, 0x63, ],
    &[0x66, 0x2e, 0xf2, 0xf0, 0x0f, 0xbb, 0x13],
    &[0x66, 0x36, 0x0f, 0x3a, 0xce, 0x8c, 0x56, 0x9e, 0x82, 0xd1, 0xbe, 0xad],
    &[0x66, 0x3e, 0x26, 0x2e, 0x2e, 0x0f, 0x38, 0x2a, 0x2b, ],
    &[0x66, 0x41, 0x0f, 0xb3, 0xc0],
    &[0x66, 0x41, 0x31, 0xc0],
    &[0x66, 0x41, 0x32, 0xc0],
    &[0x66, 0x41, 0x50],
    &[0x66, 0x45, 0x0f, 0xa4, 0xcf, 0x11],
    &[0x66, 0x45, 0x0f, 0xac, 0xcf, 0x11],
    &[0x66, 0x48, 0x0f, 0x10, 0xc0],
    &[0x66, 0x49, 0x0f, 0x38, 0x80, 0x2f],
    &[0x66, 0x49, 0x0f, 0x38, 0x81, 0x2f],
    &[0x66, 0x49, 0x0f, 0x38, 0x82, 0x2f],
    &[0x66, 0x4a, 0x0f, 0x10, 0xc0],
    &[0x66, 0x4b, 0x0f, 0x10, 0xc0],
    &[0x66, 0x4c, 0x0f, 0x10, 0xc0],
    &[0x66, 0x4d, 0x0f, 0x10, 0xc0],
    &[0x66, 0x4e, 0x0f, 0x38, 0xcf, 0x1c, 0x54],
    &[0x66, 0x4e, 0x0f, 0x3a, 0x44, 0x88, 0xb3, 0xad, 0x26, 0x35, 0x75],
    &[0x66, 0x4f, 0x0f, 0x28, 0x00],
    &[0x66, 0x4f, 0x0f, 0x28, 0x00],
    &[0x66, 0x4f, 0x0f, 0x2a, 0x00],
    &[0x66, 0x4f, 0x0f, 0x2a, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xf6, 0x01],
    &[0x66, 0x4f, 0x0f, 0xae, 0xf1],
    &[0x66, 0x4f, 0x0f, 0xb2, 0x00],
    &[0x66, 0x4f, 0x0f, 0xc7, 0x0f],
    &[0x66, 0x4f, 0x0f, 0xc7, 0x33],
    &[0x66, 0x4f, 0x0f, 0xef, 0xc0],
    &[0x66, 0x4f, 0xcf],
    &[0x66, 0x66, 0x64, 0x3e, 0x0f, 0x38, 0x23, 0x9d, 0x69, 0x0f, 0xa8, 0x2d, ],
    &[0x66, 0x8f, 0x00],
    &[0x66, 0x91],
    &[0x66, 0x99],
    &[0x66, 0xc7, 0xf8, 0x10, 0x12],
    &[0x66, 0xcf],
    &[0x66, 0xf3, 0x0f, 0x01, 0xe8],
    &[0x66, 0xf3, 0x0f, 0x01, 0xea],
    &[0x66, 0xf3, 0x0f, 0xbd, 0xc1],
    &[0x66, 0xff, 0xe0],
    &[0x67, 0x26, 0x66, 0x65, 0x0f, 0x38, 0x3f, 0x9d, 0xcc, 0x03, 0xb3, 0xfa],
    &[0x67, 0x4f, 0x0f, 0x5b, 0x01],
    &[0x67, 0x4f, 0x0f, 0xb2, 0x00],
    &[0x67, 0x4f, 0x66, 0x0f, 0x28, 0x00],
    &[0x67, 0x66, 0x4f, 0x0f, 0x28, 0x00],
    &[0x67, 0x66, 0x65, 0x3e, 0x0f, 0x6d, 0xd1],
    &[0x67, 0xa0, 0x93, 0x62, 0xc4, 0x00],
    &[0x67, 0xa1, 0x93, 0x62, 0xc4, 0x00],
    &[0x67, 0xa2, 0x93, 0x62, 0xc4, 0x00],
    &[0x67, 0xa3, 0x93, 0x62, 0xc4, 0x00],
    &[0x67, 0xe5, 0x99],
    &[0x67, 0xff, 0xe0],
    &[0x68, 0x7f, 0x63, 0xc4, 0x00],
    &[0x72, 0x5a],
    &[0x73, 0x31],
    &[0x74, 0x47],
    &[0x81, 0xec, 0x10, 0x03, 0x00, 0x00],
    &[0x89, 0x55, 0x94],
    &[0x8e, 0x00],
    &[0x8e, 0x10],
    &[0x8e, 0x18],
    &[0x8e, 0x20],
    &[0x8e, 0x28],
    &[0x8f, 0x00],
    &[0x90],
    &[0x91],
    &[0x98],
    &[0x9c],
    &[0xa0, 0x93, 0x62, 0xc4, 0x00, 0x12, 0x34, 0x12, 0x34],
    &[0xa1, 0x93, 0x62, 0xc4, 0x00, 0x12, 0x34, 0x12, 0x34],
    &[0xa2, 0x93, 0x62, 0xc4, 0x00, 0x12, 0x34, 0x12, 0x34],
    &[0xa3, 0x93, 0x62, 0xc4, 0x00, 0x12, 0x34, 0x12, 0x34],
    &[0xba, 0x01, 0x00, 0x00, 0x00],
    &[0xc3],
    &[0xc6, 0xf8, 0x10],
    &[0xc7, 0xf8, 0x10, 0x12, 0x34, 0x56],
    &[0xc8, 0x01, 0x02, 0x03],
    &[0xc9],
    &[0xca, 0x12, 0x34],
    &[0xcb],
    &[0xcd, 0x00],
    &[0xcd, 0xff],
    &[0xcf],
    &[0xd2, 0xe0],
    &[0xd8, 0x03],
    &[0xd8, 0x0b],
    &[0xd8, 0x13],
    &[0xd8, 0x1b],
    &[0xd8, 0x23],
    &[0xd8, 0x2b],
    &[0xd8, 0x33],
    &[0xd8, 0x3b],
    &[0xd8, 0xc3],
    &[0xd8, 0xcb],
    &[0xd8, 0xd3],
    &[0xd8, 0xdb],
    &[0xd8, 0xe3],
    &[0xd8, 0xeb],
    &[0xd8, 0xf3],
    &[0xd8, 0xfb],
    &[0xd9, 0x03],
    &[0xd9, 0x13],
    &[0xd9, 0x1b],
    &[0xd9, 0x23],
    &[0xd9, 0x2b],
    &[0xd9, 0x33],
    &[0xd9, 0x3b],
    &[0xd9, 0xc3],
    &[0xd9, 0xcb],
    &[0xd9, 0xd0],
    &[0xd9, 0xdb],
    &[0xd9, 0xe0],
    &[0xd9, 0xe1],
    &[0xd9, 0xe4],
    &[0xd9, 0xe5],
    &[0xd9, 0xe8],
    &[0xd9, 0xe9],
    &[0xd9, 0xea],
    &[0xd9, 0xeb],
    &[0xd9, 0xec],
    &[0xd9, 0xed],
    &[0xd9, 0xee],
    &[0xd9, 0xf0],
    &[0xd9, 0xf1],
    &[0xd9, 0xf2],
    &[0xd9, 0xf3],
    &[0xd9, 0xf4],
    &[0xd9, 0xf5],
    &[0xd9, 0xf6],
    &[0xd9, 0xf7],
    &[0xd9, 0xf8],
    &[0xd9, 0xf9],
    &[0xd9, 0xfa],
    &[0xd9, 0xfb],
    &[0xd9, 0xfc],
    &[0xd9, 0xfd],
    &[0xd9, 0xfe],
    &[0xd9, 0xff],
    &[0xda, 0x03],
    &[0xda, 0x0b],
    &[0xda, 0x13],
    &[0xda, 0x1b],
    &[0xda, 0x23],
    &[0xda, 0x2b],
    &[0xda, 0x33],
    &[0xda, 0x3b],
    &[0xda, 0xc3],
    &[0xda, 0xcb],
    &[0xda, 0xd3],
    &[0xda, 0xdb],
    &[0xda, 0xe9],
    &[0xdb, 0x03],
    &[0xdb, 0x0b],
    &[0xdb, 0x13],
    &[0xdb, 0x1b],
    &[0xdb, 0x2b],
    &[0xdb, 0x3b],
    &[0xdb, 0xc3],
    &[0xdb, 0xcb],
    &[0xdb, 0xd3],
    &[0xdb, 0xdb],
    &[0xdb, 0xe0],
    &[0xdb, 0xe1],
    &[0xdb, 0xe2],
    &[0xdb, 0xe3],
    &[0xdb, 0xe4],
    &[0xdb, 0xeb],
    &[0xdb, 0xf3],
    &[0xdc, 0x03],
    &[0xdc, 0x0b],
    &[0xdc, 0x13],
    &[0xdc, 0x1b],
    &[0xdc, 0x23],
    &[0xdc, 0x2b],
    &[0xdc, 0x33],
    &[0xdc, 0x3b],
    &[0xdc, 0xc3],
    &[0xdc, 0xcb],
    &[0xdc, 0xd3],
    &[0xdc, 0xdb],
    &[0xdc, 0xe3],
    &[0xdc, 0xeb],
    &[0xdc, 0xf3],
    &[0xdc, 0xfb],
    &[0xdd, 0x03],
    &[0xdd, 0x0b],
    &[0xdd, 0x13],
    &[0xdd, 0x1b],
    &[0xdd, 0x23],
    &[0xdd, 0x33],
    &[0xdd, 0x3b],
    &[0xdd, 0xc3],
    &[0xdd, 0xcb],
    &[0xdd, 0xd3],
    &[0xdd, 0xdb],
    &[0xdd, 0xe3],
    &[0xdd, 0xeb],
    &[0xde, 0x03],
    &[0xde, 0x0b],
    &[0xde, 0x13],
    &[0xde, 0x1b],
    &[0xde, 0x23],
    &[0xde, 0x2b],
    &[0xde, 0x33],
    &[0xde, 0x3b],
    &[0xde, 0xc3],
    &[0xde, 0xcb],
    &[0xde, 0xd3],
    &[0xde, 0xd9],
    &[0xde, 0xe3],
    &[0xde, 0xeb],
    &[0xde, 0xf3],
    &[0xde, 0xfb],
    &[0xdf, 0x03],
    &[0xdf, 0x0b],
    &[0xdf, 0x13],
    &[0xdf, 0x1b],
    &[0xdf, 0x23],
    &[0xdf, 0x2b],
    &[0xdf, 0x33],
    &[0xdf, 0x3b],
    &[0xdf, 0xc3],
    &[0xdf, 0xcb],
    &[0xdf, 0xd3],
    &[0xdf, 0xdb],
    &[0xdf, 0xe0],
    &[0xdf, 0xeb],
    &[0xdf, 0xf3],
    &[0xe0, 0x12],
    &[0xe1, 0x12],
    &[0xe2, 0x12],
    &[0xe3, 0x12],
    &[0xe4, 0x99],
    &[0xe5, 0x99],
    &[0xe6, 0x99],
    &[0xec],
    &[0xed],
    &[0xee],
    &[0xef],
    &[0xf0, 0x0f, 0xbb, 0x17],
    &[0xf0, 0x31, 0x00],
    &[0xf0, 0x80, 0x30, 0x00],
    &[0xf1],
    &[0xf2, 0x0f, 0x01, 0xe8],
    &[0xf2, 0x0f, 0x01, 0xe9],
    &[0xf2, 0x0f, 0x06],
    &[0xf2, 0x0f, 0x07],
    &[0xf2, 0x0f, 0x10, 0x0c, 0xc6],
    &[0xf2, 0x0f, 0x38, 0xf0, 0xc1],
    &[0xf2, 0x0f, 0x38, 0xf1, 0xc1],
    &[0xf2, 0x0f, 0x59, 0xc8],
    &[0xf2, 0x0f, 0xae, 0xf1],
    &[0xf2, 0x0f, 0xc0, 0xcc],
    &[0xf2, 0x0f, 0xc1, 0xcc],
    &[0xf2, 0x0f, 0xc7, 0x0f],
    &[0xf2, 0x3e, 0x26, 0x67, 0x0f, 0xf0, 0xa0, 0x1b, 0x5f, 0xcd, 0xd7],
    &[0xf2, 0x4f, 0x0f, 0x2a, 0x00],
    &[0xf2, 0x4f, 0x0f, 0x2a, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x59, 0xc8],
    &[0xf2, 0x4f, 0x0f, 0xae, 0xf1],
    &[0xf2, 0x4f, 0x0f, 0xc7, 0x0f],
    &[0xf2, 0x66, 0x66, 0x4d, 0x0f, 0x10, 0xc0],
    &[0xf2, 0xf2, 0x2e, 0x36, 0x47, 0x0f, 0x38, 0xf8, 0x83, 0x09, 0x1c, 0x9d, 0x3f],
    &[0xf2, 0xf2, 0x2e, 0x36, 0x47, 0x0f, 0x38, 0xf8, 0x83, 0x09, 0x1c, 0x9d, 0x3f],
    &[0xf3, 0x0f, 0x01, 0x29],
    &[0xf3, 0x0f, 0x01, 0xe8],
    &[0xf3, 0x0f, 0x01, 0xea],
    &[0xf3, 0x0f, 0x01, 0xec],
    &[0xf3, 0x0f, 0x01, 0xed],
    &[0xf3, 0x0f, 0x01, 0xee],
    &[0xf3, 0x0f, 0x01, 0xef],
    &[0xf3, 0x0f, 0x10, 0x04, 0x86],
    &[0xf3, 0x0f, 0x10, 0x0c, 0xc7],
    &[0xf3, 0x0f, 0x11, 0x0c, 0xc7],
    &[0xf3, 0x0f, 0x16, 0xcf],
    &[0xf3, 0x0f, 0x38, 0xf6, 0x01],
    &[0xf3, 0x0f, 0x38, 0xf6, 0xc1],
    &[0xf3, 0x0f, 0x38, 0xfa, 0xde],
    &[0xf3, 0x0f, 0x38, 0xfb, 0xde],
    &[0xf3, 0x0f, 0x59, 0xc8],
    &[0xf3, 0x0f, 0x6f, 0x07],
    &[0xf3, 0x0f, 0x70, 0xc0, 0x4e],
    &[0xf3, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x0f, 0x7f, 0x45, 0x00],
    &[0xf3, 0x0f, 0xae, 0x26],
    &[0xf3, 0x0f, 0xae, 0x30],
    &[0xf3, 0x0f, 0xae, 0xc4],
    &[0xf3, 0x0f, 0xae, 0xcc],
    &[0xf3, 0x0f, 0xae, 0xd4],
    &[0xf3, 0x0f, 0xae, 0xdc],
    &[0xf3, 0x0f, 0xae, 0xe6],
    &[0xf3, 0x0f, 0xae, 0xe9],
    &[0xf3, 0x0f, 0xae, 0xf1],
    &[0xf3, 0x0f, 0xbd, 0xc1],
    &[0xf3, 0x0f, 0xc0, 0xcc],
    &[0xf3, 0x0f, 0xc1, 0xcc],
    &[0xf3, 0x0f, 0xc2, 0xc3, 0x08],
    &[0xf3, 0x0f, 0xc7, 0x0f],
    &[0xf3, 0x0f, 0xc7, 0x33],
    &[0xf3, 0x0f, 0xc7, 0x37],
    &[0xf3, 0x0f, 0xc7, 0xf0],
    &[0xf3, 0x0f, 0xc7, 0xf2],
    &[0xf3, 0x0f, 0xc7, 0xfd],
    &[0xf3, 0x40, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x41, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x41, 0x0f, 0xc7, 0xf0],
    &[0xf3, 0x41, 0x0f, 0xc7, 0xf5],
    &[0xf3, 0x42, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x44, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x45, 0x0f, 0xbc, 0xd7],
    &[0xf3, 0x48, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x48, 0x0f, 0xbd, 0xc1],
    &[0xf3, 0x48, 0xa5],
    &[0xf3, 0x48, 0xab],
    &[0xf3, 0x49, 0x0f, 0xae, 0x26],
    &[0xf3, 0x4d, 0x0f, 0x16, 0xcf],
    &[0xf3, 0x4f, 0x0f, 0x2a, 0x00],
    &[0xf3, 0x4f, 0x0f, 0x2a, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x2a, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0x2a, 0xcf],
    &[0xf3, 0x4f, 0x0f, 0x2c, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x2c, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0x2d, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x2d, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0x38, 0xf6, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x51, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x52, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x53, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x53, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0x58, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x59, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5a, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5b, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5c, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5d, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5e, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x5f, 0x01],
    &[0xf3, 0x4f, 0x0f, 0x7e, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0xae, 0xc4],
    &[0xf3, 0x4f, 0x0f, 0xae, 0xcc],
    &[0xf3, 0x4f, 0x0f, 0xae, 0xd4],
    &[0xf3, 0x4f, 0x0f, 0xae, 0xdc],
    &[0xf3, 0x4f, 0x0f, 0xae, 0xe9],
    &[0xf3, 0x4f, 0x0f, 0xc2, 0x03, 0x08],
    &[0xf3, 0x4f, 0x0f, 0xc2, 0xc3, 0x08],
    &[0xf3, 0x4f, 0x0f, 0xc7, 0x0f],
    &[0xf3, 0x4f, 0x0f, 0xc7, 0x33],
    &[0xf3, 0x64, 0x2e, 0x65, 0x0f, 0x38, 0xdc, 0xe8],
    &[0xf3, 0x64, 0x2e, 0x65, 0x0f, 0x38, 0xdc, 0xe8],
    &[0xf3, 0x66, 0x0f, 0x01, 0x29],
    &[0xf3, 0x66, 0x0f, 0x01, 0xe8],
    &[0xf3, 0x66, 0x0f, 0x01, 0xea],
    &[0xf5],
    &[0xf6, 0x05, 0x2c, 0x9b, 0xff, 0xff, 0x01],
    &[0xf6, 0x28],
    &[0xf6, 0xc2, 0x18],
    &[0xf6, 0xe8],
    &[0xfe, 0x00],
    &[0xfe, 0x08],
    &[0xff, 0x00],
    &[0xff, 0x15, 0x7e, 0x72, 0x24, 0x00],
    &[0xff, 0x18],
    &[0xff, 0x24, 0xcd, 0x70, 0xa0, 0xbc, 0x01],
    &[0xff, 0x75, 0x08],
    &[0xff, 0x75, 0xb8],
    &[0xff, 0xe0],
    &[0x0f, 0xbb, 0x17],
    &[0x41, 0x0f, 0xbc, 0xd3],
    &[0xf0, 0x0f, 0xbb, 0x17],
    &[0x41, 0x0f, 0xbc, 0xd3],
    &[0xc4, 0xc2, 0x60, 0xf2, 0x01],
    &[0xc4, 0xc2, 0x60, 0xf7, 0x01],
    &[0xc4, 0xc2, 0x78, 0xf3, 0x09],
    &[0xc4, 0xc2, 0x78, 0xf3, 0x11],
    &[0xc4, 0xc2, 0x78, 0xf3, 0x19],
    &[0xc4, 0xc2, 0xe0, 0xf2, 0x01],
    &[0xc4, 0xc2, 0xe0, 0xf7, 0x01],
    &[0xc4, 0xc2, 0xf8, 0xf3, 0x09],
    &[0xc4, 0xc2, 0xf8, 0xf3, 0x11],
    &[0xc4, 0xc2, 0xf8, 0xf3, 0x19],
    &[0xf2, 0x41, 0x0f, 0xbc, 0xd3],
    &[0xf3, 0x41, 0x0f, 0xbc, 0xd3],
    &[0xc4, 0xc2, 0x61, 0xf7, 0x01],
    &[0xc4, 0xc2, 0x62, 0xf7, 0x01],
    &[0xc4, 0xc2, 0x63, 0xf7, 0x01],
    &[0xc4, 0xc2, 0xe1, 0xf7, 0x01],
    &[0xc4, 0xc2, 0xe2, 0xf7, 0x01],
    &[0xc4, 0xc2, 0xe3, 0xf7, 0x01],
    &[0xc4, 0xc3, 0x7b, 0xf0, 0x01, 0x05],
    &[0xc4, 0xc3, 0xfb, 0xf0, 0x01, 0x05],
    &[0xc4, 0xe2, 0x60, 0xf5, 0x07],
    &[0xc4, 0xe2, 0x62, 0xf5, 0x07],
    &[0xc4, 0xe2, 0x63, 0xf5, 0x07],
    &[0xc4, 0xe2, 0x63, 0xf6, 0x07],
    &[0xc4, 0xe2, 0xe0, 0xf5, 0x07],
    &[0xc4, 0xe2, 0xe2, 0xf5, 0x07],
    &[0xc4, 0xe2, 0xe3, 0xf5, 0x07],
    &[0xc4, 0xe2, 0xe3, 0xf6, 0x07],
    &[0xf3, 0x0f, 0xb8, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0xb8, 0xc1],
    &[0xf3, 0x41, 0x0f, 0xbc, 0xd3],
    &[0xf3, 0x0f, 0xb8, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0xb8, 0xc1],
    &[0x0f, 0x01, 0xc8],
    &[0x0f, 0x01, 0xc9],
    &[0x0f, 0x38, 0x00, 0x06],
    &[0x0f, 0x38, 0x01, 0x06],
    &[0x0f, 0x38, 0x02, 0x06],
    &[0x0f, 0x38, 0x03, 0x06],
    &[0x0f, 0x38, 0x04, 0x06],
    &[0x0f, 0x38, 0x05, 0x06],
    &[0x0f, 0x38, 0x06, 0x06],
    &[0x0f, 0x38, 0x07, 0x06],
    &[0x0f, 0x38, 0x08, 0x06],
    &[0x0f, 0x38, 0x09, 0x06],
    &[0x0f, 0x38, 0x0a, 0x06],
    &[0x0f, 0x38, 0x0b, 0x06],
    &[0x0f, 0x38, 0x1c, 0x06],
    &[0x0f, 0x38, 0x1d, 0x06],
    &[0x0f, 0x38, 0x1e, 0x06],
    &[0x0f, 0x3a, 0x0f, 0x06, 0x30],
    &[0x66, 0x0f, 0x11, 0x0c, 0xc7],
    &[0x66, 0x0f, 0x38, 0x00, 0x06],
    &[0x66, 0x0f, 0x38, 0x00, 0xda],
    &[0x66, 0x0f, 0x38, 0x01, 0x06],
    &[0x66, 0x0f, 0x38, 0x02, 0x06],
    &[0x66, 0x0f, 0x38, 0x03, 0x06],
    &[0x66, 0x0f, 0x38, 0x04, 0x06],
    &[0x66, 0x0f, 0x38, 0x05, 0x06],
    &[0x66, 0x0f, 0x38, 0x06, 0x06],
    &[0x66, 0x0f, 0x38, 0x07, 0x06],
    &[0x66, 0x0f, 0x38, 0x08, 0x06],
    &[0x66, 0x0f, 0x38, 0x09, 0x06],
    &[0x66, 0x0f, 0x38, 0x0a, 0x06],
    &[0x66, 0x0f, 0x38, 0x0b, 0x06],
    &[0x66, 0x0f, 0x38, 0x10, 0x06],
    &[0x66, 0x0f, 0x38, 0x14, 0x06],
    &[0x66, 0x0f, 0x38, 0x15, 0x06],
    &[0x66, 0x0f, 0x38, 0x17, 0x06],
    &[0x66, 0x0f, 0x38, 0x1c, 0x06],
    &[0x66, 0x0f, 0x38, 0x1d, 0x06],
    &[0x66, 0x0f, 0x38, 0x1e, 0x06],
    &[0x66, 0x0f, 0x38, 0x20, 0x06],
    &[0x66, 0x0f, 0x38, 0x21, 0x06],
    &[0x66, 0x0f, 0x38, 0x22, 0x06],
    &[0x66, 0x0f, 0x38, 0x23, 0x06],
    &[0x66, 0x0f, 0x38, 0x24, 0x06],
    &[0x66, 0x0f, 0x38, 0x25, 0x06],
    &[0x66, 0x0f, 0x38, 0x28, 0x06],
    &[0x66, 0x0f, 0x38, 0x29, 0x06],
    &[0x66, 0x0f, 0x38, 0x2a, 0x06],
    &[0x66, 0x0f, 0x38, 0x2b, 0x06],
    &[0x66, 0x0f, 0x38, 0x30, 0x06],
    &[0x66, 0x0f, 0x38, 0x31, 0x06],
    &[0x66, 0x0f, 0x38, 0x32, 0x06],
    &[0x66, 0x0f, 0x38, 0x33, 0x06],
    &[0x66, 0x0f, 0x38, 0x34, 0x06],
    &[0x66, 0x0f, 0x38, 0x35, 0x06],
    &[0x66, 0x0f, 0x38, 0x37, 0x03],
    &[0x66, 0x0f, 0x38, 0x37, 0xc3],
    &[0x66, 0x0f, 0x38, 0x38, 0x06],
    &[0x66, 0x0f, 0x38, 0x39, 0x06],
    &[0x66, 0x0f, 0x38, 0x3a, 0x06],
    &[0x66, 0x0f, 0x38, 0x3b, 0x06],
    &[0x66, 0x0f, 0x38, 0x3c, 0x06],
    &[0x66, 0x0f, 0x38, 0x3d, 0x06],
    &[0x66, 0x0f, 0x38, 0x3e, 0x06],
    &[0x66, 0x0f, 0x38, 0x3f, 0x06],
    &[0x66, 0x0f, 0x38, 0x40, 0x06],
    &[0x66, 0x0f, 0x38, 0x41, 0x06],
    &[0x66, 0x0f, 0x38, 0xdb, 0x0f],
    &[0x66, 0x0f, 0x38, 0xdc, 0x0f],
    &[0x66, 0x0f, 0x38, 0xdd, 0x0f],
    &[0x66, 0x0f, 0x38, 0xde, 0x0f],
    &[0x66, 0x0f, 0x38, 0xdf, 0x0f],
    &[0x66, 0x0f, 0x3a, 0x08, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x09, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x0a, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x0b, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x0c, 0x11, 0x22],
    &[0x66, 0x0f, 0x3a, 0x0c, 0xc1, 0x22],
    &[0x66, 0x0f, 0x3a, 0x0d, 0x11, 0x22],
    &[0x66, 0x0f, 0x3a, 0x0d, 0xc1, 0x22],
    &[0x66, 0x0f, 0x3a, 0x0e, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x0f, 0x06, 0x30],
    &[0x66, 0x0f, 0x3a, 0x14, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x15, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x16, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x17, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x20, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x21, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x22, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x40, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x41, 0x06, 0x31],
    &[0x66, 0x0f, 0x3a, 0x42, 0x06, 0x44],
    &[0x66, 0x0f, 0x3a, 0x60, 0x06, 0x54],
    &[0x66, 0x0f, 0x3a, 0x60, 0xc6, 0x54],
    &[0x66, 0x0f, 0x3a, 0x61, 0x06, 0x54],
    &[0x66, 0x0f, 0x3a, 0x61, 0xc6, 0x54],
    &[0x66, 0x0f, 0x3a, 0x62, 0x06, 0x54],
    &[0x66, 0x0f, 0x3a, 0x62, 0xc6, 0x54],
    &[0x66, 0x0f, 0x3a, 0x63, 0x06, 0x54],
    &[0x66, 0x0f, 0x3a, 0x63, 0xc6, 0x54],
    &[0x66, 0x0f, 0x3a, 0xdf, 0x0f, 0xaa],
    &[0x66, 0x0f, 0x70, 0xc0, 0x4e],
    &[0x66, 0x0f, 0x74, 0x12],
    &[0x66, 0x0f, 0x74, 0xc1],
    &[0x66, 0x0f, 0x78, 0xc1, 0x4e, 0x76],
    &[0x66, 0x0f, 0x79, 0xcf],
    &[0x66, 0x0f, 0x7c, 0x0f],
    &[0x66, 0x0f, 0x7c, 0xcf],
    &[0x66, 0x0f, 0x7d, 0x0f],
    &[0x66, 0x0f, 0x7d, 0xcf],
    &[0x66, 0x0f, 0x7e, 0xc1],
    &[0x66, 0x0f, 0xc2, 0xc3, 0x08],
    &[0x66, 0x0f, 0xc4, 0x03, 0x08],
    &[0x66, 0x0f, 0xc4, 0xc3, 0x08],
    &[0x66, 0x0f, 0xc6, 0x03, 0x08],
    &[0x66, 0x0f, 0xc6, 0xc3, 0x08],
    &[0x66, 0x0f, 0xd0, 0x0f],
    &[0x66, 0x0f, 0xd0, 0xcf],
    &[0x66, 0x0f, 0xd1, 0x01],
    &[0x66, 0x0f, 0xd1, 0xc1],
    &[0x66, 0x0f, 0xd2, 0x01],
    &[0x66, 0x0f, 0xd2, 0xc1],
    &[0x66, 0x0f, 0xd3, 0x01],
    &[0x66, 0x0f, 0xd3, 0xc1],
    &[0x66, 0x0f, 0xd4, 0x01],
    &[0x66, 0x0f, 0xd4, 0xc1],
    &[0x66, 0x0f, 0xd5, 0x01],
    &[0x66, 0x0f, 0xd5, 0xc1],
    &[0x66, 0x0f, 0xd6, 0x01],
    &[0x66, 0x0f, 0xd6, 0xc1],
    &[0x66, 0x0f, 0xd7, 0xc1],
    &[0x66, 0x0f, 0xd8, 0x01],
    &[0x66, 0x0f, 0xd8, 0xc1],
    &[0x66, 0x0f, 0xd9, 0x01],
    &[0x66, 0x0f, 0xd9, 0xc1],
    &[0x66, 0x0f, 0xda, 0x01],
    &[0x66, 0x0f, 0xda, 0xc1],
    &[0x66, 0x0f, 0xdb, 0x01],
    &[0x66, 0x0f, 0xdb, 0xc1],
    &[0x66, 0x0f, 0xdc, 0x01],
    &[0x66, 0x0f, 0xdc, 0xc1],
    &[0x66, 0x0f, 0xdd, 0x01],
    &[0x66, 0x0f, 0xdd, 0xc1],
    &[0x66, 0x0f, 0xde, 0x01],
    &[0x66, 0x0f, 0xde, 0xc1],
    &[0x66, 0x0f, 0xdf, 0x01],
    &[0x66, 0x0f, 0xdf, 0xc1],
    &[0x66, 0x0f, 0xe0, 0x01],
    &[0x66, 0x0f, 0xe0, 0xc1],
    &[0x66, 0x0f, 0xe1, 0x01],
    &[0x66, 0x0f, 0xe1, 0xc1],
    &[0x66, 0x0f, 0xe2, 0x01],
    &[0x66, 0x0f, 0xe2, 0xc1],
    &[0x66, 0x0f, 0xe3, 0x01],
    &[0x66, 0x0f, 0xe3, 0xc1],
    &[0x66, 0x0f, 0xe4, 0x01],
    &[0x66, 0x0f, 0xe4, 0xc1],
    &[0x66, 0x0f, 0xe5, 0x01],
    &[0x66, 0x0f, 0xe5, 0xc1],
    &[0x66, 0x0f, 0xe6, 0x01],
    &[0x66, 0x0f, 0xe6, 0xc1],
    &[0x66, 0x0f, 0xe7, 0x01],
    &[0x66, 0x0f, 0xe8, 0x01],
    &[0x66, 0x0f, 0xe8, 0xc1],
    &[0x66, 0x0f, 0xe9, 0x01],
    &[0x66, 0x0f, 0xe9, 0xc1],
    &[0x66, 0x0f, 0xea, 0x01],
    &[0x66, 0x0f, 0xea, 0xc1],
    &[0x66, 0x0f, 0xeb, 0x01],
    &[0x66, 0x0f, 0xeb, 0x12],
    &[0x66, 0x0f, 0xeb, 0xc1],
    &[0x66, 0x0f, 0xeb, 0xc3],
    &[0x66, 0x0f, 0xeb, 0xc4],
    &[0x66, 0x0f, 0xeb, 0xd3],
    &[0x66, 0x0f, 0xec, 0x01],
    &[0x66, 0x0f, 0xec, 0xc1],
    &[0x66, 0x0f, 0xed, 0x01],
    &[0x66, 0x0f, 0xed, 0xc1],
    &[0x66, 0x0f, 0xee, 0x01],
    &[0x66, 0x0f, 0xee, 0xc1],
    &[0x66, 0x0f, 0xef, 0x01],
    &[0x66, 0x0f, 0xef, 0xc1],
    &[0x66, 0x0f, 0xf1, 0x01],
    &[0x66, 0x0f, 0xf1, 0xc1],
    &[0x66, 0x0f, 0xf2, 0x01],
    &[0x66, 0x0f, 0xf2, 0xc1],
    &[0x66, 0x0f, 0xf3, 0x01],
    &[0x66, 0x0f, 0xf3, 0xc1],
    &[0x66, 0x0f, 0xf4, 0x01],
    &[0x66, 0x0f, 0xf4, 0xc1],
    &[0x66, 0x0f, 0xf5, 0x01],
    &[0x66, 0x0f, 0xf5, 0xc1],
    &[0x66, 0x0f, 0xf6, 0x01],
    &[0x66, 0x0f, 0xf6, 0xc1],
    &[0x66, 0x0f, 0xf7, 0xc1],
    &[0x66, 0x0f, 0xf8, 0x01],
    &[0x66, 0x0f, 0xf8, 0x12],
    &[0x66, 0x0f, 0xf8, 0xc1],
    &[0x66, 0x0f, 0xf8, 0xc8],
    &[0x66, 0x0f, 0xf8, 0xd0],
    &[0x66, 0x0f, 0xf9, 0x01],
    &[0x66, 0x0f, 0xf9, 0xc1],
    &[0x66, 0x0f, 0xfa, 0x01],
    &[0x66, 0x0f, 0xfa, 0xc1],
    &[0x66, 0x0f, 0xfb, 0x01],
    &[0x66, 0x0f, 0xfb, 0xc1],
    &[0x66, 0x0f, 0xfc, 0x01],
    &[0x66, 0x0f, 0xfc, 0xc1],
    &[0x66, 0x0f, 0xfd, 0x01],
    &[0x66, 0x0f, 0xfd, 0xc1],
    &[0x66, 0x0f, 0xfe, 0x01],
    &[0x66, 0x0f, 0xfe, 0xc1],
    &[0x66, 0x0f, 0xff, 0x01],
    &[0x66, 0x0f, 0xff, 0xc1],
    &[0x66, 0x48, 0x0f, 0x3a, 0x16, 0x06, 0x31],
    &[0x66, 0x48, 0x0f, 0x3a, 0x22, 0x06, 0x31],
    &[0x66, 0x48, 0x0f, 0x6e, 0xc0],
    &[0x66, 0x48, 0x0f, 0x7e, 0x01],
    &[0x66, 0x48, 0x0f, 0x7e, 0xc1],
    &[0x66, 0x4f, 0x0f, 0x12, 0x03],
    &[0x66, 0x4f, 0x0f, 0x13, 0x03],
    &[0x66, 0x4f, 0x0f, 0x14, 0x03],
    &[0x66, 0x4f, 0x0f, 0x14, 0xc3],
    &[0x66, 0x4f, 0x0f, 0x15, 0x03],
    &[0x66, 0x4f, 0x0f, 0x15, 0xc3],
    &[0x66, 0x4f, 0x0f, 0x16, 0x03],
    &[0x66, 0x4f, 0x0f, 0x17, 0x03],
    &[0x66, 0x4f, 0x0f, 0x28, 0x00],
    &[0x66, 0x4f, 0x0f, 0x28, 0xd0],
    &[0x66, 0x4f, 0x0f, 0x2a, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2a, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x2b, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2c, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2c, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x2d, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2d, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x2e, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2e, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x2f, 0x0f],
    &[0x66, 0x4f, 0x0f, 0x2f, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xdb, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xdc, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xdd, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xde, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x38, 0xdf, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x3a, 0xdf, 0xcf, 0xaa],
    &[0x66, 0x4f, 0x0f, 0x50, 0xc1],
    &[0x66, 0x4f, 0x0f, 0x51, 0x01],
    &[0x66, 0x4f, 0x0f, 0x54, 0x01],
    &[0x66, 0x4f, 0x0f, 0x55, 0x01],
    &[0x66, 0x4f, 0x0f, 0x56, 0x01],
    &[0x66, 0x4f, 0x0f, 0x57, 0x01],
    &[0x66, 0x4f, 0x0f, 0x58, 0x01],
    &[0x66, 0x4f, 0x0f, 0x59, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5a, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5b, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5c, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5d, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5e, 0x01],
    &[0x66, 0x4f, 0x0f, 0x5f, 0x01],
    &[0x66, 0x4f, 0x0f, 0x71, 0xd0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x71, 0xe0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x71, 0xf0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x72, 0xd0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x72, 0xe0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x72, 0xf0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x73, 0xd0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x73, 0xd8, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x73, 0xf0, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x73, 0xf8, 0x8f],
    &[0x66, 0x4f, 0x0f, 0x7c, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x7d, 0xcf],
    &[0x66, 0x4f, 0x0f, 0x7e, 0xc1],
    &[0x66, 0x4f, 0x0f, 0xc2, 0x03, 0x08],
    &[0x66, 0x4f, 0x0f, 0xc2, 0xc3, 0x08],
    &[0x66, 0x4f, 0x0f, 0xc4, 0x03, 0x08],
    &[0x66, 0x4f, 0x0f, 0xc4, 0xc3, 0x08],
    &[0x66, 0x4f, 0x0f, 0xc6, 0x03, 0x08],
    &[0x66, 0x4f, 0x0f, 0xd0, 0xcf],
    &[0x66, 0x4f, 0x0f, 0xd7, 0xc1],
    &[0x66, 0x4f, 0x0f, 0xff, 0xc1],
    &[0x66, 0xf2, 0x0f, 0x38, 0xf1, 0xc6],
    &[0x66, 0xf2, 0x0f, 0x79, 0xcf],
    &[0x66, 0xf2, 0x48, 0x0f, 0x38, 0xf1, 0xc6],
    &[0xc4, 0b000_00001, 0b0_0111_000, 0x14, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_000, 0x15, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_000, 0xc6, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x14, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x15, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x60, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x61, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x62, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x63, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x64, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x65, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x66, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x67, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x68, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x69, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x6a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0x6b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xc6, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xd5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xda, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xde, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xea, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xeb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xec, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xed, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xee, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_001, 0xef, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_010, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_011, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_011, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_100, 0x14, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_100, 0x15, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_100, 0xc6, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x14, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x15, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0x63, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_101, 0xc6, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b0_0111_110, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_111, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_0111_111, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0x2b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0xae, 0b00_010_001],
    &[0xc4, 0b000_00001, 0b0_1111_000, 0xae, 0b00_011_001],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x2b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x2e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x2e, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x2f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x2f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x6f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x7e, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0x7f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0xc5, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b0_1111_001, 0xd7, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x2d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x6f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_010, 0x7f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x2d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_011, 0x2d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_100, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x2e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x2e, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x2f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x2f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x5c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x6f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_101, 0x7f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x2d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x2d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x6f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_110, 0x7f, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x2c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x2d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b0_1111_111, 0x2d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x12, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x54, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x55, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x56, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x57, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x58, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_000, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x54, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x55, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x56, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x57, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x71, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x74, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x75, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x76, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x7c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0x7d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xc4, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xd9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xdb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xdc, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xdd, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xdf, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xe9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf1, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf2, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf3, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf4, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf8, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xf9, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xfa, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xfb, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xfc, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xfd, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_001, 0xfe, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x58, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_010, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x11, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x7c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0x7d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_011, 0xd0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x54, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x55, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x56, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x57, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x58, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_100, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x54, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x55, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x56, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x57, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x7c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0x7d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_101, 0xd0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x58, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_110, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x11, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x58, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x59, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x5d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x5e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x5f, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x7c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0x7d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0xc2, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_0111_111, 0xd0, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x17, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x52, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x53, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x5a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x5b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_000, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x13, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x17, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x6c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x6d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x6e, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x6e, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x71, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x71, 0b11_100_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x71, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x72, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x72, 0b11_100_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x72, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x73, 0b11_010_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x73, 0b11_011_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x73, 0b11_110_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x73, 0b11_111_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0x7e, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0xe7, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0xf5, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0xf6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_001, 0xf7, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x52, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x53, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_010, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x2d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0x70, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_011, 0xf0, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x2b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x52, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x53, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x5a, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x5b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_100, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x2b, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x50, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0x72, 0b11_100_010, 0x77],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_101, 0xe7, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x12, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x2d, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x51, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x52, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x53, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0x5b, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_110, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x10, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x11, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x2a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x2c, 0b00_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x2c, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x2d, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0x5a, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0xe6, 0b11_001_010],
    &[0xc4, 0b000_00001, 0b1_1111_111, 0xf0, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x0c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x0d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x28, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x29, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x2b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x37, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x38, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x39, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3a, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x3f, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_001, 0x40, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x0c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_0111_101, 0x0d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x00, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x01, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x02, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x03, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x04, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x05, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x06, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x07, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x08, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x09, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x0a, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x0b, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x0e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x0f, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x17, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x18, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x18, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x1c, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x1d, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x1e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x20, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x21, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x22, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x23, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x24, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x25, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x2a, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x30, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x31, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x32, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x33, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x34, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x35, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0x41, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x0e, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x0f, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x16, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x16, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x17, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x18, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x18, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x19, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x19, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x1a, 0b00_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x30, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x31, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x32, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x33, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x34, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x35, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b0_1111_101, 0x5a, 0b00_001_010],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x0a, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x0b, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x0c, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x0d, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x0e, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x20, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x20, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x21, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x22, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x22, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x40, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x41, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x42, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_001, 0x4c, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x0a, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x0b, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x0c, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x0d, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x0e, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x18, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_0111_101, 0x40, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x04, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x05, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x08, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x09, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x14, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x14, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x15, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x15, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x16, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x16, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x17, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x17, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x60, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x61, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x62, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_001, 0x63, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x04, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x05, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x06, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x06, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x08, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x09, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b0_1111_101, 0x19, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_0111_001, 0x0f, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_0111_001, 0x22, 0b00_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_0111_001, 0x22, 0b11_001_010, 0x77],
    &[0xc4, 0b000_00011, 0b1_0111_101, 0x0f, 0b11_001_010, 0x77],
    &[0xc4, 0x02, 0x09, 0x9d, 0xcd],
    &[0xc4, 0x02, 0x71, 0x00, 0x0f],
    &[0xc4, 0x02, 0x71, 0x00, 0xcd],
    &[0xc4, 0x02, 0x71, 0x01, 0x0f],
    &[0xc4, 0x02, 0x71, 0x01, 0xcd],
    &[0xc4, 0x02, 0x71, 0x02, 0x0f],
    &[0xc4, 0x02, 0x71, 0x02, 0xcd],
    &[0xc4, 0x02, 0x71, 0x03, 0x0f],
    &[0xc4, 0x02, 0x71, 0x03, 0xcd],
    &[0xc4, 0x02, 0x71, 0x04, 0x0f],
    &[0xc4, 0x02, 0x71, 0x04, 0xcd],
    &[0xc4, 0x02, 0x71, 0x05, 0x0f],
    &[0xc4, 0x02, 0x71, 0x05, 0xcd],
    &[0xc4, 0x02, 0x71, 0x06, 0x0f],
    &[0xc4, 0x02, 0x71, 0x06, 0xcd],
    &[0xc4, 0x02, 0x71, 0x07, 0x0f],
    &[0xc4, 0x02, 0x71, 0x07, 0xcd],
    &[0xc4, 0x02, 0x71, 0x08, 0x0f],
    &[0xc4, 0x02, 0x71, 0x08, 0xcd],
    &[0xc4, 0x02, 0x71, 0x09, 0x0f],
    &[0xc4, 0x02, 0x71, 0x09, 0xcd],
    &[0xc4, 0x02, 0x71, 0x0a, 0x0f],
    &[0xc4, 0x02, 0x71, 0x0a, 0xcd],
    &[0xc4, 0x02, 0x71, 0x0b, 0x0f],
    &[0xc4, 0x02, 0x71, 0x0b, 0xcd],
    &[0xc4, 0x02, 0x71, 0x0c, 0x0f],
    &[0xc4, 0x02, 0x71, 0x0c, 0xcd],
    &[0xc4, 0x02, 0x71, 0x0d, 0x0f],
    &[0xc4, 0x02, 0x71, 0x0d, 0xcd],
    &[0xc4, 0x02, 0x75, 0x00, 0x0f],
    &[0xc4, 0x02, 0x75, 0x00, 0xcd],
    &[0xc4, 0x02, 0x75, 0x01, 0x0f],
    &[0xc4, 0x02, 0x75, 0x01, 0xcd],
    &[0xc4, 0x02, 0x75, 0x02, 0x0f],
    &[0xc4, 0x02, 0x75, 0x02, 0xcd],
    &[0xc4, 0x02, 0x75, 0x03, 0x0f],
    &[0xc4, 0x02, 0x75, 0x03, 0xcd],
    &[0xc4, 0x02, 0x75, 0x04, 0x0f],
    &[0xc4, 0x02, 0x75, 0x04, 0xcd],
    &[0xc4, 0x02, 0x75, 0x05, 0x0f],
    &[0xc4, 0x02, 0x75, 0x05, 0xcd],
    &[0xc4, 0x02, 0x75, 0x06, 0x0f],
    &[0xc4, 0x02, 0x75, 0x06, 0xcd],
    &[0xc4, 0x02, 0x75, 0x07, 0x0f],
    &[0xc4, 0x02, 0x75, 0x07, 0xcd],
    &[0xc4, 0x02, 0x75, 0x08, 0x0f],
    &[0xc4, 0x02, 0x75, 0x08, 0xcd],
    &[0xc4, 0x02, 0x75, 0x09, 0x0f],
    &[0xc4, 0x02, 0x75, 0x09, 0xcd],
    &[0xc4, 0x02, 0x75, 0x0a, 0x0f],
    &[0xc4, 0x02, 0x75, 0x0a, 0xcd],
    &[0xc4, 0x02, 0x75, 0x0b, 0x0f],
    &[0xc4, 0x02, 0x75, 0x0b, 0xcd],
    &[0xc4, 0x02, 0x75, 0x0c, 0x0f],
    &[0xc4, 0x02, 0x75, 0x0c, 0xcd],
    &[0xc4, 0x02, 0x75, 0x0d, 0x0f],
    &[0xc4, 0x02, 0x75, 0x0d, 0xcd],
    &[0xc4, 0x02, 0x79, 0x0e, 0x0f],
    &[0xc4, 0x02, 0x79, 0x0e, 0xcd],
    &[0xc4, 0x02, 0x79, 0x0f, 0x0f],
    &[0xc4, 0x02, 0x79, 0x0f, 0xcd],
    &[0xc4, 0x02, 0x7d, 0x0e, 0x0f],
    &[0xc4, 0x02, 0x7d, 0x0e, 0xcd],
    &[0xc4, 0x02, 0x7d, 0x0f, 0x0f],
    &[0xc4, 0x02, 0x7d, 0x0f, 0xcd],
    &[0xc4, 0x02, 0x89, 0x9d, 0xcd],
    &[0xc4, 0xa2, 0x15, 0x3e, 0x14, 0xb9],
    &[0xc4, 0xc3, 0x71, 0x4a, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x71, 0x4a, 0xdc, 0x61],
    &[0xc4, 0xc3, 0x71, 0x4b, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x71, 0x4b, 0xdc, 0x61],
    &[0xc4, 0xc3, 0x71, 0x4c, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x75, 0x38, 0x7c, 0x12, 0x05, 0x01],
    &[0xc4, 0xc3, 0x75, 0x42, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x75, 0x46, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x75, 0x4a, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xc3, 0x75, 0x4b, 0x7c, 0x12, 0x05, 0x61],
    &[0xc4, 0xe2, 0x65, 0x90, 0x04, 0x51],
    &[0xc4, 0xe2, 0x65, 0x91, 0x04, 0x51],
    &[0xc4, 0xe2, 0xe5, 0x90, 0x04, 0x51],
    &[0xc4, 0xe2, 0xe5, 0x91, 0x04, 0x51],
    &[0xc4, 0xe3, 0x79, 0x14, 0x10, 0x0a],
    &[0xc4, 0xe3, 0x79, 0x14, 0xd0, 0x0a],
    &[0xc4, 0xe3, 0x7d, 0x19, 0xd1, 0x01],
    &[0xc4, 0xe3, 0xfd, 0x00, 0xc1, 0xa8],
    &[0xc5, 0b0_1111_000, 0x2e, 0b11_001_010],
    &[0xc5, 0b0_1111_000, 0x2f, 0b11_001_010],
    &[0xc5, 0b0_1111_010, 0x2c, 0b00_001_010],
    &[0xc5, 0b0_1111_010, 0x2c, 0b11_001_010],
    &[0xc5, 0b0_1111_010, 0x2d, 0b11_001_010],
    &[0xc5, 0b0_1111_011, 0x2a, 0b11_001_010],
    &[0xc5, 0b0_1111_011, 0x2c, 0b11_001_010],
    &[0xc5, 0b0_1111_011, 0x2d, 0b11_001_010],
    &[0xc5, 0b0_1111_100, 0x2e, 0b00_001_010],
    &[0xc5, 0b0_1111_100, 0x2f, 0b00_001_010],
    &[0xc5, 0b0_1111_110, 0x2c, 0b11_001_010],
    &[0xc5, 0b0_1111_110, 0x2d, 0b11_001_010],
    &[0xc5, 0b0_1111_111, 0x2a, 0b11_001_010],
    &[0xc5, 0b0_1111_111, 0x2c, 0b00_001_010],
    &[0xc5, 0b0_1111_111, 0x2c, 0b11_001_010],
    &[0xc5, 0b0_1111_111, 0x2d, 0b11_001_010],
    &[0xc5, 0x78, 0x10, 0x0f],
    &[0xc5, 0xc9, 0xf1, 0x0f],
    &[0xc5, 0xc9, 0xf1, 0xcf],
    &[0xc5, 0xc9, 0xf2, 0x0f],
    &[0xc5, 0xc9, 0xf2, 0xcf],
    &[0xc5, 0xc9, 0xf3, 0x0f],
    &[0xc5, 0xc9, 0xf3, 0xcf],
    &[0xc5, 0xcd, 0xf1, 0x0f],
    &[0xc5, 0xcd, 0xf1, 0xcf],
    &[0xc5, 0xcd, 0xf2, 0x0f],
    &[0xc5, 0xcd, 0xf2, 0xcf],
    &[0xc5, 0xcd, 0xf3, 0x0f],
    &[0xc5, 0xcd, 0xf3, 0xcf],
    &[0xc5, 0xe0, 0x54, 0x03],
    &[0xc5, 0xe0, 0x55, 0x03],
    &[0xc5, 0xe0, 0x56, 0x03],
    &[0xc5, 0xe1, 0x54, 0x03],
    &[0xc5, 0xe1, 0x55, 0x03],
    &[0xc5, 0xe1, 0x56, 0x03],
    &[0xc5, 0xed, 0x71, 0xd0, 0x04],
    &[0xc5, 0xed, 0x73, 0xd4, 0x20],
    &[0xc5, 0xf1, 0xc4, 0x18, 0x78],
    &[0xc5, 0xf1, 0xc4, 0xd8, 0x78],
    &[0xc5, 0xf8, 0x10, 0x00],
    &[0xc5, 0xf8, 0x10, 0x01],
    &[0xc5, 0xf8, 0x10, 0xcf],
    &[0xc5, 0xf9, 0x10, 0x0f],
    &[0xc5, 0xf9, 0x6e, 0x13],
    &[0xc5, 0xf9, 0x6e, 0xc6],
    &[0xc5, 0xf9, 0x7e, 0x13],
    &[0xc5, 0xf9, 0x7e, 0xc6],
    &[0xc5, 0xfa, 0x7e, 0x10],
    &[0xc5, 0xfc, 0x10, 0x0f],
    &[0xc5, 0xfd, 0x10, 0x0f],
    &[0xc5, 0xfd, 0xea, 0xd1],
    &[0xc5, 0xfd, 0xee, 0xd9],
    &[0xc5, 0xfe, 0x10, 0x0f],
    &[0xc5, 0xff, 0x10, 0x01],
    &[0xc5, 0xff, 0x10, 0xcf],
    &[0xf2, 0x0f, 0x10, 0x0c, 0xc7],
    &[0xf2, 0x0f, 0x11, 0x0c, 0xc7],
    &[0xf2, 0x0f, 0x12, 0x0f],
    &[0xf2, 0x0f, 0x12, 0xcf],
    &[0xf2, 0x0f, 0x2b, 0x06],
    &[0xf2, 0x0f, 0x38, 0xf0, 0x06],
    &[0xf2, 0x0f, 0x38, 0xf0, 0xc6],
    &[0xf2, 0x0f, 0x38, 0xf1, 0x06],
    &[0xf2, 0x0f, 0x38, 0xf1, 0xc6],
    &[0xf2, 0x0f, 0x70, 0xc0, 0x4e],
    &[0xf2, 0x0f, 0x78, 0xf1, 0x4e, 0x76],
    &[0xf2, 0x0f, 0x79, 0xcf],
    &[0xf2, 0x0f, 0x7c, 0x0f],
    &[0xf2, 0x0f, 0x7c, 0xcf],
    &[0xf2, 0x0f, 0x7d, 0x0f],
    &[0xf2, 0x0f, 0x7d, 0xcf],
    &[0xf2, 0x0f, 0xc2, 0xc3, 0x08],
    &[0xf2, 0x0f, 0xd0, 0x0f],
    &[0xf2, 0x0f, 0xd0, 0xcf],
    &[0xf2, 0x0f, 0xf0, 0x0f],
    &[0xf2, 0x0f, 0xff, 0xc1],
    &[0xf2, 0x4f, 0x0f, 0x12, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x2a, 0x0f],
    &[0xf2, 0x4f, 0x0f, 0x2a, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x2c, 0x0f],
    &[0xf2, 0x4f, 0x0f, 0x2c, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x2d, 0x0f],
    &[0xf2, 0x4f, 0x0f, 0x2d, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x51, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x58, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x59, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x5a, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x5c, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x5d, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x5e, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x5f, 0x01],
    &[0xf2, 0x4f, 0x0f, 0x7c, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0x7d, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0xc2, 0x03, 0x08],
    &[0xf2, 0x4f, 0x0f, 0xc2, 0xc3, 0x08],
    &[0xf2, 0x4f, 0x0f, 0xd0, 0xcf],
    &[0xf2, 0x4f, 0x0f, 0xd6, 0xc3],
    &[0xf3, 0x0f, 0x12, 0x0f],
    &[0xf3, 0x0f, 0x12, 0xcf],
    &[0xf3, 0x0f, 0x16, 0x0f],
    &[0xf3, 0x0f, 0x16, 0xcf],
    &[0xf3, 0x0f, 0x2b, 0x06],
    &[0xf3, 0x0f, 0x70, 0xc0, 0x4e],
    &[0xf3, 0x0f, 0xff, 0xc1],
    &[0xf3, 0x4f, 0x0f, 0x12, 0xcf],
    &[0xf3, 0x4f, 0x0f, 0x16, 0xcf],
    &[0xf3, 0x4f, 0x0f, 0xd6, 0xc3],
    &[0xc4, 0b000_00010, 0b0_1111_001, 0xdb, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_001, 0xdc, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_001, 0xdd, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_001, 0xde, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_001, 0xdf, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_101, 0xdc, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_101, 0xdd, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_101, 0xde, 0b11_001_010],
    &[0xc4, 0b000_00010, 0b1_0111_101, 0xdf, 0b11_001_010],
    &[0xc4, 0b000_00011, 0b1_1111_001, 0xdf, 0b11_001_010, 0x77],
];

#[test]
fn test_against_leftover_data() {
    use super::rand::{thread_rng, Rng};
    use yaxpeax_arch::U8Reader;
    let mut rng = thread_rng();

    let decoder = InstDecoder::default();

    for _ in 0..100000 {
        let first_vec = INSTRUCTIONS[rng.gen_range(0..INSTRUCTIONS.len())];
        let mut first_reader = U8Reader::new(first_vec);
        let first_decode = decoder.decode(&mut first_reader).unwrap();

        let second_vec = INSTRUCTIONS[rng.gen_range(0..INSTRUCTIONS.len())];
        let mut second_reader = U8Reader::new(second_vec);
        let mut reused_decode = decoder.decode(&mut second_reader).unwrap();
        let mut first_reader = U8Reader::new(first_vec);
        decoder.decode_into(&mut reused_decode, &mut first_reader).unwrap();

        assert_eq!(first_decode, reused_decode);
    }
}
