/* $NetBSD: tegra_intr.h,v 1.12 2017/05/30 22:00:25 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_INTR_H
#define _ARM_TEGRA_INTR_H

#define TEGRA_INTR(x)		((x) + 32)

#define TEGRA_INTR_TMR1		TEGRA_INTR(0)
#define TEGRA_INTR_TMR2		TEGRA_INTR(1)
#define TEGRA_INTR_CEC		TEGRA_INTR(3)
#define TEGRA_INTR_SDMMC1	TEGRA_INTR(14)
#define TEGRA_INTR_SDMMC2	TEGRA_INTR(15)
#define TEGRA_INTR_SDMMC3	TEGRA_INTR(19)
#define TEGRA_INTR_USB1		TEGRA_INTR(20)
#define TEGRA_INTR_USB2		TEGRA_INTR(21)
#define TEGRA_INTR_SATA		TEGRA_INTR(23)
#define TEGRA_INTR_SDMMC4	TEGRA_INTR(31)
#define TEGRA_INTR_UARTA	TEGRA_INTR(36)
#define TEGRA_INTR_UARTB	TEGRA_INTR(37)
#define TEGRA_INTR_I2C1		TEGRA_INTR(38)
#define TEGRA_INTR_TMR3		TEGRA_INTR(41)
#define TEGRA_INTR_TMR4		TEGRA_INTR(42)
#define TEGRA_INTR_UARTC	TEGRA_INTR(46)
#define TEGRA_INTR_THERMAL	TEGRA_INTR(48)
#define TEGRA_INTR_I2C5		TEGRA_INTR(53)
#define TEGRA_INTR_I2C6		TEGRA_INTR(63)
#define TEGRA_INTR_HOST1X_SYNCPT_COP	TEGRA_INTR(64)
#define TEGRA_INTR_HOST1X_SYNCPT_CPU	TEGRA_INTR(65)
#define TEGRA_INTR_HOST1X_GEN_COP	TEGRA_INTR(66)
#define TEGRA_INTR_HOST1X_GEN_CPU	TEGRA_INTR(67)
#define TEGRA_INTR_MSENC	TEGRA_INTR(68)
#define TEGRA_INTR_VI		TEGRA_INTR(69)
#define TEGRA_INTR_ISPB		TEGRA_INTR(70)
#define TEGRA_INTR_ISP		TEGRA_INTR(71)
#define TEGRA_INTR_VIC		TEGRA_INTR(72)
#define TEGRA_INTR_DISPLAYA	TEGRA_INTR(73)
#define TEGRA_INTR_DISPLAYB	TEGRA_INTR(74)
#define TEGRA_INTR_HDMI		TEGRA_INTR(75)
#define TEGRA_INTR_SOR		TEGRA_INTR(76)
#define TEGRA_INTR_MC		TEGRA_INTR(77)
#define TEGRA_INTR_EMC		TEGRA_INTR(78)
#define TEGRA_INTR_SPI6		TEGRA_INTR(79)
#define TEGRA_INTR_HDA		TEGRA_INTR(81)
#define TEGRA_INTR_SPI2		TEGRA_INTR(82)
#define TEGRA_INTR_SPI3		TEGRA_INTR(83)
#define TEGRA_INTR_I2C2		TEGRA_INTR(84)
#define TEGRA_INTR_PMU_EXT	TEGRA_INTR(86)
#define TEGRA_INTR_GPIO6	TEGRA_INTR(87)
#define TEGRA_INTR_GPIO7	TEGRA_INTR(89)
#define TEGRA_INTR_UARTD	TEGRA_INTR(90)
#define TEGRA_INTR_I2C3		TEGRA_INTR(92)
#define TEGRA_INTR_SW_INTR	TEGRA_INTR(95)
#define TEGRA_INTR_SNOR		TEGRA_INTR(96)
#define TEGRA_INTR_USB3		TEGRA_INTR(97)
#define TEGRA_INTR_PCIE_INT	TEGRA_INTR(98)
#define TEGRA_INTR_PCIE_MSI	TEGRA_INTR(99)
#define TEGRA_INTR_PCIE_WAKE	TEGRA_INTR(100)
#define TEGRA_INTR_I2C4		TEGRA_INTR(120)
#define TEGRA_INTR_TMR5		TEGRA_INTR(121)
#define TEGRA_INTR_WDT_CPU	TEGRA_INTR(123)
#define TEGRA_INTR_WDT_AVP	TEGRA_INTR(124)
#define TEGRA_INTR_TMR6		TEGRA_INTR(152)
#define TEGRA_INTR_TMR7		TEGRA_INTR(153)
#define TEGRA_INTR_TMR8		TEGRA_INTR(154)
#define TEGRA_INTR_TMR9		TEGRA_INTR(155)
#define TEGRA_INTR_TMR0		TEGRA_INTR(156)
#define TEGRA_INTR_GPU		TEGRA_INTR(157)
#define TEGRA_INTR_GPU_NONSTALL	TEGRA_INTR(158)

#endif /* _ARM_TEGRA_INTR_H */
