/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.support;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.apache.commons.beanutils.BeanUtils;
import org.sonatype.nexus.client.core.subsystem.Entity;

public abstract class EntitySupport<E extends Entity<E>, S>
implements Entity<E> {
    private final String id;
    private final S settings;
    private boolean shouldCreate;

    public EntitySupport(String id) {
        this.id = id;
        this.settings = Preconditions.checkNotNull(this.createSettings(id));
        this.shouldCreate = true;
    }

    public EntitySupport(String id, S settings) {
        this((String)Preconditions.checkNotNull((Object)id));
        this.shouldCreate = false;
        this.overwriteWith(settings);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public synchronized E refresh() {
        S processed = null;
        if (!this.shouldCreate) {
            processed = this.doGet();
        }
        this.shouldCreate = processed == null;
        this.overwriteWith(processed);
        return this.me();
    }

    @Override
    public synchronized E save() {
        S processed = this.shouldCreate ? this.doCreate() : this.doUpdate();
        this.overwriteWith(processed);
        this.shouldCreate = false;
        return this.me();
    }

    @Override
    public synchronized E remove() {
        this.doRemove();
        this.shouldCreate = true;
        return this.me();
    }

    public String toString() {
        return String.format("%s{id=%s}", this.getClass().getSimpleName(), this.id());
    }

    public void overwriteWith(S source) {
        try {
            BeanUtils.copyProperties(this.settings(), source == null ? Preconditions.checkNotNull(this.createSettings(this.id)) : source);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected S settings() {
        return this.settings;
    }

    protected boolean shouldCreate() {
        return this.shouldCreate;
    }

    private E me() {
        return (E)this;
    }

    protected abstract S createSettings(String var1);

    protected abstract S doGet();

    protected abstract S doCreate();

    protected abstract S doUpdate();

    protected abstract void doRemove();
}

