/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.Version;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.apache.felix.bundleplugin.baseline.InfoComparator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

abstract class AbstractBaselinePlugin
extends AbstractMojo {
    @Parameter(property="baseline.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="baseline.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="baseline.failOnWarning", defaultValue="false")
    protected boolean failOnWarning;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String finalName;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactFactory factory;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Parameter(defaultValue="${project.groupId}", property="comparisonGroupId")
    protected String comparisonGroupId;
    @Parameter(defaultValue="${project.artifactId}", property="comparisonArtifactId")
    protected String comparisonArtifactId;
    @Parameter(defaultValue="(,${project.version})", property="comparisonVersion")
    protected String comparisonVersion;
    @Parameter(defaultValue="${project.packaging}", property="comparisonPackaging")
    protected String comparisonPackaging;
    @Parameter(property="comparisonClassifier")
    protected String comparisonClassifier;
    @Parameter
    private String[] filters;
    @Parameter
    protected List<String> supportedProjectTypes = Arrays.asList("jar", "bundle");
    @Component
    protected BuildContext buildContext;

    AbstractBaselinePlugin() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Object context) throws MojoExecutionException, MojoFailureException {
        Baseline.Info[] infos;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Baseline execution");
            return;
        }
        if (!this.supportedProjectTypes.contains(this.project.getArtifact().getType())) {
            this.getLog().info((CharSequence)("Skipping Baseline (project type " + this.project.getArtifact().getType() + " not supported)"));
            return;
        }
        Jar currentBundle = this.getCurrentBundle();
        if (currentBundle == null) {
            this.getLog().info((CharSequence)"Not generating Baseline report as there is no bundle generated by the project");
            return;
        }
        Artifact previousArtifact = this.getPreviousArtifact();
        Jar previousBundle = previousArtifact != null ? AbstractBaselinePlugin.openJar(previousArtifact.getFile()) : null;
        if (previousBundle == null) {
            this.getLog().info((CharSequence)"Not generating Baseline report as there is no previous version of the library to compare against");
            return;
        }
        Instructions packageFilters = this.filters == null || this.filters.length == 0 ? new Instructions() : new Instructions(Arrays.asList(this.filters));
        String generationDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'").format(new Date());
        Processor reporter = new Processor();
        try {
            Set infoSet = new Baseline((Reporter)reporter, (Differ)new DiffPluginImpl()).baseline(currentBundle, previousBundle, packageFilters);
            infos = infoSet.toArray(new Baseline.Info[infoSet.size()]);
            Arrays.sort(infos, new InfoComparator());
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Impossible to calculate the baseline", e);
            }
            catch (Throwable throwable) {
                AbstractBaselinePlugin.closeJars(currentBundle, previousBundle);
                throw throwable;
            }
        }
        AbstractBaselinePlugin.closeJars(currentBundle, previousBundle);
        try {
            context = this.init(context);
            this.startBaseline(context, generationDate, this.project.getArtifactId(), this.project.getVersion(), previousArtifact.getVersion());
            for (Baseline.Info info : infos) {
                DiffMessage diffMessage = null;
                if (info.suggestedVersion != null) {
                    if (info.newerVersion.compareTo(info.suggestedVersion) > 0) {
                        diffMessage = new DiffMessage("Excessive version increase", DiffMessage.Type.warning);
                        reporter.warning("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                    } else if (info.newerVersion.compareTo(info.suggestedVersion) < 0) {
                        diffMessage = new DiffMessage("Version increase required", DiffMessage.Type.error);
                        reporter.error("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                    }
                }
                switch (info.packageDiff.getDelta()) {
                    case UNCHANGED: {
                        if (info.newerVersion.compareTo(info.suggestedVersion) == 0) break;
                        diffMessage = new DiffMessage("Version has been increased but analysis detected no changes", DiffMessage.Type.warning);
                        reporter.warning("%s: %s; detected %s, suggested %s", new Object[]{info.packageName, diffMessage, info.newerVersion, info.suggestedVersion});
                        break;
                    }
                    case REMOVED: {
                        diffMessage = new DiffMessage("Package removed", DiffMessage.Type.info);
                        reporter.trace("%s: %s ", new Object[]{info.packageName, diffMessage});
                        break;
                    }
                }
                this.startPackage(context, info.mismatch, info.packageName, AbstractBaselinePlugin.getShortDelta(info.packageDiff.getDelta()), StringUtils.lowerCase((String)String.valueOf(info.packageDiff.getDelta())), info.newerVersion, info.olderVersion, info.suggestedVersion, diffMessage, info.attributes);
                if (Delta.REMOVED != info.packageDiff.getDelta()) {
                    this.doPackageDiff(context, info.packageDiff);
                }
                this.endPackage(context);
            }
            this.endBaseline(context);
        }
        finally {
            this.close(context);
        }
        boolean fail = false;
        if (!reporter.isOk()) {
            for (String errorMessage : reporter.getErrors()) {
                this.getLog().error((CharSequence)errorMessage);
            }
            if (this.failOnError) {
                fail = true;
            }
        }
        if (!reporter.getWarnings().isEmpty()) {
            for (String warningMessage : reporter.getWarnings()) {
                this.getLog().warn((CharSequence)warningMessage);
            }
            if (this.failOnWarning) {
                fail = true;
            }
        }
        this.getLog().info((CharSequence)String.format("Baseline analysis complete, %s error(s), %s warning(s)", reporter.getErrors().size(), reporter.getWarnings().size()));
        if (fail) {
            throw new MojoFailureException("Baseline failed, see generated report");
        }
    }

    private void doPackageDiff(Object context, Diff diff) {
        int depth = 1;
        for (Diff curDiff : diff.getChildren()) {
            if (Delta.UNCHANGED == curDiff.getDelta()) continue;
            this.doDiff(context, curDiff, depth);
        }
    }

    private void doDiff(Object context, Diff diff, int depth) {
        String type = StringUtils.lowerCase((String)String.valueOf(diff.getType()));
        String shortDelta = AbstractBaselinePlugin.getShortDelta(diff.getDelta());
        String delta = StringUtils.lowerCase((String)String.valueOf(diff.getDelta()));
        String name = diff.getName();
        this.startDiff(context, depth, type, name, delta, shortDelta);
        for (Diff curDiff : diff.getChildren()) {
            if (Delta.UNCHANGED == curDiff.getDelta()) continue;
            this.doDiff(context, curDiff, depth + 1);
        }
        this.endDiff(context, depth);
    }

    protected abstract Object init(Object var1);

    protected abstract void close(Object var1);

    protected abstract void startBaseline(Object var1, String var2, String var3, String var4, String var5);

    protected abstract void startPackage(Object var1, boolean var2, String var3, String var4, String var5, Version var6, Version var7, Version var8, DiffMessage var9, Map<String, String> var10);

    protected abstract void startDiff(Object var1, int var2, String var3, String var4, String var5, String var6);

    protected abstract void endDiff(Object var1, int var2);

    protected abstract void endPackage(Object var1);

    protected abstract void endBaseline(Object var1);

    private Jar getCurrentBundle() throws MojoExecutionException {
        File currentBundle = new File(this.buildDirectory, this.getBundleName());
        if (!currentBundle.exists()) {
            this.getLog().debug((CharSequence)("Produced bundle not found: " + currentBundle));
            return null;
        }
        return AbstractBaselinePlugin.openJar(currentBundle);
    }

    private Artifact getPreviousArtifact() throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)this.comparisonVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
        try {
            previousArtifact = this.factory.createDependencyArtifact(this.comparisonGroupId, this.comparisonArtifactId, range, this.comparisonPackaging, this.comparisonClassifier, "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + previousArtifact.getVersionRange()));
                List availableVersions = this.metadataSource.retrieveAvailableVersions(previousArtifact, this.session.getLocalRepository(), this.project.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                ArtifactVersion version = range.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException ocve) {
            throw new MojoFailureException("Invalid comparison version: " + ocve.getMessage());
        }
        catch (ArtifactMetadataRetrievalException amre) {
            throw new MojoExecutionException("Error determining previous version: " + amre.getMessage(), (Exception)((Object)amre));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)"Unable to find a previous version of the project in the repository");
            return null;
        }
        try {
            this.resolver.resolve(previousArtifact, this.project.getRemoteArtifactRepositories(), this.session.getLocalRepository());
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Artifact " + previousArtifact + " cannot be resolved : " + are.getMessage(), (Exception)((Object)are));
        }
        catch (ArtifactNotFoundException anfe) {
            throw new MojoExecutionException("Artifact " + previousArtifact + " does not exist on local/remote repositories", (Exception)((Object)anfe));
        }
        return previousArtifact;
    }

    private void filterSnapshots(List<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = versionIterator.next();
            if (version.getQualifier() == null || !version.getQualifier().endsWith("SNAPSHOT")) continue;
            versionIterator.remove();
        }
    }

    private static Jar openJar(File file) throws MojoExecutionException {
        try {
            return new Jar(file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while opening JAR directory: " + file, (Exception)e);
        }
    }

    private static void closeJars(Jar ... jars) {
        for (Jar jar : jars) {
            jar.close();
        }
    }

    private String getBundleName() {
        String classifier;
        String extension;
        try {
            extension = this.project.getArtifact().getArtifactHandler().getExtension();
        }
        catch (Throwable e) {
            extension = this.project.getArtifact().getType();
        }
        if (StringUtils.isEmpty((String)extension) || "bundle".equals(extension) || "pom".equals(extension)) {
            extension = "jar";
        }
        String string = classifier = this.comparisonClassifier != null ? this.comparisonClassifier : this.project.getArtifact().getClassifier();
        if (null != classifier && classifier.trim().length() > 0) {
            return this.finalName + '-' + classifier + '.' + extension;
        }
        return this.finalName + '.' + extension;
    }

    private static String getShortDelta(Delta delta) {
        switch (delta) {
            case ADDED: {
                return "+";
            }
            case CHANGED: {
                return "~";
            }
            case MAJOR: {
                return ">";
            }
            case MICRO: {
                return "0xB5";
            }
            case MINOR: {
                return "<";
            }
            case REMOVED: {
                return "-";
            }
            case UNCHANGED: {
                return " ";
            }
        }
        String deltaString = delta.toString();
        return String.valueOf(deltaString.charAt(0));
    }
}

