/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.OSUtil;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.Profile;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

@Named(value="requireOS")
public final class RequireOS
extends AbstractStandardEnforcerRule {
    private final ProfileActivator activator;
    private final ProfileActivationContext profileActivationContext;
    private String family = null;
    private String name = null;
    private String version = null;
    private String arch = null;
    private boolean display = false;

    @Inject
    RequireOS(@Named(value="os") ProfileActivator activator, MavenSession session) {
        this.activator = Objects.requireNonNull(activator);
        this.profileActivationContext = this.createProfileActivationContext(session);
    }

    private ProfileActivationContext createProfileActivationContext(MavenSession session) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(session.getRequest().getActiveProfiles());
        context.setInactiveProfileIds(session.getRequest().getInactiveProfiles());
        context.setProjectDirectory(session.getCurrentProject().getBasedir());
        context.setProjectProperties(session.getCurrentProject().getProperties());
        context.setSystemProperties(System.getProperties());
        context.setUserProperties(session.getUserProperties());
        return context;
    }

    public void execute() throws EnforcerRuleException {
        this.displayOSInfo();
        if (this.allParamsEmpty()) {
            throw new EnforcerRuleError("All parameters can not be empty. You must pick at least one of (family, name, version, arch), you can use mvn --version to see the current OS information.");
        }
        if (this.isValidFamily(this.family)) {
            if (!this.isAllowed()) {
                String message = this.getMessage();
                if (message == null || message.isEmpty()) {
                    message = "OS Arch: " + Os.OS_ARCH + " Family: " + Os.OS_FAMILY + " Name: " + Os.OS_NAME + " Version: " + Os.OS_VERSION + " is not allowed by" + (this.arch != null ? " Arch=" + this.arch : "") + (this.family != null ? " Family=" + this.family : "") + (this.name != null ? " Name=" + this.name : "") + (this.version != null ? " Version=" + this.version : "");
                }
                throw new EnforcerRuleException(message);
            }
        } else {
            String validFamilies = String.join((CharSequence)",", Os.getValidFamilies());
            throw new EnforcerRuleError("Invalid Family type used. Valid family types are: " + validFamilies);
        }
    }

    private void displayOSInfo() {
        String string = OSUtil.getOSInfo();
        if (!this.display) {
            this.getLog().debug((CharSequence)string);
        } else {
            this.getLog().info((CharSequence)string);
        }
    }

    public boolean isAllowed() {
        return this.activator.isActive(this.createProfile(), this.profileActivationContext, req -> {});
    }

    public boolean allParamsEmpty() {
        return !(this.family != null && !this.family.isEmpty() || this.arch != null && !this.arch.isEmpty() || this.name != null && !this.name.isEmpty() || this.version != null && !this.version.isEmpty());
    }

    private Profile createProfile() {
        Profile profile = new Profile();
        profile.setActivation(this.createActivation());
        return profile;
    }

    private Activation createActivation() {
        Activation activation = new Activation();
        activation.setActiveByDefault(false);
        activation.setOs(this.createOsBean());
        return activation;
    }

    private ActivationOS createOsBean() {
        ActivationOS os = new ActivationOS();
        os.setArch(this.arch);
        os.setFamily(this.family);
        os.setName(this.name);
        os.setVersion(this.version);
        return os;
    }

    public boolean isValidFamily(String theFamily) {
        return (theFamily = StringUtils.stripStart((String)theFamily, (String)"!")) == null || theFamily.isEmpty() || Os.getValidFamilies().contains(theFamily);
    }

    public void setArch(String theArch) {
        this.arch = theArch;
    }

    public void setFamily(String theFamily) {
        this.family = theFamily;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public String getCacheId() {
        StringBuilder b = new StringBuilder();
        if (this.version != null && !this.version.isEmpty()) {
            b.append(this.version.hashCode());
        }
        if (this.name != null && !this.name.isEmpty()) {
            b.append(this.name.hashCode());
        }
        if (this.arch != null && !this.arch.isEmpty()) {
            b.append(this.arch.hashCode());
        }
        if (this.family != null && !this.family.isEmpty()) {
            b.append(this.family.hashCode());
        }
        return b.toString();
    }

    public String toString() {
        return String.format("RequireOS[message=%s, arch=%s, family=%s, name=%s, version=%s, display=%b]", this.getMessage(), this.arch, this.family, this.name, this.version, this.display);
    }
}

